/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.DefaultAuthHandler;
import HTTPClient.GlobalConstants;
import HTTPClient.HashVerifier;
import HTTPClient.HttpHeaderElement;
import HTTPClient.Log;
import HTTPClient.MD5;
import HTTPClient.ParseException;
import HTTPClient.RoResponse;
import HTTPClient.Util;
import java.io.IOException;
import java.util.Vector;

class VerifyRspAuth
implements HashVerifier,
GlobalConstants {
    private String uri;
    private String HA1;
    private String alg;
    private String nonce;
    private String cnonce;
    private String nc;
    private String hdr;
    private RoResponse resp;

    public VerifyRspAuth(String string, String string2, String string3, String string4, String string5, String string6, String string7, RoResponse roResponse) {
        this.uri = string;
        this.HA1 = string2;
        this.alg = string3;
        this.nonce = string4;
        this.cnonce = string5;
        this.nc = string6;
        this.hdr = string7;
        this.resp = roResponse;
    }

    public void verifyHash(byte[] byArray, long l) throws IOException {
        String string;
        Vector vector;
        String string2 = this.resp.getHeader(this.hdr);
        if (string2 == null) {
            string2 = this.resp.getTrailer(this.hdr);
        }
        if (string2 == null) {
            return;
        }
        try {
            vector = Util.parseHeader(string2);
        }
        catch (ParseException parseException) {
            throw new IOException(parseException.toString());
        }
        HttpHeaderElement httpHeaderElement = Util.getElement(vector, "qop");
        if (httpHeaderElement == null || (string = httpHeaderElement.getValue()) == null || !string.equalsIgnoreCase("auth") && !string.equalsIgnoreCase("auth-int")) {
            return;
        }
        httpHeaderElement = Util.getElement(vector, "rspauth");
        if (httpHeaderElement == null || httpHeaderElement.getValue() == null) {
            return;
        }
        byte[] byArray2 = DefaultAuthHandler.unHex(httpHeaderElement.getValue());
        httpHeaderElement = Util.getElement(vector, "cnonce");
        if (httpHeaderElement != null && httpHeaderElement.getValue() != null && !httpHeaderElement.getValue().equals(this.cnonce)) {
            throw new IOException("Digest auth scheme: received wrong client-nonce '" + httpHeaderElement.getValue() + "' - expected '" + this.cnonce + "'");
        }
        httpHeaderElement = Util.getElement(vector, "nc");
        if (httpHeaderElement != null && httpHeaderElement.getValue() != null && !httpHeaderElement.getValue().equals(this.nc)) {
            throw new IOException("Digest auth scheme: received wrong nonce-count '" + httpHeaderElement.getValue() + "' - expected '" + this.nc + "'");
        }
        String string3 = this.alg != null && this.alg.equalsIgnoreCase("MD5-sess") ? MD5.hexDigest(this.HA1 + ":" + this.nonce + ":" + this.cnonce) : this.HA1;
        String string4 = ":" + this.uri;
        if (string.equalsIgnoreCase("auth-int")) {
            string4 = string4 + ":" + MD5.toHex(byArray);
        }
        string4 = MD5.hexDigest(string4);
        byArray = MD5.digest(string3 + ":" + this.nonce + ":" + this.nc + ":" + this.cnonce + ":" + string + ":" + string4);
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            throw new IOException("MD5-Digest mismatch: expected " + DefaultAuthHandler.hex(byArray2) + " but calculated " + DefaultAuthHandler.hex(byArray));
        }
        Log.write(8, "Auth:  rspauth from " + this.hdr + " successfully verified");
    }
}

