/*
 * Decompiled with CFR 0.152.
 */
package com.ms.xml.dso;

import com.ms.xml.dso.SchemaNode;
import com.ms.xml.dso.XMLParserThread;
import com.ms.xml.dso.XMLRowsetProvider;
import com.ms.xml.om.Document;
import com.ms.xml.om.Element;
import com.ms.xml.om.ElementEnumeration;
import com.ms.xml.util.Name;
import com.ms.xml.util.StringInputStream;
import com.ms.xml.util.XMLOutputStream;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;

public class XMLDSO
extends Applet {
    private XMLRowsetProvider myProvider;
    private Object myDSL;
    private Document document = new Document();
    private Document schema;
    private Element schemaRoot;
    private String error;
    private URL url;
    private boolean loaded = false;
    private boolean inlineXML = false;
    static Vector providers = new Vector();

    public void init() {
        super.init();
        String string = this.getParameter("URL");
        if (string != null && string.length() > 0) {
            this.load(string);
        } else {
            this.loaded = true;
            string = this.getParameter("ID");
            if (string != null && string.length() > 0) {
                Object var2_2 = null;
                if (var2_2 == null) {
                    this.setError("Error finding <APPLET> with ID=" + string);
                }
            } else {
                this.setError("No PARAM with NAME=URL was found, so perhaps you specified the XML inside the APPET tag but in order for this to work you must also specify <PARAM NAME=\"APPLET\" VALUE=\"xmldso\"> where the value matches the ID of your APPLET tag.");
            }
        }
        this.updateSchema();
    }

    public void updateSchema() {
        this.schema = new Document();
        String string = this.getParameter("SCHEMA");
        if (string != null && string.length() > 0) {
            this.schema = this.parseXML(string);
            this.schemaRoot = this.schema.getRoot();
        } else if (this.document != null && this.document.getRoot() != null) {
            Element element = this.document.getRoot();
            SchemaNode schemaNode = new SchemaNode(this.schema, this.schema, element.getTagName());
            this.generateSchema(element, schemaNode);
            ElementEnumeration elementEnumeration = new ElementEnumeration(this.schema.getRoot(), XMLRowsetProvider.nameROWSET, 0);
            this.schemaRoot = (Element)elementEnumeration.nextElement();
        }
        this.notifyListeners();
    }

    public Document parseXML(String string) {
        Document document = new Document();
        if (string == null) {
            return document;
        }
        try {
            document.load(new StringInputStream(string));
        }
        catch (Exception exception) {
            this.setError("Caught exception parsing given XML.  " + exception.toString());
        }
        return document;
    }

    public void handleUpdateString(String string) {
        Document document = this.parseXML(string);
        this.handleUpdate(document.getRoot());
    }

    public void handleUpdate(Element element) {
        if (this.document == null) {
            this.document = new Document();
            this.document.addChild(element, null);
            this.updateSchema();
            return;
        }
        try {
            Element element2 = this.document.getRoot();
            ElementEnumeration elementEnumeration = new ElementEnumeration(element);
            while (elementEnumeration.hasMoreElements()) {
                Element element3 = (Element)elementEnumeration.nextElement();
                this.updateTree(element2, element3);
            }
        }
        catch (Exception exception) {
            this.setError("HandleUpdate error: " + exception.toString());
        }
    }

    boolean updateTree(Element element, Element element2) {
        int n = element2.getType();
        if (n == 2 || n == 5 || n == 12) {
            return true;
        }
        if (n == 1 || n == 11) {
            return element.getText().equals(element2.getText());
        }
        String string = (String)element2.getAttribute("UPDATE-ACTION");
        if (string != null && (string.equalsIgnoreCase("APPEND") || string.equalsIgnoreCase("INSERT"))) {
            element2.removeAttribute("UPDATE-ACTION");
            boolean bl = string.equalsIgnoreCase("APPEND");
            if (bl) {
                element.addChild(element2, null);
            } else {
                element.addChild(element2, 0, 0);
            }
            this.notifyNewRow(element, bl);
            return true;
        }
        int n2 = element2.numElements();
        if (n2 > 0) {
            int n3 = 0;
            ElementEnumeration elementEnumeration = new ElementEnumeration(element, element2.getTagName(), 0);
            while (elementEnumeration.hasMoreElements()) {
                String string2;
                Element element3;
                ++n3;
                Element element4 = (Element)elementEnumeration.nextElement();
                Vector<Element> vector = new Vector<Element>();
                boolean bl = false;
                Enumeration enumeration = new ElementEnumeration(element2);
                while (((ElementEnumeration)enumeration).hasMoreElements()) {
                    element3 = (Element)((ElementEnumeration)enumeration).nextElement();
                    string2 = (String)element3.getAttribute("UPDATE-ACTION");
                    if (string2 == null || string2.equalsIgnoreCase("APPEND") || string2.equalsIgnoreCase("INSERT") || string2.equalsIgnoreCase("REMOVE")) {
                        bl = this.updateTree(element4, element3);
                        if (bl) continue;
                        break;
                    }
                    vector.addElement(element3);
                }
                if (!bl) continue;
                if (string != null && string.equalsIgnoreCase("REMOVE")) {
                    element.removeChild(element4);
                    this.notifyRemovedRow(element, n3);
                    return true;
                }
                enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    element3 = (Element)enumeration.nextElement();
                    string2 = (String)element3.getAttribute("UPDATE-ACTION");
                    element3.removeAttribute("UPDATE-ACTION");
                    if (!string2.equalsIgnoreCase("REPLACE")) continue;
                    ElementEnumeration elementEnumeration2 = new ElementEnumeration(element4, element3.getTagName(), 0);
                    Element element5 = (Element)elementEnumeration2.nextElement();
                    element4.addChild(element3, element5);
                    if (element5 != null) {
                        element4.removeChild(element5);
                    }
                    element4.setParent(element);
                    this.notifyCellChanged(n3, element4, element3);
                }
                return true;
            }
        }
        return false;
    }

    int getColumn(Element element, Element element2) {
        int n = 0;
        String string = element2.getTagName().toString();
        Enumeration enumeration = element.getElements();
        while (enumeration.hasMoreElements()) {
            ++n;
            Element element3 = (Element)enumeration.nextElement();
            String string2 = element3.getAttribute("NAME").toString();
            if (!string2.equals(string)) continue;
            return n;
        }
        this.setError(string + " not found in schema.");
        return 0;
    }

    void removeProvider(XMLRowsetProvider xMLRowsetProvider) {
        if (xMLRowsetProvider != null) {
            providers.removeElement(xMLRowsetProvider);
        }
    }

    void addProvider(XMLRowsetProvider xMLRowsetProvider) {
        if (xMLRowsetProvider != null) {
            providers.addElement(xMLRowsetProvider);
        }
    }

    void notifyCellChanged(int n, Element element, Element element2) {
        long l = 0L;
        Enumeration enumeration = providers.elements();
        while (enumeration.hasMoreElements()) {
            XMLRowsetProvider xMLRowsetProvider = (XMLRowsetProvider)enumeration.nextElement();
            for (Element element3 = element; element3 != null; element3 = element3.getParent()) {
                XMLRowsetProvider xMLRowsetProvider2 = xMLRowsetProvider.findChildProvider(element3);
                if (xMLRowsetProvider2 == null) continue;
                ++l;
            }
        }
    }

    void notifyNewRow(Element element, boolean bl) {
        Enumeration enumeration = providers.elements();
        while (enumeration.hasMoreElements()) {
            XMLRowsetProvider xMLRowsetProvider = (XMLRowsetProvider)enumeration.nextElement();
            XMLRowsetProvider xMLRowsetProvider2 = xMLRowsetProvider.findChildProvider(element);
            if (xMLRowsetProvider2 == null) continue;
        }
    }

    void notifyRemovedRow(Element element, int n) {
        Enumeration enumeration = providers.elements();
        while (enumeration.hasMoreElements()) {
            XMLRowsetProvider xMLRowsetProvider = (XMLRowsetProvider)enumeration.nextElement();
            XMLRowsetProvider xMLRowsetProvider2 = xMLRowsetProvider.findChildProvider(element);
            if (xMLRowsetProvider2 == null) continue;
        }
    }

    public void notifyListeners() {
        if (this.myDSL != null) {
            // empty if block
        }
    }

    public Object getDocument() {
        return this.document;
    }

    public void setRoot(Element element) {
        this.document = new Document();
        this.document.addChild(element, null);
        this.updateSchema();
    }

    public void clear() {
        this.document = new Document();
        this.updateSchema();
    }

    public void load(String string) {
        URL uRL = this.getDocumentBase();
        this.loaded = false;
        try {
            this.url = uRL == null ? new URL(string) : new URL(uRL, string);
            this.document.load(this.url.toString());
            this.loaded = true;
        }
        catch (Exception exception) {
            this.setError("Error loading XML document '" + string + "'.  " + exception.toString());
        }
        if (this.loaded && this.schema != null) {
            this.updateSchema();
        }
    }

    public void asyncLoad(String string, String string2) {
        this.document = null;
        try {
            URL uRL = new URL(this.getDocumentBase(), string);
            this.document = new Document();
            Object var4_5 = null;
            XMLParserThread xMLParserThread = new XMLParserThread(uRL, var4_5, string2);
            xMLParserThread.start();
        }
        catch (Exception exception) {
            this.setError("Error loading document '" + string + "'.  " + exception.toString());
        }
    }

    public Object getXML(int n) {
        if (this.document != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                XMLOutputStream xMLOutputStream = new XMLOutputStream(byteArrayOutputStream);
                xMLOutputStream.setOutputStyle(n);
                this.document.save(xMLOutputStream);
            }
            catch (Exception exception) {
                this.setError(exception.toString());
            }
            return byteArrayOutputStream.toString();
        }
        return null;
    }

    public String getError() {
        return this.error;
    }

    public void saveSchema(String string) {
        if (this.schema != null) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(string);
                this.schema.save(new XMLOutputStream(fileOutputStream));
            }
            catch (Exception exception) {
                this.setError(exception.toString());
            }
        }
    }

    public Object getSchema(int n) {
        if (this.schema != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                XMLOutputStream xMLOutputStream = new XMLOutputStream(byteArrayOutputStream);
                xMLOutputStream.setOutputStyle(n);
                this.schema.save(xMLOutputStream);
            }
            catch (Exception exception) {
                this.setError(exception.toString());
            }
            return byteArrayOutputStream.toString();
        }
        return null;
    }

    public void save(String string) {
        if (this.document != null) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(string);
                this.document.save(this.document.createOutputStream(fileOutputStream));
            }
            catch (Exception exception) {
                this.setError(exception.toString());
            }
        }
    }

    private void setError(String string) {
        this.error = string;
        this.repaint();
    }

    void generateSchema(Element element, SchemaNode schemaNode) {
        ElementEnumeration elementEnumeration = new ElementEnumeration(element);
        while (elementEnumeration.hasMoreElements()) {
            Element element2 = (Element)elementEnumeration.nextElement();
            int n = element2.getType();
            Name name = element2.getTagName();
            if (n != 0) continue;
            SchemaNode schemaNode2 = schemaNode.setRow(name);
            this.generateSchema(element2, schemaNode2);
        }
        if (schemaNode.e == null) {
            schemaNode.createElement(false);
        }
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (dimension.width > 0 && dimension.height > 0) {
            if (this.error == null) {
                graphics.setColor(Color.green);
            } else {
                graphics.setColor(Color.red);
            }
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            String string = this.error;
            if (string == null) {
                string = this.url != null ? "Successfully loaded XML from \"" + this.url.toString() + "\"" : (this.inlineXML ? "Successfully loaded inline XML" : (this.document.getRoot() != null ? "Successfully loaded document." : "Empty"));
            }
            graphics.setColor(Color.black);
            this.drawText(graphics, string, 5, 5, dimension.width - 10, true, 0);
        }
    }

    private int drawText(Graphics graphics, String string, int n, int n2, int n3, boolean bl, int n4) {
        int n5;
        if (string == null || string.length() == 0) {
            return n2;
        }
        if (n3 < 5) {
            return n2;
        }
        int n6 = 0;
        int n7 = n4 == 0 ? string.length() : n4;
        for (n5 = 0; n5 < n7 && bl && this.isWhiteSpace(string.charAt(n5)); ++n5) {
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n8 = n5;
        int n9 = n5;
        while (n5 < n7) {
            char c = string.charAt(n5);
            int n10 = fontMetrics.charWidth(c);
            if ((n6 += n10) > n3 || c == '\n') {
                if (c == '\n' && string.charAt(n5 - 1) == '\r') {
                    n8 = n5 - 1;
                } else if (n9 == n8) {
                    n8 = n5;
                }
                String string2 = string.substring(n9, n8);
                graphics.drawString(string2, n, n2 + fontMetrics.getMaxAscent());
                n2 += fontMetrics.getHeight();
                if (c == '\n' && string.charAt(n5 - 1) == '\r') {
                    n8 = n5 + 1;
                }
                while (bl && n8 < n7 && this.isWhiteSpace(string.charAt(n8))) {
                    ++n8;
                }
                n5 = n8;
                n9 = n8;
                n6 = 0;
                continue;
            }
            if (bl && this.isWhiteSpace(c)) {
                n8 = n5;
            }
            ++n5;
        }
        String string3 = string.substring(n9);
        graphics.drawString(string3, n, n2 + fontMetrics.getMaxAscent());
        return n2;
    }

    private boolean isWhiteSpace(char c) {
        return Character.isWhitespace(c) || c == '\r';
    }
}

