/*
 * Decompiled with CFR 0.152.
 */
package com.ms.xml.om;

import com.ms.xml.om.Document;
import com.ms.xml.om.Element;
import com.ms.xml.om.ElementCollection;
import com.ms.xml.om.ElementEnumeration;
import com.ms.xml.parser.AttDef;
import com.ms.xml.parser.DTD;
import com.ms.xml.parser.ElementDecl;
import com.ms.xml.parser.Entity;
import com.ms.xml.util.Atom;
import com.ms.xml.util.Attribute;
import com.ms.xml.util.Attributes;
import com.ms.xml.util.EnumWrapper;
import com.ms.xml.util.Name;
import com.ms.xml.util.XMLOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class ElementImpl
implements Element {
    Name tag;
    int type;
    String text;
    Element parent;
    Vector children;
    Document doc;
    protected Attributes attrlist;
    static Atom nameXML = Atom.create("xml");
    static Name nameXMLSPACE = Name.create("xml-space", "xml");
    static Name nameXMLAS = Name.create("prefix", "xml");
    static Name nameXMLHREF = Name.create("ns", "xml");

    public ElementImpl() {
        this(null, 0);
    }

    public ElementImpl(Name name, int n) {
        this.tag = name;
        this.type = n;
    }

    public Name getTagName() {
        return this.tag;
    }

    public int getType() {
        return this.type;
    }

    public String getText() {
        if (this.type == 11) {
            Entity entity;
            DTD dTD;
            Document document = this.getDocument();
            if (document != null && (dTD = document.getDTD()) != null && (entity = dTD.findEntity(this.getTagName())) != null) {
                return entity.getText();
            }
        } else {
            if (this.children == null || this.type == 6 || this.type == 1 || this.type == 12) {
                return this.text == null ? new String("") : this.text;
            }
            if (this.children != null) {
                StringBuffer stringBuffer = new StringBuffer();
                Enumeration enumeration = this.children.elements();
                while (enumeration.hasMoreElements()) {
                    stringBuffer.append(((Element)enumeration.nextElement()).getText());
                }
                return stringBuffer.toString();
            }
        }
        return "";
    }

    public void setText(String string) {
        this.text = string;
    }

    public Element getParent() {
        return this.parent;
    }

    public void setParent(Element element) {
        this.parent = element;
        this.doc = null;
    }

    public Enumeration getElements() {
        if (this.children == null) {
            return EnumWrapper.emptyEnumeration;
        }
        return this.children.elements();
    }

    public ElementCollection getChildren() {
        return new ElementCollection(this);
    }

    public int numAttributes() {
        return this.attrlist == null ? 0 : this.attrlist.size();
    }

    public int numElements() {
        return this.children == null ? 0 : this.children.size();
    }

    public void addChild(Element element, Element element2) {
        if (this.children == null) {
            this.children = new Vector(4);
        }
        if (element2 == null) {
            this.children.addElement(element);
        } else if (element2 == this) {
            this.children.insertElementAt(element, 0);
        } else {
            this.children.insertElementAt(element, this.children.indexOf(element2) + 1);
        }
        element.setParent(this);
    }

    public void addChild(Element element, int n, int n2) {
        if (n == 0) {
            this.addChild(element, this);
        } else if (n < 0 || n > this.numElements() - 1) {
            this.addChild(element, null);
        } else {
            this.addChild(element, this.getChild(n - 1));
        }
    }

    public Element getChild(int n) {
        if (this.children != null && n >= 0 && n < this.children.size()) {
            try {
                return (Element)this.children.elementAt(n);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public void removeChild(Element element) {
        if (this.children != null) {
            element.setParent(null);
            this.children.removeElement(element);
        }
    }

    public Enumeration getAttributes() {
        if (this.attrlist == null) {
            return EnumWrapper.emptyEnumeration;
        }
        return this.attrlist.attributes();
    }

    public Object getAttribute(String string) {
        return this.getAttribute(this.qualifyName(string));
    }

    public Object getAttribute(Name name) {
        Object object = null;
        if (this.attrlist != null) {
            object = this.attrlist.get(name);
        }
        return object;
    }

    public void setAttribute(String string, Object object) {
        this.setAttribute(this.qualifyName(string), object);
    }

    public void removeAttribute(String string) {
        this.removeAttribute(this.qualifyName(string));
    }

    public void removeAttribute(Name name) {
        if (this.attrlist != null) {
            this.attrlist.remove(name);
        }
    }

    public String toString() {
        return this.getClass().getName() + "[tag=" + this.tag + ",type=" + this.type + ",text=" + this.text + "]";
    }

    public void setAttribute(Name name, Object object) {
        if (this.attrlist == null) {
            this.attrlist = new Attributes();
        }
        this.attrlist.put(name, object);
    }

    void clear() {
        if (this.children != null) {
            this.children.removeAllElements();
        }
        this.text = null;
        this.parent = null;
        if (this.attrlist != null) {
            this.attrlist.removeAll();
        }
    }

    public void saveAttributes(Atom atom, XMLOutputStream xMLOutputStream) throws IOException {
        Enumeration enumeration = this.getAttributes();
        while (enumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)enumeration.nextElement();
            Name name = attribute.getName();
            xMLOutputStream.write(32);
            if (name == nameXMLSPACE) {
                xMLOutputStream.writeChars(name.getName());
            } else {
                xMLOutputStream.writeQualifiedName(name, atom);
            }
            xMLOutputStream.write(61);
            boolean bl = this.isAttributeQualified(name, xMLOutputStream.dtd);
            Object object = attribute.getValue();
            if (object instanceof Name) {
                xMLOutputStream.write(34);
                if (bl) {
                    xMLOutputStream.writeQualifiedName((Name)object, atom);
                } else {
                    xMLOutputStream.writeChars(object.toString());
                }
                xMLOutputStream.write(34);
                continue;
            }
            if (object instanceof Vector) {
                Vector vector = (Vector)object;
                xMLOutputStream.write(34);
                Enumeration enumeration2 = vector.elements();
                while (enumeration2.hasMoreElements()) {
                    Name name2 = (Name)enumeration2.nextElement();
                    if (bl) {
                        xMLOutputStream.writeQualifiedName(name2, atom);
                    } else {
                        xMLOutputStream.writeChars(name2.toString());
                    }
                    if (!enumeration2.hasMoreElements()) continue;
                    xMLOutputStream.write(32);
                }
                xMLOutputStream.write(34);
                continue;
            }
            xMLOutputStream.writeQuotedString(object.toString());
        }
    }

    public boolean isAttributeQualified(Name name, DTD dTD) {
        int n;
        AttDef attDef;
        ElementDecl elementDecl;
        return dTD != null && (elementDecl = dTD.findElementDecl(this.tag)) != null && (attDef = elementDecl.findAttDef(name)) != null && ((n = attDef.getType()) == 4 || n == 5 || n == 8);
    }

    public Element toSchema() {
        return this;
    }

    void writeTagName(XMLOutputStream xMLOutputStream) throws IOException {
        Element element = this.getParent();
        Name name = this.getTagName();
        if (element != null && element.getTagName() != null && element.getTagName().getNameSpace() != null) {
            xMLOutputStream.writeQualifiedName(name, Atom.create(""));
        } else if (name.getNameSpace() != null) {
            xMLOutputStream.writeQualifiedName(name, Atom.create(""));
        } else {
            xMLOutputStream.writeChars(name.getName());
        }
    }

    public void save(XMLOutputStream xMLOutputStream) throws IOException {
        if (this.getType() != 12) {
            xMLOutputStream.writeIndent();
        }
        int n = this.getType();
        switch (n) {
            case 12: {
                if (xMLOutputStream.getOutputStyle() != XMLOutputStream.DEFAULT) break;
                xMLOutputStream.writeChars(this.getText());
                break;
            }
            case 0: 
            case 7: {
                Object object;
                Object object2;
                int n2 = -1;
                boolean bl = xMLOutputStream.mixed;
                if (this.tag != null) {
                    xMLOutputStream.writeChars("<");
                    this.writeTagName(xMLOutputStream);
                    this.saveAttributes(this.getTagName().getNameSpace(), xMLOutputStream);
                    object2 = this.getAttribute(nameXMLSPACE);
                    object = null;
                    if (object2 != null) {
                        object = object2.toString();
                    }
                    if (object != null) {
                        n2 = xMLOutputStream.getOutputStyle();
                        boolean bl2 = ((String)object).equalsIgnoreCase("preserve");
                        xMLOutputStream.setOutputStyle(bl2 ? XMLOutputStream.COMPACT : XMLOutputStream.PRETTY);
                    }
                    if (this.numElements() > 0) {
                        xMLOutputStream.write(62);
                    } else {
                        xMLOutputStream.writeChars("/>");
                    }
                }
                object2 = null;
                xMLOutputStream.mixed = false;
                object2 = new ElementEnumeration(this);
                while (((ElementEnumeration)object2).hasMoreElements()) {
                    object = (Element)((ElementEnumeration)object2).nextElement();
                    if (object.getType() != 1 && object.getType() != 11) continue;
                    xMLOutputStream.mixed = true;
                    break;
                }
                xMLOutputStream.writeNewLine();
                xMLOutputStream.addIndent(1);
                xMLOutputStream.nameSpaceContext.push();
                object2 = new ElementEnumeration(this);
                while (((ElementEnumeration)object2).hasMoreElements()) {
                    object = (Element)((ElementEnumeration)object2).nextElement();
                    object.save(xMLOutputStream);
                }
                xMLOutputStream.nameSpaceContext.pop();
                xMLOutputStream.addIndent(-1);
                if (this.tag == null || this.numElements() <= 0) break;
                xMLOutputStream.writeIndent();
                xMLOutputStream.writeChars("</");
                this.writeTagName(xMLOutputStream);
                xMLOutputStream.writeChars(">");
                if (n2 != -1) {
                    xMLOutputStream.setOutputStyle(n2);
                }
                xMLOutputStream.mixed = bl;
                xMLOutputStream.writeNewLine();
                break;
            }
            case 5: {
                xMLOutputStream.writeChars("<?");
                xMLOutputStream.writeQualifiedName(this.getTagName(), null);
                this.saveAttributes(this.getTagName().getNameSpace(), xMLOutputStream);
                xMLOutputStream.writeChars(this.getText() + "?>");
                xMLOutputStream.writeNewLine();
                break;
            }
            case 6: {
                xMLOutputStream.writeChars("<![CDATA[" + this.getText() + "]]>");
                xMLOutputStream.writeNewLine();
                break;
            }
            case 1: {
                xMLOutputStream.writeChars(this.getText());
                xMLOutputStream.writeNewLine();
                break;
            }
            case 11: {
                if (xMLOutputStream.savingDTD) {
                    xMLOutputStream.write(37);
                } else {
                    xMLOutputStream.write(38);
                }
                xMLOutputStream.writeQualifiedName(this.getTagName(), this.getParent().getTagName().getNameSpace());
                xMLOutputStream.writeChars(";");
                if (!xMLOutputStream.savingDTD) break;
                xMLOutputStream.writeNewLine();
                break;
            }
            case 2: {
                xMLOutputStream.writeChars("<!--" + this.getText() + "-->");
                xMLOutputStream.writeNewLine();
                break;
            }
            case 10: {
                xMLOutputStream.writeChars("<?xml:namespace ");
                this.saveAttributes(nameXML, xMLOutputStream);
                xMLOutputStream.writeChars("?>");
                xMLOutputStream.writeNewLine();
                Atom atom = Atom.create(this.getAttribute(nameXMLAS).toString());
                Atom atom2 = Atom.create(this.getAttribute(nameXMLHREF).toString());
                xMLOutputStream.nameSpaceContext.addNameSpace(atom2, atom);
                break;
            }
            case 13: {
                if (this.tag == null) {
                    xMLOutputStream.writeChars("<![INCLUDE[");
                } else {
                    xMLOutputStream.writeChars("<![%");
                    xMLOutputStream.writeChars(this.tag.toString());
                    xMLOutputStream.writeChars(";[");
                }
                ElementEnumeration elementEnumeration = new ElementEnumeration(this);
                while (elementEnumeration.hasMoreElements()) {
                    Element element = (Element)elementEnumeration.nextElement();
                    element.save(xMLOutputStream);
                }
                xMLOutputStream.writeChars("]]>");
                break;
            }
            case 14: {
                if (this.tag == null) {
                    xMLOutputStream.writeChars("<![IGNORE[");
                } else {
                    xMLOutputStream.writeChars("<![%");
                    xMLOutputStream.writeChars(this.tag.toString());
                    xMLOutputStream.writeChars(";[");
                }
                ElementEnumeration elementEnumeration = new ElementEnumeration(this);
                while (elementEnumeration.hasMoreElements()) {
                    Element element = (Element)elementEnumeration.nextElement();
                    element.save(xMLOutputStream);
                }
                break;
            }
        }
        xMLOutputStream.flush();
    }

    public Name qualifyName(String string) {
        int n = string.indexOf(":");
        if (n != -1) {
            int n2 = 1;
            if (n + 1 < string.length() && string.charAt(n + 1) == ':') {
                ++n2;
            }
            String string2 = string.substring(0, n);
            Atom atom = this.getNamespace(string2);
            String string3 = string.substring(n + n2);
            return Name.create(string3, atom);
        }
        if (this.tag != null) {
            return Name.create(string, this.tag.getNameSpace());
        }
        return Name.create(string);
    }

    Atom getNamespace(String string) {
        Atom atom;
        DTD dTD;
        Atom atom2 = Atom.create(string);
        Document document = this.getDocument();
        if (document != null && (dTD = document.getDTD()) != null && (atom = dTD.findLongNameSpace(atom2)) != null) {
            return atom;
        }
        return atom2;
    }

    Document getDocument() {
        if (this.doc == null) {
            Element element = this;
            while (element.getParent() != null) {
                element = element.getParent();
            }
            if (element instanceof Document) {
                this.doc = (Document)element;
            }
        }
        return this.doc;
    }
}

