/*
 * Decompiled with CFR 0.152.
 */
package com.ms.xml.om;

import com.ms.xml.om.Element;
import com.ms.xml.util.EnumWrapper;
import com.ms.xml.util.Queue;
import java.util.Enumeration;
import java.util.Stack;

public class TreeEnumeration
implements Enumeration {
    Element originalNode;
    Element next;
    Enumeration children;
    Stack DFSstack;
    Element curr;
    Queue BFSqueue;
    boolean enumerationDir;

    public TreeEnumeration(Element element) {
        this.Initialize(element, true);
    }

    public TreeEnumeration(Element element, boolean bl) {
        this.Initialize(element, bl);
    }

    private void Initialize(Element element, boolean bl) {
        this.originalNode = element;
        this.enumerationDir = bl;
        this.next = null;
        this.DFSstack = null;
        this.BFSqueue = null;
        this.curr = element;
        this.children = new EnumWrapper(element);
        if (!bl) {
            this.BFSqueue = new Queue();
        } else {
            this.next = element;
            this.children.nextElement();
            this.DFSstack = new Stack();
        }
    }

    public void reset() {
        this.Initialize(this.originalNode, this.enumerationDir);
    }

    public boolean hasMoreElements() {
        if (this.next == null) {
            this.next = this.next();
        }
        return this.next != null;
    }

    public Object nextElement() {
        if (this.next != null) {
            Element element = this.next;
            this.next = null;
            return element;
        }
        return this.next();
    }

    Element next() {
        if (!this.enumerationDir) {
            return this.nextElementTreeBFS();
        }
        return this.nextElementTreeDFS();
    }

    Element nextElementTreeDFS() {
        while (this.curr != null) {
            this.DFSstack.push(this.children);
            this.children = this.curr.getElements();
            if (this.children.hasMoreElements()) {
                this.curr = (Element)this.children.nextElement();
                return this.curr;
            }
            this.curr = this.curr.getParent();
            while (this.curr != null) {
                if (this.DFSstack.empty()) {
                    return null;
                }
                this.children = (Enumeration)this.DFSstack.pop();
                if (this.children.hasMoreElements()) {
                    this.curr = (Element)this.children.nextElement();
                    return this.curr;
                }
                this.curr = this.curr.getParent();
            }
        }
        return null;
    }

    Element nextElementTreeBFS() {
        if (this.curr != null) {
            while (!this.children.hasMoreElements()) {
                this.children = (Enumeration)this.BFSqueue.pull();
                if (this.children != null) continue;
                return null;
            }
            this.curr = (Element)this.children.nextElement();
            this.BFSqueue.push(this.curr.getElements());
            return this.curr;
        }
        return null;
    }
}

