/*
 * Decompiled with CFR 0.152.
 */
package com.ms.xml.parser;

import com.ms.xml.om.Element;
import com.ms.xml.om.ElementImpl;
import com.ms.xml.parser.Choice;
import com.ms.xml.parser.Closure;
import com.ms.xml.parser.ClosurePlus;
import com.ms.xml.parser.Context;
import com.ms.xml.parser.Entity;
import com.ms.xml.parser.Node;
import com.ms.xml.parser.ParseException;
import com.ms.xml.parser.Parser;
import com.ms.xml.parser.Qmark;
import com.ms.xml.parser.Sequence;
import com.ms.xml.parser.Terminal;
import com.ms.xml.util.Atom;
import com.ms.xml.util.Name;
import com.ms.xml.util.XMLOutputStream;
import java.io.IOException;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ContentModel {
    Node content;
    Terminal end;
    Vector terminalnodes;
    Hashtable symboltable;
    Vector symbols;
    Vector Dtrans;
    public static final byte EMPTY = 1;
    public static final byte ANY = 2;
    public static final byte ELEMENTS = 4;
    byte type;
    static Name nameEMPTY = Name.create("EMPTY", "XML");
    static Name nameANY = Name.create("ANY", "XML");

    public byte getType() {
        return this.type;
    }

    public String toString() {
        String string;
        switch (this.type) {
            case 1: {
                string = "EMPTY";
                break;
            }
            case 2: {
                string = "ANY";
                break;
            }
            case 4: {
                string = "ELEMENTS";
                break;
            }
            default: {
                string = "*UNKNOWN*";
            }
        }
        return "Content: type=" + string;
    }

    final void parseModel(Parser parser) throws ParseException {
        this.terminalnodes = new Vector();
        this.symboltable = new Hashtable();
        this.symbols = new Vector();
        this.content = this.parseRootNode(parser);
        this.end = new Terminal(this, null);
        this.content = new Sequence(this.content, this.end);
        int n = this.terminalnodes.size();
        BitSet[] bitSetArray = new BitSet[n];
        for (int i = 0; i < n; ++i) {
            bitSetArray[i] = new BitSet(n);
        }
        this.content.calcfollowpos(bitSetArray);
        Vector<BitSet> vector = new Vector<BitSet>();
        this.Dtrans = new Vector();
        Vector<BitSet> vector2 = new Vector<BitSet>();
        Hashtable<BitSet, Integer> hashtable = new Hashtable<BitSet, Integer>();
        BitSet bitSet = new BitSet(n);
        hashtable.put(bitSet, new Integer(-1));
        int n2 = 0;
        BitSet bitSet2 = this.content.firstpos(n);
        hashtable.put(bitSet2, new Integer(vector.size()));
        vector2.addElement(bitSet2);
        vector.addElement(bitSet2);
        int[] nArray = new int[this.symbols.size() + 1];
        this.Dtrans.addElement(nArray);
        if (bitSet2.get(this.end.pos)) {
            nArray[this.symbols.size()] = 1;
        }
        while (vector2.size() > 0) {
            int[] nArray2 = (int[])this.Dtrans.elementAt(n2);
            bitSet2 = (BitSet)vector2.elementAt(0);
            vector2.removeElementAt(0);
            for (int i = 0; i < this.symbols.size(); ++i) {
                int n3;
                Name name = (Name)this.symbols.elementAt(i);
                BitSet bitSet3 = new BitSet(n);
                for (int j = 0; j < n; ++j) {
                    if (!bitSet2.get(j) || ((Terminal)this.terminalnodes.elementAt((int)j)).name != name) continue;
                    bitSet3.or(bitSetArray[j]);
                }
                Integer n4 = (Integer)hashtable.get(bitSet3);
                if (n4 == null) {
                    n3 = vector.size();
                    hashtable.put(bitSet3, new Integer(n3));
                    vector2.addElement(bitSet3);
                    vector.addElement(bitSet3);
                    nArray = new int[this.symbols.size() + 1];
                    this.Dtrans.addElement(nArray);
                    if (bitSet3.get(this.end.pos)) {
                        nArray[this.symbols.size()] = 1;
                    }
                } else {
                    n3 = n4;
                }
                nArray2[i] = n3;
            }
            ++n2;
        }
    }

    final Node parseList(Parser parser) throws ParseException {
        Hashtable<Name, Name> hashtable = new Hashtable<Name, Name>();
        hashtable.put(parser.name, parser.name);
        Node node = this.parseNode(parser);
        int n = parser.token;
        switch (parser.token) {
            case 44: {
                parser.nextToken();
                node = new Sequence(node, this.parseNode(parser));
                break;
            }
            case 124: {
                parser.nextToken();
                if (parser.token == -4) {
                    if (hashtable.contains(parser.name)) {
                        parser.error("Warning: Repeated element in content model: " + parser.name);
                    } else {
                        hashtable.put(parser.name, parser.name);
                    }
                }
                node = new Choice(node, this.parseNode(parser));
                break;
            }
            case 41: {
                return node;
            }
            default: {
                parser.error("Illegal token in content model: " + parser.tokenString(parser.token));
            }
        }
        while (parser.token != 41) {
            if (n == 44 && parser.token == 44) {
                parser.nextToken();
                node = new Sequence(node, this.parseNode(parser));
                continue;
            }
            if (n == 124 && parser.token == 124) {
                parser.nextToken();
                if (parser.token == -4) {
                    if (hashtable.contains(parser.name)) {
                        parser.error("Repeated element in content model: " + parser.name);
                    } else {
                        hashtable.put(parser.name, parser.name);
                    }
                }
                node = new Choice(node, this.parseNode(parser));
                continue;
            }
            parser.error("Illegal token in content model: " + parser.tokenString(parser.token));
        }
        return node;
    }

    final Node parseNode(Parser parser) throws ParseException {
        Node node;
        switch (parser.token) {
            case 40: {
                parser.nextToken();
                node = this.parseList(parser);
                break;
            }
            case -4: {
                node = new Terminal(this, parser.name);
                break;
            }
            default: {
                node = null;
                parser.error("Illegal token in content model: " + parser.tokenString(parser.token));
            }
        }
        return this.finishNode(parser, node);
    }

    final Node finishNode(Parser parser, Node node) throws ParseException {
        Node node2;
        switch (parser.lookahead) {
            case 42: {
                parser.nextToken();
                node2 = new Closure(node);
                break;
            }
            case 43: {
                parser.nextToken();
                node2 = new ClosurePlus(node);
                break;
            }
            case 63: {
                parser.nextToken();
                node2 = new Qmark(node);
                break;
            }
            default: {
                node2 = node;
            }
        }
        parser.nextToken();
        return node2;
    }

    final Node parseRootNode(Parser parser) throws ParseException {
        Node node;
        switch (parser.token) {
            case 40: {
                parser.nextToken();
                if (parser.token == 35) {
                    return this.parseMixed(parser);
                }
                node = this.parseList(parser);
                break;
            }
            case -4: {
                node = new Terminal(this, parser.name);
                break;
            }
            default: {
                node = null;
                parser.error("Expected ANY, EMPTY or '(' instead of: " + parser.tokenString(parser.token));
            }
        }
        return this.finishNode(parser, node);
    }

    final Node parseMixed(Parser parser) throws ParseException {
        Hashtable<Name, Name> hashtable = new Hashtable<Name, Name>();
        parser.parseKeyword(-18, "PCDATA");
        Node node = new Terminal(this, parser.name);
        hashtable.put(parser.name, parser.name);
        parser.nextToken();
        switch (parser.token) {
            case 41: {
                node = new Closure(node);
                if (parser.lookahead != 42) break;
                parser.nextToken();
                break;
            }
            case 124: {
                while (parser.token == 124) {
                    parser.nextToken();
                    if (parser.token == -4) {
                        if (hashtable.contains(parser.name)) {
                            parser.error("Repeated element in content model: " + parser.name);
                        } else {
                            hashtable.put(parser.name, parser.name);
                        }
                    }
                    node = new Choice(node, this.parseNode(parser));
                }
                if (parser.token == 41) {
                    if (parser.lookahead == 42) {
                        parser.nextToken();
                        node = new Closure(node);
                        break;
                    }
                    parser.error("Expected '*' instead of: " + parser.tokenString(parser.token));
                    break;
                }
                parser.error("Illegal token in content model: " + parser.tokenString(parser.token));
                break;
            }
            default: {
                parser.error("Illegal token in content model: " + parser.tokenString(parser.token));
            }
        }
        parser.nextToken();
        return node;
    }

    final void initContent(Context context, Parser parser) throws ParseException {
        context.state = 0;
        context.matched = this.Dtrans != null && this.Dtrans.size() > 0 ? ((int[])this.Dtrans.elementAt(context.state))[this.symbols.size()] > 0 : true;
    }

    final boolean acceptEmpty() {
        if (this.type == 2 || this.type == 1) {
            return true;
        }
        Node node = ((Sequence)this.content).left;
        return node instanceof Qmark || node instanceof Closure;
    }

    final Vector expectedElements(int n) {
        int[] nArray = (int[])this.Dtrans.elementAt(n);
        Vector<Name> vector = new Vector<Name>();
        Enumeration enumeration = this.terminalnodes.elements();
        while (enumeration.hasMoreElements()) {
            Integer n2;
            Name name = ((Terminal)enumeration.nextElement()).name;
            if (name == null || vector.contains(name) || (n2 = (Integer)this.symboltable.get(name)) == null || nArray[n2] == -1) continue;
            vector.addElement(name);
        }
        return vector;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final boolean checkContent(Context context, Element element, Parser parser) throws ParseException {
        Object object;
        if (this.type == 2) {
            context.matched = true;
            return true;
        }
        Name name = null;
        if (element.getType() == 11) {
            object = parser.dtd.findEntity(element.getTagName());
            if (((Entity)object).getLength() != -1) return true;
            name = Parser.namePCDATA;
        } else {
            name = element.getType() == 1 ? Parser.namePCDATA : element.getTagName();
        }
        if (name != null) {
            object = (Integer)this.symboltable.get(name);
            if (object != null) {
                int n = (Integer)object;
                int n2 = ((int[])this.Dtrans.elementAt(context.state))[n];
                if (n2 == -1) {
                    parser.error("Pattern mismatch in content of '" + element.getParent().getTagName() + "'. Expected " + this.expectedElements(context.state));
                    return true;
                } else {
                    context.state = n2;
                    context.matched = ((int[])this.Dtrans.elementAt(context.state))[this.symbols.size()] > 0;
                }
                return true;
            }
            Vector vector = this.expectedElements(context.state);
            if (vector.isEmpty()) {
                parser.error("Invalid element '" + name + "' in content of '" + context.ed.name + "'.  Expected closing tag.");
                return false;
            } else {
                parser.error("Invalid element '" + name + "' in content of '" + context.ed.name + "'.  Expected " + vector);
            }
            return false;
        } else {
            parser.error("Invalid element in content of '" + context.ed.name + "'");
        }
        return false;
    }

    public Element toSchema() {
        Element element = null;
        switch (this.type) {
            case 1: {
                element = new ElementImpl(nameEMPTY, 0);
                break;
            }
            case 2: {
                element = new ElementImpl(nameANY, 0);
                break;
            }
            case 4: {
                if (this.content == null) break;
                ElementImpl elementImpl = new ElementImpl(Name.create("DUMMYNODE"), 0);
                ((Sequence)this.content).left.toSchema(35, 0, elementImpl);
                element = elementImpl.getChild(0);
            }
        }
        return element;
    }

    public void save(Atom atom, XMLOutputStream xMLOutputStream) throws IOException {
        switch (this.type) {
            case 1: {
                xMLOutputStream.writeChars("EMPTY");
                break;
            }
            case 2: {
                xMLOutputStream.writeChars("ANY");
                break;
            }
            case 4: {
                if (this.content == null) break;
                ((Sequence)this.content).left.save(xMLOutputStream, 35, 0, atom);
            }
        }
    }
}

