/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.DAVExplorer;

import com.ms.xml.om.Element;
import com.ms.xml.om.TreeEnumeration;
import com.ms.xml.util.Name;
import edu.uci.ics.DAVExplorer.ACLNode;
import edu.uci.ics.DAVExplorer.GlobalData;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class ACLModel
extends AbstractTableModel {
    protected String[] names = new String[]{"Principals", "Privileges", "Grant/Deny", "Inherited From"};
    protected Class[] types = new Class[]{class$java$lang$String == null ? (class$java$lang$String = ACLModel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = ACLModel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = ACLModel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = ACLModel.class$("java.lang.String")) : class$java$lang$String};
    protected Vector rows = new Vector();
    static /* synthetic */ Class class$java$lang$String;

    public ACLModel(Element element) {
        this.parseProperties(element);
    }

    public String getColumnName(int n) {
        if (n < this.names.length) {
            return this.names[n];
        }
        return super.getColumnName(n);
    }

    public Class getColumnClass(int n) {
        if (n < this.names.length) {
            return this.types[n];
        }
        return super.getColumnClass(n);
    }

    public int getColumnCount() {
        return 4;
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public Object getValueAt(int n, int n2) {
        ACLNode aCLNode = (ACLNode)this.rows.get(n);
        switch (n2) {
            case 0: {
                return aCLNode.getPrincipal()[0];
            }
            case 1: {
                Vector vector = aCLNode.getPrivileges();
                String string = "";
                if (vector != null) {
                    for (int i = 0; i < vector.size(); ++i) {
                        if (i > 0) {
                            string = string + ", ";
                        }
                        string = string + vector.get(i);
                    }
                }
                return string;
            }
            case 2: {
                if (aCLNode.getGrant()) {
                    return "Grant";
                }
                return "Deny";
            }
            case 3: {
                if (aCLNode.isInherited()) {
                    return aCLNode.getInherited();
                }
                return "";
            }
        }
        return null;
    }

    public void clear() {
        for (int i = 0; i < this.rows.size(); ++i) {
            ((ACLNode)this.rows.get(i)).clearModified();
        }
    }

    public void addRow(String[] stringArray, int n, Vector vector, boolean bl) {
        int n2 = this.rows.size();
        ACLNode aCLNode = new ACLNode(stringArray, n, vector, bl);
        this.rows.add(aCLNode);
        this.fireTableRowsInserted(n2, n2);
    }

    public ACLNode getRow(int n) {
        if (n < this.rows.size()) {
            return (ACLNode)this.rows.get(n);
        }
        return null;
    }

    public void removeRow(int n) {
        if (n < this.rows.size()) {
            this.rows.remove(n);
            this.fireTableRowsDeleted(n, n);
        }
    }

    private void parseProperties(Element element) {
        if (GlobalData.getGlobalData().getDebugResponse()) {
            System.err.println("ACLModel::parseProperties");
        }
        if (element != null) {
            TreeEnumeration treeEnumeration = new TreeEnumeration(element);
            while (treeEnumeration.hasMoreElements()) {
                Element element2 = (Element)treeEnumeration.nextElement();
                Name name = element2.getTagName();
                if (name == null || !name.getName().equals("ace")) continue;
                this.parseACE(element2);
            }
        }
    }

    private void parseACE(Element element) {
        ACLNode aCLNode = new ACLNode();
        TreeEnumeration treeEnumeration = new TreeEnumeration(element);
        while (treeEnumeration.hasMoreElements()) {
            Element element2 = (Element)treeEnumeration.nextElement();
            Name name = element2.getTagName();
            if (name == null) continue;
            if (name.getName().equals("principal")) {
                this.parsePrincipal(element2, aCLNode);
                continue;
            }
            if (name.getName().equals("grant")) {
                aCLNode.setGrant(true);
                this.parsePrivileges(element2, aCLNode);
                continue;
            }
            if (name.getName().equals("deny")) {
                aCLNode.setGrant(false);
                this.parsePrivileges(element2, aCLNode);
                continue;
            }
            if (!name.getName().equals("inherited")) continue;
            this.parseInherited(element2, aCLNode);
        }
        aCLNode.clearModified();
        this.rows.add(aCLNode);
    }

    private void parsePrincipal(Element element, ACLNode aCLNode) {
        TreeEnumeration treeEnumeration = new TreeEnumeration(element);
        while (treeEnumeration.hasMoreElements()) {
            Object object;
            Element element2 = (Element)treeEnumeration.nextElement();
            Name name = element2.getTagName();
            if (name == null || name.getName().equals("principal")) continue;
            if (name.getName().equals("href")) {
                object = (String[])treeEnumeration.nextElement();
                if (object == null || object.getType() != 1 && object.getType() != 6) continue;
                String[] stringArray = new String[2];
                stringArray[0] = stringArray[1] = GlobalData.getGlobalData().unescape(object.getText(), "UTF-8", null);
                aCLNode.setPrincipal(stringArray);
                aCLNode.setPrincipalType(3);
                break;
            }
            if (name.getName().equals("property")) {
                object = (Element)treeEnumeration.nextElement();
                while (object.getTagName() == null) {
                    object = (Element)treeEnumeration.nextElement();
                }
                String[] stringArray = new String[]{"property", object.getTagName().getName()};
                aCLNode.setPrincipal(stringArray);
                aCLNode.setPrincipalType(2);
                break;
            }
            object = new String[2];
            object[0] = object[1] = name.getName();
            aCLNode.setPrincipal((String[])object);
            aCLNode.setPrincipalType(1);
            break;
        }
    }

    private void parsePrivileges(Element element, ACLNode aCLNode) {
        TreeEnumeration treeEnumeration = new TreeEnumeration(element);
        while (treeEnumeration.hasMoreElements()) {
            Element element2 = (Element)treeEnumeration.nextElement();
            Name name = element2.getTagName();
            if (name == null || name.getName().equals("grant") || name.getName().equals("deny") || !name.getName().equals("privilege")) continue;
            Element element3 = (Element)treeEnumeration.nextElement();
            while (element3.getTagName() == null) {
                element3 = (Element)treeEnumeration.nextElement();
            }
            aCLNode.addPrivilege(element3.getTagName().getName());
        }
    }

    private void parseInherited(Element element, ACLNode aCLNode) {
        TreeEnumeration treeEnumeration = new TreeEnumeration(element);
        while (treeEnumeration.hasMoreElements()) {
            Element element2;
            Element element3 = (Element)treeEnumeration.nextElement();
            Name name = element3.getTagName();
            if (name == null || name.getName().equals("inherited") || !name.getName().equals("href") || (element2 = (Element)treeEnumeration.nextElement()) == null || element2.getType() != 1 && element2.getType() != 6) continue;
            aCLNode.setInherited(GlobalData.getGlobalData().unescape(element2.getText(), "UTF-8", null));
            break;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

