/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.DAVExplorer;

import HTTPClient.ContentEncodingModule;
import HTTPClient.HttpHeaderElement;
import HTTPClient.Log;
import HTTPClient.ModuleException;
import HTTPClient.NVPair;
import HTTPClient.ParseException;
import HTTPClient.Request;
import HTTPClient.Response;
import HTTPClient.RoRequest;
import HTTPClient.Util;
import java.io.IOException;
import java.util.Vector;

public class ContentEncoding
extends ContentEncodingModule {
    public int requestHandler(Request request, Response[] responseArray) throws ModuleException {
        Vector vector;
        int n;
        int n2 = super.requestHandler(request, responseArray);
        NVPair[] nVPairArray = request.getHeaders();
        for (n = 0; n < nVPairArray.length && !nVPairArray[n].getName().equalsIgnoreCase("Accept-Encoding"); ++n) {
        }
        if (n == nVPairArray.length) {
            return n2;
        }
        try {
            vector = Util.parseHeader(nVPairArray[n].getValue());
        }
        catch (ParseException parseException) {
            throw new ModuleException(parseException.toString());
        }
        HttpHeaderElement httpHeaderElement = Util.getElement(vector, "*");
        if (httpHeaderElement != null) {
            NVPair[] nVPairArray2 = httpHeaderElement.getParams();
            for (n = 0; n < nVPairArray2.length && !nVPairArray2[n].getName().equalsIgnoreCase("q"); ++n) {
            }
            if (n == nVPairArray2.length) {
                return n2;
            }
            if (nVPairArray2[n].getValue() == null || nVPairArray2[n].getValue().length() == 0) {
                throw new ModuleException("Invalid q value for \"*\" in Accept-Encoding header: ");
            }
            try {
                if ((double)Float.valueOf(nVPairArray2[n].getValue()).floatValue() > 0.0) {
                    return n2;
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new ModuleException("Invalid q value for \"*\" in Accept-Encoding header: " + numberFormatException.getMessage());
            }
        }
        if (vector.contains(new HttpHeaderElement("deflate"))) {
            vector.removeElement(new HttpHeaderElement("deflate"));
        }
        if (vector.contains(new HttpHeaderElement("gzip"))) {
            vector.removeElement(new HttpHeaderElement("gzip"));
        }
        if (vector.contains(new HttpHeaderElement("x-gzip"))) {
            vector.removeElement(new HttpHeaderElement("x-gzip"));
        }
        if (vector.contains(new HttpHeaderElement("compress"))) {
            vector.removeElement(new HttpHeaderElement("compress"));
        }
        if (vector.contains(new HttpHeaderElement("x-compress"))) {
            vector.removeElement(new HttpHeaderElement("x-compress"));
        }
        nVPairArray[n] = new NVPair("Accept-Encoding", Util.assembleHeader(vector));
        return n2;
    }

    public void responsePhase3Handler(Response response, RoRequest roRequest) throws IOException, ModuleException {
        Vector vector;
        String string = response.getHeader("Content-Encoding");
        if (string == null || roRequest.getMethod().equals("HEAD") || response.getStatusCode() == 206) {
            return;
        }
        try {
            vector = Util.parseHeader(string);
        }
        catch (ParseException parseException) {
            throw new ModuleException(parseException.toString());
        }
        if (vector.size() == 0) {
            return;
        }
        String string2 = ((HttpHeaderElement)vector.firstElement()).getName();
        if (string2.equalsIgnoreCase("identity")) {
            super.responsePhase3Handler(response, roRequest);
            return;
        }
        Log.write(32, "CEM:   Unknown content encoding '" + string2 + "'");
        if (vector.size() > 0) {
            response.setHeader("Content-Encoding", Util.assembleHeader(vector));
        } else {
            response.deleteHeader("Content-Encoding");
        }
    }
}

