/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.DAVExplorer;

import edu.uci.ics.DAVExplorer.AsGen;
import edu.uci.ics.DAVExplorer.EscapeInputStream;
import edu.uci.ics.DAVExplorer.URIBox;
import edu.uci.ics.DAVExplorer.WebDAVRequestGenerator;
import edu.uci.ics.DAVExplorer.WebDAVResponseInterpreter;
import edu.uci.ics.DAVExplorer.WebDAVTreeNode;
import edu.uci.ics.DAVExplorer.WebDAVTreeView;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

class GlobalData {
    boolean debugAll = false;
    boolean debugRequest = this.debugAll | false;
    boolean debugResponse = this.debugAll | false;
    boolean debugTreeView = this.debugAll | false;
    boolean debugTreeNode = this.debugAll | false;
    boolean debugFileView = this.debugAll | false;
    boolean ssl = false;
    boolean compression = true;
    JFrame mainFrame = null;
    Cursor origCursor = null;
    private static final String fileName = "DAVExplorer.dat";
    private static final String tmpFileName = "DAVExplorer.tmp";
    private boolean isAppletMode = false;
    private boolean hideURIBox = false;
    private String[][] initialSites = new String[][]{new String[0]};
    private String appletProxy;
    private boolean doAddStartDir = true;
    private URIBox uriBox;
    private WebDAVTreeView tree;
    private static GlobalData globalData = null;
    public static final String WebDAVPrefix = "http://";
    public static final String WebDAVPrefixSSL = "https://";

    protected GlobalData() {
        this.init(true);
    }

    static void reset() {
        globalData = null;
        AsGen.clear();
        WebDAVRequestGenerator.reset();
        WebDAVResponseInterpreter.reset();
        WebDAVTreeNode.reset();
        System.gc();
    }

    static GlobalData getGlobalData() {
        if (globalData == null) {
            globalData = new GlobalData();
        }
        return globalData;
    }

    public void setTree(WebDAVTreeView webDAVTreeView) {
        this.tree = webDAVTreeView;
    }

    public WebDAVTreeView getTree() {
        return this.tree;
    }

    public boolean isAppletMode() {
        return this.isAppletMode;
    }

    public void setAppletMode(boolean bl) {
        this.isAppletMode = bl;
    }

    public void setInitialSites(String[][] stringArray) {
        if (stringArray != null) {
            this.initialSites = stringArray;
        }
    }

    public String[][] getInitialSites() {
        return this.initialSites;
    }

    public void setProxy(String string) {
        this.appletProxy = string;
    }

    public String getProxy() {
        return this.appletProxy;
    }

    public boolean hideURIBox() {
        return this.hideURIBox;
    }

    public void setHideURIBox(boolean bl) {
        this.hideURIBox = bl;
    }

    public void setURIBox(URIBox uRIBox) {
        this.uriBox = uRIBox;
    }

    public URIBox getURIBox() {
        return this.uriBox;
    }

    public boolean doAddStartDir() {
        return this.doAddStartDir;
    }

    public void setAddStartDir(boolean bl) {
        this.doAddStartDir = bl;
    }

    public boolean getDebugAll() {
        return this.debugAll;
    }

    public void setDebugAll(boolean bl) {
        this.debugAll = bl;
        this.init(false);
    }

    public boolean getDebugRequest() {
        return this.debugRequest;
    }

    public void setDebugRequest(boolean bl) {
        this.debugRequest = bl;
        this.init(false);
    }

    public boolean getDebugResponse() {
        return this.debugResponse;
    }

    public void setDebugResponse(boolean bl) {
        this.debugResponse = bl;
        this.init(false);
    }

    public boolean getDebugTreeView() {
        return this.debugTreeView;
    }

    public void setDebugTreeView(boolean bl) {
        this.debugTreeView = bl;
        this.init(false);
    }

    public boolean getDebugTreeNode() {
        return this.debugTreeNode;
    }

    public void setDebugTreeNode(boolean bl) {
        this.debugTreeNode = bl;
        this.init(false);
    }

    public boolean getDebugFileView() {
        return this.debugFileView;
    }

    public void setDebugFileView(boolean bl) {
        this.debugFileView = bl;
        this.init(false);
    }

    public JFrame getMainFrame() {
        return this.mainFrame;
    }

    public void setMainFrame(JFrame jFrame) {
        this.mainFrame = jFrame;
        if (this.mainFrame != null) {
            this.origCursor = this.mainFrame.getCursor();
        }
    }

    public void errorMsg(String string) {
        Object[] objectArray = new Object[]{"OK"};
        JOptionPane.showOptionDialog(this.mainFrame, string, "Error Message", -1, 0, null, objectArray, objectArray[0]);
    }

    public void setCursor(Cursor cursor) {
        if (this.mainFrame != null) {
            this.mainFrame.setCursor(cursor);
        }
    }

    public void resetCursor() {
        if (this.mainFrame != null && this.origCursor != null) {
            this.mainFrame.setCursor(this.origCursor);
        }
    }

    public String unescape(String string, String string2, String string3) {
        EscapeInputStream escapeInputStream;
        ByteArrayInputStream byteArrayInputStream;
        ByteArrayInputStream byteArrayInputStream2;
        try {
            if (string2 == null || string2.length() == 0) {
                byteArrayInputStream2 = new ByteArrayInputStream(string.getBytes("UTF-8"));
                byteArrayInputStream = new ByteArrayInputStream(string.getBytes("UTF-8"));
            } else {
                byteArrayInputStream2 = new ByteArrayInputStream(string.getBytes(string2));
                byteArrayInputStream = new ByteArrayInputStream(string.getBytes(string2));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byteArrayInputStream2 = new ByteArrayInputStream(string.getBytes());
            byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        }
        boolean bl = true;
        if (string3 == null || string3.length() == 0) {
            escapeInputStream = new EscapeInputStream(byteArrayInputStream, true);
            try {
                int n;
                while ((n = escapeInputStream.read()) != -1 && (bl = this.checkUTFFormed(n, escapeInputStream)) && n != -1) {
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        escapeInputStream = new EscapeInputStream(byteArrayInputStream2, true);
        try {
            InputStreamReader inputStreamReader = null;
            inputStreamReader = string3 == null || string3.length() == 0 ? (bl ? new InputStreamReader((InputStream)escapeInputStream, "UTF-8") : new InputStreamReader(escapeInputStream)) : new InputStreamReader((InputStream)escapeInputStream, string3);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String string4 = bufferedReader.readLine();
            return string4 == null ? "" : string4;
        }
        catch (IOException iOException) {
            GlobalData.getGlobalData().errorMsg("String unescaping error: \n" + iOException);
            return "";
        }
    }

    private boolean checkUTFFormed(int n, InputStream inputStream) {
        try {
            if (n < 128) {
                return true;
            }
            if (n >= 194 && n <= 223 ? (n = inputStream.read()) >= 128 && n <= 191 : (n == 224 ? (n = inputStream.read()) >= 160 && n <= 191 && (n = inputStream.read()) >= 128 && n <= 191 : (n >= 225 && n <= 236 ? (n = inputStream.read()) >= 128 && n <= 191 && (n = inputStream.read()) >= 128 && n <= 191 : (n == 237 ? (n = inputStream.read()) >= 128 && n <= 159 && (n = inputStream.read()) >= 128 && n <= 191 : (n >= 238 && n <= 239 ? (n = inputStream.read()) >= 128 && n <= 191 && (n = inputStream.read()) >= 128 && n <= 191 : (n == 240 ? (n = inputStream.read()) >= 144 && n <= 191 && (n = inputStream.read()) >= 128 && n <= 191 && (n = inputStream.read()) >= 128 && n <= 191 : (n >= 241 && n <= 243 ? (n = inputStream.read()) >= 128 && n <= 191 && (n = inputStream.read()) >= 128 && n <= 191 && (n = inputStream.read()) >= 128 && n <= 191 : n == 244 && (n = inputStream.read()) >= 128 && n <= 143 && (n = inputStream.read()) >= 128 && n <= 191 && (n = inputStream.read()) >= 128 && n <= 191))))))) {
                return true;
            }
        }
        catch (IOException iOException) {
            return false;
        }
        return false;
    }

    public void setSSL(boolean bl) {
        this.ssl = bl;
        this.WriteConfigEntry("UseSSL", Boolean.toString(bl));
    }

    public boolean getSSL() {
        return this.ssl;
    }

    public void setCompressions(boolean bl) {
        this.compression = bl;
    }

    public boolean getCompression() {
        return this.compression;
    }

    public String ReadConfigEntry(String string, String string2) {
        Vector vector = this.ReadConfigEntry(string, false);
        if (vector.size() > 0) {
            return (String)vector.elementAt(0);
        }
        if (string2 != null) {
            return string2;
        }
        return "";
    }

    public String ReadConfigEntry(String string) {
        return this.ReadConfigEntry(string, "");
    }

    public Vector ReadConfigEntry(String string, boolean bl) {
        Vector<String> vector = new Vector<String>();
        String string2 = System.getProperty("user.home");
        string2 = string2 == null ? "" : string2 + File.separatorChar;
        String string3 = null;
        File file = new File(string2 + fileName);
        if (file.exists()) {
            string3 = string2 + fileName;
        }
        if (string3 != null) {
            try {
                String string4;
                FileInputStream fileInputStream = new FileInputStream(string3);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
                boolean bl2 = false;
                while ((string4 = bufferedReader.readLine()) != null) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string4, "= \t");
                    if (stringTokenizer.nextToken().equals(string)) {
                        String string5 = stringTokenizer.nextToken();
                        vector.addElement(string5);
                        bl2 = true;
                    }
                    if (bl || !bl2) continue;
                }
                bufferedReader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return vector;
    }

    public void WriteConfigEntry(String string, String string2) {
        this.WriteConfigEntry(string, string2, true);
    }

    public void WriteConfigEntry(String string, Vector vector) {
        if (vector == null || vector.size() == 0) {
            return;
        }
        this.WriteConfigEntry(string, (String)vector.elementAt(0), true);
        for (int i = 1; i < vector.size(); ++i) {
            this.WriteConfigEntry(string, (String)vector.elementAt(i), false);
        }
    }

    public void WriteConfigEntry(String string, Vector vector, boolean bl) {
        if (vector == null || vector.size() == 0) {
            return;
        }
        this.WriteConfigEntry(string, (String)vector.elementAt(0), bl);
        for (int i = 1; i < vector.size(); ++i) {
            this.WriteConfigEntry(string, (String)vector.elementAt(i), false);
        }
    }

    public void WriteConfigEntry(String string, String string2, boolean bl) {
        String string3 = System.getProperty("user.home");
        string3 = string3 == null ? "" : string3 + File.separatorChar;
        String string4 = string3 + fileName;
        String string5 = string3 + tmpFileName;
        try {
            Object object;
            FileOutputStream fileOutputStream = new FileOutputStream(string5);
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(fileOutputStream));
            File file = new File(string4);
            if (file.exists()) {
                object = new FileInputStream(string4);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)object));
                String string6 = null;
                do {
                    if ((string6 = bufferedReader.readLine()) == null) continue;
                    StringTokenizer stringTokenizer = new StringTokenizer(string6, "= \t");
                    if (bl && stringTokenizer.nextToken().equals(string)) continue;
                    bufferedWriter.write(string6);
                    bufferedWriter.newLine();
                } while (string6 != null);
                bufferedReader.close();
            }
            bufferedWriter.write(string);
            bufferedWriter.write("=");
            bufferedWriter.write(string2);
            bufferedWriter.newLine();
            bufferedWriter.close();
            if (file.exists()) {
                file.delete();
            }
            object = new File(string5);
            ((File)object).renameTo(file);
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
    }

    private void init(boolean bl) {
        if (bl) {
            String string = System.getProperty("debug");
            if (string != null) {
                if (string.equalsIgnoreCase("all")) {
                    this.setDebugAll(true);
                } else if (string.equalsIgnoreCase("request")) {
                    this.setDebugRequest(true);
                } else if (string.equalsIgnoreCase("response")) {
                    this.setDebugResponse(true);
                } else if (string.equalsIgnoreCase("treeview")) {
                    this.setDebugTreeView(true);
                } else if (string.equalsIgnoreCase("treenode")) {
                    this.setDebugTreeNode(true);
                } else if (string.equalsIgnoreCase("fileview")) {
                    this.setDebugFileView(true);
                }
            }
            String string2 = this.ReadConfigEntry("UseSSL", "no");
            if ((string2 = System.getProperty("ssl", string2)).equalsIgnoreCase("yes") || string2.equalsIgnoreCase("true")) {
                this.setSSL(true);
            } else {
                string2 = System.getProperty("SSL", "no");
                if (string2.equalsIgnoreCase("yes") || string2.equalsIgnoreCase("true")) {
                    this.setSSL(true);
                }
            }
            String string3 = System.getProperty("compress", "yes");
            if (string3.equalsIgnoreCase("no") || string3.equalsIgnoreCase("false")) {
                this.compression = false;
            }
        }
        this.debugRequest |= this.debugAll;
        this.debugResponse |= this.debugAll;
        this.debugTreeView |= this.debugAll;
        this.debugTreeNode |= this.debugAll;
        this.debugFileView |= this.debugAll;
    }

    public ImageIcon getImageIcon(String string, String string2) {
        try {
            InputStream inputStream = this.getClass().getResourceAsStream("icons/" + string);
            return new ImageIcon(GlobalData.toByteArray(inputStream), string2);
        }
        catch (Exception exception) {
            this.errorMsg("Icon load failure: " + exception);
            return null;
        }
    }

    public static byte[] toByteArray(InputStream inputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[10000];
        while ((n = inputStream.read(byArray, 0, byArray.length)) > 0) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static void methodEnter(String string, String string2, boolean bl) {
        if (bl) {
            System.err.println(string2 + "::" + string + " entered.");
        }
    }

    public static void methodLeave(String string, String string2, boolean bl) {
        if (bl) {
            System.err.println(string2 + "::" + string + " left.");
        }
    }

    protected void center(Dialog dialog) {
        int n;
        Rectangle rectangle = dialog.getParent().getBounds();
        Rectangle rectangle2 = dialog.getBounds();
        int n2 = rectangle.x + (rectangle.width - rectangle2.width) / 2;
        if (n2 < 0) {
            n2 = 0;
        }
        if ((n = rectangle.y + (rectangle.height - rectangle2.height) / 2) < 0) {
            n = 0;
        }
        dialog.setBounds(n2, n, rectangle2.width, rectangle2.height);
    }
}

