/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.DAVExplorer;

import HTTPClient.CookieModule;
import HTTPClient.DefaultAuthHandler;
import edu.uci.ics.DAVExplorer.ACLReportPropertiesDialog;
import edu.uci.ics.DAVExplorer.ACLReportSearchPropertyDialog;
import edu.uci.ics.DAVExplorer.ACLRequestGenerator;
import edu.uci.ics.DAVExplorer.ACLResponseInterpreter;
import edu.uci.ics.DAVExplorer.AuthDialog;
import edu.uci.ics.DAVExplorer.GlobalData;
import edu.uci.ics.DAVExplorer.InsertionListener;
import edu.uci.ics.DAVExplorer.ProgressBar;
import edu.uci.ics.DAVExplorer.ResponseException;
import edu.uci.ics.DAVExplorer.URIBox;
import edu.uci.ics.DAVExplorer.ViewSelectionEvent;
import edu.uci.ics.DAVExplorer.ViewSelectionListener;
import edu.uci.ics.DAVExplorer.WebDAVCompletionEvent;
import edu.uci.ics.DAVExplorer.WebDAVCompletionListener;
import edu.uci.ics.DAVExplorer.WebDAVFileView;
import edu.uci.ics.DAVExplorer.WebDAVLockInfo;
import edu.uci.ics.DAVExplorer.WebDAVManager;
import edu.uci.ics.DAVExplorer.WebDAVMenu;
import edu.uci.ics.DAVExplorer.WebDAVProxyInfo;
import edu.uci.ics.DAVExplorer.WebDAVRequestEvent;
import edu.uci.ics.DAVExplorer.WebDAVRequestListener;
import edu.uci.ics.DAVExplorer.WebDAVResponseEvent;
import edu.uci.ics.DAVExplorer.WebDAVResponseListener;
import edu.uci.ics.DAVExplorer.WebDAVToolBar;
import edu.uci.ics.DAVExplorer.WebDAVTreeNode;
import edu.uci.ics.DAVExplorer.WebDAVTreeView;
import edu.uci.ics.DAVExplorer.WebDAVURIBoxListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.EventListenerList;

public class Main
extends JFrame {
    public static final String VERSION = "0.91";
    public static final String UserAgent = "UCI DAV Explorer/0.91";
    public static final String COPYRIGHT = "Copyright (c) 1998-2005 Regents of the University of California";
    public static final String EMAIL = "EMail: dav-exp@ics.uci.edu";
    protected DropEnabler dropEnabler;
    protected WebDAVFileView fileView;
    protected WebDAVTreeView treeView;
    protected ACLRequestGenerator requestGenerator;
    protected ACLResponseInterpreter responseInterpreter;
    protected WebDAVManager webdavManager;
    protected WebDAVMenu CommandMenu;
    protected Hashtable authTable;
    protected String writeToDir;
    protected EventListenerList listenerList = new EventListenerList();
    protected URIBox uribox;
    static /* synthetic */ Class class$edu$uci$ics$DAVExplorer$WebDAVCompletionListener;

    public Main(String string) {
        super(string);
        this.setLookAndFeel();
        GlobalData.getGlobalData().setMainFrame(this);
        this.authTable = new Hashtable();
        this.treeView = new WebDAVTreeView();
        this.treeView.setUserAgent(UserAgent);
        this.fileView = this.createFileView();
        this.treeView.addViewSelectionListener(this.fileView);
        this.fileView.addViewSelectionListener(this.treeView);
        DefaultAuthHandler.setAuthorizationPrompter(new AuthDialog());
        CookieModule.setCookiePolicyHandler(null);
        this.requestGenerator = new ACLRequestGenerator();
        this.requestGenerator.addRequestListener(new RequestListener());
        this.requestGenerator.setUserAgent(UserAgent);
        this.responseInterpreter = new ACLResponseInterpreter(this.requestGenerator);
        this.responseInterpreter.addInsertionListener(new TreeInsertionListener());
        this.responseInterpreter.addMoveUpdateListener(new MoveUpdateListener());
        this.responseInterpreter.addLockListener(new LockListener());
        this.responseInterpreter.addActionListener(this.fileView);
        this.responseInterpreter.addVersionControlListener(new VersionControlListener());
        this.responseInterpreter.addCheckoutListener(new CheckoutListener());
        this.responseInterpreter.addUnCheckoutListener(new UnCheckoutListener());
        this.responseInterpreter.addCheckinListener(new CheckinListener());
        this.responseInterpreter.addMkActivityListener(new MkActivityListener());
        this.responseInterpreter.addMergeListener(new MergeListener());
        this.responseInterpreter.addCopyResponseListener(this.treeView);
        this.responseInterpreter.addPutListener(this.treeView);
        this.webdavManager = new WebDAVManager();
        this.webdavManager.addResponseListener(new ResponseListener());
        System.setProperty("HTTPClient.deferStreamed", "true");
        this.buildFrame();
        try {
            this.dropEnabler = new DropEnabler(this.fileView.table);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            this.dropEnabler = null;
        }
        if (!GlobalData.getGlobalData().isAppletMode()) {
            this.setVisible(true);
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
            });
        }
    }

    public void setLookAndFeel() {
    }

    public void buildFrame() {
        this.CommandMenu = new WebDAVMenu();
        this.setJMenuBar(this.CommandMenu);
        MenuListener_Gen menuListener_Gen = new MenuListener_Gen();
        this.CommandMenu.addWebDAVMenuListener(menuListener_Gen);
        WebDAVToolBar webDAVToolBar = new WebDAVToolBar();
        webDAVToolBar.addActionListener(menuListener_Gen);
        this.uribox = new URIBox();
        GlobalData.getGlobalData().setURIBox(this.uribox);
        this.uribox.addActionListener(new URIBoxListener_Gen());
        JScrollPane jScrollPane = this.fileView.getScrollPane();
        JScrollPane jScrollPane2 = this.treeView.getScrollPane();
        JSplitPane jSplitPane = new JSplitPane(1, jScrollPane2, jScrollPane);
        jSplitPane.setContinuousLayout(true);
        JPanel jPanel = new JPanel();
        jPanel.setSize(800, 600);
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(webDAVToolBar, gridBagConstraints);
        jPanel.add(webDAVToolBar);
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridheight = -1;
        gridBagLayout.setConstraints(this.uribox, gridBagConstraints);
        jPanel.add(this.uribox);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridheight = 0;
        gridBagLayout.setConstraints(jSplitPane, gridBagConstraints);
        jPanel.add(jSplitPane);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)jPanel, "Center");
        this.getContentPane().add((Component)new ProgressBar(), "South");
        this.treeView.initTree();
        this.pack();
    }

    protected WebDAVFileView createFileView() {
        this.fileView = new WebDAVFileView();
        this.fileView.addRenameListener(new RenameListener());
        this.fileView.addDisplayLockListener(new DisplayLockListener());
        this.fileView.addDisplayVersionListener(new DisplayVersionListener());
        return this.fileView;
    }

    public static void main(String[] stringArray) {
        String string = System.getProperty("help", "no");
        if (string.equalsIgnoreCase("no")) {
            string = System.getProperty("version", "no");
            if (!string.equalsIgnoreCase("no")) {
                System.out.println("DAV Explorer Version 0.91");
                System.out.println(COPYRIGHT);
                System.out.println(EMAIL);
                return;
            }
            new Main("DAV Explorer");
        } else {
            System.out.println("DAV Explorer Version 0.91");
            System.out.println(COPYRIGHT);
            System.out.println("Authors: Yuzo Kanomata, Joachim Feise");
            System.out.println(EMAIL);
            System.out.println("Based on code from the UCI WebDAV Client Group of the ICS126B class");
            System.out.println("Winter 1998: Gerair Balian, Mirza Baig, Robert Emmery, Thai Le, Tu Le.");
            System.out.println("Basic DeltaV support based on code from the DeltaV Team of the ICS125");
            System.out.println("class Spring 2003: Max Slabyak, Matt Story, Hyung Kim.");
            System.out.println("Uses the HTTPClient library (http://www.innovation.ch/java/HTTPClient/).");
            System.out.println("Uses Microsoft's XML parser published in June 1997.\n");
            System.out.println("For other contributors see the contributors.txt file.\n");
            System.out.println("Options:");
            System.out.println("-Dhelp=yes");
            System.out.println("  This help message.\n");
            System.out.println("-Ddebug=option");
            System.out.println("  where option is one of:");
            System.out.println("  all          all function traces are enabled");
            System.out.println("  request      function traces related to HTTP requests are enabled");
            System.out.println("  response     function traces related to HTTP responses are enabled");
            System.out.println("  treeview     function traces related to the tree view on the left side");
            System.out.println("               of the DAVExplorer window are enabled");
            System.out.println("  treenode     function traces related to each node in the tree view are");
            System.out.println("               enabled");
            System.out.println("  fileview     function traces related to the file view on the right side");
            System.out.println("               of the DAVExplorer window are enabled\n");
            System.out.println("-Dpropfind=allprop");
            System.out.println("  This option results in using the <allprop> tag in PROPFIND.\n");
            System.out.println("-DSSL=yes");
            System.out.println("  This option enables the use of SSL.\n");
            System.out.println("-DSharePoint=yes");
            System.out.println("  This option enables a workaround for a bug in Microsoft's SharePoint");
            System.out.println("  server which allows tags to start with a digit.\n");
            System.out.println("-DApache=yes");
            System.out.println("  This option enables a workaround for a bug in Apache 1.3.x, which returns");
            System.out.println("  a 500 error in response to a PROPPATCH if the Host: header contains a port");
            System.out.println("  number.\n");
            System.out.println("-Dlocal=no");
            System.out.println("  This option prevents showing the local directory structure in the main");
            System.out.println("  DAV Explorer window.\n");
            System.out.println("-Dcompress=no");
            System.out.println("  This option prevents the use of compression when transferring data.");
        }
    }

    public void addWebDAVCompletionListener(WebDAVCompletionListener webDAVCompletionListener) {
        this.listenerList.add(class$edu$uci$ics$DAVExplorer$WebDAVCompletionListener == null ? (class$edu$uci$ics$DAVExplorer$WebDAVCompletionListener = Main.class$("edu.uci.ics.DAVExplorer.WebDAVCompletionListener")) : class$edu$uci$ics$DAVExplorer$WebDAVCompletionListener, webDAVCompletionListener);
    }

    public void removeWebDAVCompletionListener(WebDAVCompletionListener webDAVCompletionListener) {
        this.listenerList.remove(class$edu$uci$ics$DAVExplorer$WebDAVCompletionListener == null ? (class$edu$uci$ics$DAVExplorer$WebDAVCompletionListener = Main.class$("edu.uci.ics.DAVExplorer.WebDAVCompletionListener")) : class$edu$uci$ics$DAVExplorer$WebDAVCompletionListener, webDAVCompletionListener);
    }

    protected void fireWebDAVCompletion(Object object, boolean bl) {
        Object[] objectArray = this.listenerList.getListenerList();
        WebDAVCompletionEvent webDAVCompletionEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$edu$uci$ics$DAVExplorer$WebDAVCompletionListener == null ? Main.class$("edu.uci.ics.DAVExplorer.WebDAVCompletionListener") : class$edu$uci$ics$DAVExplorer$WebDAVCompletionListener)) continue;
            if (webDAVCompletionEvent == null) {
                webDAVCompletionEvent = new WebDAVCompletionEvent(object, bl);
            }
            ((WebDAVCompletionListener)objectArray[i + 1]).completion(webDAVCompletionEvent);
        }
    }

    protected void viewDocument() {
        if (this.requestGenerator.GenerateGet(51)) {
            this.requestGenerator.execute();
        }
    }

    protected void saveAsDocument() {
        String string = this.fileView.getSelected();
        if (string == null) {
            GlobalData.getGlobalData().errorMsg("No file selected.");
        } else {
            WebDAVTreeNode webDAVTreeNode = this.fileView.getParentNode();
            this.requestGenerator.setResource(string, webDAVTreeNode);
            if (this.requestGenerator.GenerateGet(6)) {
                this.requestGenerator.execute();
            }
        }
    }

    protected void deleteDocument(boolean bl) {
        String string = this.fileView.getSelected();
        if (!this.fileView.hasSelected()) {
            GlobalData.getGlobalData().errorMsg("No file selected.");
        } else {
            String string2 = null;
            String string3 = null;
            String string4 = null;
            if (this.treeView.isRemote(string)) {
                WebDAVTreeNode webDAVTreeNode = this.fileView.getParentNode();
                this.requestGenerator.setResource(string, webDAVTreeNode);
                string4 = this.requestGenerator.getDefaultName(null);
            } else {
                string4 = string;
            }
            if (bl) {
                string3 = "Delete Collection";
                string2 = "Delete the collection " + string4 + " and all its contents:\nAre you sure?";
            } else {
                string3 = "Delete File";
                string2 = "Delete " + string4 + ":\nAre you sure?";
            }
            int n = JOptionPane.showConfirmDialog(GlobalData.getGlobalData().getMainFrame(), string2, string3, 0);
            if (n == 0) {
                if (this.treeView.isRemote(string)) {
                    WebDAVTreeNode webDAVTreeNode = this.fileView.getParentNode();
                    this.requestGenerator.setResource(string, webDAVTreeNode);
                    this.requestGenerator.setExtendedInfo(20, null);
                    boolean bl2 = false;
                    bl2 = this.fileView.isSelectedLocked() ? this.requestGenerator.GenerateDelete(this.fileView.getSelectedLockToken()) : this.requestGenerator.GenerateDelete(null);
                    if (bl2) {
                        this.requestGenerator.execute();
                    }
                } else {
                    WebDAVTreeNode webDAVTreeNode = this.fileView.getParentNode();
                    File file = new File(string);
                    if (!this.deleteLocal(file)) {
                        GlobalData.getGlobalData().errorMsg("Delete Error on local filesystem.");
                    }
                    this.treeView.refreshLocal(webDAVTreeNode);
                }
            }
        }
    }

    protected void lockDocument(boolean bl) {
        if (bl) {
            this.requestGenerator.DiscoverLock(10, null);
        } else {
            this.requestGenerator.DiscoverLock(11, null);
        }
    }

    protected void unlockDocument() {
        this.requestGenerator.DiscoverLock(12, null);
    }

    protected void viewProperties() {
        String string = this.fileView.getSelected();
        if (string == null) {
            GlobalData.getGlobalData().errorMsg("No file selected.");
        } else {
            this.requestGenerator.setResource(string, null);
            this.requestGenerator.setExtendedInfo(5, null);
            if (this.requestGenerator.GeneratePropFind(null, "allprop", "zero", null, null, false)) {
                this.requestGenerator.execute();
            }
        }
    }

    protected void doWriteFile(String string, String string2) {
        if (string != null && !string.equals("") && string2 != null && !string2.equals("")) {
            this.writeToDir = string;
            String string3 = string + string2;
            String string4 = this.treeView.getLockToken(string2);
            String string5 = "";
            WebDAVTreeNode webDAVTreeNode = this.fileView.getSelectedCollection();
            string5 = this.fileView.getSelected();
            if (string5 == null) {
                string5 = "";
            }
            WebDAVTreeNode webDAVTreeNode2 = this.fileView.getParentNode();
            boolean bl = false;
            if (webDAVTreeNode == null) {
                this.requestGenerator.setResource(string5, webDAVTreeNode2);
                bl = this.requestGenerator.GeneratePut(string3, string5, string4, null);
            } else {
                this.requestGenerator.setResource(string5, webDAVTreeNode);
                bl = this.requestGenerator.GeneratePut(string3, string5, string4, webDAVTreeNode2);
            }
            if (bl) {
                this.requestGenerator.execute();
            }
        }
    }

    private String selectName(String string, String string2) {
        return this.selectName(string, string2, null);
    }

    private String selectName(String string, String string2, String string3) {
        String string4 = (String)JOptionPane.showInputDialog(GlobalData.getGlobalData().getMainFrame(), string2, string, 3, null, null, string3);
        return string4;
    }

    private boolean deleteLocal(File file) {
        try {
            if (file.isDirectory()) {
                String[] stringArray = file.list();
                for (int i = 0; i < stringArray.length; ++i) {
                    if (this.deleteLocal(new File(stringArray[i]))) continue;
                    return false;
                }
                return file.delete();
            }
            return file.delete();
        }
        catch (Exception exception) {
            return false;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class DropEnabler
    implements DropTargetListener,
    DragSourceListener,
    DragGestureListener {
        Component drop_enabled;
        DropTarget dropTarget;
        DragSource dragSource;
        int drop_action_allowed;
        String os_name;

        public DropEnabler(Component component) {
            this.dropTarget = new DropTarget(this.drop_enabled, this);
            this.dragSource = DragSource.getDefaultDragSource();
            this.drop_action_allowed = 1;
            this.drop_enabled = component;
            int n = 1;
            this.dropTarget = new DropTarget(this.drop_enabled, n, this, true);
            this.dragSource.createDefaultDragGestureRecognizer(this.drop_enabled, 1, this);
            this.os_name = System.getProperty("os.name");
        }

        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        }

        public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dragExit(DragSourceEvent dragSourceEvent) {
        }

        public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            dropTargetDragEvent.acceptDrag(this.drop_action_allowed);
        }

        public void dragExit(DropTargetEvent dropTargetEvent) {
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        }

        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }

        public synchronized void drop(DropTargetDropEvent dropTargetDropEvent) {
            try {
                Transferable transferable = dropTargetDropEvent.getTransferable();
                if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    dropTargetDropEvent.acceptDrop(3);
                    List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        File file = (File)iterator.next();
                        Main.this.doWriteFile(file.getParent() + File.separator, file.getName());
                    }
                    dropTargetDropEvent.getDropTargetContext().dropComplete(true);
                } else {
                    DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
                    String string = new String("Dropped object has no acceptable type; they are ");
                    for (int i = 0; i < dataFlavorArray.length; ++i) {
                        string = string + "\n" + dataFlavorArray[i].getHumanPresentableName();
                    }
                    GlobalData.getGlobalData().errorMsg(string);
                    dropTargetDropEvent.rejectDrop();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                dropTargetDropEvent.rejectDrop();
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                unsupportedFlavorException.printStackTrace();
                dropTargetDropEvent.rejectDrop();
            }
        }

        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            String string = Main.this.fileView.getSelected();
            if (string == null) {
                Main.this.getToolkit().beep();
            } else if (this.os_name.substring(0, 3).compareToIgnoreCase("win") == 0) {
                try {
                    Runtime.getRuntime().exec("cmd /c start " + string);
                }
                catch (Exception exception) {
                    GlobalData.getGlobalData().errorMsg("Cannot start " + string);
                    System.out.println(exception);
                }
            }
        }
    }

    public class MenuListener_Gen
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            switch (actionEvent.getID()) {
                case 9: {
                    if (GlobalData.getGlobalData().isAppletMode()) break;
                    System.exit(0);
                    break;
                }
                case 0: {
                    Main.this.saveAsDocument();
                    break;
                }
                case 1: {
                    FileDialog fileDialog = new FileDialog((Frame)GlobalData.getGlobalData().getMainFrame(), "Write File", 0);
                    if (Main.this.writeToDir != null) {
                        fileDialog.setDirectory(Main.this.writeToDir);
                    }
                    fileDialog.setVisible(true);
                    String string = fileDialog.getDirectory();
                    String string2 = fileDialog.getFile();
                    Main.this.doWriteFile(string, string2);
                    break;
                }
                case 2: {
                    String string = Main.this.fileView.getSelected();
                    if (string == null) {
                        GlobalData.getGlobalData().errorMsg("No resource selected.");
                        break;
                    }
                    WebDAVTreeNode webDAVTreeNode = Main.this.fileView.getParentNode();
                    Main.this.requestGenerator.setResource(string, webDAVTreeNode);
                    Main.this.lockDocument(true);
                    break;
                }
                case 3: {
                    String string = Main.this.fileView.getSelected();
                    if (string == null) {
                        GlobalData.getGlobalData().errorMsg("No resource selected.");
                        break;
                    }
                    WebDAVTreeNode webDAVTreeNode = Main.this.fileView.getParentNode();
                    Main.this.requestGenerator.setResource(string, webDAVTreeNode);
                    Main.this.lockDocument(false);
                    break;
                }
                case 4: {
                    String string = Main.this.fileView.getSelected();
                    if (string == null) {
                        GlobalData.getGlobalData().errorMsg("No resource selected.");
                        break;
                    }
                    WebDAVTreeNode webDAVTreeNode = Main.this.fileView.getParentNode();
                    Main.this.requestGenerator.setResource(string, webDAVTreeNode);
                    Main.this.unlockDocument();
                    break;
                }
                case 5: {
                    String string = Main.this.fileView.getSelected();
                    if (string == null || string.length() == 0) {
                        GlobalData.getGlobalData().errorMsg("No resource selected.");
                        break;
                    }
                    WebDAVTreeNode webDAVTreeNode = Main.this.fileView.getParentNode();
                    Main.this.requestGenerator.setResource(string, webDAVTreeNode);
                    String string3 = "Enter the name of the copy:";
                    String string4 = "Copy Resource";
                    String string5 = Main.this.requestGenerator.getDefaultName("_copy");
                    String string6 = Main.this.selectName(string4, string3, string5);
                    if (string6 == null || !Main.this.requestGenerator.GenerateCopy(string6, true, true)) break;
                    Main.this.requestGenerator.execute();
                    break;
                }
                case 6: {
                    String string = Main.this.fileView.getSelected();
                    if (string == null || string.length() == 0) {
                        GlobalData.getGlobalData().errorMsg("No resource selected.");
                        break;
                    }
                    WebDAVTreeNode webDAVTreeNode = Main.this.fileView.getParentNode();
                    Main.this.requestGenerator.setResource(string, webDAVTreeNode);
                    String string7 = "Enter the new name of the resource:";
                    String string8 = "Move Resource";
                    String string9 = Main.this.requestGenerator.getDefaultName(null);
                    String string10 = Main.this.selectName(string8, string7, string9);
                    if (string10 == null) break;
                    boolean bl = false;
                    bl = Main.this.fileView.isSelectedLocked() ? Main.this.requestGenerator.GenerateMove(string10, null, false, true, Main.this.fileView.getSelectedLockToken(), 30) : Main.this.requestGenerator.GenerateMove(string10, null, false, true, null, 30);
                    if (!bl) break;
                    Main.this.requestGenerator.execute();
                    break;
                }
                case 7: {
                    String string = Main.this.fileView.getSelected();
                    if (string == null) {
                        GlobalData.getGlobalData().errorMsg("No resource selected.");
                        break;
                    }
                    WebDAVTreeNode webDAVTreeNode = Main.this.fileView.getSelectedCollection();
                    if (webDAVTreeNode == null) {
                        Main.this.deleteDocument(false);
                        break;
                    }
                    Main.this.deleteDocument(true);
                    break;
                }
                case 8: {
                    WebDAVTreeNode webDAVTreeNode = Main.this.fileView.getParentNode();
                    String string = new String("Enter collection name:");
                    String string11 = new String("Create Collection");
                    String string12 = Main.this.selectName(string11, string);
                    if (string12 == null) break;
                    WebDAVTreeNode webDAVTreeNode2 = Main.this.fileView.getSelectedCollection();
                    if (Main.this.treeView.isRemote(Main.this.fileView.getParentPath())) {
                        boolean bl = false;
                        if (webDAVTreeNode2 == null) {
                            Main.this.requestGenerator.setNode(webDAVTreeNode);
                            Main.this.requestGenerator.setExtendedInfo(40, null);
                            bl = Main.this.requestGenerator.GenerateMkCol(Main.this.fileView.getParentPath(), string12);
                        } else {
                            Main.this.requestGenerator.setNode(webDAVTreeNode2);
                            Main.this.requestGenerator.setExtendedInfo(41, null);
                            bl = Main.this.requestGenerator.GenerateMkCol(Main.this.fileView.getSelected(), string12);
                        }
                        if (!bl) break;
                        Main.this.requestGenerator.execute();
                        break;
                    }
                    string12 = !Main.this.treeView.getCurrentPath().endsWith(String.valueOf(File.separatorChar)) ? Main.this.fileView.getSelected() + File.separatorChar + string12 : Main.this.fileView.getSelected() + string12;
                    File file = new File(string12);
                    boolean bl = file.mkdir();
                    if (webDAVTreeNode2 == null) {
                        Main.this.treeView.refreshLocal(webDAVTreeNode);
                        break;
                    }
                    Main.this.treeView.refreshLocalNoSelection(webDAVTreeNode2);
                    break;
                }
                case 12: {
                    Main.this.authTable.clear();
                    break;
                }
                case 11: {
                    WebDAVProxyInfo webDAVProxyInfo = new WebDAVProxyInfo(GlobalData.getGlobalData().getMainFrame(), "Proxy Info", true);
                    break;
                }
                case 10: {
                    WebDAVLockInfo webDAVLockInfo = new WebDAVLockInfo(GlobalData.getGlobalData().getMainFrame(), "Lock Info", true);
                    break;
                }
                case 100: {
                    String string = Main.this.fileView.getSelected();
                    if (string == null || string.length() == 0) {
                        GlobalData.getGlobalData().errorMsg("No resource selected.");
                        return;
                    }
                    WebDAVTreeNode webDAVTreeNode = Main.this.fileView.getParentNode();
                    Main.this.requestGenerator.setResource(string, webDAVTreeNode);
                    if (!Main.this.requestGenerator.GenerateEnableVersioning()) break;
                    Main.this.requestGenerator.execute();
                    break;
                }
                case 101: {
                    String string = Main.this.fileView.getSelected();
                    if (string == null || string.length() == 0) {
                        GlobalData.getGlobalData().errorMsg("No resource selected.");
                        return;
                    }
                    WebDAVTreeNode webDAVTreeNode = Main.this.fileView.getParentNode();
                    Main.this.requestGenerator.setResource(string, webDAVTreeNode);
                    if (!Main.this.requestGenerator.GenerateVersionHistory(50)) break;
                    Main.this.requestGenerator.execute();
                    break;
                }
                case 102: {
                    String string = Main.this.fileView.getSelected();
                    if (string == null || string.length() == 0) {
                        GlobalData.getGlobalData().errorMsg("No resource selected.");
                        return;
                    }
                    WebDAVTreeNode webDAVTreeNode = Main.this.fileView.getParentNode();
                    Main.this.requestGenerator.setResource(string, webDAVTreeNode);
                    if (!Main.this.requestGenerator.GenerateCheckOut()) break;
                    Main.this.requestGenerator.execute();
                    break;
                }
                case 103: {
                    String string = Main.this.fileView.getSelected();
                    if (string == null || string.length() == 0) {
                        GlobalData.getGlobalData().errorMsg("No resource selected.");
                        return;
                    }
                    WebDAVTreeNode webDAVTreeNode = Main.this.fileView.getParentNode();
                    Main.this.requestGenerator.setResource(string, webDAVTreeNode);
                    if (!Main.this.requestGenerator.GenerateUnCheckOut()) break;
                    Main.this.requestGenerator.execute();
                    break;
                }
                case 104: {
                    String string = Main.this.fileView.getSelected();
                    if (string == null || string.length() == 0) {
                        GlobalData.getGlobalData().errorMsg("No resource selected.");
                        return;
                    }
                    WebDAVTreeNode webDAVTreeNode = Main.this.fileView.getParentNode();
                    Main.this.requestGenerator.setResource(string, webDAVTreeNode);
                    if (!Main.this.requestGenerator.GenerateCheckIn()) break;
                    Main.this.requestGenerator.execute();
                    break;
                }
                case 105: {
                    String string = Main.this.fileView.getSelected();
                    if (string == null || string.length() == 0) {
                        GlobalData.getGlobalData().errorMsg("No resource selected.");
                        return;
                    }
                    WebDAVTreeNode webDAVTreeNode = Main.this.fileView.getParentNode();
                    Main.this.requestGenerator.setResource(string, webDAVTreeNode);
                    if (!Main.this.requestGenerator.GenerateMkActivity()) break;
                    Main.this.requestGenerator.execute();
                    break;
                }
                case 106: {
                    String string = Main.this.fileView.getSelected();
                    if (string == null || string.length() == 0) {
                        GlobalData.getGlobalData().errorMsg("No resource selected.");
                        return;
                    }
                    WebDAVTreeNode webDAVTreeNode = Main.this.fileView.getParentNode();
                    Main.this.requestGenerator.setResource(string, webDAVTreeNode);
                    if (!Main.this.requestGenerator.GenerateMerge()) break;
                    Main.this.requestGenerator.execute();
                    break;
                }
                case 200: {
                    String string = Main.this.fileView.getSelected();
                    if (string == null || string.length() == 0) {
                        GlobalData.getGlobalData().errorMsg("No resource selected.");
                        return;
                    }
                    WebDAVTreeNode webDAVTreeNode = Main.this.fileView.getParentNode();
                    Main.this.requestGenerator.setResource(string, webDAVTreeNode);
                    Main.this.requestGenerator.GetOwner();
                    break;
                }
                case 202: {
                    String string = Main.this.fileView.getSelected();
                    if (string == null || string.length() == 0) {
                        GlobalData.getGlobalData().errorMsg("No resource selected.");
                        return;
                    }
                    WebDAVTreeNode webDAVTreeNode = Main.this.fileView.getParentNode();
                    Main.this.requestGenerator.setResource(string, webDAVTreeNode);
                    Main.this.requestGenerator.GetGroup();
                    break;
                }
                case 205: {
                    String string = Main.this.fileView.getSelected();
                    if (string == null || string.length() == 0) {
                        GlobalData.getGlobalData().errorMsg("No resource selected.");
                        return;
                    }
                    WebDAVTreeNode webDAVTreeNode = Main.this.fileView.getParentNode();
                    Main.this.requestGenerator.setResource(string, webDAVTreeNode);
                    Main.this.requestGenerator.GetUserPrivileges();
                    break;
                }
                case 206: {
                    String string = Main.this.fileView.getSelected();
                    if (string == null || string.length() == 0) {
                        GlobalData.getGlobalData().errorMsg("No resource selected.");
                        return;
                    }
                    WebDAVTreeNode webDAVTreeNode = Main.this.fileView.getParentNode();
                    Main.this.requestGenerator.setResource(string, webDAVTreeNode);
                    Main.this.requestGenerator.GetACL();
                    break;
                }
                case 207: {
                    String string = Main.this.fileView.getSelected();
                    if (string == null || string.length() == 0) {
                        GlobalData.getGlobalData().errorMsg("No resource selected.");
                        return;
                    }
                    WebDAVTreeNode webDAVTreeNode = Main.this.fileView.getParentNode();
                    Main.this.requestGenerator.setResource(string, webDAVTreeNode);
                    Main.this.requestGenerator.GetACLRestrictions();
                    break;
                }
                case 209: {
                    String string = Main.this.fileView.getSelected();
                    if (string == null || string.length() == 0) {
                        GlobalData.getGlobalData().errorMsg("No resource selected.");
                        return;
                    }
                    WebDAVTreeNode webDAVTreeNode = Main.this.fileView.getParentNode();
                    Main.this.requestGenerator.setResource(string, webDAVTreeNode);
                    Main.this.requestGenerator.GetInheritedACLs();
                    break;
                }
                case 211: {
                    String string = Main.this.fileView.getSelected();
                    if (string == null || string.length() == 0) {
                        GlobalData.getGlobalData().errorMsg("No resource selected.");
                        return;
                    }
                    ACLReportPropertiesDialog aCLReportPropertiesDialog = new ACLReportPropertiesDialog(string, true);
                    if (aCLReportPropertiesDialog.isCanceled()) break;
                    Vector vector = aCLReportPropertiesDialog.getSelected();
                    WebDAVTreeNode webDAVTreeNode = Main.this.fileView.getParentNode();
                    Main.this.requestGenerator.setResource(string, webDAVTreeNode);
                    if (!Main.this.requestGenerator.GetPrincipalPropSetReport(vector)) break;
                    Main.this.requestGenerator.execute();
                    break;
                }
                case 212: {
                    String string = Main.this.fileView.getSelected();
                    if (string == null || string.length() == 0) {
                        GlobalData.getGlobalData().errorMsg("No resource selected.");
                        return;
                    }
                    ACLReportSearchPropertyDialog aCLReportSearchPropertyDialog = new ACLReportSearchPropertyDialog(string, false);
                    if (aCLReportSearchPropertyDialog.isCanceled()) break;
                    Vector vector = aCLReportSearchPropertyDialog.getSearchCriteria();
                    Vector vector2 = aCLReportSearchPropertyDialog.getSelected();
                    boolean bl = aCLReportSearchPropertyDialog.isSelf();
                    WebDAVTreeNode webDAVTreeNode = Main.this.fileView.getParentNode();
                    Main.this.requestGenerator.setResource(string, webDAVTreeNode);
                    if (!Main.this.requestGenerator.GetPrincipalMatchReport(vector, vector2, bl)) break;
                    Main.this.requestGenerator.execute();
                    break;
                }
                case 213: {
                    String string = Main.this.fileView.getSelected();
                    if (string == null || string.length() == 0) {
                        GlobalData.getGlobalData().errorMsg("No resource selected.");
                        return;
                    }
                    ACLReportSearchPropertyDialog aCLReportSearchPropertyDialog = new ACLReportSearchPropertyDialog(string, true);
                    if (aCLReportSearchPropertyDialog.isCanceled()) break;
                    Vector vector = aCLReportSearchPropertyDialog.getSearchCriteria();
                    Vector vector3 = aCLReportSearchPropertyDialog.getSelected();
                    WebDAVTreeNode webDAVTreeNode = Main.this.fileView.getParentNode();
                    Main.this.requestGenerator.setResource(string, webDAVTreeNode);
                    if (!Main.this.requestGenerator.GetPrincipalPropertySearchReport(vector, vector3)) break;
                    Main.this.requestGenerator.execute();
                    break;
                }
                case 214: {
                    String string = Main.this.fileView.getSelected();
                    if (string == null || string.length() == 0) {
                        GlobalData.getGlobalData().errorMsg("No resource selected.");
                        return;
                    }
                    WebDAVTreeNode webDAVTreeNode = Main.this.fileView.getParentNode();
                    Main.this.requestGenerator.setResource(string, webDAVTreeNode);
                    if (!Main.this.requestGenerator.GetPrincipalSearchPropertySetReport()) break;
                    Main.this.requestGenerator.execute();
                    break;
                }
                case 13: {
                    boolean bl = false;
                    String string = null;
                    if (Main.this.CommandMenu.getLogging()) {
                        String string13 = new String("WARNING: The logfile may get very large,\nsince all data is logged.\nHit Cancel now if you don't want to log the data.");
                        int n = JOptionPane.showConfirmDialog(GlobalData.getGlobalData().getMainFrame(), string13, "HTTP Logging", 2);
                        if (n == 0) {
                            JFileChooser jFileChooser = new JFileChooser();
                            jFileChooser.setDialogType(1);
                            jFileChooser.setFileSelectionMode(0);
                            jFileChooser.setDialogTitle("Select Logging File");
                            String string14 = System.getProperty("os.name").toLowerCase();
                            String string15 = null;
                            if (string14.indexOf("windows") == -1) {
                                string15 = System.getProperty("user.home");
                            }
                            if (string15 == null) {
                                string15 = new Character(File.separatorChar).toString();
                            }
                            jFileChooser.setCurrentDirectory(new File(string15));
                            jFileChooser.setApproveButtonMnemonic('U');
                            jFileChooser.setApproveButtonToolTipText("Use the selected file for logging");
                            int n2 = jFileChooser.showDialog(GlobalData.getGlobalData().getMainFrame(), "Logging");
                            if (n2 == 0) {
                                string = jFileChooser.getSelectedFile().getAbsolutePath();
                                try {
                                    File file = jFileChooser.getSelectedFile();
                                    if (file.exists()) {
                                        file.delete();
                                    }
                                    bl = true;
                                }
                                catch (Exception exception) {
                                    System.out.println("File could not be deleted.\n" + exception);
                                    string = null;
                                }
                            }
                        }
                    }
                    Main.this.CommandMenu.setLogging(bl);
                    Main.this.webdavManager.setLogging(bl, string);
                    break;
                }
                case 18: {
                    boolean bl = Main.this.CommandMenu.getSSL();
                    GlobalData.getGlobalData().setSSL(bl);
                    Main.this.uribox.invalidate();
                    break;
                }
                case 15: {
                    Main.this.viewProperties();
                    break;
                }
                case 14: {
                    String string = Main.this.fileView.getSelected();
                    if (string == null) {
                        GlobalData.getGlobalData().errorMsg("No file selected.");
                        break;
                    }
                    WebDAVTreeNode webDAVTreeNode = Main.this.fileView.getParentNode();
                    Main.this.requestGenerator.setResource(string, webDAVTreeNode);
                    Main.this.requestGenerator.DiscoverLock(50, null);
                    break;
                }
                case 16: {
                    WebDAVTreeNode webDAVTreeNode = Main.this.fileView.getParentNode();
                    Main.this.responseInterpreter.setRefresh(webDAVTreeNode);
                    break;
                }
                case 17: {
                    String string = new String("DAV Explorer Version 0.91\nCopyright (c) 1998-2005 Regents of the University of California\nAuthors: Yuzo Kanomata, Joachim Feise\nEMail: dav-exp@ics.uci.edu\n\nBased on code from the UCI WebDAV Client Group of the ICS126B class\nWinter 1998: Gerair Balian, Mirza Baig, Robert Emmery, Thai Le, Tu Le.\nBasic DeltaV support based on code from the DeltaV Team of the ICS125\nclass Spring 2003: Max Slabyak, Matt Story, Hyung Kim.\nUses the HTTPClient library (http://www.innovation.ch/java/HTTPClient/).\nUses Microsoft's XML parser published in June 1997.\nFor other contributors see the contributors.txt file.");
                    Object[] objectArray = new Object[]{"OK"};
                    JOptionPane.showOptionDialog(GlobalData.getGlobalData().getMainFrame(), string, "About DAV Explorer", -1, 1, null, objectArray, objectArray[0]);
                }
            }
        }
    }

    public class ResponseListener
    implements WebDAVResponseListener {
        public void responseFormed(WebDAVResponseEvent webDAVResponseEvent) {
            boolean bl = false;
            try {
                bl = Main.this.responseInterpreter.handleResponse(webDAVResponseEvent);
            }
            catch (ResponseException responseException) {
                GlobalData.getGlobalData().errorMsg("HTTP error or Server timeout,\nplease retry the last operation");
                Main.this.fireWebDAVCompletion(Main.this.responseInterpreter, false);
                return;
            }
            if (bl) {
                Main.this.fireWebDAVCompletion(Main.this.responseInterpreter, true);
            }
            int n = webDAVResponseEvent.getExtendedCode();
            String string = webDAVResponseEvent.getMethodName();
            if (!string.equals("COPY") && !string.equals("PUT")) {
                switch (n) {
                    case 3: 
                    case 4: {
                        WebDAVTreeNode webDAVTreeNode = webDAVResponseEvent.getNode();
                        if (webDAVTreeNode == null) break;
                        webDAVTreeNode.finishLoadChildren();
                        break;
                    }
                    case 2: {
                        WebDAVTreeNode webDAVTreeNode = webDAVResponseEvent.getNode();
                        if (webDAVTreeNode == null) break;
                        webDAVTreeNode.finishLoadChildren();
                        Main.this.treeView.setSelectedNode(webDAVTreeNode);
                        break;
                    }
                    case 1: {
                        WebDAVTreeNode webDAVTreeNode = webDAVResponseEvent.getNode();
                    }
                }
            }
        }
    }

    public class RequestListener
    implements WebDAVRequestListener {
        public void requestFormed(WebDAVRequestEvent webDAVRequestEvent) {
            Main.this.webdavManager.sendRequest(webDAVRequestEvent);
        }
    }

    public class RenameListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string != null) {
                String string2 = Main.this.fileView.getOldSelectedResource();
                WebDAVTreeNode webDAVTreeNode = Main.this.fileView.getParentNode();
                Main.this.requestGenerator.setResource(string2, webDAVTreeNode);
                boolean bl = false;
                bl = Main.this.fileView.isSelectedLocked() ? Main.this.requestGenerator.GenerateMove(string, Main.this.fileView.getParentPath(), false, true, Main.this.fileView.getSelectedLockToken(), 30) : Main.this.requestGenerator.GenerateMove(string, Main.this.fileView.getParentPath(), false, true, null, 30);
                if (bl) {
                    Main.this.requestGenerator.execute();
                }
            }
        }
    }

    public class DisplayVersionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getActionCommand() != null) {
                Main.this.requestGenerator.setResource(actionEvent.getActionCommand(), null);
            }
            if (Main.this.requestGenerator.GenerateVersionHistory(50)) {
                Main.this.requestGenerator.execute();
            }
        }
    }

    public class DisplayLockListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getActionCommand() != null) {
                Main.this.requestGenerator.setResource(actionEvent.getActionCommand(), null);
            }
            Main.this.requestGenerator.DiscoverLock(50, null);
        }
    }

    public class MergeListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            int n = actionEvent.getID();
            String string2 = n >= 200 && n < 300 ? "Merge for " + string + " successful." : "Merge failed. Error: " + string;
            JOptionPane.showMessageDialog(GlobalData.getGlobalData().getMainFrame(), string2);
        }
    }

    public class MkActivityListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            int n = actionEvent.getID();
            String string2 = n >= 200 && n < 300 ? "Make Activity for " + string + " successful." : "Make Activity failed. Error: " + string;
            JOptionPane.showMessageDialog(GlobalData.getGlobalData().getMainFrame(), string2);
        }
    }

    public class CheckinListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            int n = actionEvent.getID();
            String string2 = n >= 200 && n < 300 ? "Checkin for " + string + " successful." : "Checkin failed. Error: " + string;
            JOptionPane.showMessageDialog(GlobalData.getGlobalData().getMainFrame(), string2);
        }
    }

    public class UnCheckoutListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            int n = actionEvent.getID();
            String string2 = n >= 200 && n < 300 ? "Uncheckout for " + string + " successful." : "Uncheckout failed. Error: " + string;
            JOptionPane.showMessageDialog(GlobalData.getGlobalData().getMainFrame(), string2);
        }
    }

    public class CheckoutListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            int n = actionEvent.getID();
            String string2 = n >= 200 && n < 300 ? "Checkout for " + string + " successful." : "Checkout failed. Error: " + string;
            JOptionPane.showMessageDialog(GlobalData.getGlobalData().getMainFrame(), string2);
        }
    }

    public class VersionControlListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            int n = actionEvent.getID();
            String string2 = n >= 200 && n < 300 ? "Version control enabled for " + string + "." : "Version control command failed. Error: " + string;
            JOptionPane.showMessageDialog(GlobalData.getGlobalData().getMainFrame(), string2);
        }
    }

    public class LockListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (actionEvent.getID() == 0) {
                Main.this.fileView.setLock();
                Main.this.treeView.setLock(Main.this.fileView.getName(), string);
            } else {
                Main.this.fileView.resetLock();
                Main.this.treeView.resetLock(Main.this.fileView.getName());
            }
        }
    }

    public class TreeSelectListener_Gen
    implements ViewSelectionListener {
        public void selectionChanged(ViewSelectionEvent viewSelectionEvent) {
            Main.this.requestGenerator.treeSelectionChanged(viewSelectionEvent);
        }
    }

    public class TableSelectListener_Tree
    implements ViewSelectionListener {
        public void selectionChanged(ViewSelectionEvent viewSelectionEvent) {
            Main.this.treeView.tableSelectionChanged(viewSelectionEvent);
        }
    }

    public class TableSelectListener_Gen
    implements ViewSelectionListener {
        public void selectionChanged(ViewSelectionEvent viewSelectionEvent) {
            Main.this.requestGenerator.tableSelectionChanged(viewSelectionEvent);
        }
    }

    public class MoveUpdateListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string == null) {
                Main.this.fileView.update();
            } else {
                Main.this.fileView.resetName();
            }
        }
    }

    public class TreeInsertionListener
    implements InsertionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            this.actionPerformed(actionEvent, false);
        }

        public void actionPerformed(ActionEvent actionEvent, boolean bl) {
            String string = actionEvent.getActionCommand();
            if (string == null) {
                Main.this.treeView.refresh();
            } else {
                Main.this.treeView.addRowToRoot(string, false, bl);
            }
        }
    }

    public class URIBoxListener_Gen
    implements WebDAVURIBoxListener {
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (!string.endsWith("/")) {
                string = string + "/";
            }
            Main.this.requestGenerator.setExtendedInfo(1, null);
            String string2 = System.getProperty("options", "yes");
            if (string2.equalsIgnoreCase("no")) {
                Main.this.requestGenerator.DoPropFind(string, true);
            } else if (Main.this.requestGenerator.GenerateOptions(string)) {
                Main.this.requestGenerator.execute();
            }
        }
    }
}

