/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.DAVExplorer;

import edu.uci.ics.DAVExplorer.DeltaVDataNode;
import edu.uci.ics.DAVExplorer.GlobalData;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class VersionInfoDialog
extends JDialog
implements ActionListener {
    String[] colNames = new String[]{"Version", "Author", "Date", "Size", "Checked-In", "Comment", "href"};
    private Vector data = new Vector();
    private TableModel dataModel;
    private JTable table;
    private JButton closeButton;
    private String resource;
    private Vector getVersionListeners = new Vector();
    private ImageIcon CHECKEDIN_ICON;
    private ImageIcon CHECKEDOUT_ICON;

    public VersionInfoDialog(Vector vector, String string, String string2) {
        super(GlobalData.getGlobalData().getMainFrame());
        this.setTitle("View Version Information");
        this.resource = string2 + string;
        JLabel jLabel = new JLabel(this.resource, 0);
        jLabel.setForeground(Color.black);
        this.getContentPane().add("North", jLabel);
        this.closeButton = new JButton("Close");
        this.closeButton.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.add(this.closeButton);
        this.getRootPane().setDefaultButton(this.closeButton);
        this.closeButton.grabFocus();
        this.getContentPane().add("South", jPanel);
        this.setBackground(Color.lightGray);
        this.CHECKEDIN_ICON = GlobalData.getGlobalData().getImageIcon("version.gif", "");
        this.CHECKEDOUT_ICON = GlobalData.getGlobalData().getImageIcon("noversion.gif", "");
        this.dataModel = new AbstractTableModel(){

            public int getColumnCount() {
                return VersionInfoDialog.this.colNames.length;
            }

            public int getRowCount() {
                return VersionInfoDialog.this.data.size();
            }

            public Object getValueAt(int n, int n2) {
                if (VersionInfoDialog.this.data.size() == 0) {
                    return null;
                }
                return ((Vector)VersionInfoDialog.this.data.elementAt(n)).elementAt(n2);
            }

            public String getColumnName(int n) {
                return VersionInfoDialog.this.colNames[n];
            }

            public Class getColumnClass(int n) {
                if (VersionInfoDialog.this.data.size() == 0) {
                    return null;
                }
                Object object = null;
                int n2 = 0;
                while (object == null && n2 < VersionInfoDialog.this.data.size() && (object = this.getValueAt(n2++, n)) == null) {
                }
                if (object == null) {
                    return null;
                }
                return object.getClass();
            }

            public boolean isCellEditable(int n, int n2) {
                return false;
            }

            public void setValueAt(Object object, int n, int n2) {
                try {
                    ((Vector)VersionInfoDialog.this.data.elementAt(n)).setElementAt(object, n2);
                }
                catch (Exception exception) {
                    System.out.println(exception);
                }
            }
        };
        this.table = new JTable(this.dataModel);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(this.table);
        this.getContentPane().add("Center", jScrollPane);
        this.setupTable(this.table);
        this.addRows(vector);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                VersionInfoDialog.this.cancel();
            }
        });
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    VersionInfoDialog.this.handleDoubleClick(mouseEvent);
                }
            }
        };
        this.table.addMouseListener(mouseAdapter);
        this.pack();
        this.center();
    }

    protected void addRows(Vector vector) {
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                Object[] objectArray = new Object[]{((DeltaVDataNode)vector.elementAt(i)).getVersionName(), ((DeltaVDataNode)vector.elementAt(i)).getCreatorDisplayName(), ((DeltaVDataNode)vector.elementAt(i)).getDate(), new Long(((DeltaVDataNode)vector.elementAt(i)).getSize()), new Boolean(!((DeltaVDataNode)vector.elementAt(i)).getCheckedIn().equals("")), ((DeltaVDataNode)vector.elementAt(i)).getComment(), ((DeltaVDataNode)vector.elementAt(i)).getHref()};
                this.addRow(objectArray);
                this.addRows(((DeltaVDataNode)vector.elementAt(i)).getVersions());
            }
        }
    }

    private void addRow(Object[] objectArray) {
        Vector<Object> vector = new Vector<Object>();
        int n = this.table.getColumnCount();
        for (int i = 0; i < n; ++i) {
            vector.addElement(objectArray[i]);
        }
        this.data.addElement(vector);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Close")) {
            this.cancel();
        }
    }

    public void cancel() {
        this.setVisible(false);
        this.dispose();
    }

    protected void center() {
        Rectangle rectangle = this.getParent().getBounds();
        Rectangle rectangle2 = this.getBounds();
        this.setBounds(rectangle.x + (rectangle.width - rectangle2.width) / 2, rectangle.y + (rectangle.height - rectangle2.height) / 2, rectangle2.width, rectangle2.height);
    }

    public Dimension getPreferredSize() {
        return new Dimension(700, 200);
    }

    public void setupTable(JTable jTable) {
        if (GlobalData.getGlobalData().getDebugFileView()) {
            System.err.println("WebDAVFileView::setupTable");
        }
        jTable.clearSelection();
        jTable.setIntercellSpacing(new Dimension(0, 0));
        jTable.setCellSelectionEnabled(false);
        jTable.setColumnSelectionAllowed(false);
        jTable.setShowGrid(false);
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
        defaultTableCellRenderer.setHorizontalAlignment(0);
        TableColumn tableColumn = jTable.getColumn(this.colNames[0]);
        tableColumn.setMinWidth(50);
        tableColumn.setCellRenderer(defaultTableCellRenderer);
        tableColumn = jTable.getColumn(this.colNames[1]);
        tableColumn.setMinWidth(50);
        tableColumn.setCellRenderer(defaultTableCellRenderer);
        tableColumn = jTable.getColumn(this.colNames[2]);
        tableColumn.setMinWidth(150);
        tableColumn.setCellRenderer(defaultTableCellRenderer);
        tableColumn = jTable.getColumn(this.colNames[3]);
        tableColumn.setMinWidth(50);
        tableColumn.setCellRenderer(defaultTableCellRenderer);
        tableColumn = jTable.getColumn(this.colNames[4]);
        tableColumn.setMinWidth(70);
        tableColumn.setMaxWidth(70);
        DefaultTableCellRenderer defaultTableCellRenderer2 = new DefaultTableCellRenderer(){

            public void setValue(Object object) {
                try {
                    boolean bl = new Boolean(object.toString());
                    if (bl) {
                        this.setIcon(VersionInfoDialog.this.CHECKEDIN_ICON);
                    } else {
                        this.setIcon(VersionInfoDialog.this.CHECKEDOUT_ICON);
                    }
                    this.setHorizontalAlignment(0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        tableColumn.setCellRenderer(defaultTableCellRenderer2);
        tableColumn = jTable.getColumn(this.colNames[5]);
        tableColumn.setMinWidth(100);
        tableColumn.setCellRenderer(defaultTableCellRenderer);
        tableColumn = jTable.getColumn(this.colNames[6]);
        tableColumn.setMinWidth(0);
        tableColumn.setMaxWidth(0);
        tableColumn.setCellRenderer(defaultTableCellRenderer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleDoubleClick(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        int n = this.table.columnAtPoint(point);
        int n2 = this.table.rowAtPoint(point);
        int n3 = this.table.convertColumnIndexToView(0);
        if (n3 == -1) {
            n3 = 0;
        }
        if (n == n3 && n2 != -1) {
            Vector vector;
            Serializable serializable = this;
            synchronized (serializable) {
                vector = (Vector)this.getVersionListeners.clone();
            }
            serializable = new ActionEvent(this, 0, (String)this.table.getValueAt(n2, 6));
            for (int i = 0; i < vector.size(); ++i) {
                ActionListener actionListener = (ActionListener)vector.elementAt(i);
                actionListener.actionPerformed((ActionEvent)serializable);
            }
        }
    }

    public synchronized void addGetVersionListener(ActionListener actionListener) {
        this.getVersionListeners.addElement(actionListener);
    }

    public synchronized void removeGetVersionListener(ActionListener actionListener) {
        this.getVersionListeners.removeElement(actionListener);
    }
}

