/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.DAVExplorer;

import HTTPClient.HTTPConnection;
import HTTPClient.HTTPResponse;
import HTTPClient.HttpOutputStream;
import HTTPClient.ModuleException;
import HTTPClient.NVPair;
import HTTPClient.ProtocolNotSuppException;
import edu.uci.ics.DAVExplorer.GlobalData;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class WebDAVConnection
extends HTTPConnection {
    static final int DEFAULT_PORT = 80;

    public WebDAVConnection(String string) {
        super(string, 80);
        this.removeModules();
        this.addModules();
        this.changeModules();
    }

    public WebDAVConnection(String string, String string2) throws ProtocolNotSuppException {
        super(string, string2, 80);
        this.removeModules();
        this.addModules();
        this.changeModules();
    }

    public WebDAVConnection(String string, int n) {
        super(string, n);
        this.removeModules();
        this.addModules();
        this.changeModules();
    }

    public WebDAVConnection(String string, String string2, int n) throws ProtocolNotSuppException {
        super(string, string2, n);
        this.removeModules();
        this.addModules();
        this.changeModules();
    }

    public HTTPResponse Put(String string, String string2, NVPair[] nVPairArray) throws IOException, ModuleException {
        File file = new File(string2);
        long l = file.length();
        HttpOutputStream httpOutputStream = new HttpOutputStream(l);
        HTTPResponse hTTPResponse = null;
        do {
            hTTPResponse = this.ExtensionMethod("PUT", string, httpOutputStream, nVPairArray);
            FileInputStream fileInputStream = new FileInputStream(file);
            byte[] byArray = new byte[65536];
            long l2 = 0L;
            int n = 0;
            do {
                l2 += (long)n;
                n = fileInputStream.read(byArray);
                if (n == -1) continue;
                httpOutputStream.write(byArray, 0, n);
            } while (n != -1 && l2 + (long)n < l);
            httpOutputStream.close();
        } while (hTTPResponse.retryRequest());
        return hTTPResponse;
    }

    public HTTPResponse PropFind(String string, byte[] byArray, NVPair[] nVPairArray) throws IOException, ModuleException {
        return this.ExtensionMethod("PROPFIND", string, byArray, nVPairArray);
    }

    public HTTPResponse PropPatch(String string, byte[] byArray, NVPair[] nVPairArray) throws IOException, ModuleException {
        return this.ExtensionMethod("PROPPATCH", string, byArray, nVPairArray);
    }

    public HTTPResponse MkCol(String string, NVPair[] nVPairArray) throws IOException, ModuleException {
        return this.ExtensionMethod("MKCOL", string, (byte[])null, nVPairArray);
    }

    public HTTPResponse AddRef(String string, NVPair[] nVPairArray) throws IOException, ModuleException {
        return this.ExtensionMethod("ADDREF", string, (byte[])null, nVPairArray);
    }

    public HTTPResponse DelRef(String string, NVPair[] nVPairArray) throws IOException, ModuleException {
        return this.ExtensionMethod("DELREF", string, (byte[])null, nVPairArray);
    }

    public HTTPResponse Copy(String string, byte[] byArray, NVPair[] nVPairArray) throws IOException, ModuleException {
        return this.ExtensionMethod("COPY", string, byArray, nVPairArray);
    }

    public HTTPResponse Copy(String string, NVPair[] nVPairArray) throws IOException, ModuleException {
        return this.Copy(string, null, nVPairArray);
    }

    public HTTPResponse Move(String string, byte[] byArray, NVPair[] nVPairArray) throws IOException, ModuleException {
        return this.ExtensionMethod("MOVE", string, byArray, nVPairArray);
    }

    public HTTPResponse Move(String string, NVPair[] nVPairArray) throws IOException, ModuleException {
        return this.Move(string, null, nVPairArray);
    }

    public HTTPResponse Lock(String string, byte[] byArray, NVPair[] nVPairArray) throws IOException, ModuleException {
        return this.ExtensionMethod("LOCK", string, byArray, nVPairArray);
    }

    public HTTPResponse Lock(String string, NVPair[] nVPairArray) throws IOException, ModuleException {
        return this.Lock(string, null, nVPairArray);
    }

    public HTTPResponse Unlock(String string, NVPair[] nVPairArray) throws IOException, ModuleException {
        return this.ExtensionMethod("UNLOCK", string, (byte[])null, nVPairArray);
    }

    public HTTPResponse Generic(String string, String string2, byte[] byArray, NVPair[] nVPairArray) throws IOException, ModuleException {
        return this.ExtensionMethod(string, string2, byArray, nVPairArray);
    }

    protected void removeModules() {
        try {
            this.removeModule(Class.forName("HTTPClient.RedirectionModule"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    protected void addModules() {
    }

    protected void changeModules() {
        try {
            if (!GlobalData.getGlobalData().getCompression()) {
                this.removeModule(Class.forName("HTTPClient.TransferEncodingModule"));
                this.removeModule(Class.forName("HTTPClient.ContentEncodingModule"));
                this.addModule(Class.forName("edu.uci.ics.DAVExplorer.TransferEncodingModule"), -1);
                this.addModule(Class.forName("edu.uci.ics.DAVExplorer.ContentEncodingModule"), -1);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

