/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.DAVExplorer;

import edu.uci.ics.DAVExplorer.GlobalData;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

public class WebDAVMenu
extends JMenuBar
implements ActionListener {
    public static final int GET_FILE = 0;
    public static final int WRITE_FILE = 1;
    public static final int EXCLUSIVE_LOCK = 2;
    public static final int SHARED_LOCK = 3;
    public static final int UNLOCK = 4;
    public static final int COPY = 5;
    public static final int MOVE = 6;
    public static final int DELETE = 7;
    public static final int CREATE_COLLECTION = 8;
    public static final int EXIT = 9;
    public static final int EDIT_LOCK_INFO = 10;
    public static final int EDIT_PROXY_INFO = 11;
    public static final int CLEAR_AUTH_BUFFER = 12;
    public static final int HTTP_LOGGING = 13;
    public static final int VIEW_LOCK_PROPS = 14;
    public static final int VIEW_MODIFY_PROPS = 15;
    public static final int REFRESH = 16;
    public static final int ABOUT = 17;
    public static final int USE_SSL = 18;
    public static final int INIT_VERSION_CONTROL = 100;
    public static final int VERSION_REPORT = 101;
    public static final int CHECKOUT = 102;
    public static final int UNCHECKOUT = 103;
    public static final int CHECKIN = 104;
    public static final int MAKE_ACTIVITY = 105;
    public static final int MERGE = 106;
    public static final int VIEW_OWNER = 200;
    public static final int VIEW_GROUP = 202;
    public static final int GET_SUPPORTED_PRIVILEGES = 204;
    public static final int GET_USER_PRIVILEGES = 205;
    public static final int VIEW_ACL = 206;
    public static final int GET_SUPPORTED_ACL = 207;
    public static final int GET_INHERITED_ACL = 209;
    public static final int GET_PRINCIPALS = 210;
    public static final int ACL_PRINCIPAL_PROP_SET_REPORT = 211;
    public static final int PRINCIPAL_MATCH_REPORT = 212;
    public static final int PRINCIPAL_PROPERTY_SEARCH_REPORT = 213;
    public static final int PRINCIPAL_SEARCH_PROPERTY_SET_REPORT = 214;
    protected Vector menuListeners;
    private WebDAVCheckBoxMenuItem logging;
    private WebDAVCheckBoxMenuItem ssl;

    public WebDAVMenu() {
        this.add(this.generateFileMenu());
        this.add(this.generateEditMenu());
        this.add(this.generateVersionMenu());
        this.add(this.generateACLMenu());
        this.add(this.generateViewMenu());
        this.add(this.generateHelpMenu());
        this.menuListeners = new Vector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent actionEvent) {
        Vector vector;
        Serializable serializable = this;
        synchronized (serializable) {
            vector = (Vector)this.menuListeners.clone();
        }
        serializable = actionEvent;
        JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
        if (jMenuItem instanceof WebDAVMenuItem) {
            serializable = new ActionEvent(jMenuItem, ((WebDAVMenuItem)jMenuItem).getId(), actionEvent.getActionCommand());
        } else if (jMenuItem instanceof WebDAVCheckBoxMenuItem) {
            serializable = new ActionEvent(jMenuItem, ((WebDAVCheckBoxMenuItem)jMenuItem).getId(), actionEvent.getActionCommand());
        }
        for (int i = 0; i < vector.size(); ++i) {
            ActionListener actionListener = (ActionListener)vector.elementAt(i);
            actionListener.actionPerformed((ActionEvent)serializable);
        }
    }

    public synchronized void addWebDAVMenuListener(ActionListener actionListener) {
        this.menuListeners.addElement(actionListener);
    }

    public synchronized void removeWebDAVMenuListener(ActionListener actionListener) {
        this.menuListeners.removeElement(actionListener);
    }

    public void setLogging(boolean bl) {
        this.logging.setState(bl);
    }

    public boolean getLogging() {
        return this.logging.getState();
    }

    public void setSSL(boolean bl) {
        this.ssl.setState(bl);
    }

    public boolean getSSL() {
        return this.ssl.getState();
    }

    protected JMenu generateFileMenu() {
        JMenu jMenu = new JMenu("File", true);
        jMenu.add(new WebDAVMenuItem("Get File", 0, this));
        jMenu.add(new WebDAVMenuItem("Write File", 1, this));
        jMenu.addSeparator();
        jMenu.add(new WebDAVMenuItem("Exclusive Lock", 2, this));
        jMenu.add(new WebDAVMenuItem("Shared Lock", 3, this));
        jMenu.add(new WebDAVMenuItem("Unlock", 4, this));
        jMenu.addSeparator();
        jMenu.add(new WebDAVMenuItem("Copy", 5, this));
        jMenu.add(new WebDAVMenuItem("Move", 6, this));
        jMenu.add(new WebDAVMenuItem("Delete", 7, this));
        jMenu.addSeparator();
        jMenu.add(new WebDAVMenuItem("Create Collection", 8, this));
        if (!GlobalData.getGlobalData().isAppletMode()) {
            jMenu.addSeparator();
            jMenu.add(new WebDAVMenuItem("Exit", 9, this));
        }
        return jMenu;
    }

    protected JMenu generateEditMenu() {
        JMenu jMenu = new JMenu("Edit", true);
        jMenu.add(new WebDAVMenuItem("Edit Lock Info", 10, this));
        jMenu.add(new WebDAVMenuItem("Edit Proxy Info", 11, this));
        jMenu.addSeparator();
        jMenu.add(new WebDAVMenuItem("Clear Auth Buffer", 12, this));
        jMenu.addSeparator();
        this.ssl = new WebDAVCheckBoxMenuItem("Use SSL", 18, this);
        this.setSSL(GlobalData.getGlobalData().getSSL());
        jMenu.add(this.ssl);
        jMenu.addSeparator();
        this.logging = new WebDAVCheckBoxMenuItem("HTTP Logging", 13, this);
        jMenu.add(this.logging);
        return jMenu;
    }

    protected JMenu generateVersionMenu() {
        JMenu jMenu = new JMenu("Versioning", true);
        jMenu.add(new WebDAVMenuItem("Put Under Version Control", 100, this));
        jMenu.addSeparator();
        jMenu.add(new WebDAVMenuItem("Version Report", 101, this));
        jMenu.addSeparator();
        jMenu.add(new WebDAVMenuItem("Check Out", 102, this));
        jMenu.add(new WebDAVMenuItem("Uncheckout", 103, this));
        jMenu.add(new WebDAVMenuItem("Check In", 104, this));
        return jMenu;
    }

    protected JMenu generateACLMenu() {
        JMenu jMenu = new JMenu("Access Control", true);
        jMenu.add(new WebDAVMenuItem("View/Modify Owner", 200, this));
        jMenu.add(new WebDAVMenuItem("View/Modify Group", 202, this));
        jMenu.addSeparator();
        jMenu.add(new WebDAVMenuItem("Get User's Privileges", 205, this));
        jMenu.addSeparator();
        jMenu.add(new WebDAVMenuItem("Get ACL Restrictions", 207, this));
        jMenu.add(new WebDAVMenuItem("Get Inherited ACLs", 209, this));
        jMenu.addSeparator();
        jMenu.add(new WebDAVMenuItem("View/Modify ACLs", 206, this));
        jMenu.addSeparator();
        jMenu.add(new WebDAVMenuItem("Principal-Property-Set Report", 211, this));
        jMenu.add(new WebDAVMenuItem("Principal-Match Report", 212, this));
        jMenu.add(new WebDAVMenuItem("Principal-Property-Search Report", 213, this));
        jMenu.add(new WebDAVMenuItem("Principal-Search-Property-Set Report", 214, this));
        return jMenu;
    }

    protected JMenu generateViewMenu() {
        JMenu jMenu = new JMenu("View", true);
        jMenu.add(new WebDAVMenuItem("View Lock Properties", 14, this));
        jMenu.addSeparator();
        jMenu.add(new WebDAVMenuItem("View/Modify Properties", 15, this));
        jMenu.addSeparator();
        jMenu.add(new WebDAVMenuItem("Refresh", 16, this));
        return jMenu;
    }

    protected JMenu generateHelpMenu() {
        JMenu jMenu = new JMenu("Help", true);
        jMenu.add(new WebDAVMenuItem("About DAV Explorer...", 17, this));
        return jMenu;
    }

    class WebDAVCheckBoxMenuItem
    extends JCheckBoxMenuItem {
        private int id;

        public WebDAVCheckBoxMenuItem(String string, int n, ActionListener actionListener, boolean bl) {
            super(string);
            this.addActionListener(actionListener);
            this.setEnabled(bl);
            this.id = n;
        }

        public WebDAVCheckBoxMenuItem(String string, int n, ActionListener actionListener) {
            super(string);
            this.addActionListener(actionListener);
            this.setEnabled(true);
            this.id = n;
        }

        public int getId() {
            return this.id;
        }
    }

    class WebDAVMenuItem
    extends JMenuItem {
        private int id;

        public WebDAVMenuItem(String string, int n, ActionListener actionListener, boolean bl) {
            super(string);
            this.addActionListener(actionListener);
            this.setEnabled(bl);
            this.id = n;
        }

        public WebDAVMenuItem(String string, int n, ActionListener actionListener) {
            super(string);
            this.addActionListener(actionListener);
            this.setEnabled(true);
            this.id = n;
        }

        public int getId() {
            return this.id;
        }
    }
}

