/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.AuthSchemeNotImplException;
import HTTPClient.AuthorizationHandler;
import HTTPClient.AuthorizationInfo;
import HTTPClient.AuthorizationPrompter;
import HTTPClient.Codecs;
import HTTPClient.GlobalConstants;
import HTTPClient.HttpHeaderElement;
import HTTPClient.Log;
import HTTPClient.MD5;
import HTTPClient.MD5InputStream;
import HTTPClient.NVPair;
import HTTPClient.ParseException;
import HTTPClient.Response;
import HTTPClient.RoRequest;
import HTTPClient.RoResponse;
import HTTPClient.SimpleAuthPopup;
import HTTPClient.SimpleAuthPrompt;
import HTTPClient.URI;
import HTTPClient.Util;
import HTTPClient.VerifyDigest;
import HTTPClient.VerifyRspAuth;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;

public class DefaultAuthHandler
implements AuthorizationHandler,
GlobalConstants {
    private static final byte[] NUL = new byte[0];
    private static final int DI_A1 = 0;
    private static final int DI_A1S = 1;
    private static final int DI_QOP = 2;
    private static byte[] digest_secret = null;
    private static AuthorizationPrompter prompter = null;
    private static boolean prompterSet = false;

    public AuthorizationInfo fixupAuthInfo(AuthorizationInfo authorizationInfo, RoRequest roRequest, AuthorizationInfo authorizationInfo2, RoResponse roResponse) throws AuthSchemeNotImplException {
        if (authorizationInfo.getScheme().equalsIgnoreCase("Basic") || authorizationInfo.getScheme().equalsIgnoreCase("SOCKS5")) {
            return authorizationInfo;
        }
        if (!authorizationInfo.getScheme().equalsIgnoreCase("Digest")) {
            throw new AuthSchemeNotImplException(authorizationInfo.getScheme());
        }
        if (Log.isEnabled(8)) {
            Log.write(8, "Auth:  fixing up Authorization for host " + authorizationInfo.getHost() + ":" + authorizationInfo.getPort() + "; scheme: " + authorizationInfo.getScheme() + "; realm: " + authorizationInfo.getRealm());
        }
        return DefaultAuthHandler.digest_fixup(authorizationInfo, roRequest, authorizationInfo2, roResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthorizationInfo getAuthorization(AuthorizationInfo authorizationInfo, RoRequest roRequest, RoResponse roResponse) throws AuthSchemeNotImplException, IOException {
        NVPair nVPair;
        AuthorizationInfo authorizationInfo2;
        if (Log.isEnabled(8)) {
            Log.write(8, "Auth:  Requesting Authorization for host " + authorizationInfo.getHost() + ":" + authorizationInfo.getPort() + "; scheme: " + authorizationInfo.getScheme() + "; realm: " + authorizationInfo.getRealm());
        }
        if (!(authorizationInfo.getScheme().equalsIgnoreCase("Basic") || authorizationInfo.getScheme().equalsIgnoreCase("Digest") || authorizationInfo.getScheme().equalsIgnoreCase("SOCKS5"))) {
            throw new AuthSchemeNotImplException(authorizationInfo.getScheme());
        }
        if (authorizationInfo.getScheme().equalsIgnoreCase("Digest") && (authorizationInfo2 = DefaultAuthHandler.digest_check_stale(authorizationInfo, roRequest, roResponse)) != null) {
            return authorizationInfo2;
        }
        NVPair[] nVPairArray = this.getClass();
        synchronized (nVPairArray) {
            if (!roRequest.allowUI() || prompterSet && prompter == null) {
                return null;
            }
            if (prompter == null) {
                DefaultAuthHandler.setDefaultPrompter();
            }
            nVPair = prompter.getUsernamePassword(authorizationInfo, roResponse.getStatusCode() == 407);
        }
        if (nVPair == null) {
            return null;
        }
        if (authorizationInfo.getScheme().equalsIgnoreCase("basic")) {
            authorizationInfo2 = new AuthorizationInfo(authorizationInfo.getHost(), authorizationInfo.getPort(), authorizationInfo.getScheme(), authorizationInfo.getRealm(), Codecs.base64Encode(nVPair.getName() + ":" + nVPair.getValue()));
        } else if (authorizationInfo.getScheme().equalsIgnoreCase("Digest")) {
            authorizationInfo2 = DefaultAuthHandler.digest_gen_auth_info(authorizationInfo.getHost(), authorizationInfo.getPort(), authorizationInfo.getRealm(), nVPair.getName(), nVPair.getValue(), roRequest.getConnection().getContext());
            authorizationInfo2 = DefaultAuthHandler.digest_fixup(authorizationInfo2, roRequest, authorizationInfo, null);
        } else {
            nVPairArray = new NVPair[]{nVPair};
            authorizationInfo2 = new AuthorizationInfo(authorizationInfo.getHost(), authorizationInfo.getPort(), authorizationInfo.getScheme(), authorizationInfo.getRealm(), nVPairArray, null);
        }
        nVPair = null;
        System.gc();
        Log.write(8, "Auth:  Got Authorization");
        return authorizationInfo2;
    }

    public void handleAuthHeaders(Response response, RoRequest roRequest, AuthorizationInfo authorizationInfo, AuthorizationInfo authorizationInfo2) throws IOException {
        String string = response.getHeader("Authentication-Info");
        String string2 = response.getHeader("Proxy-Authentication-Info");
        if (string == null && authorizationInfo != null && DefaultAuthHandler.hasParam(authorizationInfo.getParams(), "qop", "auth-int")) {
            string = "";
        }
        if (string2 == null && authorizationInfo2 != null && DefaultAuthHandler.hasParam(authorizationInfo2.getParams(), "qop", "auth-int")) {
            string2 = "";
        }
        try {
            DefaultAuthHandler.handleAuthInfo(string, "Authentication-Info", authorizationInfo, response, roRequest, true);
            DefaultAuthHandler.handleAuthInfo(string2, "Proxy-Authentication-Info", authorizationInfo2, response, roRequest, true);
        }
        catch (ParseException parseException) {
            throw new IOException(parseException.toString());
        }
    }

    public void handleAuthTrailers(Response response, RoRequest roRequest, AuthorizationInfo authorizationInfo, AuthorizationInfo authorizationInfo2) throws IOException {
        String string = response.getTrailer("Authentication-Info");
        String string2 = response.getTrailer("Proxy-Authentication-Info");
        try {
            DefaultAuthHandler.handleAuthInfo(string, "Authentication-Info", authorizationInfo, response, roRequest, false);
            DefaultAuthHandler.handleAuthInfo(string2, "Proxy-Authentication-Info", authorizationInfo2, response, roRequest, false);
        }
        catch (ParseException parseException) {
            throw new IOException(parseException.toString());
        }
    }

    private static void handleAuthInfo(String string, String string2, AuthorizationInfo authorizationInfo, Response response, RoRequest roRequest, boolean bl) throws ParseException, IOException {
        if (string == null) {
            return;
        }
        Vector vector = Util.parseHeader(string);
        HttpHeaderElement httpHeaderElement = Util.getElement(vector, "nextnonce");
        if (DefaultAuthHandler.handle_nextnonce(authorizationInfo, roRequest, httpHeaderElement)) {
            vector.removeElement(httpHeaderElement);
        }
        if (DefaultAuthHandler.handle_discard(authorizationInfo, roRequest, httpHeaderElement = Util.getElement(vector, "discard"))) {
            vector.removeElement(httpHeaderElement);
        }
        if (bl) {
            HttpHeaderElement httpHeaderElement2 = null;
            if (vector != null && (httpHeaderElement2 = Util.getElement(vector, "qop")) != null && httpHeaderElement2.getValue() != null) {
                DefaultAuthHandler.handle_rspauth(authorizationInfo, response, roRequest, vector, string2);
            } else if (authorizationInfo != null && (Util.hasToken(response.getHeader("Trailer"), string2) && DefaultAuthHandler.hasParam(authorizationInfo.getParams(), "qop", null) || DefaultAuthHandler.hasParam(authorizationInfo.getParams(), "qop", "auth-int"))) {
                DefaultAuthHandler.handle_rspauth(authorizationInfo, response, roRequest, null, string2);
            } else if (vector != null && httpHeaderElement2 == null && vector.contains(new HttpHeaderElement("digest")) || Util.hasToken(response.getHeader("Trailer"), string2) && authorizationInfo != null && !DefaultAuthHandler.hasParam(authorizationInfo.getParams(), "qop", null)) {
                DefaultAuthHandler.handle_digest(authorizationInfo, response, roRequest, string2);
            }
        }
        if (vector.size() > 0) {
            response.setHeader(string2, Util.assembleHeader(vector));
        } else {
            response.deleteHeader(string2);
        }
    }

    private static final boolean hasParam(NVPair[] nVPairArray, String string, String string2) {
        for (int i = 0; i < nVPairArray.length; ++i) {
            if (!nVPairArray[i].getName().equalsIgnoreCase(string) || string2 != null && !nVPairArray[i].getValue().equalsIgnoreCase(string2)) continue;
            return true;
        }
        return false;
    }

    private static AuthorizationInfo digest_gen_auth_info(String string, int n, String string2, String string3, String string4, Object object) {
        NVPair[] nVPairArray;
        String string5 = string3 + ":" + string2 + ":" + string4;
        String[] stringArray = new String[]{MD5.hexDigest(string5), null, null};
        AuthorizationInfo authorizationInfo = AuthorizationInfo.getAuthorization(string, n, "Digest", string2, object);
        if (authorizationInfo == null) {
            nVPairArray = new NVPair[]{new NVPair("username", string3), new NVPair("uri", ""), new NVPair("nonce", ""), new NVPair("response", "")};
        } else {
            nVPairArray = authorizationInfo.getParams();
            for (int i = 0; i < nVPairArray.length; ++i) {
                if (!nVPairArray[i].getName().equalsIgnoreCase("username")) continue;
                nVPairArray[i] = new NVPair("username", string3);
                break;
            }
        }
        return new AuthorizationInfo(string, n, "Digest", string2, nVPairArray, stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AuthorizationInfo digest_fixup(AuthorizationInfo authorizationInfo, RoRequest roRequest, AuthorizationInfo authorizationInfo2, RoResponse roResponse) throws AuthSchemeNotImplException {
        boolean bl;
        NVPair[] nVPairArray;
        Object object;
        Object object2;
        String[] stringArray;
        NVPair[] nVPairArray2;
        int n;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        int n8 = -1;
        NVPair[] nVPairArray3 = null;
        if (authorizationInfo2 != null) {
            nVPairArray3 = authorizationInfo2.getParams();
            for (n = 0; n < nVPairArray3.length; ++n) {
                String string = nVPairArray3[n].getName().toLowerCase();
                if (string.equals("domain")) {
                    n2 = n;
                    continue;
                }
                if (string.equals("nonce")) {
                    n3 = n;
                    continue;
                }
                if (string.equals("opaque")) {
                    n5 = n;
                    continue;
                }
                if (string.equals("algorithm")) {
                    n4 = n;
                    continue;
                }
                if (string.equals("stale")) {
                    n6 = n;
                    continue;
                }
                if (string.equals("digest-required")) {
                    n7 = n;
                    continue;
                }
                if (!string.equals("qop")) continue;
                n8 = n;
            }
        }
        n = -1;
        int n9 = -1;
        int n10 = -1;
        int n11 = -1;
        int n12 = -1;
        int n13 = -1;
        int n14 = -1;
        int n15 = -1;
        int n16 = -1;
        int n17 = -1;
        int n18 = -1;
        Object object3 = authorizationInfo;
        synchronized (object3) {
            nVPairArray2 = authorizationInfo.getParams();
            for (int i = 0; i < nVPairArray2.length; ++i) {
                String string = nVPairArray2[i].getName().toLowerCase();
                if (string.equals("uri")) {
                    n = i;
                    continue;
                }
                if (string.equals("username")) {
                    n9 = i;
                    continue;
                }
                if (string.equals("algorithm")) {
                    n10 = i;
                    continue;
                }
                if (string.equals("nonce")) {
                    n12 = i;
                    continue;
                }
                if (string.equals("cnonce")) {
                    n13 = i;
                    continue;
                }
                if (string.equals("nc")) {
                    n14 = i;
                    continue;
                }
                if (string.equals("response")) {
                    n11 = i;
                    continue;
                }
                if (string.equals("opaque")) {
                    n15 = i;
                    continue;
                }
                if (string.equals("digest")) {
                    n16 = i;
                    continue;
                }
                if (string.equals("digest-required")) {
                    n17 = i;
                    continue;
                }
                if (!string.equals("qop")) continue;
                n18 = i;
            }
            stringArray = (String[])authorizationInfo.getExtraInfo();
            if (n10 != -1 && !nVPairArray2[n10].getValue().equalsIgnoreCase("MD5") && !nVPairArray2[n10].getValue().equalsIgnoreCase("MD5-sess")) {
                throw new AuthSchemeNotImplException("Digest auth scheme: Algorithm " + nVPairArray2[n10].getValue() + " not implemented");
            }
            if (n4 != -1 && !nVPairArray3[n4].getValue().equalsIgnoreCase("MD5") && !nVPairArray3[n4].getValue().equalsIgnoreCase("MD5-sess")) {
                throw new AuthSchemeNotImplException("Digest auth scheme: Algorithm " + nVPairArray3[n4].getValue() + " not implemented");
            }
            nVPairArray2[n] = new NVPair("uri", URI.escape(roRequest.getRequestURI(), URI.escpdPathChar, false));
            object2 = nVPairArray2[n12].getValue();
            if (n3 != -1 && !((String)object2).equals(nVPairArray3[n3].getValue())) {
                nVPairArray2[n12] = nVPairArray3[n3];
            }
            if (n5 != -1) {
                if (n15 == -1) {
                    nVPairArray2 = Util.resizeArray(nVPairArray2, nVPairArray2.length + 1);
                    n15 = nVPairArray2.length - 1;
                }
                nVPairArray2[n15] = nVPairArray3[n5];
            }
            if (n4 != -1) {
                if (n10 == -1) {
                    nVPairArray2 = Util.resizeArray(nVPairArray2, nVPairArray2.length + 1);
                    n10 = nVPairArray2.length - 1;
                }
                nVPairArray2[n10] = nVPairArray3[n4];
            } else {
                if (n10 == -1) {
                    nVPairArray2 = Util.resizeArray(nVPairArray2, nVPairArray2.length + 1);
                    n10 = nVPairArray2.length - 1;
                }
                nVPairArray2[n10] = new NVPair("algorithm", "MD5");
            }
            if (n8 != -1 || n4 != -1 && nVPairArray3[n4].getValue().equalsIgnoreCase("MD5-sess")) {
                if (n13 == -1) {
                    nVPairArray2 = Util.resizeArray(nVPairArray2, nVPairArray2.length + 1);
                    n13 = nVPairArray2.length - 1;
                }
                if (digest_secret == null) {
                    digest_secret = DefaultAuthHandler.gen_random_bytes(20);
                }
                long l = System.currentTimeMillis();
                object = new byte[]{(byte)(l & 0xFFL), (byte)(l >> 8 & 0xFFL), (byte)(l >> 16 & 0xFFL), (byte)(l >> 24 & 0xFFL), (byte)(l >> 32 & 0xFFL), (byte)(l >> 40 & 0xFFL), (byte)(l >> 48 & 0xFFL), (byte)(l >> 56 & 0xFFL)};
                nVPairArray2[n13] = new NVPair("cnonce", MD5.hexDigest(digest_secret, object));
            }
            if (n8 != -1) {
                int n19;
                if (n18 == -1) {
                    nVPairArray2 = Util.resizeArray(nVPairArray2, nVPairArray2.length + 1);
                    n18 = nVPairArray2.length - 1;
                }
                stringArray[2] = nVPairArray3[n8].getValue();
                String[] stringArray2 = DefaultAuthHandler.splitList(stringArray[2], ",");
                nVPairArray = null;
                for (n19 = 0; n19 < stringArray2.length; ++n19) {
                    if (stringArray2[n19].equalsIgnoreCase("auth-int") && roRequest.getStream() == null) {
                        nVPairArray = "auth-int";
                        break;
                    }
                    if (!stringArray2[n19].equalsIgnoreCase("auth")) continue;
                    nVPairArray = "auth";
                }
                if (nVPairArray == null) {
                    for (n19 = 0; n19 < stringArray2.length; ++n19) {
                        if (!stringArray2[n19].equalsIgnoreCase("auth-int")) continue;
                        throw new AuthSchemeNotImplException("Digest auth scheme: Can't comply with qop option 'auth-int' because an HttpOutputStream is being used and we don't support stream-filters in modules yet");
                    }
                    throw new AuthSchemeNotImplException("Digest auth scheme: None of the available qop options '" + nVPairArray3[n8].getValue() + "' implemented");
                }
                nVPairArray2[n18] = new NVPair("qop", (String)nVPairArray);
            }
            if (n18 != -1) {
                if (n14 == -1) {
                    nVPairArray2 = Util.resizeArray(nVPairArray2, nVPairArray2.length + 1);
                    n14 = nVPairArray2.length - 1;
                    nVPairArray2[n14] = new NVPair("nc", "00000001");
                } else if (((String)object2).equals(nVPairArray2[n12].getValue())) {
                    String string = Long.toHexString(Long.parseLong(nVPairArray2[n14].getValue(), 16) + 1L);
                    nVPairArray2[n14] = new NVPair("nc", "00000000".substring(string.length()) + string);
                } else {
                    nVPairArray2[n14] = new NVPair("nc", "00000001");
                }
            }
            if (authorizationInfo2 != null && (n6 == -1 || !nVPairArray3[n6].getValue().equalsIgnoreCase("true")) && n10 != -1 && nVPairArray2[n10].getValue().equalsIgnoreCase("MD5-sess")) {
                stringArray[1] = MD5.hexDigest(stringArray[0] + ":" + nVPairArray2[n12].getValue() + ":" + nVPairArray2[n13].getValue());
            }
            authorizationInfo.setParams(nVPairArray2);
            authorizationInfo.setExtraInfo(stringArray);
        }
        object3 = null;
        if (n18 != -1 && nVPairArray2[n18].getValue().equalsIgnoreCase("auth-int")) {
            if (roRequest.getStream() != null) {
                throw new AuthSchemeNotImplException("Digest auth scheme: Can't comply with qop option 'auth-int' because an HttpOutputStream is being used and we don't support stream-filters in modules yet");
            }
            object3 = MD5.hexDigest(roRequest.getData() == null ? NUL : roRequest.getData());
        }
        nVPairArray2[n11] = new NVPair("response", DefaultAuthHandler.calcResponseAttr((String)object3, stringArray, nVPairArray2, n10, n, n18, n12, n14, n13, roRequest.getMethod()));
        boolean bl2 = false;
        if (n7 != -1 && (nVPairArray3[n7].getValue() == null || nVPairArray3[n7].getValue().equalsIgnoreCase("true"))) {
            bl2 = true;
        }
        if ((bl2 || n16 != -1) && roRequest.getStream() == null) {
            if (n16 == -1) {
                nVPairArray = Util.resizeArray(nVPairArray2, nVPairArray2.length + 1);
                n16 = nVPairArray2.length;
            } else {
                nVPairArray = nVPairArray2;
            }
            nVPairArray[n16] = new NVPair("digest", DefaultAuthHandler.calc_digest(roRequest, stringArray[0], nVPairArray2[n12].getValue()));
            if (n17 == -1) {
                n17 = nVPairArray.length;
                nVPairArray = Util.resizeArray(nVPairArray, nVPairArray.length + 1);
                nVPairArray[n17] = new NVPair("digest-required", "true");
            }
            object2 = new AuthorizationInfo(authorizationInfo.getHost(), authorizationInfo.getPort(), authorizationInfo.getScheme(), authorizationInfo.getRealm(), nVPairArray, stringArray);
        } else {
            object2 = bl2 ? null : new AuthorizationInfo(authorizationInfo.getHost(), authorizationInfo.getPort(), authorizationInfo.getScheme(), authorizationInfo.getRealm(), nVPairArray2, stringArray);
        }
        boolean bl3 = bl = authorizationInfo2 != null && authorizationInfo2.getHost().equalsIgnoreCase(roRequest.getConnection().getHost());
        if (n2 != -1) {
            object = null;
            try {
                object = new URI(roRequest.getConnection().getProtocol(), roRequest.getConnection().getHost(), roRequest.getConnection().getPort(), roRequest.getRequestURI());
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            StringTokenizer stringTokenizer = new StringTokenizer(nVPairArray3[n2].getValue());
            while (stringTokenizer.hasMoreTokens()) {
                URI uRI;
                try {
                    uRI = new URI((URI)object, stringTokenizer.nextToken());
                }
                catch (ParseException parseException) {
                    continue;
                }
                if (uRI.getHost() == null) continue;
                AuthorizationInfo authorizationInfo3 = AuthorizationInfo.getAuthorization(uRI.getHost(), uRI.getPort(), authorizationInfo.getScheme(), authorizationInfo.getRealm(), roRequest.getConnection().getContext());
                if (authorizationInfo3 == null) {
                    nVPairArray2[n] = new NVPair("uri", uRI.getPathAndQuery());
                    authorizationInfo3 = new AuthorizationInfo(uRI.getHost(), uRI.getPort(), authorizationInfo.getScheme(), authorizationInfo.getRealm(), nVPairArray2, stringArray);
                    AuthorizationInfo.addAuthorization(authorizationInfo3);
                }
                if (!bl) continue;
                authorizationInfo3.addPath(uRI.getPathAndQuery());
            }
        } else if (bl && authorizationInfo2 != null && (object = (Object)AuthorizationInfo.getAuthorization(authorizationInfo2.getHost(), authorizationInfo2.getPort(), authorizationInfo.getScheme(), authorizationInfo.getRealm(), roRequest.getConnection().getContext())) != null) {
            object.addPath("/");
        }
        return object2;
    }

    private static AuthorizationInfo digest_check_stale(AuthorizationInfo authorizationInfo, RoRequest roRequest, RoResponse roResponse) throws AuthSchemeNotImplException, IOException {
        AuthorizationInfo authorizationInfo2 = null;
        NVPair[] nVPairArray = authorizationInfo.getParams();
        for (int i = 0; i < nVPairArray.length; ++i) {
            String string = nVPairArray[i].getName();
            if (!string.equalsIgnoreCase("stale") || !nVPairArray[i].getValue().equalsIgnoreCase("true")) continue;
            authorizationInfo2 = AuthorizationInfo.getAuthorization(authorizationInfo, roRequest, roResponse, false);
            if (authorizationInfo2 == null) break;
            return DefaultAuthHandler.digest_fixup(authorizationInfo2, roRequest, authorizationInfo, roResponse);
        }
        return authorizationInfo2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean handle_nextnonce(AuthorizationInfo authorizationInfo, RoRequest roRequest, HttpHeaderElement httpHeaderElement) throws IOException {
        AuthorizationInfo authorizationInfo2;
        if (authorizationInfo == null || httpHeaderElement == null || httpHeaderElement.getValue() == null) {
            return false;
        }
        try {
            authorizationInfo2 = AuthorizationInfo.getAuthorization(authorizationInfo, roRequest, null, false);
        }
        catch (AuthSchemeNotImplException authSchemeNotImplException) {
            authorizationInfo2 = authorizationInfo;
        }
        AuthorizationInfo authorizationInfo3 = authorizationInfo2;
        synchronized (authorizationInfo3) {
            NVPair[] nVPairArray = authorizationInfo2.getParams();
            nVPairArray = DefaultAuthHandler.setValue(nVPairArray, "nonce", httpHeaderElement.getValue());
            nVPairArray = DefaultAuthHandler.setValue(nVPairArray, "nc", "00000000");
            authorizationInfo2.setParams(nVPairArray);
        }
        return true;
    }

    private static boolean handle_digest(AuthorizationInfo authorizationInfo, Response response, RoRequest roRequest, String string) throws IOException {
        if (authorizationInfo == null) {
            return false;
        }
        NVPair[] nVPairArray = authorizationInfo.getParams();
        VerifyDigest verifyDigest = new VerifyDigest(((String[])authorizationInfo.getExtraInfo())[0], DefaultAuthHandler.getValue(nVPairArray, "nonce"), roRequest.getMethod(), DefaultAuthHandler.getValue(nVPairArray, "uri"), string, response);
        if (response.hasEntity()) {
            Log.write(8, "Auth:  pushing md5-check-stream to verify digest from " + string);
            response.inp_stream = new MD5InputStream(response.inp_stream, verifyDigest);
        } else {
            Log.write(8, "Auth:  verifying digest from " + string);
            verifyDigest.verifyHash(MD5.digest(NUL), 0L);
        }
        return true;
    }

    private static boolean handle_rspauth(AuthorizationInfo authorizationInfo, Response response, RoRequest roRequest, Vector vector, String string) throws IOException {
        Object object;
        if (authorizationInfo == null) {
            return false;
        }
        NVPair[] nVPairArray = authorizationInfo.getParams();
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        for (int i = 0; i < nVPairArray.length; ++i) {
            object = nVPairArray[i].getName().toLowerCase();
            if (((String)object).equals("uri")) {
                n = i;
                continue;
            }
            if (((String)object).equals("algorithm")) {
                n2 = i;
                continue;
            }
            if (((String)object).equals("nonce")) {
                n3 = i;
                continue;
            }
            if (((String)object).equals("cnonce")) {
                n4 = i;
                continue;
            }
            if (!((String)object).equals("nc")) continue;
            n5 = i;
        }
        VerifyRspAuth verifyRspAuth = new VerifyRspAuth(nVPairArray[n].getValue(), ((String[])authorizationInfo.getExtraInfo())[0], n2 == -1 ? null : nVPairArray[n2].getValue(), nVPairArray[n3].getValue(), n4 == -1 ? "" : nVPairArray[n4].getValue(), n5 == -1 ? "" : nVPairArray[n5].getValue(), string, response);
        object = null;
        if (vector != null && (object = Util.getElement(vector, "qop")) != null && ((HttpHeaderElement)object).getValue() != null && (((HttpHeaderElement)object).getValue().equalsIgnoreCase("auth") || !response.hasEntity() && ((HttpHeaderElement)object).getValue().equalsIgnoreCase("auth-int"))) {
            Log.write(8, "Auth:  verifying rspauth from " + string);
            verifyRspAuth.verifyHash(MD5.digest(NUL), 0L);
        } else {
            Log.write(8, "Auth:  pushing md5-check-stream to verify rspauth from " + string);
            response.inp_stream = new MD5InputStream(response.inp_stream, verifyRspAuth);
        }
        return true;
    }

    private static String calcResponseAttr(String string, String[] stringArray, NVPair[] nVPairArray, int n, int n2, int n3, int n4, int n5, int n6, String string2) {
        String string3 = n != -1 && nVPairArray[n].getValue().equalsIgnoreCase("MD5-sess") ? stringArray[1] : stringArray[0];
        String string4 = string2 + ":" + nVPairArray[n2].getValue();
        if (n3 != -1 && nVPairArray[n3].getValue().equalsIgnoreCase("auth-int")) {
            string4 = string4 + ":" + string;
        }
        string4 = MD5.hexDigest(string4);
        String string5 = n3 == -1 ? MD5.hexDigest(string3 + ":" + nVPairArray[n4].getValue() + ":" + string4) : MD5.hexDigest(string3 + ":" + nVPairArray[n4].getValue() + ":" + nVPairArray[n5].getValue() + ":" + nVPairArray[n6].getValue() + ":" + nVPairArray[n3].getValue() + ":" + string4);
        return string5;
    }

    private static String calc_digest(RoRequest roRequest, String string, String string2) {
        Object object;
        if (roRequest.getStream() != null) {
            return "";
        }
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        for (int i = 0; i < roRequest.getHeaders().length; ++i) {
            object = roRequest.getHeaders()[i].getName();
            if (((String)object).equalsIgnoreCase("Content-type")) {
                n = i;
                continue;
            }
            if (((String)object).equalsIgnoreCase("Content-Encoding")) {
                n2 = i;
                continue;
            }
            if (((String)object).equalsIgnoreCase("Last-Modified")) {
                n3 = i;
                continue;
            }
            if (((String)object).equalsIgnoreCase("Expires")) {
                n4 = i;
                continue;
            }
            if (!((String)object).equalsIgnoreCase("Date")) continue;
            n5 = i;
        }
        NVPair[] nVPairArray = roRequest.getHeaders();
        object = roRequest.getData() == null ? NUL : roRequest.getData();
        String string3 = MD5.hexDigest((byte[])object);
        String string4 = MD5.hexDigest(roRequest.getRequestURI() + ":" + (n == -1 ? "" : nVPairArray[n].getValue()) + ":" + ((Object)object).length + ":" + (n2 == -1 ? "" : nVPairArray[n2].getValue()) + ":" + (n3 == -1 ? "" : nVPairArray[n3].getValue()) + ":" + (n4 == -1 ? "" : nVPairArray[n4].getValue()));
        String string5 = string + ":" + string2 + ":" + roRequest.getMethod() + ":" + (n5 == -1 ? "" : nVPairArray[n5].getValue()) + ":" + string4 + ":" + string3;
        if (Log.isEnabled(8)) {
            Log.write(8, "Auth:  Entity-Info: '" + roRequest.getRequestURI() + ":" + (n == -1 ? "" : nVPairArray[n].getValue()) + ":" + ((Object)object).length + ":" + (n2 == -1 ? "" : nVPairArray[n2].getValue()) + ":" + (n3 == -1 ? "" : nVPairArray[n3].getValue()) + ":" + (n4 == -1 ? "" : nVPairArray[n4].getValue()) + "'");
            Log.write(8, "Auth:  Entity-Body: '" + string3 + "'");
            Log.write(8, "Auth:  Entity-Digest: '" + string5 + "'");
        }
        return MD5.hexDigest(string5);
    }

    private static boolean handle_discard(AuthorizationInfo authorizationInfo, RoRequest roRequest, HttpHeaderElement httpHeaderElement) {
        if (httpHeaderElement != null && authorizationInfo != null) {
            AuthorizationInfo.removeAuthorization(authorizationInfo, roRequest.getConnection().getContext());
            return true;
        }
        return false;
    }

    private static byte[] gen_random_bytes(int n) {
        try {
            FileInputStream fileInputStream = new FileInputStream("/dev/random");
            DataInputStream dataInputStream = new DataInputStream(fileInputStream);
            byte[] byArray = new byte[n];
            dataInputStream.readFully(byArray);
            try {
                dataInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return byArray;
        }
        catch (Throwable throwable) {
            byte[] byArray = new byte[n];
            try {
                long l = Runtime.getRuntime().freeMemory();
                byArray[0] = (byte)(l & 0xFFL);
                byArray[1] = (byte)(l >> 8 & 0xFFL);
                int n2 = byArray.hashCode();
                byArray[2] = (byte)(n2 & 0xFF);
                byArray[3] = (byte)(n2 >> 8 & 0xFF);
                byArray[4] = (byte)(n2 >> 16 & 0xFF);
                byArray[5] = (byte)(n2 >> 24 & 0xFF);
                long l2 = System.currentTimeMillis();
                byArray[6] = (byte)(l2 & 0xFFL);
                byArray[7] = (byte)(l2 >> 8 & 0xFFL);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            return byArray;
        }
    }

    private static final String getValue(NVPair[] nVPairArray, String string) {
        int n = nVPairArray.length;
        for (int i = 0; i < n; ++i) {
            if (!nVPairArray[i].getName().equalsIgnoreCase(string)) continue;
            return nVPairArray[i].getValue();
        }
        return null;
    }

    private static final int getIndex(NVPair[] nVPairArray, String string) {
        int n = nVPairArray.length;
        for (int i = 0; i < n; ++i) {
            if (!nVPairArray[i].getName().equalsIgnoreCase(string)) continue;
            return i;
        }
        return -1;
    }

    private static final NVPair[] setValue(NVPair[] nVPairArray, String string, String string2) {
        int n = DefaultAuthHandler.getIndex(nVPairArray, string);
        if (n == -1) {
            n = nVPairArray.length;
            nVPairArray = Util.resizeArray(nVPairArray, nVPairArray.length + 1);
        }
        nVPairArray[n] = new NVPair(string, string2);
        return nVPairArray;
    }

    private static String[] splitList(String string, String string2) {
        if (string == null) {
            return new String[0];
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringTokenizer.nextToken().trim();
        }
        return stringArray;
    }

    static String hex(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 3);
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(Character.forDigit(byArray[i] >> 4 & 0xF, 16));
            stringBuffer.append(Character.forDigit(byArray[i] & 0xF, 16));
            stringBuffer.append(':');
        }
        stringBuffer.setLength(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }

    static final byte[] unHex(String string) {
        byte[] byArray = new byte[string.length() / 2];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)(0xFF & Integer.parseInt(string.substring(2 * i, 2 * (i + 1)), 16));
        }
        return byArray;
    }

    public static synchronized AuthorizationPrompter setAuthorizationPrompter(AuthorizationPrompter authorizationPrompter) {
        AuthorizationPrompter authorizationPrompter2 = prompter;
        prompter = authorizationPrompter;
        prompterSet = true;
        return authorizationPrompter2;
    }

    private static void setDefaultPrompter() {
        prompter = !SimpleAuthPrompt.canUseCLPrompt() || DefaultAuthHandler.isAWTRunning() ? new SimpleAuthPopup() : new SimpleAuthPrompt();
    }

    private static final boolean isAWTRunning() {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        while (threadGroup.getParent() != null) {
            threadGroup = threadGroup.getParent();
        }
        Thread[] threadArray = new Thread[threadGroup.activeCount() + 5];
        int n = threadGroup.enumerate(threadArray);
        for (int i = 0; i < n; ++i) {
            if (!threadArray[i].getName().startsWith("AWT-")) continue;
            return true;
        }
        return false;
    }
}

