/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.AuthorizationInfo;
import HTTPClient.CIHashtable;
import HTTPClient.Codecs;
import HTTPClient.GlobalConstants;
import HTTPClient.HTTPClientModule;
import HTTPClient.HTTPClientModuleConstants;
import HTTPClient.HTTPResponse;
import HTTPClient.HttpHeaderElement;
import HTTPClient.HttpOutputStream;
import HTTPClient.IdempotentSequence;
import HTTPClient.LinkedList;
import HTTPClient.Log;
import HTTPClient.ModuleException;
import HTTPClient.NVPair;
import HTTPClient.ParseException;
import HTTPClient.ProgressObserver;
import HTTPClient.ProtocolNotSuppException;
import HTTPClient.Request;
import HTTPClient.Response;
import HTTPClient.SocksClient;
import HTTPClient.SocksException;
import HTTPClient.StreamDemultiplexor;
import HTTPClient.URI;
import HTTPClient.Util;
import java.applet.Applet;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Vector;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.security.cert.X509Certificate;
import sun.security.x509.X500Name;

public class HTTPConnection
implements GlobalConstants,
HTTPClientModuleConstants {
    public static final String version = "RPT-HTTPClient/0.3-3E";
    private static final Object dflt_context;
    private Object Context = null;
    private int Protocol;
    int ServerProtocolVersion;
    boolean ServProtVersKnown;
    private String RequestProtocolVersion;
    private String Host;
    private int Port;
    private InetAddress LocalAddr;
    private int LocalPort;
    private String Proxy_Host = null;
    private int Proxy_Port;
    private static String Default_Proxy_Host;
    private static int Default_Proxy_Port;
    private static CIHashtable non_proxy_host_list;
    private static Vector non_proxy_dom_list;
    private static Vector non_proxy_addr_list;
    private static Vector non_proxy_mask_list;
    private SocksClient Socks_client = null;
    private static SocksClient Default_Socks_client;
    private StreamDemultiplexor input_demux = null;
    LinkedList DemuxList = new LinkedList();
    private LinkedList RequestList = new LinkedList();
    private boolean doesKeepAlive = false;
    private boolean keepAliveUnknown = true;
    private int keepAliveReqMax = -1;
    private int keepAliveReqLeft;
    private static boolean no_chunked;
    private static boolean force_1_0;
    private static boolean neverPipeline;
    private static boolean noKeepAlives;
    private static boolean haveMSLargeWritesBug;
    static boolean deferStreamed;
    private static int DefaultTimeout;
    private int Timeout;
    private NVPair[] DefaultHeaders = new NVPair[0];
    private static Vector DefaultModuleList;
    private Vector ModuleList;
    private static boolean defaultAllowUI;
    private boolean allowUI;
    private static boolean logging;
    private static String logFilename;
    private static String outboundHeader;
    private static boolean JSSE;
    private Object sslFactory;
    private boolean allowAnyHostname = false;
    private volatile Response early_stall = null;
    private volatile Response late_stall = null;
    private volatile Response prev_resp = null;
    private boolean output_finished = true;

    public HTTPConnection(Applet applet) throws ProtocolNotSuppException {
        this(applet.getCodeBase().getProtocol(), applet.getCodeBase().getHost(), applet.getCodeBase().getPort());
    }

    public HTTPConnection(String string) {
        this.Setup(0, string, 80, null, -1);
    }

    public HTTPConnection(String string, int n) {
        this.Setup(0, string, n, null, -1);
    }

    public HTTPConnection(String string, String string2, int n) throws ProtocolNotSuppException {
        this(string, string2, n, null, -1);
    }

    public HTTPConnection(String string, String string2, int n, InetAddress inetAddress, int n2) throws ProtocolNotSuppException {
        string = string.trim().toLowerCase();
        if (!string.equals("http") && !string.equals("https")) {
            throw new ProtocolNotSuppException("Unsupported protocol '" + string + "'");
        }
        if (string.equals("http")) {
            this.Setup(0, string2, n, inetAddress, n2);
        } else if (string.equals("https")) {
            this.Setup(1, string2, n, inetAddress, n2);
        } else if (string.equals("shttp")) {
            this.Setup(2, string2, n, inetAddress, n2);
        } else if (string.equals("http-ng")) {
            this.Setup(3, string2, n, inetAddress, n2);
        }
    }

    public HTTPConnection(URL uRL) throws ProtocolNotSuppException {
        this(uRL.getProtocol(), uRL.getHost(), uRL.getPort());
    }

    public HTTPConnection(URI uRI) throws ProtocolNotSuppException {
        this(uRI.getScheme(), uRI.getHost(), uRI.getPort());
    }

    private void Setup(int n, String string, int n2, InetAddress inetAddress, int n3) {
        this.Protocol = n;
        this.Host = string.trim().toLowerCase();
        this.Port = n2;
        this.LocalAddr = inetAddress;
        this.LocalPort = n3;
        if (this.Port == -1) {
            this.Port = URI.defaultPort(this.getProtocol());
        }
        if (Default_Proxy_Host != null && !this.matchNonProxy(this.Host)) {
            this.setCurrentProxy(Default_Proxy_Host, Default_Proxy_Port);
        } else {
            this.setCurrentProxy(null, 0);
        }
        this.Socks_client = Default_Socks_client;
        this.Timeout = DefaultTimeout;
        this.ModuleList = (Vector)DefaultModuleList.clone();
        this.allowUI = defaultAllowUI;
        if (noKeepAlives) {
            this.setDefaultHeaders(new NVPair[]{new NVPair("Connection", "close")});
        }
        if (JSSE) {
            try {
                this.sslFactory = SSLSocketFactory.getDefault();
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                this.sslFactory = null;
                JSSE = false;
            }
        } else {
            this.sslFactory = null;
        }
    }

    private boolean matchNonProxy(String string) {
        InetAddress[] inetAddressArray;
        if (non_proxy_host_list.get(string) != null) {
            return true;
        }
        for (int i = 0; i < non_proxy_dom_list.size(); ++i) {
            if (!string.endsWith((String)non_proxy_dom_list.elementAt(i))) continue;
            return true;
        }
        if (non_proxy_addr_list.size() == 0) {
            return false;
        }
        try {
            inetAddressArray = InetAddress.getAllByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
        for (int i = 0; i < non_proxy_addr_list.size(); ++i) {
            byte[] byArray = (byte[])non_proxy_addr_list.elementAt(i);
            byte[] byArray2 = (byte[])non_proxy_mask_list.elementAt(i);
            block4: for (int j = 0; j < inetAddressArray.length; ++j) {
                byte[] byArray3 = inetAddressArray[j].getAddress();
                if (byArray3.length != byArray.length) continue;
                for (int k = 0; k < byArray3.length; ++k) {
                    if ((byArray3[k] & byArray2[k]) != (byArray[k] & byArray2[k])) continue block4;
                }
                return true;
            }
        }
        return false;
    }

    public HTTPResponse Head(String string) throws IOException, ModuleException {
        return this.Head(string, (String)null, null);
    }

    public HTTPResponse Head(String string, NVPair[] nVPairArray) throws IOException, ModuleException {
        return this.Head(string, nVPairArray, null);
    }

    public HTTPResponse Head(String string, NVPair[] nVPairArray, NVPair[] nVPairArray2) throws IOException, ModuleException {
        String string2 = this.stripRef(string);
        String string3 = Codecs.nv2query(nVPairArray);
        if (string3 != null && string3.length() > 0) {
            string2 = string2 + "?" + string3;
        }
        return this.setupRequest("HEAD", string2, nVPairArray2, null, null);
    }

    public HTTPResponse Head(String string, String string2) throws IOException, ModuleException {
        return this.Head(string, string2, null);
    }

    public HTTPResponse Head(String string, String string2, NVPair[] nVPairArray) throws IOException, ModuleException {
        String string3 = this.stripRef(string);
        if (string2 != null && string2.length() > 0) {
            string3 = string3 + "?" + Codecs.URLEncode(string2);
        }
        return this.setupRequest("HEAD", string3, nVPairArray, null, null);
    }

    public HTTPResponse Get(String string) throws IOException, ModuleException {
        return this.Get(string, (String)null, null);
    }

    public HTTPResponse Get(String string, NVPair[] nVPairArray) throws IOException, ModuleException {
        return this.Get(string, nVPairArray, null);
    }

    public HTTPResponse Get(String string, NVPair[] nVPairArray, NVPair[] nVPairArray2) throws IOException, ModuleException {
        String string2 = this.stripRef(string);
        String string3 = Codecs.nv2query(nVPairArray);
        if (string3 != null && string3.length() > 0) {
            string2 = string2 + "?" + string3;
        }
        return this.setupRequest("GET", string2, nVPairArray2, null, null);
    }

    public HTTPResponse Get(String string, String string2) throws IOException, ModuleException {
        return this.Get(string, string2, null);
    }

    public HTTPResponse Get(String string, String string2, NVPair[] nVPairArray) throws IOException, ModuleException {
        String string3 = this.stripRef(string);
        if (string2 != null && string2.length() > 0) {
            string3 = string3 + "?" + Codecs.URLEncode(string2);
        }
        return this.setupRequest("GET", string3, nVPairArray, null, null);
    }

    public HTTPResponse Post(String string) throws IOException, ModuleException {
        return this.Post(string, (byte[])null, null);
    }

    public HTTPResponse Post(String string, NVPair[] nVPairArray) throws IOException, ModuleException {
        NVPair[] nVPairArray2 = new NVPair[]{new NVPair("Content-type", "application/x-www-form-urlencoded")};
        return this.Post(string, Codecs.nv2query(nVPairArray), nVPairArray2);
    }

    public HTTPResponse Post(String string, NVPair[] nVPairArray, NVPair[] nVPairArray2) throws IOException, ModuleException {
        int n;
        for (n = 0; n < nVPairArray2.length && !nVPairArray2[n].getName().equalsIgnoreCase("Content-type"); ++n) {
        }
        if (n == nVPairArray2.length) {
            nVPairArray2 = Util.resizeArray(nVPairArray2, n + 1);
            nVPairArray2[n] = new NVPair("Content-type", "application/x-www-form-urlencoded");
        }
        return this.Post(string, Codecs.nv2query(nVPairArray), nVPairArray2);
    }

    public HTTPResponse Post(String string, String string2) throws IOException, ModuleException {
        return this.Post(string, string2, null);
    }

    public HTTPResponse Post(String string, String string2, NVPair[] nVPairArray) throws IOException, ModuleException {
        byte[] byArray = null;
        if (string2 != null && string2.length() > 0) {
            byArray = string2.getBytes();
        }
        return this.Post(string, byArray, nVPairArray);
    }

    public HTTPResponse Post(String string, byte[] byArray) throws IOException, ModuleException {
        return this.Post(string, byArray, null);
    }

    public HTTPResponse Post(String string, byte[] byArray, NVPair[] nVPairArray) throws IOException, ModuleException {
        if (byArray == null) {
            byArray = new byte[]{};
        }
        return this.setupRequest("POST", this.stripRef(string), nVPairArray, byArray, null);
    }

    public HTTPResponse Post(String string, HttpOutputStream httpOutputStream) throws IOException, ModuleException {
        return this.Post(string, httpOutputStream, null);
    }

    public HTTPResponse Post(String string, HttpOutputStream httpOutputStream, NVPair[] nVPairArray) throws IOException, ModuleException {
        return this.setupRequest("POST", this.stripRef(string), nVPairArray, null, httpOutputStream);
    }

    public HTTPResponse Put(String string, String string2) throws IOException, ModuleException {
        return this.Put(string, string2, null);
    }

    public HTTPResponse Put(String string, String string2, NVPair[] nVPairArray) throws IOException, ModuleException {
        byte[] byArray = null;
        if (string2 != null && string2.length() > 0) {
            byArray = string2.getBytes();
        }
        return this.Put(string, byArray, nVPairArray);
    }

    public HTTPResponse Put(String string, byte[] byArray) throws IOException, ModuleException {
        return this.Put(string, byArray, null);
    }

    public HTTPResponse Put(String string, byte[] byArray, NVPair[] nVPairArray) throws IOException, ModuleException {
        if (byArray == null) {
            byArray = new byte[]{};
        }
        return this.setupRequest("PUT", this.stripRef(string), nVPairArray, byArray, null);
    }

    public HTTPResponse Put(String string, HttpOutputStream httpOutputStream) throws IOException, ModuleException {
        return this.Put(string, httpOutputStream, null);
    }

    public HTTPResponse Put(String string, HttpOutputStream httpOutputStream, NVPair[] nVPairArray) throws IOException, ModuleException {
        return this.setupRequest("PUT", this.stripRef(string), nVPairArray, null, httpOutputStream);
    }

    public HTTPResponse Options(String string) throws IOException, ModuleException {
        return this.Options(string, null, (byte[])null);
    }

    public HTTPResponse Options(String string, NVPair[] nVPairArray) throws IOException, ModuleException {
        return this.Options(string, nVPairArray, (byte[])null);
    }

    public HTTPResponse Options(String string, NVPair[] nVPairArray, byte[] byArray) throws IOException, ModuleException {
        return this.setupRequest("OPTIONS", this.stripRef(string), nVPairArray, byArray, null);
    }

    public HTTPResponse Options(String string, NVPair[] nVPairArray, HttpOutputStream httpOutputStream) throws IOException, ModuleException {
        return this.setupRequest("OPTIONS", this.stripRef(string), nVPairArray, null, httpOutputStream);
    }

    public HTTPResponse Delete(String string) throws IOException, ModuleException {
        return this.Delete(string, null);
    }

    public HTTPResponse Delete(String string, NVPair[] nVPairArray) throws IOException, ModuleException {
        return this.setupRequest("DELETE", this.stripRef(string), nVPairArray, null, null);
    }

    public HTTPResponse Trace(String string, NVPair[] nVPairArray) throws IOException, ModuleException {
        return this.setupRequest("TRACE", this.stripRef(string), nVPairArray, null, null);
    }

    public HTTPResponse Trace(String string) throws IOException, ModuleException {
        return this.Trace(string, null);
    }

    public HTTPResponse ExtensionMethod(String string, String string2, byte[] byArray, NVPair[] nVPairArray) throws IOException, ModuleException {
        return this.setupRequest(string.trim(), this.stripRef(string2), nVPairArray, byArray, null);
    }

    public HTTPResponse ExtensionMethod(String string, String string2, HttpOutputStream httpOutputStream, NVPair[] nVPairArray) throws IOException, ModuleException {
        return this.setupRequest(string.trim(), this.stripRef(string2), nVPairArray, null, httpOutputStream);
    }

    public void stop() {
        Object object = (Request)this.RequestList.enumerate();
        while (object != null) {
            ((Request)object).aborted = true;
            object = (Request)this.RequestList.next();
        }
        object = (StreamDemultiplexor)this.DemuxList.enumerate();
        while (object != null) {
            ((StreamDemultiplexor)object).abort();
            object = (StreamDemultiplexor)this.DemuxList.next();
        }
    }

    public void setSSLSocketFactory(Object object) {
        if (JSSE) {
            try {
                if (object instanceof SSLSocketFactory) {
                    this.sslFactory = object;
                }
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
    }

    public Object getSSLSocketFactory() {
        return this.sslFactory;
    }

    public void setAllowAnyHostname(boolean bl) {
        this.allowAnyHostname = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultHeaders(NVPair[] nVPairArray) {
        Object object;
        int n = nVPairArray == null ? 0 : nVPairArray.length;
        NVPair[] nVPairArray2 = new NVPair[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (nVPairArray[i] == null || ((String)(object = nVPairArray[i].getName().trim())).equalsIgnoreCase("Content-length")) continue;
            nVPairArray2[n2++] = nVPairArray[i];
        }
        if (n2 < n) {
            nVPairArray2 = Util.resizeArray(nVPairArray2, n2);
        }
        object = this.DefaultHeaders;
        synchronized (this.DefaultHeaders) {
            this.DefaultHeaders = nVPairArray2;
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NVPair[] getDefaultHeaders() {
        NVPair[] nVPairArray = this.DefaultHeaders;
        synchronized (this.DefaultHeaders) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return (NVPair[])this.DefaultHeaders.clone();
        }
    }

    public String getProtocol() {
        switch (this.Protocol) {
            case 0: {
                return "http";
            }
            case 1: {
                return "https";
            }
            case 2: {
                return "shttp";
            }
            case 3: {
                return "http-ng";
            }
        }
        throw new Error("HTTPClient Internal Error: invalid protocol " + this.Protocol);
    }

    public String getHost() {
        return this.Host;
    }

    public int getPort() {
        return this.Port;
    }

    public String getProxyHost() {
        return this.Proxy_Host;
    }

    public int getProxyPort() {
        return this.Proxy_Port;
    }

    public boolean isCompatibleWith(URI uRI) {
        if (!uRI.getScheme().equals(this.getProtocol()) || !uRI.getHost().equalsIgnoreCase(this.Host)) {
            return false;
        }
        int n = uRI.getPort();
        if (n == -1) {
            n = URI.defaultPort(uRI.getScheme());
        }
        return n == this.Port;
    }

    public void setRawMode(boolean bl) {
        String[] stringArray = new String[]{"HTTPClient.CookieModule", "HTTPClient.RedirectionModule", "HTTPClient.AuthorizationModule", "HTTPClient.DefaultModule", "HTTPClient.TransferEncodingModule", "HTTPClient.ContentMD5Module", "HTTPClient.ContentEncodingModule"};
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                if (bl) {
                    this.removeModule(Class.forName(stringArray[i]));
                    continue;
                }
                this.addModule(Class.forName(stringArray[i]), -1);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    public static void setDefaultTimeout(int n) {
        DefaultTimeout = n;
    }

    public static int getDefaultTimeout() {
        return DefaultTimeout;
    }

    public void setTimeout(int n) {
        this.Timeout = n;
    }

    public int getTimeout() {
        return this.Timeout;
    }

    public void setAllowUserInteraction(boolean bl) {
        this.allowUI = bl;
    }

    public boolean getAllowUserInteraction() {
        return this.allowUI;
    }

    public static void setDefaultAllowUserInteraction(boolean bl) {
        defaultAllowUI = bl;
    }

    public static boolean getDefaultAllowUserInteraction() {
        return defaultAllowUI;
    }

    public static Class[] getDefaultModules() {
        return HTTPConnection.getModules(DefaultModuleList);
    }

    public static boolean addDefaultModule(Class clazz, int n) {
        return HTTPConnection.addModule(DefaultModuleList, clazz, n);
    }

    public static boolean removeDefaultModule(Class clazz) {
        return HTTPConnection.removeModule(DefaultModuleList, clazz);
    }

    public Class[] getModules() {
        return HTTPConnection.getModules(this.ModuleList);
    }

    public boolean addModule(Class clazz, int n) {
        return HTTPConnection.addModule(this.ModuleList, clazz, n);
    }

    public boolean removeModule(Class clazz) {
        return HTTPConnection.removeModule(this.ModuleList, clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Class[] getModules(Vector vector) {
        Vector vector2 = vector;
        synchronized (vector2) {
            Object[] objectArray = new Class[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean addModule(Vector vector, Class clazz, int n) {
        Object object;
        if (clazz == null) {
            return false;
        }
        try {
            object = (HTTPClientModule)clazz.newInstance();
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
        object = vector;
        synchronized (object) {
            if (vector.contains(clazz)) {
                return false;
            }
            if (n < 0) {
                vector.insertElementAt(clazz, DefaultModuleList.size() + n + 1);
            } else {
                vector.insertElementAt(clazz, n);
            }
        }
        Log.write(1, "Conn:  Added module " + clazz.getName() + " to " + (vector == DefaultModuleList ? "default " : "") + "list");
        return true;
    }

    private static final boolean removeModule(Vector vector, Class clazz) {
        if (clazz == null) {
            return false;
        }
        boolean bl = vector.removeElement(clazz);
        if (bl) {
            Log.write(1, "Conn:  Removed module " + clazz.getName() + " from " + (vector == DefaultModuleList ? "default " : "") + "list");
        }
        return bl;
    }

    public void setContext(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Context must be non-null");
        }
        if (this.Context != null) {
            throw new IllegalStateException("Context already set");
        }
        this.Context = object;
    }

    public Object getContext() {
        if (this.Context != null) {
            return this.Context;
        }
        return dflt_context;
    }

    public static Object getDefaultContext() {
        return dflt_context;
    }

    public void addDigestAuthorization(String string, String string2, String string3) {
        AuthorizationInfo.addDigestAuthorization(this.Host, this.Port, string, string2, string3, this.getContext());
    }

    public void addBasicAuthorization(String string, String string2, String string3) {
        AuthorizationInfo.addBasicAuthorization(this.Host, this.Port, string, string2, string3, this.getContext());
    }

    public static void setProxyServer(String string, int n) {
        if (string == null || string.trim().length() == 0) {
            Default_Proxy_Host = null;
        } else {
            Default_Proxy_Host = string.trim().toLowerCase();
            Default_Proxy_Port = n;
        }
    }

    public synchronized void setCurrentProxy(String string, int n) {
        if (string == null || string.trim().length() == 0) {
            this.Proxy_Host = null;
        } else {
            this.Proxy_Host = string.trim().toLowerCase();
            this.Proxy_Port = n <= 0 ? 80 : n;
        }
        switch (this.Protocol) {
            case 0: 
            case 1: {
                if (force_1_0) {
                    this.ServerProtocolVersion = 65536;
                    this.ServProtVersKnown = true;
                    this.RequestProtocolVersion = "HTTP/1.0";
                    break;
                }
                this.ServerProtocolVersion = 65537;
                this.ServProtVersKnown = false;
                this.RequestProtocolVersion = "HTTP/1.1";
                break;
            }
            case 3: {
                this.ServerProtocolVersion = -1;
                this.ServProtVersKnown = false;
                this.RequestProtocolVersion = "";
                break;
            }
            case 2: {
                this.ServerProtocolVersion = -1;
                this.ServProtVersKnown = false;
                this.RequestProtocolVersion = "Secure-HTTP/1.3";
                break;
            }
            default: {
                throw new Error("HTTPClient Internal Error: invalid protocol " + this.Protocol);
            }
        }
        this.keepAliveUnknown = true;
        this.doesKeepAlive = false;
        this.input_demux = null;
        this.early_stall = null;
        this.late_stall = null;
        this.prev_resp = null;
    }

    public static void dontProxyFor(String string) throws ParseException {
        int n;
        byte[] byArray;
        byte[] byArray2;
        if ((string = string.trim().toLowerCase()).charAt(0) == '.') {
            if (!non_proxy_dom_list.contains(string)) {
                non_proxy_dom_list.addElement(string);
            }
            return;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isDigit(string.charAt(i)) || string.charAt(i) == '.' || string.charAt(i) == '/') continue;
            non_proxy_host_list.put(string, "");
            return;
        }
        int n2 = string.indexOf(47);
        if (n2 != -1) {
            byArray2 = HTTPConnection.string2arr(string.substring(0, n2));
            if (byArray2.length != (byArray = HTTPConnection.string2arr(string.substring(n2 + 1))).length) {
                throw new ParseException("length of IP-address (" + byArray2.length + ") != length of netmask (" + byArray.length + ")");
            }
        } else {
            byArray2 = HTTPConnection.string2arr(string);
            byArray = new byte[byArray2.length];
            for (n = 0; n < byArray.length; ++n) {
                byArray[n] = -1;
            }
        }
        block2: for (n = 0; n < non_proxy_addr_list.size(); ++n) {
            byte[] byArray3 = (byte[])non_proxy_addr_list.elementAt(n);
            byte[] byArray4 = (byte[])non_proxy_mask_list.elementAt(n);
            if (byArray3.length != byArray2.length) continue;
            for (int i = 0; i < byArray3.length; ++i) {
                if ((byArray2[i] & byArray4[i]) != (byArray3[i] & byArray4[i]) || byArray4[i] != byArray[i]) continue block2;
            }
            return;
        }
        non_proxy_addr_list.addElement(byArray2);
        non_proxy_mask_list.addElement(byArray);
    }

    public static void dontProxyFor(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                if (stringArray[i] == null) continue;
                HTTPConnection.dontProxyFor(stringArray[i]);
                continue;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }

    public static boolean doProxyFor(String string) throws ParseException {
        int n;
        byte[] byArray;
        byte[] byArray2;
        if ((string = string.trim().toLowerCase()).charAt(0) == '.') {
            return non_proxy_dom_list.removeElement(string);
        }
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isDigit(string.charAt(i)) || string.charAt(i) == '.' || string.charAt(i) == '/') continue;
            return non_proxy_host_list.remove(string) != null;
        }
        int n2 = string.indexOf(47);
        if (n2 != -1) {
            byArray2 = HTTPConnection.string2arr(string.substring(0, n2));
            if (byArray2.length != (byArray = HTTPConnection.string2arr(string.substring(n2 + 1))).length) {
                throw new ParseException("length of IP-address (" + byArray2.length + ") != length of netmask (" + byArray.length + ")");
            }
        } else {
            byArray2 = HTTPConnection.string2arr(string);
            byArray = new byte[byArray2.length];
            for (n = 0; n < byArray.length; ++n) {
                byArray[n] = -1;
            }
        }
        block2: for (n = 0; n < non_proxy_addr_list.size(); ++n) {
            byte[] byArray3 = (byte[])non_proxy_addr_list.elementAt(n);
            byte[] byArray4 = (byte[])non_proxy_mask_list.elementAt(n);
            if (byArray3.length != byArray2.length) continue;
            for (int i = 0; i < byArray3.length; ++i) {
                if ((byArray2[i] & byArray4[i]) != (byArray3[i] & byArray4[i]) || byArray4[i] != byArray[i]) continue block2;
            }
            non_proxy_addr_list.removeElementAt(n);
            non_proxy_mask_list.removeElementAt(n);
            return true;
        }
        return false;
    }

    private static byte[] string2arr(String string) {
        int n;
        char[] cArray = new char[string.length()];
        string.getChars(0, cArray.length, cArray, 0);
        int n2 = 0;
        for (n = 0; n < cArray.length; ++n) {
            if (cArray[n] != '.') continue;
            ++n2;
        }
        byte[] byArray = new byte[n2 + 1];
        n2 = 0;
        n = 0;
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] != '.') continue;
            byArray[n2] = (byte)Integer.parseInt(string.substring(n, i));
            ++n2;
            n = i + 1;
        }
        byArray[n2] = (byte)Integer.parseInt(string.substring(n));
        return byArray;
    }

    public static void setSocksServer(String string) {
        HTTPConnection.setSocksServer(string, 1080);
    }

    public static void setSocksServer(String string, int n) {
        if (n <= 0) {
            n = 1080;
        }
        Default_Socks_client = string == null || string.length() == 0 ? null : new SocksClient(string, n);
    }

    public static void setSocksServer(String string, int n, int n2) throws SocksException {
        if (n <= 0) {
            n = 1080;
        }
        Default_Socks_client = string == null || string.length() == 0 ? null : new SocksClient(string, n, n2);
    }

    private final String stripRef(String string) {
        if (string == null) {
            return "";
        }
        int n = string.indexOf(35);
        if (n != -1) {
            string = string.substring(0, n);
        }
        return string.trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final HTTPResponse setupRequest(String string, String string2, NVPair[] nVPairArray, byte[] byArray, HttpOutputStream httpOutputStream) throws IOException, ModuleException {
        Request request = new Request(this, string, string2, this.mergedHeaders(nVPairArray), byArray, httpOutputStream, this.allowUI);
        this.RequestList.addToEnd(request);
        try {
            HTTPResponse hTTPResponse = new HTTPResponse(this.gen_mod_insts(), this.Timeout, request);
            hTTPResponse.setLogging(logging, logFilename);
            Codecs.setLogging(logging, logFilename);
            this.handleRequest(request, hTTPResponse, null, true);
            HTTPResponse hTTPResponse2 = hTTPResponse;
            return hTTPResponse2;
        }
        finally {
            this.RequestList.remove(request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NVPair[] mergedHeaders(NVPair[] nVPairArray) {
        int n = nVPairArray != null ? nVPairArray.length : 0;
        NVPair[] nVPairArray2 = this.DefaultHeaders;
        synchronized (this.DefaultHeaders) {
            int n2 = this.DefaultHeaders != null ? this.DefaultHeaders.length : 0;
            NVPair[] nVPairArray3 = new NVPair[n + n2];
            System.arraycopy(this.DefaultHeaders, 0, nVPairArray3, 0, n2);
            // ** MonitorExit[var5_3] (shouldn't be in output)
            int n3 = n2;
            for (int i = 0; i < n; ++i) {
                int n4;
                String string;
                if (nVPairArray[i] == null || (string = nVPairArray[i].getName().trim()).equalsIgnoreCase("Content-length")) continue;
                for (n4 = 0; n4 < n3 && !nVPairArray3[n4].getName().trim().equalsIgnoreCase(string); ++n4) {
                }
                nVPairArray3[n4] = nVPairArray[i];
                if (n4 != n3) continue;
                ++n3;
            }
            if (n3 < nVPairArray3.length) {
                nVPairArray3 = Util.resizeArray(nVPairArray3, n3);
            }
            return nVPairArray3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HTTPClientModule[] gen_mod_insts() {
        Vector vector = this.ModuleList;
        synchronized (vector) {
            HTTPClientModule[] hTTPClientModuleArray = new HTTPClientModule[this.ModuleList.size()];
            for (int i = 0; i < this.ModuleList.size(); ++i) {
                Class clazz = (Class)this.ModuleList.elementAt(i);
                try {
                    hTTPClientModuleArray[i] = (HTTPClientModule)clazz.newInstance();
                    continue;
                }
                catch (Exception exception) {
                    throw new Error("HTTPClient Internal Error: could not create instance of " + clazz.getName() + " -\n" + exception);
                }
            }
            return hTTPClientModuleArray;
        }
    }

    void handleRequest(Request request, HTTPResponse hTTPResponse, Response response, boolean bl) throws IOException, ModuleException {
        int n;
        Response[] responseArray = new Response[]{response};
        HTTPClientModule[] hTTPClientModuleArray = hTTPResponse.getModules();
        if (bl) {
            block10: for (n = 0; n < hTTPClientModuleArray.length; ++n) {
                int n2 = hTTPClientModuleArray[n].requestHandler(request, responseArray);
                switch (n2) {
                    case 0: {
                        continue block10;
                    }
                    case 1: {
                        n = -1;
                        continue block10;
                    }
                    case 2: {
                        break block10;
                    }
                    case 3: 
                    case 4: {
                        if (responseArray[0] == null) {
                            throw new Error("HTTPClient Internal Error: no response returned by module " + hTTPClientModuleArray[n].getClass().getName());
                        }
                        hTTPResponse.set(request, responseArray[0]);
                        if (request.getStream() != null) {
                            request.getStream().ignoreData(request);
                        }
                        if (request.internal_subrequest) {
                            return;
                        }
                        if (n2 == 3) {
                            hTTPResponse.handleResponse();
                        } else {
                            hTTPResponse.init(responseArray[0]);
                        }
                        return;
                    }
                    case 5: {
                        if (request.internal_subrequest) {
                            return;
                        }
                        request.getConnection().handleRequest(request, hTTPResponse, responseArray[0], true);
                        return;
                    }
                    case 6: {
                        if (request.internal_subrequest) {
                            return;
                        }
                        request.getConnection().handleRequest(request, hTTPResponse, responseArray[0], false);
                        return;
                    }
                    default: {
                        throw new Error("HTTPClient Internal Error: invalid status " + n2 + " returned by module " + hTTPClientModuleArray[n].getClass().getName());
                    }
                }
            }
        }
        if (request.internal_subrequest) {
            return;
        }
        if (request.getStream() != null && request.getStream().getLength() == -1L) {
            if (!this.ServProtVersKnown || this.ServerProtocolVersion < 65537 || no_chunked) {
                request.getStream().goAhead(request, null, hTTPResponse.getTimeout());
                hTTPResponse.set(request, request.getStream());
            } else {
                NVPair[] nVPairArray = request.getHeaders();
                for (n = 0; n < nVPairArray.length && !nVPairArray[n].getName().equalsIgnoreCase("Transfer-Encoding"); ++n) {
                }
                if (n == nVPairArray.length) {
                    nVPairArray = Util.resizeArray(nVPairArray, n + 1);
                    nVPairArray[n] = new NVPair("Transfer-Encoding", "chunked");
                    request.setHeaders(nVPairArray);
                } else {
                    String string = nVPairArray[n].getValue();
                    try {
                        if (!Util.hasToken(string, "chunked")) {
                            nVPairArray[n] = new NVPair("Transfer-Encoding", string + ", chunked");
                        }
                    }
                    catch (ParseException parseException) {
                        throw new IOException(parseException.toString());
                    }
                }
                hTTPResponse.set(request, this.sendRequest(request, hTTPResponse.getTimeout()));
            }
        } else {
            hTTPResponse.set(request, this.sendRequest(request, hTTPResponse.getTimeout()));
        }
        if (request.aborted) {
            throw new IOException("Request aborted by user");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Response sendRequest(Request request, int n) throws IOException, ModuleException {
        boolean bl;
        Object object;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(600);
        Response response = null;
        if (this.early_stall != null) {
            try {
                Log.write(1, "Conn:  Early-stalling Request: " + request.getMethod() + " " + request.getRequestURI());
                object = this.early_stall;
                synchronized (object) {
                    try {
                        this.early_stall.getVersion();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.early_stall = null;
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        object = this.assembleHeaders(request, byteArrayOutputStream);
        try {
            bl = this.ServerProtocolVersion >= 65537 && !Util.hasToken(object[0], "close") || this.ServerProtocolVersion == 65536 && Util.hasToken(object[0], "keep-alive");
        }
        catch (ParseException parseException) {
            throw new IOException(parseException.toString());
        }
        HTTPConnection hTTPConnection = this;
        synchronized (hTTPConnection) {
            if (this.late_stall != null) {
                if (this.input_demux != null || this.keepAliveUnknown) {
                    Log.write(1, "Conn:  Stalling Request: " + request.getMethod() + " " + request.getRequestURI());
                    try {
                        this.late_stall.getVersion();
                        if (this.keepAliveUnknown) {
                            this.determineKeepAlive(this.late_stall);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                this.late_stall = null;
            }
            if ((request.getMethod().equals("POST") || request.dont_pipeline) && this.prev_resp != null && this.input_demux != null) {
                Log.write(1, "Conn:  Stalling Request: " + request.getMethod() + " " + request.getRequestURI());
                try {
                    this.prev_resp.getVersion();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (!this.output_finished) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    throw new IOException(interruptedException.toString());
                }
            }
            if (request.aborted) {
                throw new IOException("Request aborted by user");
            }
            int n2 = 3;
            while (n2-- > 0) {
                try {
                    Object object2;
                    Object object3;
                    if (this.input_demux == null || (object3 = this.input_demux.getSocket()) == null) {
                        object3 = this.getSocket(n);
                        if (this.Protocol == 1) {
                            if (this.Proxy_Host != null) {
                                object2 = new Socket[]{object3};
                                response = this.enableSSLTunneling((Socket[])object2, request, n);
                                if (response != null) {
                                    response.final_resp = true;
                                    return response;
                                }
                                object3 = object2[0];
                            }
                            ((Socket)object3).setSoTimeout(n);
                            if (JSSE) {
                                try {
                                    object3 = ((SSLSocketFactory)this.sslFactory).createSocket((Socket)object3, this.Host, this.Port, true);
                                    HTTPConnection.checkCert(((SSLSocket)object3).getSession().getPeerCertificateChain()[0], this.Host, this.allowAnyHostname);
                                }
                                catch (NoClassDefFoundError noClassDefFoundError) {
                                    throw new IOException(noClassDefFoundError.getMessage());
                                }
                            } else {
                                throw new IOException("SSL support not active");
                            }
                        }
                        this.input_demux = new StreamDemultiplexor(this.Protocol, (Socket)object3, this);
                        this.DemuxList.addToEnd(this.input_demux);
                        this.keepAliveReqLeft = this.keepAliveReqMax;
                    }
                    if (request.aborted) {
                        throw new IOException("Request aborted by user");
                    }
                    Log.write(1, "Conn:  Sending Request: ", byteArrayOutputStream);
                    if (logging) {
                        try {
                            object2 = new FileOutputStream(logFilename, true);
                            ((FileOutputStream)object2).write(outboundHeader.getBytes());
                            byteArrayOutputStream.writeTo((OutputStream)object2);
                            ((FileOutputStream)object2).close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    object2 = new BufferedOutputStream(((Socket)object3).getOutputStream());
                    if (haveMSLargeWritesBug) {
                        object2 = new MSLargeWritesBugStream((OutputStream)object2);
                    }
                    byteArrayOutputStream.writeTo((OutputStream)object2);
                    try {
                        if (this.ServProtVersKnown && this.ServerProtocolVersion >= 65537 && Util.hasToken(object[1], "100-continue")) {
                            response = new Response(request, this.Proxy_Host != null && this.Protocol != 1, this.input_demux);
                            response.setLogging(logging, logFilename);
                            response.timeout = 60;
                            if (response.getContinue() != 100) {
                                break;
                            }
                        }
                    }
                    catch (ParseException parseException) {
                        throw new IOException(parseException.toString());
                    }
                    catch (InterruptedIOException interruptedIOException) {
                    }
                    finally {
                        if (response != null) {
                            response.timeout = 0;
                        }
                    }
                    if (request.getData() != null && request.getData().length > 0) {
                        if (request.delay_entity > 0L) {
                            long l = request.delay_entity / 100L;
                            long l2 = request.delay_entity / l;
                            int n3 = 0;
                            while ((long)n3 < l && this.input_demux.available(null) == 0) {
                                try {
                                    Thread.sleep(l2);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                                ++n3;
                            }
                            if (this.input_demux.available(null) == 0) {
                                int n4 = 0;
                                int n5 = 4096;
                                byte[] byArray = request.getData();
                                if (n4 + n5 > byArray.length) {
                                    n5 = byArray.length;
                                }
                                while (n4 < byArray.length) {
                                    ((OutputStream)object2).write(byArray, n4, n5);
                                    ProgressObserver.getInstance().fireProgressEvent(n4 += n5, byArray.length, request.getMethod());
                                    if (n4 + n5 <= byArray.length) continue;
                                    n5 = byArray.length - n4;
                                }
                                ProgressObserver.getInstance().fireProgressEvent(n4, n4, request.getMethod());
                            } else {
                                bl = false;
                            }
                        } else {
                            int n6 = 0;
                            int n7 = 4096;
                            byte[] byArray = request.getData();
                            if (n6 + n7 > byArray.length) {
                                n7 = byArray.length;
                            }
                            while (n6 < byArray.length) {
                                ((OutputStream)object2).write(byArray, n6, n7);
                                ProgressObserver.getInstance().fireProgressEvent(n6 += n7, byArray.length, request.getMethod());
                                if (n6 + n7 <= byArray.length) continue;
                                n7 = byArray.length - n6;
                            }
                            ProgressObserver.getInstance().fireProgressEvent(n6, n6, request.getMethod());
                        }
                        if (logging && request.getData() != null && request.getData().length > 0) {
                            try {
                                FileOutputStream fileOutputStream = new FileOutputStream(logFilename, true);
                                fileOutputStream.write(request.getData());
                                fileOutputStream.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }
                    if (request.getStream() != null) {
                        request.getStream().setLogging(logging, logFilename);
                        request.getStream().goAhead(request, (OutputStream)object2, 0);
                    } else {
                        ((OutputStream)object2).flush();
                    }
                    if (response != null) break;
                    response = new Response(request, this.Proxy_Host != null && this.Protocol != 1, this.input_demux);
                    response.setLogging(logging, logFilename);
                    break;
                }
                catch (IOException iOException) {
                    Log.write(1, "Conn:  ", iOException);
                    this.closeDemux(iOException, true);
                    if (n2 == 0 || iOException instanceof UnknownHostException || iOException instanceof ConnectException || iOException instanceof NoRouteToHostException || iOException instanceof InterruptedIOException || request.aborted) {
                        throw iOException;
                    }
                    Log.write(1, "Conn:  Retrying request");
                }
            }
            this.prev_resp = response;
            if (!this.keepAliveUnknown && !this.doesKeepAlive || !bl || this.keepAliveReqMax != -1 && this.keepAliveReqLeft-- == 0) {
                this.input_demux.markForClose(response);
                this.input_demux = null;
            } else {
                this.input_demux.restartTimer();
            }
            if (this.keepAliveReqMax != -1) {
                Log.write(1, "Conn:  Number of requests left: " + this.keepAliveReqLeft);
            }
            if (!this.ServProtVersKnown) {
                this.early_stall = response;
                response.markAsFirstResponse(request);
            }
            if (this.keepAliveUnknown || !IdempotentSequence.methodIsIdempotent(request.getMethod()) || request.dont_pipeline || neverPipeline) {
                this.late_stall = response;
            }
            if (request.getStream() != null) {
                this.output_finished = false;
            } else {
                this.output_finished = true;
                this.notify();
            }
            Log.write(1, "Conn:  Request sent");
        }
        return response;
    }

    private Socket getSocket(int n) throws IOException {
        int n2;
        String string;
        Socket socket = null;
        if (this.Proxy_Host != null) {
            string = this.Proxy_Host;
            n2 = this.Proxy_Port;
        } else {
            string = this.Host;
            n2 = this.Port;
        }
        Log.write(1, "Conn:  Creating Socket: " + string + ":" + n2);
        if (n == 0) {
            if (this.Socks_client != null) {
                socket = this.Socks_client.getSocket(string, n2);
            } else {
                InetAddress[] inetAddressArray = InetAddress.getAllByName(string);
                for (int i = 0; i < inetAddressArray.length; ++i) {
                    try {
                        socket = this.LocalAddr == null ? new Socket(inetAddressArray[i], n2) : new Socket(inetAddressArray[i], n2, this.LocalAddr, this.LocalPort);
                        break;
                    }
                    catch (SocketException socketException) {
                        if (i != inetAddressArray.length - 1) continue;
                        throw socketException;
                    }
                }
            }
        } else {
            EstablishConnection establishConnection = new EstablishConnection(string, n2, this.Socks_client);
            establishConnection.start();
            try {
                establishConnection.join(n);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (establishConnection.getException() != null) {
                throw establishConnection.getException();
            }
            socket = establishConnection.getSocket();
            if (socket == null) {
                establishConnection.forget();
                socket = establishConnection.getSocket();
                if (socket == null) {
                    throw new InterruptedIOException("Connection establishment timed out");
                }
            }
        }
        return socket;
    }

    private Response enableSSLTunneling(Socket[] socketArray, Request request, int n) throws IOException, ModuleException {
        Object object;
        Vector<NVPair> vector = new Vector<NVPair>();
        for (int i = 0; i < request.getHeaders().length; ++i) {
            object = request.getHeaders()[i].getName();
            if (!((String)object).equalsIgnoreCase("User-Agent") && !((String)object).equalsIgnoreCase("Proxy-Authorization")) continue;
            vector.addElement(request.getHeaders()[i]);
        }
        Object[] objectArray = new NVPair[vector.size()];
        vector.copyInto(objectArray);
        object = new Request(this, "CONNECT", this.Host + ":" + this.Port, (NVPair[])objectArray, null, null, request.allowUI());
        ((Request)object).internal_subrequest = true;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(600);
        HTTPResponse hTTPResponse = new HTTPResponse(this.gen_mod_insts(), n, (Request)object);
        hTTPResponse.setLogging(logging, logFilename);
        Response response = null;
        while (true) {
            this.handleRequest((Request)object, hTTPResponse, response, true);
            byteArrayOutputStream.reset();
            this.assembleHeaders((Request)object, byteArrayOutputStream);
            Log.write(1, "Conn:  Sending SSL-Tunneling Subrequest: ", byteArrayOutputStream);
            byteArrayOutputStream.writeTo(socketArray[0].getOutputStream());
            response = new Response((Request)object, socketArray[0].getInputStream());
            response.setLogging(logging, logFilename);
            if (response.getStatusCode() == 200) {
                return null;
            }
            try {
                response.getData();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                socketArray[0].close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            hTTPResponse.set((Request)object, response);
            if (!hTTPResponse.handleResponse()) {
                return response;
            }
            socketArray[0] = this.getSocket(n);
        }
    }

    private static void checkCert(X509Certificate x509Certificate, String string, boolean bl) throws IOException {
        if (JSSE) {
            String string2;
            try {
                string2 = ((X500Name)x509Certificate.getSubjectDN()).getCommonName().toLowerCase();
            }
            catch (Throwable throwable) {
                return;
            }
            if (Util.wildcardMatch(string2, string)) {
                return;
            }
            if (bl) {
                return;
            }
            Object var4_5 = null;
            try {
                Class<?> clazz = Class.forName("javax.net.ssl.SSLException");
                Class[] classArray = new Class[]{Class.forName("java.lang.String")};
                Constructor<?> constructor = clazz.getConstructor(classArray);
                Object[] objectArray = new String[]{"Name in certificate `" + string2 + "' does not " + "match host name `" + string + "'"};
                var4_5 = constructor.newInstance(objectArray);
            }
            catch (Throwable throwable) {
                JSSE = false;
                throw new IOException("SSL support not enabled.");
            }
            if (var4_5 != null) {
                throw (IOException)var4_5;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private String[] assembleHeaders(Request var1_1, ByteArrayOutputStream var2_2) throws IOException {
        var3_3 = new DataOutputStream(var2_2);
        var4_4 = new String[]{"", ""};
        var5_5 = var1_1.getHeaders();
        var6_6 = -1;
        var7_7 = -1;
        var8_8 = -1;
        var9_9 = -1;
        var10_10 = -1;
        var11_11 = -1;
        var12_12 = -1;
        var13_13 = -1;
        var14_14 = -1;
        var15_15 = -1;
        for (var16_16 = 0; var16_16 < var5_5.length; ++var16_16) {
            var17_18 = var5_5[var16_16].getName().trim().toLowerCase();
            if (var17_18.equals("host")) {
                var6_6 = var16_16;
                continue;
            }
            if (var17_18.equals("content-type")) {
                var7_7 = var16_16;
                continue;
            }
            if (var17_18.equals("user-agent")) {
                var8_8 = var16_16;
                continue;
            }
            if (var17_18.equals("connection")) {
                var9_9 = var16_16;
                continue;
            }
            if (var17_18.equals("proxy-connection")) {
                var10_10 = var16_16;
                continue;
            }
            if (var17_18.equals("keep-alive")) {
                var11_11 = var16_16;
                continue;
            }
            if (var17_18.equals("expect")) {
                var12_12 = var16_16;
                continue;
            }
            if (var17_18.equals("te")) {
                var13_13 = var16_16;
                continue;
            }
            if (var17_18.equals("transfer-encoding")) {
                var14_14 = var16_16;
                continue;
            }
            if (!var17_18.equals("upgrade")) continue;
            var15_15 = var16_16;
        }
        var16_17 = Util.escapeUnsafeChars(var1_1.getRequestURI());
        if (this.Proxy_Host != null && this.Protocol != 1 && !var16_17.equals("*")) {
            var3_3.writeBytes(var1_1.getMethod() + " http://" + this.Host + ":" + this.Port + var16_17 + " " + this.RequestProtocolVersion + "\r\n");
        } else {
            var3_3.writeBytes(var1_1.getMethod() + " " + var16_17 + " " + this.RequestProtocolVersion + "\r\n");
        }
        v0 = var17_18 = var6_6 >= 0 ? var5_5[var6_6].getValue().trim() : this.Host;
        if (this.Port != URI.defaultPort(this.getProtocol()) && var17_18.indexOf(":") == -1) {
            var3_3.writeBytes("Host: " + var17_18 + ":" + this.Port + "\r\n");
        } else {
            var3_3.writeBytes("Host: " + var17_18 + "\r\n");
        }
        var18_19 = null;
        if (!this.ServProtVersKnown || this.ServerProtocolVersion < 65537 || var9_9 != -1) {
            if (var9_9 == -1) {
                var18_19 = "Keep-Alive";
                var4_4[0] = "Keep-Alive";
            } else {
                var4_4[0] = var5_5[var9_9].getValue().trim();
                var18_19 = var4_4[0];
            }
            try {
                if (var11_11 != -1 && Util.hasToken(var4_4[0], "keep-alive")) {
                    var3_3.writeBytes("Keep-Alive: " + var5_5[var11_11].getValue().trim() + "\r\n");
                }
            }
            catch (ParseException var19_20) {
                throw new IOException(var19_20.toString());
            }
        }
        if (!(this.Proxy_Host == null || this.Protocol == 1 || this.ServProtVersKnown && this.ServerProtocolVersion >= 65537 || var18_19 == null)) {
            var3_3.writeBytes("Proxy-Connection: ");
            var3_3.writeBytes(var18_19);
            var3_3.writeBytes("\r\n");
            var18_19 = null;
        }
        if (var18_19 != null) {
            try {
                if (Util.hasToken(var18_19, "TE")) ** GOTO lbl83
                var18_19 = var18_19 + ", TE";
            }
            catch (ParseException var19_21) {
                throw new IOException(var19_21.toString());
            }
        } else {
            var18_19 = "TE";
        }
lbl83:
        // 3 sources

        if (var15_15 != -1) {
            var18_19 = var18_19 + ", Upgrade";
        }
        if (var18_19 != null) {
            var3_3.writeBytes("Connection: ");
            var3_3.writeBytes(var18_19);
            var3_3.writeBytes("\r\n");
        }
        if (var13_13 != -1) {
            var3_3.writeBytes("TE: ");
            try {
                var19_22 = Util.parseHeader(var5_5[var13_13].getValue());
            }
            catch (ParseException var20_25) {
                throw new IOException(var20_25.toString());
            }
            if (!var19_22.contains(new HttpHeaderElement("trailers"))) {
                var3_3.writeBytes("trailers, ");
            }
            var3_3.writeBytes(var5_5[var13_13].getValue().trim() + "\r\n");
        } else {
            var3_3.writeBytes("TE: trailers\r\n");
        }
        if (var8_8 != -1) {
            var3_3.writeBytes("User-Agent: " + var5_5[var8_8].getValue().trim() + " " + "RPT-HTTPClient/0.3-3E" + "\r\n");
        } else {
            var3_3.writeBytes("User-Agent: RPT-HTTPClient/0.3-3E\r\n");
        }
        for (var19_23 = 0; var19_23 < var5_5.length; ++var19_23) {
            if (var19_23 == var7_7 || var19_23 == var8_8 || var19_23 == var9_9 || var19_23 == var10_10 || var19_23 == var11_11 || var19_23 == var12_12 || var19_23 == var13_13 || var19_23 == var6_6) continue;
            var3_3.writeBytes(var5_5[var19_23].getName().trim() + ": " + var5_5[var19_23].getValue().trim() + "\r\n");
        }
        if (var1_1.getData() != null || var1_1.getStream() != null) {
            var3_3.writeBytes("Content-type: ");
            if (var7_7 != -1) {
                var3_3.writeBytes(var5_5[var7_7].getValue().trim());
            } else {
                var3_3.writeBytes("application/octet-stream");
            }
            var3_3.writeBytes("\r\n");
            if (var1_1.getData() != null) {
                var3_3.writeBytes("Content-length: " + var1_1.getData().length + "\r\n");
            } else if (var1_1.getStream().getLength() != -1L && var14_14 == -1) {
                var3_3.writeBytes("Content-length: " + var1_1.getStream().getLength() + "\r\n");
            }
            if (var12_12 != -1) {
                var4_4[1] = var5_5[var12_12].getValue().trim();
                var3_3.writeBytes("Expect: " + var4_4[1] + "\r\n");
            }
        } else if (var12_12 != -1) {
            try {
                var19_24 = Util.parseHeader(var5_5[var12_12].getValue());
            }
            catch (ParseException var20_26) {
                throw new IOException(var20_26.toString());
            }
            var20_27 = new HttpHeaderElement("100-continue");
            while (var19_24.removeElement(var20_27)) {
            }
            if (!var19_24.isEmpty()) {
                var4_4[1] = Util.assembleHeader(var19_24);
                var3_3.writeBytes("Expect: " + var4_4[1] + "\r\n");
            }
        }
        var3_3.writeBytes("\r\n");
        return var4_4;
    }

    boolean handleFirstRequest(Request request, Response response) throws IOException {
        this.ServerProtocolVersion = HTTPConnection.String2ProtVers(response.getVersion());
        this.ServProtVersKnown = true;
        int n = response.getStatusCode();
        if (this.Proxy_Host != null && this.Protocol != 1 && response.getHeader("Via") == null && n != 407 && n != 502 && n != 504) {
            this.ServerProtocolVersion = 65536;
        }
        Log.write(1, "Conn:  Protocol Version established: " + HTTPConnection.ProtVers2String(this.ServerProtocolVersion));
        if (this.ServerProtocolVersion == 65536 && (response.getStatusCode() == 400 || response.getStatusCode() == 500)) {
            if (this.input_demux != null) {
                this.input_demux.markForClose(response);
            }
            this.input_demux = null;
            this.RequestProtocolVersion = "HTTP/1.0";
            return false;
        }
        return true;
    }

    private void determineKeepAlive(Response response) throws IOException {
        try {
            HttpHeaderElement httpHeaderElement;
            String string;
            if (this.ServerProtocolVersion >= 65537 || ((this.Proxy_Host == null || this.Protocol == 1) && (string = response.getHeader("Connection")) != null || this.Proxy_Host != null && this.Protocol != 1 && (string = response.getHeader("Proxy-Connection")) != null) && Util.hasToken(string, "keep-alive")) {
                this.doesKeepAlive = true;
                this.keepAliveUnknown = false;
                Log.write(1, "Conn:  Keep-Alive enabled");
            } else if (response.getStatusCode() < 400) {
                this.keepAliveUnknown = false;
            }
            if (this.doesKeepAlive && this.ServerProtocolVersion == 65536 && (string = response.getHeader("Keep-Alive")) != null && (httpHeaderElement = Util.getElement(Util.parseHeader(string), "max")) != null && httpHeaderElement.getValue() != null) {
                this.keepAliveReqLeft = this.keepAliveReqMax = Integer.parseInt(httpHeaderElement.getValue());
                Log.write(1, "Conn:  Max Keep-Alive requests: " + this.keepAliveReqMax);
            }
        }
        catch (ParseException parseException) {
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    synchronized void outputFinished() {
        this.output_finished = true;
        this.notify();
    }

    synchronized void closeDemux(IOException iOException, boolean bl) {
        if (this.input_demux != null) {
            this.input_demux.close(iOException, bl);
        }
        this.early_stall = null;
        this.late_stall = null;
        this.prev_resp = null;
    }

    static final String ProtVers2String(int n) {
        return "HTTP/" + (n >>> 16) + "." + (n & 0xFFFF);
    }

    static final int String2ProtVers(String string) {
        String string2 = string.substring(5);
        int n = string2.indexOf(46);
        return Integer.parseInt(string2.substring(0, n)) << 16 | Integer.parseInt(string2.substring(n + 1));
    }

    public String toString() {
        return this.getProtocol() + "://" + this.getHost() + (this.getPort() != URI.defaultPort(this.getProtocol()) ? ":" + this.getPort() : "");
    }

    public void setLogging(boolean bl, String string) {
        logging = bl;
        logFilename = string;
    }

    public boolean getLogging() {
        return logging;
    }

    public String getLogFilename() {
        return logFilename;
    }

    static {
        int n;
        String string;
        dflt_context = new Object();
        Default_Proxy_Host = null;
        non_proxy_host_list = new CIHashtable();
        non_proxy_dom_list = new Vector();
        non_proxy_addr_list = new Vector();
        non_proxy_mask_list = new Vector();
        Default_Socks_client = null;
        no_chunked = false;
        force_1_0 = false;
        neverPipeline = false;
        noKeepAlives = false;
        haveMSLargeWritesBug = false;
        deferStreamed = false;
        DefaultTimeout = 0;
        defaultAllowUI = true;
        logging = false;
        logFilename = null;
        outboundHeader = "\r\n========= Outbound Message =========\r\n";
        JSSE = true;
        try {
            string = System.getProperty("http.proxyHost");
            if (string == null) {
                throw new Exception();
            }
            int n2 = Integer.getInteger("http.proxyPort", -1);
            Log.write(1, "Conn:  using proxy " + string + ":" + n2);
            HTTPConnection.setProxyServer(string, n2);
        }
        catch (Exception exception) {
            try {
                if (Boolean.getBoolean("proxySet")) {
                    String string2 = System.getProperty("proxyHost");
                    n = Integer.getInteger("proxyPort", -1);
                    Log.write(1, "Conn:  using proxy " + string2 + ":" + n);
                    HTTPConnection.setProxyServer(string2, n);
                }
            }
            catch (Exception exception2) {
                Default_Proxy_Host = null;
            }
        }
        try {
            string = System.getProperty("HTTPClient.nonProxyHosts");
            if (string == null) {
                string = System.getProperty("http.nonProxyHosts");
            }
            String[] stringArray = Util.splitProperty(string);
            HTTPConnection.dontProxyFor(stringArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            string = System.getProperty("HTTPClient.socksHost");
            if (string != null && string.length() > 0) {
                int n3 = Integer.getInteger("HTTPClient.socksPort", -1);
                n = Integer.getInteger("HTTPClient.socksVersion", -1);
                Log.write(1, "Conn:  using SOCKS " + string + ":" + n3);
                if (n == -1) {
                    HTTPConnection.setSocksServer(string, n3);
                } else {
                    HTTPConnection.setSocksServer(string, n3, n);
                }
            }
        }
        catch (Exception exception) {
            Default_Socks_client = null;
        }
        string = "HTTPClient.RetryModule|HTTPClient.CookieModule|HTTPClient.RedirectionModule|HTTPClient.AuthorizationModule|HTTPClient.DefaultModule|HTTPClient.TransferEncodingModule|HTTPClient.ContentMD5Module|HTTPClient.ContentEncodingModule";
        boolean bl = false;
        try {
            string = System.getProperty("HTTPClient.Modules", string);
        }
        catch (SecurityException securityException) {
            bl = true;
        }
        DefaultModuleList = new Vector();
        String[] stringArray = Util.splitProperty(string);
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                DefaultModuleList.addElement(Class.forName(stringArray[i]));
                Log.write(1, "Conn:  added module " + stringArray[i]);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (bl) continue;
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        try {
            neverPipeline = Boolean.getBoolean("HTTPClient.disable_pipelining");
            if (neverPipeline) {
                Log.write(1, "Conn:  disabling pipelining");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            noKeepAlives = Boolean.getBoolean("HTTPClient.disableKeepAlives");
            if (noKeepAlives) {
                Log.write(1, "Conn:  disabling keep-alives");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            force_1_0 = Boolean.getBoolean("HTTPClient.forceHTTP_1.0");
            if (force_1_0) {
                Log.write(1, "Conn:  forcing HTTP/1.0 requests");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            no_chunked = Boolean.getBoolean("HTTPClient.dontChunkRequests");
            if (no_chunked) {
                Log.write(1, "Conn:  never chunking requests");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (System.getProperty("os.name").indexOf("Windows") >= 0 && System.getProperty("java.version").startsWith("1.1")) {
                haveMSLargeWritesBug = true;
            }
            if (haveMSLargeWritesBug) {
                Log.write(1, "Conn:  splitting large writes into 20K chunks (M$ bug)");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            deferStreamed = Boolean.getBoolean("HTTPClient.deferStreamed");
            if (deferStreamed) {
                Log.write(1, "Conn:  enabling defered handling of responses to streamed requests");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class MSLargeWritesBugStream
    extends FilterOutputStream {
        private final int CHUNK_SIZE = 20000;

        MSLargeWritesBugStream(OutputStream outputStream) {
            super(outputStream);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            while (n2 > 20000) {
                this.out.write(byArray, n, 20000);
                n += 20000;
                n2 -= 20000;
            }
            this.out.write(byArray, n, n2);
        }
    }

    private class EstablishConnection
    extends Thread {
        String actual_host;
        int actual_port;
        IOException exception;
        Socket sock;
        SocksClient Socks_client;
        boolean close;

        EstablishConnection(String string, int n, SocksClient socksClient) {
            super("EstablishConnection (" + string + ":" + n + ")");
            try {
                this.setDaemon(true);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            this.actual_host = string;
            this.actual_port = n;
            this.Socks_client = socksClient;
            this.exception = null;
            this.sock = null;
            this.close = false;
        }

        public void run() {
            block9: {
                try {
                    if (this.Socks_client != null) {
                        this.sock = this.Socks_client.getSocket(this.actual_host, this.actual_port);
                        break block9;
                    }
                    InetAddress[] inetAddressArray = InetAddress.getAllByName(this.actual_host);
                    for (int i = 0; i < inetAddressArray.length; ++i) {
                        try {
                            this.sock = HTTPConnection.this.LocalAddr == null ? new Socket(inetAddressArray[i], this.actual_port) : new Socket(inetAddressArray[i], this.actual_port, HTTPConnection.this.LocalAddr, HTTPConnection.this.LocalPort);
                            break;
                        }
                        catch (SocketException socketException) {
                            if (i != inetAddressArray.length - 1 && !this.close) continue;
                            throw socketException;
                        }
                    }
                }
                catch (IOException iOException) {
                    this.exception = iOException;
                }
            }
            if (this.close && this.sock != null) {
                try {
                    this.sock.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.sock = null;
            }
        }

        IOException getException() {
            return this.exception;
        }

        Socket getSocket() {
            return this.sock;
        }

        void forget() {
            this.close = true;
        }
    }
}

