/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.CIHashtable;
import HTTPClient.GlobalConstants;
import HTTPClient.HTTPConnection;
import HTTPClient.HTTPResponse;
import HTTPClient.HttpHeaderElement;
import HTTPClient.Log;
import HTTPClient.ModuleException;
import HTTPClient.NVPair;
import HTTPClient.ParseException;
import HTTPClient.Request;
import HTTPClient.RespInputStream;
import HTTPClient.RoResponse;
import HTTPClient.StreamDemultiplexor;
import HTTPClient.URI;
import HTTPClient.Util;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.SequenceInputStream;
import java.io.UnsupportedEncodingException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.Date;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public final class Response
implements RoResponse,
GlobalConstants,
Cloneable {
    private static final Hashtable singleValueHeaders;
    private HTTPConnection connection;
    private StreamDemultiplexor stream_handler;
    HTTPResponse http_resp;
    int timeout = 0;
    public InputStream inp_stream;
    private RespInputStream resp_inp_stream = null;
    private String method;
    String resource;
    private boolean used_proxy;
    private boolean sent_entity;
    int StatusCode = 0;
    String ReasonLine;
    String Version;
    URI EffectiveURI = null;
    CIHashtable Headers = new CIHashtable();
    CIHashtable Trailers = new CIHashtable();
    int ContentLength = -1;
    int cd_type = 1;
    byte[] Data = null;
    boolean reading_headers = false;
    boolean got_headers = false;
    boolean got_trailers = false;
    private IOException exception = null;
    boolean final_resp = false;
    boolean retry = false;
    private boolean logging = false;
    private String logFilename = null;
    private static String inboundHeader;
    private byte[] buf = new byte[7];
    private int buf_pos = 0;
    private StringBuffer hdrs = new StringBuffer(400);
    private boolean reading_lines = false;
    private boolean bol = true;
    private boolean got_cr = false;
    boolean trailers_read = false;
    Request req = null;
    boolean isFirstResponse = false;

    Response(Request request, boolean bl, StreamDemultiplexor streamDemultiplexor) throws IOException {
        this.connection = request.getConnection();
        this.method = request.getMethod();
        this.resource = request.getRequestURI();
        this.used_proxy = bl;
        this.stream_handler = streamDemultiplexor;
        this.sent_entity = request.getData() != null;
        streamDemultiplexor.register(this, request);
        this.resp_inp_stream = streamDemultiplexor.getStream(this);
        this.inp_stream = this.resp_inp_stream;
    }

    Response(Request request, InputStream inputStream) throws IOException {
        this.connection = request.getConnection();
        this.method = request.getMethod();
        this.resource = request.getRequestURI();
        this.used_proxy = false;
        this.stream_handler = null;
        this.sent_entity = request.getData() != null;
        this.inp_stream = inputStream;
    }

    public Response(String string, int n, String string2, NVPair[] nVPairArray, byte[] byArray, InputStream inputStream, int n2) {
        this.Version = string;
        this.StatusCode = n;
        this.ReasonLine = string2;
        if (nVPairArray != null) {
            for (int i = 0; i < nVPairArray.length; ++i) {
                this.setHeader(nVPairArray[i].getName(), nVPairArray[i].getValue());
            }
        }
        if (byArray != null) {
            this.Data = byArray;
        } else if (inputStream == null) {
            this.Data = new byte[0];
        } else {
            this.inp_stream = inputStream;
            this.ContentLength = n2;
        }
        this.got_headers = true;
        this.got_trailers = true;
    }

    public final int getStatusCode() throws IOException {
        if (!this.got_headers) {
            this.getHeaders(true);
        }
        return this.StatusCode;
    }

    public final String getReasonLine() throws IOException {
        if (!this.got_headers) {
            this.getHeaders(true);
        }
        return this.ReasonLine;
    }

    public final String getVersion() throws IOException {
        if (!this.got_headers) {
            this.getHeaders(true);
        }
        return this.Version;
    }

    int getContinue() throws IOException {
        this.getHeaders(false);
        return this.StatusCode;
    }

    public final URI getEffectiveURI() throws IOException {
        if (!this.got_headers) {
            this.getHeaders(true);
        }
        return this.EffectiveURI;
    }

    public void setEffectiveURI(URI uRI) {
        this.EffectiveURI = uRI;
    }

    public final URL getEffectiveURL() throws IOException {
        return this.getEffectiveURI().toURL();
    }

    public void setEffectiveURL(URL uRL) {
        try {
            this.setEffectiveURI(new URI(uRL));
        }
        catch (ParseException parseException) {
            throw new Error(parseException.toString());
        }
    }

    public String getHeader(String string) throws IOException {
        if (!this.got_headers) {
            this.getHeaders(true);
        }
        return (String)this.Headers.get(string.trim());
    }

    public int getHeaderAsInt(String string) throws IOException, NumberFormatException {
        String string2 = this.getHeader(string);
        if (string2 == null) {
            throw new NumberFormatException("null");
        }
        return Integer.parseInt(string2);
    }

    public Date getHeaderAsDate(String string) throws IOException, IllegalArgumentException {
        Date date;
        String string2 = this.getHeader(string);
        if (string2 == null) {
            return null;
        }
        if (string2.toUpperCase().indexOf("GMT") == -1 && string2.indexOf(32) > 0) {
            string2 = string2 + " GMT";
        }
        try {
            date = Util.parseHttpDate(string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            long l;
            try {
                l = Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw illegalArgumentException;
            }
            if (l < 0L) {
                l = 0L;
            }
            date = new Date(l * 1000L);
        }
        return date;
    }

    public void setHeader(String string, String string2) {
        this.Headers.put(string.trim(), string2.trim());
    }

    public void deleteHeader(String string) {
        this.Headers.remove(string.trim());
    }

    public String getTrailer(String string) throws IOException {
        if (!this.got_trailers) {
            this.getTrailers();
        }
        return (String)this.Trailers.get(string.trim());
    }

    public int getTrailerAsInt(String string) throws IOException, NumberFormatException {
        String string2 = this.getTrailer(string);
        if (string2 == null) {
            throw new NumberFormatException("null");
        }
        return Integer.parseInt(string2);
    }

    public Date getTrailerAsDate(String string) throws IOException, IllegalArgumentException {
        Date date;
        String string2 = this.getTrailer(string);
        if (string2 == null) {
            return null;
        }
        if (string2.toUpperCase().indexOf("GMT") == -1 && string2.indexOf(32) > 0) {
            string2 = string2 + " GMT";
        }
        try {
            date = Util.parseHttpDate(string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            long l;
            try {
                l = Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw illegalArgumentException;
            }
            if (l < 0L) {
                l = 0L;
            }
            date = new Date(l * 1000L);
        }
        return date;
    }

    public void setTrailer(String string, String string2) {
        this.Trailers.put(string.trim(), string2.trim());
    }

    public void deleteTrailer(String string) {
        this.Trailers.remove(string.trim());
    }

    public synchronized byte[] getData() throws IOException {
        if (!this.got_headers) {
            this.getHeaders(true);
        }
        if (this.Data == null) {
            try {
                this.readResponseData(this.inp_stream);
            }
            catch (InterruptedIOException interruptedIOException) {
                throw interruptedIOException;
            }
            catch (IOException iOException) {
                Log.write(2, "Resp:  (" + this.inp_stream.hashCode() + ")", iOException);
                try {
                    this.inp_stream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw iOException;
            }
            this.inp_stream.close();
        }
        return this.Data;
    }

    public synchronized InputStream getInputStream() throws IOException {
        if (!this.got_headers) {
            this.getHeaders(true);
        }
        if (this.Data == null) {
            return this.inp_stream;
        }
        return new ByteArrayInputStream(this.Data);
    }

    public synchronized boolean hasEntity() throws IOException {
        if (!this.got_headers) {
            this.getHeaders(true);
        }
        return this.cd_type != 2;
    }

    public void setRetryRequest(boolean bl) {
        this.retry = bl;
    }

    public boolean retryRequest() {
        return this.retry;
    }

    private synchronized void getHeaders(boolean bl) throws IOException {
        Object object;
        if (this.got_headers) {
            return;
        }
        if (this.exception != null) {
            this.exception.fillInStackTrace();
            throw this.exception;
        }
        this.reading_headers = true;
        try {
            do {
                this.Headers.clear();
                String string = this.readResponseHeaders(this.inp_stream);
                this.parseResponseHeaders(string);
            } while (this.StatusCode == 100 && bl || this.StatusCode > 101 && this.StatusCode < 200);
        }
        catch (IOException iOException) {
            if (!(iOException instanceof InterruptedIOException)) {
                this.exception = iOException;
            }
            if (iOException instanceof ProtocolException) {
                this.cd_type = 3;
                if (this.stream_handler != null) {
                    this.stream_handler.markForClose(this);
                }
            }
            throw iOException;
        }
        finally {
            this.reading_headers = false;
        }
        if (this.StatusCode == 100) {
            return;
        }
        int n = -1;
        String string = (String)this.Headers.get("Content-Length");
        if (string != null) {
            try {
                n = Integer.parseInt(string);
                if (n < 0) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new ProtocolException("Invalid Content-length header received: " + string);
            }
        }
        boolean bl2 = false;
        boolean bl3 = true;
        boolean bl4 = false;
        Vector vector = null;
        try {
            vector = Util.parseHeader((String)this.Headers.get("Transfer-Encoding"));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        if (vector != null) {
            bl2 = ((HttpHeaderElement)vector.lastElement()).getName().equalsIgnoreCase("chunked");
            for (int i = 0; i < vector.size(); ++i) {
                if (((HttpHeaderElement)vector.elementAt(i)).getName().equalsIgnoreCase("identity")) {
                    vector.removeElementAt(i--);
                    continue;
                }
                bl3 = false;
            }
        }
        try {
            object = (String)this.Headers.get("Content-Type");
            if (object != null) {
                Vector vector2 = Util.parseHeader((String)object);
                bl4 = vector2.contains(new HttpHeaderElement("multipart/byteranges")) || vector2.contains(new HttpHeaderElement("multipart/x-byteranges"));
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        if (this.StatusCode < 200 || this.StatusCode == 204 || this.StatusCode == 205 || this.StatusCode == 304) {
            this.cd_type = 2;
        } else if (bl2) {
            this.cd_type = 5;
            vector.removeElementAt(vector.size() - 1);
            if (vector.size() > 0) {
                this.setHeader("Transfer-Encoding", Util.assembleHeader(vector));
            } else {
                this.deleteHeader("Transfer-Encoding");
            }
        } else if (n != -1 && bl3) {
            this.cd_type = 4;
        } else if (bl4 && bl3) {
            this.cd_type = 6;
        } else if (!this.method.equals("HEAD")) {
            this.cd_type = 3;
            if (this.stream_handler != null) {
                this.stream_handler.markForClose(this);
            }
            if (this.Version.equals("HTTP/0.9")) {
                this.inp_stream = new SequenceInputStream(new ByteArrayInputStream(this.Data), this.inp_stream);
                this.Data = null;
            }
        }
        if (this.cd_type == 4) {
            this.ContentLength = n;
        } else {
            this.deleteHeader("Content-Length");
        }
        if (this.method.equals("HEAD")) {
            this.cd_type = 2;
        }
        if (this.cd_type == 2) {
            this.ContentLength = 0;
            this.Data = new byte[0];
            this.inp_stream.close();
        }
        Log.write(2, "Resp:  Response entity delimiter: " + (this.cd_type == 2 ? "No Entity" : (this.cd_type == 3 ? "Close" : (this.cd_type == 4 ? "Content-Length" : (this.cd_type == 5 ? "Chunked" : (this.cd_type == 6 ? "Multipart" : "???"))))) + " (" + this.inp_stream.hashCode() + ")");
        if (this.connection.ServerProtocolVersion >= 65537) {
            this.deleteHeader("Proxy-Connection");
        } else {
            String string2;
            if (this.connection.getProxyHost() != null) {
                this.deleteHeader("Connection");
            } else {
                this.deleteHeader("Proxy-Connection");
            }
            try {
                object = Util.parseHeader((String)this.Headers.get("Connection"));
            }
            catch (ParseException parseException) {
                object = null;
            }
            if (object != null) {
                for (int i = 0; i < ((Vector)object).size(); ++i) {
                    string2 = ((HttpHeaderElement)((Vector)object).elementAt(i)).getName();
                    if (string2.equalsIgnoreCase("keep-alive")) continue;
                    ((Vector)object).removeElementAt(i);
                    this.deleteHeader(string2);
                    --i;
                }
                if (((Vector)object).size() > 0) {
                    this.setHeader("Connection", Util.assembleHeader((Vector)object));
                } else {
                    this.deleteHeader("Connection");
                }
            }
            try {
                object = Util.parseHeader((String)this.Headers.get("Proxy-Connection"));
            }
            catch (ParseException parseException) {
                object = null;
            }
            if (object != null) {
                for (int i = 0; i < ((Vector)object).size(); ++i) {
                    string2 = ((HttpHeaderElement)((Vector)object).elementAt(i)).getName();
                    if (string2.equalsIgnoreCase("keep-alive")) continue;
                    ((Vector)object).removeElementAt(i);
                    this.deleteHeader(string2);
                    --i;
                }
                if (((Vector)object).size() > 0) {
                    this.setHeader("Proxy-Connection", Util.assembleHeader((Vector)object));
                } else {
                    this.deleteHeader("Proxy-Connection");
                }
            }
        }
        this.got_headers = true;
        if (this.isFirstResponse && !this.connection.handleFirstRequest(this.req, this)) {
            try {
                object = this.connection.sendRequest(this.req, this.timeout);
            }
            catch (ModuleException moduleException) {
                throw new IOException(moduleException.toString());
            }
            ((Response)object).getVersion();
            this.StatusCode = ((Response)object).StatusCode;
            this.ReasonLine = ((Response)object).ReasonLine;
            this.Version = ((Response)object).Version;
            this.EffectiveURI = ((Response)object).EffectiveURI;
            this.ContentLength = ((Response)object).ContentLength;
            this.Headers = ((Response)object).Headers;
            this.inp_stream = ((Response)object).inp_stream;
            this.Data = ((Response)object).Data;
            this.req = null;
        }
    }

    private String readResponseHeaders(InputStream inputStream) throws IOException {
        if (this.buf_pos == 0) {
            Log.write(2, "Resp:  Reading Response headers " + this.inp_stream.hashCode());
        } else {
            Log.write(2, "Resp:  Resuming reading Response headers " + this.inp_stream.hashCode());
        }
        if (!this.reading_lines) {
            int n;
            try {
                if (this.buf_pos == 0) {
                    do {
                        if ((n = inputStream.read()) != -1) continue;
                        throw new EOFException("Encountered premature EOF while reading Version");
                    } while (Character.isWhitespace((char)n));
                    this.buf[0] = (byte)n;
                    this.buf_pos = 1;
                }
                while (this.buf_pos < this.buf.length) {
                    n = inputStream.read(this.buf, this.buf_pos, this.buf.length - this.buf_pos);
                    if (n == -1) {
                        throw new EOFException("Encountered premature EOF while reading Version");
                    }
                    this.buf_pos += n;
                }
            }
            catch (EOFException eOFException) {
                Log.write(2, "Resp:  (" + this.inp_stream.hashCode() + ")", eOFException);
                throw eOFException;
            }
            for (n = 0; n < this.buf.length; ++n) {
                this.hdrs.append((char)this.buf[n]);
            }
            this.reading_lines = true;
        }
        if (this.hdrs.toString().startsWith("HTTP/") || this.hdrs.toString().startsWith("HTTP ")) {
            this.readLines(inputStream);
        }
        this.buf_pos = 0;
        this.reading_lines = false;
        this.bol = true;
        this.got_cr = false;
        String string = this.hdrs.toString();
        this.hdrs.setLength(0);
        return string;
    }

    void readTrailers(InputStream inputStream) throws IOException {
        try {
            this.readLines(inputStream);
            this.trailers_read = true;
        }
        catch (IOException iOException) {
            if (!(iOException instanceof InterruptedIOException)) {
                this.exception = iOException;
            }
            throw iOException;
        }
    }

    private void readLines(InputStream inputStream) throws IOException {
        block6: while (true) {
            int n = inputStream.read();
            switch (n) {
                case -1: {
                    throw new EOFException("Encountered premature EOF while reading headers:\n" + this.hdrs);
                }
                case 13: {
                    this.got_cr = true;
                    continue block6;
                }
                case 10: {
                    if (this.bol) break block6;
                    this.hdrs.append('\n');
                    this.bol = true;
                    this.got_cr = false;
                    continue block6;
                }
                case 9: 
                case 32: {
                    if (this.bol) {
                        this.hdrs.setCharAt(this.hdrs.length() - 1, ' ');
                        this.bol = false;
                        continue block6;
                    }
                }
                default: {
                    if (this.got_cr) {
                        this.hdrs.append('\r');
                        this.got_cr = false;
                    }
                    this.hdrs.append((char)(n & 0xFF));
                    this.bol = false;
                    continue block6;
                }
            }
            break;
        }
    }

    private void parseResponseHeaders(String string) throws ProtocolException {
        StringTokenizer stringTokenizer;
        String string2 = null;
        StringTokenizer stringTokenizer2 = new StringTokenizer(string, "\r\n");
        if (Log.isEnabled(2)) {
            Log.write(2, "Resp:  Parsing Response headers from Request \"" + this.method + " " + this.resource + "\":  (" + this.inp_stream.hashCode() + ")\n\n" + string);
        }
        if (this.logging) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(this.logFilename, true);
                fileOutputStream.write(inboundHeader.getBytes());
                fileOutputStream.write(string.getBytes());
                fileOutputStream.write(new byte[]{13, 10});
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!string.regionMatches(true, 0, "HTTP/", 0, 5) && !string.regionMatches(true, 0, "HTTP ", 0, 5)) {
            this.Version = "HTTP/0.9";
            this.StatusCode = 200;
            this.ReasonLine = "OK";
            try {
                this.Data = string.getBytes("8859_1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new Error(unsupportedEncodingException.toString());
            }
            return;
        }
        try {
            string2 = stringTokenizer2.nextToken();
            stringTokenizer = new StringTokenizer(string2, " \t");
            this.Version = stringTokenizer.nextToken();
            this.StatusCode = Integer.valueOf(stringTokenizer.nextToken());
            if (this.Version.equalsIgnoreCase("HTTP")) {
                this.Version = "HTTP/1.0";
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new ProtocolException("Invalid HTTP status line received: " + string2);
        }
        try {
            this.ReasonLine = stringTokenizer.nextToken("").trim();
        }
        catch (NoSuchElementException noSuchElementException) {
            this.ReasonLine = "";
        }
        if (this.StatusCode >= 300 && this.sent_entity && this.stream_handler != null) {
            this.stream_handler.markForClose(this);
        }
        this.parseHeaderFields(stringTokenizer2, this.Headers);
        if (this.Headers.get("Trailer") != null && this.resp_inp_stream != null) {
            this.resp_inp_stream.dontTruncate();
        }
        boolean bl = !this.Version.equalsIgnoreCase("HTTP/0.9") && !this.Version.equalsIgnoreCase("HTTP/1.0");
        try {
            String string3 = (String)this.Headers.get("Connection");
            String string4 = (String)this.Headers.get("Proxy-Connection");
            if (!((!bl || string3 == null || !Util.hasToken(string3, "close")) && (bl || !this.used_proxy && string3 != null && Util.hasToken(string3, "keep-alive") || this.used_proxy && string4 != null && Util.hasToken(string4, "keep-alive")) || this.stream_handler == null)) {
                this.stream_handler.markForClose(this);
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void getTrailers() throws IOException {
        if (this.got_trailers) {
            return;
        }
        if (this.exception != null) {
            this.exception.fillInStackTrace();
            throw this.exception;
        }
        Log.write(2, "Resp:  Reading Response trailers " + this.inp_stream.hashCode());
        try {
            if (!this.trailers_read && this.resp_inp_stream != null) {
                this.resp_inp_stream.readAll(this.timeout);
            }
            if (this.trailers_read) {
                Log.write(2, "Resp:  Parsing Response trailers from Request \"" + this.method + " " + this.resource + "\":  (" + this.inp_stream.hashCode() + ")\n\n" + this.hdrs);
                this.parseHeaderFields(new StringTokenizer(this.hdrs.toString(), "\r\n"), this.Trailers);
            }
        }
        finally {
            this.got_trailers = true;
        }
    }

    private void parseHeaderFields(StringTokenizer stringTokenizer, CIHashtable cIHashtable) throws ProtocolException {
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            int n = string.indexOf(58);
            if (n == -1) {
                n = string.indexOf(32);
            }
            if (n == -1) {
                throw new ProtocolException("Invalid HTTP header received: " + string);
            }
            String string2 = string.substring(0, n).trim();
            String string3 = string.substring(n + 1).trim();
            if (!singleValueHeaders.containsKey(string2.toLowerCase())) {
                String string4 = (String)cIHashtable.get(string2);
                if (string4 == null) {
                    cIHashtable.put(string2, string3);
                    continue;
                }
                cIHashtable.put(string2, string4 + ", " + string3);
                continue;
            }
            cIHashtable.put(string2, string3);
        }
    }

    private void readResponseData(InputStream inputStream) throws IOException {
        block14: {
            if (this.ContentLength == 0) {
                return;
            }
            if (this.Data == null) {
                this.Data = new byte[0];
            }
            int n = this.Data.length;
            try {
                if (this.getHeader("Content-Length") != null) {
                    int n2 = 0;
                    this.Data = new byte[this.ContentLength];
                    while ((n2 = inputStream.read(this.Data, n += n2, this.ContentLength - n)) != -1) {
                        if (n + n2 < this.ContentLength) continue;
                        break block14;
                    }
                    break block14;
                }
                int n3 = 1000;
                int n4 = 0;
                do {
                    this.Data = Util.resizeArray(this.Data, (n += n4) + n3);
                } while ((n4 = inputStream.read(this.Data, n, n3)) != -1);
                this.Data = Util.resizeArray(this.Data, n);
            }
            catch (IOException iOException) {
                this.Data = Util.resizeArray(this.Data, n);
                throw iOException;
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    void markAsFirstResponse(Request request) {
        this.req = request;
        this.isFirstResponse = true;
    }

    public Object clone() {
        Response response;
        try {
            response = (Response)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
        response.Headers = (CIHashtable)this.Headers.clone();
        response.Trailers = (CIHashtable)this.Trailers.clone();
        return response;
    }

    public void setLogging(boolean bl, String string) {
        this.setLogging(bl, string, true);
    }

    public void setLogging(boolean bl, String string, boolean bl2) {
        this.logging = bl;
        this.logFilename = string;
        if (bl2) {
            if (this.http_resp != null) {
                this.http_resp.setLogging(bl, string);
            }
            if (this.stream_handler != null) {
                this.stream_handler.setLogging(bl, string);
            }
        }
    }

    public boolean getLogging() {
        return this.logging;
    }

    public String getLogFilename() {
        return this.logFilename;
    }

    static {
        inboundHeader = "\r\n========= Inbound Message =========\r\n";
        String[] stringArray = new String[]{"age", "location", "content-base", "content-length", "content-location", "content-md5", "content-range", "content-type", "date", "etag", "expires", "proxy-authenticate", "retry-after"};
        singleValueHeaders = new Hashtable(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            singleValueHeaders.put(stringArray[i], stringArray[i]);
        }
    }
}

