/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.AuthorizationInfo;
import HTTPClient.Cookie;
import HTTPClient.HttpHeaderElement;
import HTTPClient.NVPair;
import HTTPClient.ParseException;
import HTTPClient.URI;
import java.lang.reflect.Array;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.BitSet;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.StringTokenizer;
import java.util.Vector;

public class Util {
    private static final BitSet Separators;
    private static final BitSet TokenChar;
    private static final BitSet UnsafeChar;
    private static DateFormat http_format;
    private static DateFormat parse_1123;
    private static DateFormat parse_850;
    private static DateFormat parse_asctime;
    private static final Object http_format_lock;
    private static final Object http_parse_lock;
    static final char[] hex_map;

    private Util() {
    }

    static final Object[] resizeArray(Object[] objectArray, int n) {
        Class<?> clazz = objectArray.getClass().getComponentType();
        Object[] objectArray2 = (Object[])Array.newInstance(clazz, n);
        System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length < n ? objectArray.length : n);
        return objectArray2;
    }

    public static final NVPair[] resizeArray(NVPair[] nVPairArray, int n) {
        NVPair[] nVPairArray2 = new NVPair[n];
        System.arraycopy(nVPairArray, 0, nVPairArray2, 0, nVPairArray.length < n ? nVPairArray.length : n);
        return nVPairArray2;
    }

    static final AuthorizationInfo[] resizeArray(AuthorizationInfo[] authorizationInfoArray, int n) {
        AuthorizationInfo[] authorizationInfoArray2 = new AuthorizationInfo[n];
        System.arraycopy(authorizationInfoArray, 0, authorizationInfoArray2, 0, authorizationInfoArray.length < n ? authorizationInfoArray.length : n);
        return authorizationInfoArray2;
    }

    static final Cookie[] resizeArray(Cookie[] cookieArray, int n) {
        Cookie[] cookieArray2 = new Cookie[n];
        System.arraycopy(cookieArray, 0, cookieArray2, 0, cookieArray.length < n ? cookieArray.length : n);
        return cookieArray2;
    }

    static final String[] resizeArray(String[] stringArray, int n) {
        String[] stringArray2 = new String[n];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length < n ? stringArray.length : n);
        return stringArray2;
    }

    static final boolean[] resizeArray(boolean[] blArray, int n) {
        boolean[] blArray2 = new boolean[n];
        System.arraycopy(blArray, 0, blArray2, 0, blArray.length < n ? blArray.length : n);
        return blArray2;
    }

    static final byte[] resizeArray(byte[] byArray, int n) {
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length < n ? byArray.length : n);
        return byArray2;
    }

    static final char[] resizeArray(char[] cArray, int n) {
        char[] cArray2 = new char[n];
        System.arraycopy(cArray, 0, cArray2, 0, cArray.length < n ? cArray.length : n);
        return cArray2;
    }

    static final int[] resizeArray(int[] nArray, int n) {
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length < n ? nArray.length : n);
        return nArray2;
    }

    static String[] splitProperty(String string) {
        if (string == null) {
            return new String[0];
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringTokenizer.nextToken().trim();
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final Hashtable getList(Hashtable hashtable, Object object) {
        Hashtable hashtable2 = hashtable;
        synchronized (hashtable2) {
            Hashtable hashtable3 = (Hashtable)hashtable.get(object);
            if (hashtable3 == null) {
                hashtable3 = new Hashtable();
                hashtable.put(object, hashtable3);
            }
            return hashtable3;
        }
    }

    static final int[] compile_search(byte[] byArray) {
        int[] nArray = new int[]{0, 1, 0, 1, 0, 1};
        for (int i = 0; i < byArray.length; ++i) {
            int n;
            for (n = i + 1; n < byArray.length && byArray[i] != byArray[n]; ++n) {
            }
            if (n >= byArray.length) continue;
            if (n - i > nArray[1]) {
                nArray[4] = nArray[2];
                nArray[5] = nArray[3];
                nArray[2] = nArray[0];
                nArray[3] = nArray[1];
                nArray[0] = i;
                nArray[1] = n - i;
                continue;
            }
            if (n - i > nArray[3]) {
                nArray[4] = nArray[2];
                nArray[5] = nArray[3];
                nArray[2] = i;
                nArray[3] = n - i;
                continue;
            }
            if (n - i <= nArray[3]) continue;
            nArray[4] = i;
            nArray[5] = n - i;
        }
        nArray[1] = nArray[1] + nArray[0];
        nArray[3] = nArray[3] + nArray[2];
        nArray[5] = nArray[5] + nArray[4];
        return nArray;
    }

    static final int findStr(byte[] byArray, int[] nArray, byte[] byArray2, int n, int n2) {
        int n3 = nArray[0];
        int n4 = nArray[1];
        int n5 = n4 - n3;
        int n6 = nArray[2];
        int n7 = nArray[3];
        int n8 = n7 - n6;
        int n9 = nArray[4];
        int n10 = nArray[5];
        int n11 = n10 - n9;
        while (n + byArray.length <= n2) {
            if (byArray[n4] == byArray2[n + n4]) {
                if (byArray[n3] == byArray2[n + n3]) {
                    boolean bl = true;
                    for (int i = 0; i < byArray.length; ++i) {
                        if (byArray[i] == byArray2[n + i]) continue;
                        bl = false;
                        break;
                    }
                    if (bl) break;
                }
                n += n5;
                continue;
            }
            if (byArray[n7] == byArray2[n + n7]) {
                n += n8;
                continue;
            }
            if (byArray[n10] == byArray2[n + n10]) {
                n += n11;
                continue;
            }
            ++n;
        }
        if (n + byArray.length > n2) {
            return -1;
        }
        return n;
    }

    public static final String dequoteString(String string) {
        if (string.indexOf(92) == -1) {
            return string;
        }
        char[] cArray = string.toCharArray();
        int n = 0;
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] != '\\' || i + 1 >= cArray.length) continue;
            System.arraycopy(cArray, i + 1, cArray, i, cArray.length - i - 1);
            ++n;
        }
        return new String(cArray, 0, cArray.length - n);
    }

    public static final String quoteString(String string, String string2) {
        int n;
        char[] cArray = string2.toCharArray();
        for (n = 0; n < cArray.length && string.indexOf(cArray[n]) == -1; ++n) {
        }
        if (n == cArray.length) {
            return string;
        }
        int n2 = string.length();
        char[] cArray2 = new char[n2 * 2];
        string.getChars(0, n2, cArray2, 0);
        for (int i = 0; i < n2; ++i) {
            if (string2.indexOf(cArray2[i], 0) == -1) continue;
            if (n2 == cArray2.length) {
                cArray2 = Util.resizeArray(cArray2, n2 + string.length());
            }
            System.arraycopy(cArray2, i, cArray2, i + 1, n2 - i);
            ++n2;
            cArray2[i++] = 92;
        }
        return new String(cArray2, 0, n2);
    }

    public static final Vector parseHeader(String string) throws ParseException {
        return Util.parseHeader(string, true);
    }

    public static final Vector parseHeader(String string, boolean bl) throws ParseException {
        if (string == null) {
            return null;
        }
        char[] cArray = string.toCharArray();
        Vector<HttpHeaderElement> vector = new Vector<HttpHeaderElement>();
        boolean bl2 = true;
        int n = -1;
        int n2 = 0;
        int n3 = cArray.length;
        int[] nArray = new int[1];
        while (true) {
            String string2;
            if (!bl2) {
                n = Util.skipSpace(cArray, n2);
                if (n == n3) break;
                if (cArray[n] != ',') {
                    throw new ParseException("Bad header format: '" + string + "'\nExpected \",\" at position " + n);
                }
            }
            bl2 = false;
            if ((n = Util.skipSpace(cArray, n + 1)) == n3) break;
            if (cArray[n] == ',') {
                n2 = n;
                continue;
            }
            if (cArray[n] == '=' || cArray[n] == ';' || cArray[n] == '\"') {
                throw new ParseException("Bad header format: '" + string + "'\nEmpty element name at position " + n);
            }
            for (n2 = n + 1; n2 < n3 && !Character.isWhitespace(cArray[n2]) && cArray[n2] != '=' && cArray[n2] != ',' && cArray[n2] != ';'; ++n2) {
            }
            String string3 = new String(cArray, n, n2 - n);
            n = Util.skipSpace(cArray, n2);
            if (n < n3 && cArray[n] == '=') {
                nArray[0] = n + 1;
                string2 = Util.parseValue(cArray, nArray, string, bl);
                n2 = nArray[0];
            } else {
                string2 = null;
                n2 = n;
            }
            NVPair[] nVPairArray = new NVPair[]{};
            while ((n = Util.skipSpace(cArray, n2)) != n3 && cArray[n] == ';') {
                String string4;
                if ((n = Util.skipSpace(cArray, n + 1)) == n3 || cArray[n] == ',') {
                    n2 = n;
                    break;
                }
                if (cArray[n] == ';') {
                    n2 = n;
                    continue;
                }
                if (cArray[n] == '=' || cArray[n] == '\"') {
                    throw new ParseException("Bad header format: '" + string + "'\nEmpty parameter name at position " + n);
                }
                for (n2 = n + 1; n2 < n3 && !Character.isWhitespace(cArray[n2]) && cArray[n2] != '=' && cArray[n2] != ',' && cArray[n2] != ';'; ++n2) {
                }
                String string5 = new String(cArray, n, n2 - n);
                n = Util.skipSpace(cArray, n2);
                if (n < n3 && cArray[n] == '=') {
                    nArray[0] = n + 1;
                    string4 = Util.parseValue(cArray, nArray, string, bl);
                    n2 = nArray[0];
                } else {
                    string4 = null;
                    n2 = n;
                }
                nVPairArray = Util.resizeArray(nVPairArray, nVPairArray.length + 1);
                nVPairArray[nVPairArray.length - 1] = new NVPair(string5, string4);
            }
            vector.addElement(new HttpHeaderElement(string3, string2, nVPairArray));
        }
        return vector;
    }

    private static String parseValue(char[] cArray, int[] nArray, String string, boolean bl) throws ParseException {
        String string2;
        int n;
        int n2 = n = nArray[0];
        int n3 = cArray.length;
        if ((n = Util.skipSpace(cArray, n)) < n3 && cArray[n] == '\"') {
            char[] cArray2 = null;
            int n4 = 0;
            int n5 = n;
            for (n2 = ++n; n2 < n3 && cArray[n2] != '\"'; ++n2) {
                if (cArray[n2] != '\\') continue;
                if (bl) {
                    if (cArray2 == null) {
                        cArray2 = new char[cArray.length];
                    }
                    System.arraycopy(cArray, n5, cArray2, n4, n2 - n5);
                    n4 += n2 - n5;
                    n5 = ++n2;
                    continue;
                }
                ++n2;
            }
            if (n2 == n3) {
                throw new ParseException("Bad header format: '" + string + "'\nClosing <\"> for quoted-string" + " starting at position " + (n - 1) + " not found");
            }
            if (cArray2 != null) {
                System.arraycopy(cArray, n5, cArray2, n4, n2 - n5);
                string2 = new String(cArray2, 0, n4 += n2 - n5);
            } else {
                string2 = new String(cArray, n, n2 - n);
            }
        } else {
            for (n2 = n; n2 < n3 && !Character.isWhitespace(cArray[n2]) && cArray[n2] != ',' && cArray[n2] != ';'; ++n2) {
            }
            string2 = new String(cArray, n, n2 - n);
        }
        nArray[0] = ++n2;
        return string2;
    }

    public static final boolean hasToken(String string, String string2) throws ParseException {
        if (string == null) {
            return false;
        }
        return Util.parseHeader(string).contains(new HttpHeaderElement(string2));
    }

    public static final HttpHeaderElement getElement(Vector vector, String string) {
        int n = vector.indexOf(new HttpHeaderElement(string));
        if (n == -1) {
            return null;
        }
        return (HttpHeaderElement)vector.elementAt(n);
    }

    public static final String getParameter(String string, String string2) throws ParseException {
        NVPair[] nVPairArray = ((HttpHeaderElement)Util.parseHeader(string2).firstElement()).getParams();
        for (int i = 0; i < nVPairArray.length; ++i) {
            if (!nVPairArray[i].getName().equalsIgnoreCase(string)) continue;
            return nVPairArray[i].getValue();
        }
        return null;
    }

    public static final String assembleHeader(Vector vector) {
        StringBuffer stringBuffer = new StringBuffer(200);
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            ((HttpHeaderElement)vector.elementAt(i)).appendTo(stringBuffer);
            stringBuffer.append(", ");
        }
        stringBuffer.setLength(stringBuffer.length() - 2);
        return stringBuffer.toString();
    }

    static final int skipSpace(char[] cArray, int n) {
        int n2 = cArray.length;
        while (n < n2 && Character.isWhitespace(cArray[n])) {
            ++n;
        }
        return n;
    }

    static final int findSpace(char[] cArray, int n) {
        int n2 = cArray.length;
        while (n < n2 && !Character.isWhitespace(cArray[n])) {
            ++n;
        }
        return n;
    }

    static final int skipToken(char[] cArray, int n) {
        int n2 = cArray.length;
        while (n < n2 && TokenChar.get(cArray[n])) {
            ++n;
        }
        return n;
    }

    static final boolean needsQuoting(String string) {
        int n;
        int n2 = string.length();
        for (n = 0; n < n2 && TokenChar.get(string.charAt(n)); ++n) {
        }
        return n < n2;
    }

    public static final boolean sameHttpURL(URL uRL, URL uRL2) {
        if (!uRL.getProtocol().equalsIgnoreCase(uRL2.getProtocol())) {
            return false;
        }
        if (!uRL.getHost().equalsIgnoreCase(uRL2.getHost())) {
            return false;
        }
        int n = uRL.getPort();
        int n2 = uRL2.getPort();
        if (n == -1) {
            n = URI.defaultPort(uRL.getProtocol());
        }
        if (n2 == -1) {
            n2 = URI.defaultPort(uRL.getProtocol());
        }
        if (n != n2) {
            return false;
        }
        try {
            return URI.unescape(uRL.getFile(), null).equals(URI.unescape(uRL2.getFile(), null));
        }
        catch (ParseException parseException) {
            return uRL.getFile().equals(uRL2.getFile());
        }
    }

    public static final int defaultPort(String string) {
        return URI.defaultPort(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final Date parseHttpDate(String string) {
        Object object = http_parse_lock;
        synchronized (object) {
            if (parse_1123 == null) {
                Util.setupParsers();
            }
        }
        try {
            return parse_1123.parse(string);
        }
        catch (java.text.ParseException parseException) {
            try {
                return parse_850.parse(string);
            }
            catch (java.text.ParseException parseException2) {
                try {
                    return parse_asctime.parse(string);
                }
                catch (java.text.ParseException parseException3) {
                    throw new IllegalArgumentException(parseException3.toString());
                }
            }
        }
    }

    private static final void setupParsers() {
        parse_1123 = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
        parse_850 = new SimpleDateFormat("EEEE, dd-MMM-yy HH:mm:ss 'GMT'", Locale.US);
        parse_asctime = new SimpleDateFormat("EEE MMM d HH:mm:ss yyyy", Locale.US);
        parse_1123.setTimeZone(new SimpleTimeZone(0, "GMT"));
        parse_850.setTimeZone(new SimpleTimeZone(0, "GMT"));
        parse_asctime.setTimeZone(new SimpleTimeZone(0, "GMT"));
        parse_1123.setLenient(true);
        parse_850.setLenient(true);
        parse_asctime.setLenient(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String httpDate(Date date) {
        Object object = http_format_lock;
        synchronized (object) {
            if (http_format == null) {
                Util.setupFormatter();
            }
        }
        return http_format.format(date);
    }

    private static final void setupFormatter() {
        http_format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
        http_format.setTimeZone(new SimpleTimeZone(0, "GMT"));
    }

    static final String escapeUnsafeChars(String string) {
        int n = string.length();
        char[] cArray = new char[3 * n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c >= '\u0080' || UnsafeChar.get(c)) {
                cArray[n2++] = 37;
                cArray[n2++] = hex_map[(c & 0xF0) >>> 4];
                cArray[n2++] = hex_map[c & 0xF];
                continue;
            }
            cArray[n2++] = c;
        }
        if (n2 > n) {
            return new String(cArray, 0, n2);
        }
        return string;
    }

    public static final String getPath(String string) {
        int n = string.length();
        int n2 = string.indexOf(35);
        if (n2 != -1) {
            n = n2;
        }
        if ((n2 = string.indexOf(63)) != -1 && n2 < n) {
            n = n2;
        }
        if ((n2 = string.indexOf(59)) != -1 && n2 < n) {
            n = n2;
        }
        return string.substring(0, n);
    }

    public static final String getParams(String string) {
        int n = string.indexOf(59);
        if (n == -1) {
            return null;
        }
        int n2 = string.indexOf(35);
        if (n2 != -1 && n2 < n) {
            return null;
        }
        int n3 = string.indexOf(63);
        if (n3 != -1 && n3 < n) {
            return null;
        }
        if (n3 == -1 && n2 == -1) {
            return string.substring(n + 1);
        }
        if (n2 == -1 || n3 != -1 && n3 < n2) {
            return string.substring(n + 1, n3);
        }
        return string.substring(n + 1, n2);
    }

    public static final String getQuery(String string) {
        int n = string.indexOf(63);
        if (n == -1) {
            return null;
        }
        int n2 = string.indexOf(35);
        if (n2 != -1 && n2 < n) {
            return null;
        }
        if (n2 == -1) {
            return string.substring(n + 1);
        }
        return string.substring(n + 1, n2);
    }

    public static final String getFragment(String string) {
        int n = string.indexOf(35);
        if (n == -1) {
            return null;
        }
        return string.substring(n + 1);
    }

    public static final boolean wildcardMatch(String string, String string2) {
        return Util.wildcardMatch(string, string2, 0, 0, string.length(), string2.length());
    }

    private static final boolean wildcardMatch(String string, String string2, int n, int n2, int n3, int n4) {
        int n5 = string.indexOf(42, n);
        if (n5 < 0) {
            return n3 - n == n4 - n2 && string.regionMatches(n, string2, n2, n3 - n);
        }
        if (!string.regionMatches(n, string2, n2, n5 - n)) {
            return false;
        }
        if (n5 == n3 - 1) {
            return true;
        }
        while (!Util.wildcardMatch(string, string2, n5 + 1, n2, n3, n4) && n2 < n4) {
            ++n2;
        }
        return n2 < n4;
    }

    static {
        int n;
        Separators = new BitSet(128);
        TokenChar = new BitSet(128);
        UnsafeChar = new BitSet(128);
        http_format_lock = new Object();
        http_parse_lock = new Object();
        Separators.set(40);
        Separators.set(41);
        Separators.set(60);
        Separators.set(62);
        Separators.set(64);
        Separators.set(44);
        Separators.set(59);
        Separators.set(58);
        Separators.set(92);
        Separators.set(34);
        Separators.set(47);
        Separators.set(91);
        Separators.set(93);
        Separators.set(63);
        Separators.set(61);
        Separators.set(123);
        Separators.set(125);
        Separators.set(32);
        Separators.set(9);
        for (n = 32; n < 127; ++n) {
            TokenChar.set(n);
        }
        TokenChar.xor(Separators);
        for (n = 0; n < 32; ++n) {
            UnsafeChar.set(n);
        }
        UnsafeChar.set(32);
        UnsafeChar.set(60);
        UnsafeChar.set(62);
        UnsafeChar.set(34);
        UnsafeChar.set(123);
        UnsafeChar.set(125);
        UnsafeChar.set(124);
        UnsafeChar.set(92);
        UnsafeChar.set(94);
        UnsafeChar.set(126);
        UnsafeChar.set(91);
        UnsafeChar.set(93);
        UnsafeChar.set(96);
        UnsafeChar.set(127);
        hex_map = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    }
}

