/*
 * Decompiled with CFR 0.152.
 */
package com.ms.xml.om;

import com.ms.xml.om.Element;
import java.util.Enumeration;

public class SiblingEnumeration
implements Enumeration {
    Element originalNode;
    Element next;
    Element parent;
    Enumeration siblings;
    int siblingIndex;
    boolean enumerationDir;

    public SiblingEnumeration(Element element) {
        this.Initialize(element, true);
    }

    public SiblingEnumeration(Element element, boolean bl) {
        this.Initialize(element, bl);
    }

    private void Initialize(Element element, boolean bl) {
        this.originalNode = element;
        this.enumerationDir = bl;
        this.next = null;
        this.parent = null;
        this.siblings = null;
        this.siblingIndex = 0;
        if (element != null) {
            this.parent = element.getParent();
            if (this.parent != null) {
                if (!bl) {
                    int n = 0;
                    Enumeration enumeration = this.parent.getElements();
                    while (enumeration.hasMoreElements() && (Element)enumeration.nextElement() != element) {
                        ++n;
                    }
                    this.siblingIndex = n < this.parent.numElements() ? n : 0;
                } else {
                    this.siblings = this.parent.getElements();
                    while (this.siblings.hasMoreElements() && (Element)this.siblings.nextElement() != element) {
                    }
                    this.next = element;
                }
            }
        }
    }

    public void reset() {
        this.Initialize(this.originalNode, this.enumerationDir);
    }

    public boolean hasMoreElements() {
        if (this.next == null) {
            this.next = this.next();
        }
        return this.next != null;
    }

    public Object nextElement() {
        if (this.next != null) {
            Element element = this.next;
            this.next = null;
            return element;
        }
        return this.next();
    }

    Element next() {
        if (!this.enumerationDir) {
            return this.prevSibling();
        }
        return this.nextSibling();
    }

    Element nextSibling() {
        if (this.siblings != null && this.siblings.hasMoreElements()) {
            Element element = (Element)this.siblings.nextElement();
            return element;
        }
        return null;
    }

    Element prevSibling() {
        if (this.parent != null) {
            Element element = this.parent.getChild(--this.siblingIndex);
            return element;
        }
        return null;
    }
}

