/*
 * Decompiled with CFR 0.152.
 */
package com.ms.xml.parser;

import com.ms.xml.om.Element;
import com.ms.xml.om.ElementImpl;
import com.ms.xml.parser.AttDef;
import com.ms.xml.parser.ContentModel;
import com.ms.xml.parser.Context;
import com.ms.xml.parser.ParseException;
import com.ms.xml.parser.Parser;
import com.ms.xml.util.Atom;
import com.ms.xml.util.Name;
import com.ms.xml.util.XMLOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class ElementDecl
extends ElementImpl {
    Name name;
    private Vector attdefs;
    private ContentModel content;
    ElementDecl base;
    Vector interfaces;
    Element schema = null;
    static Name nameELEMENTTYPE = Name.create("ELEMENTTYPE", "XML");
    static Name nameID = Name.create("ID", "XML");

    ElementDecl(Name name) {
        super(name, 9);
        this.name = name;
    }

    final void parseModel(Parser parser) throws ParseException {
        this.content = new ContentModel();
        parser.parseKeyword(0, "EMPTY|...");
        if (parser.token == -37) {
            parser.parseToken(-4, "base element declaration");
            this.base = parser.dtd.findElementDecl(parser.name);
            if (this.base == null) {
                parser.error("Didn't find element declaration to extend " + parser.name);
            }
            parser.parseKeyword(0, "EMPTY|...");
        }
        if (parser.token == -38) {
            this.interfaces = new Vector();
            int n = parser.parseNames(this.interfaces, 44, null);
            --n;
            while (n >= 0) {
                ElementDecl elementDecl = parser.dtd.findElementDecl((Name)this.interfaces.elementAt(n));
                if (elementDecl == null) {
                    parser.error("Didn't find element declaration to implement " + this.interfaces.elementAt(n));
                } else {
                    this.interfaces.setElementAt(elementDecl, n);
                }
                --n;
            }
            if (parser.token == -4) {
                parser.token = parser.lookup(this.name.getName());
            }
        }
        switch (parser.token) {
            case -16: {
                this.content.type = 1;
                parser.nextToken();
                break;
            }
            case -17: {
                this.content.type = (byte)2;
                parser.nextToken();
                break;
            }
            case 40: {
                this.content.type = (byte)4;
                this.content.parseModel(parser);
                break;
            }
            case 62: {
                if (this.base != null) {
                    this.content = this.base.content;
                    break;
                }
            }
            default: {
                parser.error("Expected EMPTY, ANY, or '('.");
            }
        }
        if (parser.token != 62) {
            parser.error("Element declaration syntax error. Expected '>' instead of '" + parser.tokenString(parser.token) + "'");
        }
    }

    final void parseAttList(Parser parser) throws ParseException {
        parser.nextToken();
        while (parser.token == -4) {
            AttDef attDef;
            Name name = parser.name;
            if (name.getName().equals(Parser.nameXMLSpace.getName())) {
                name = Parser.nameXMLSpace;
            }
            parser.parseKeyword(0, "Attdef");
            switch (parser.token) {
                case -27: 
                case -26: 
                case -25: 
                case -24: 
                case -23: 
                case -22: 
                case -21: 
                case -20: {
                    attDef = new AttDef(name, -20 - parser.token + 0);
                    break;
                }
                case -28: {
                    parser.parseToken(40, "(");
                    Vector vector = new Vector();
                    int n = parser.parseNames(vector, 0, null);
                    --n;
                    while (n >= 0) {
                        Name name2 = (Name)vector.elementAt(n);
                        if (parser.dtd.findNotation(name2) == null) {
                            parser.error("Notation not declared '" + name2 + "'");
                        }
                        --n;
                    }
                    parser.parseToken(41, ")");
                    attDef = new AttDef(name, 8, vector);
                    break;
                }
                case 40: {
                    ++parser.nametoken;
                    Vector vector = new Vector();
                    int n = parser.parseNames(vector, 124, null);
                    --parser.nametoken;
                    if (parser.token != 41) {
                        parser.error("Expected )");
                    }
                    attDef = new AttDef(name, 9, vector);
                    break;
                }
                default: {
                    attDef = null;
                    parser.error("Unknown token in attlist declaration " + parser.token);
                }
            }
            if (parser.nextToken() == 35) {
                parser.parseKeyword(0, "attribute default");
                switch (parser.token) {
                    case -31: {
                        attDef.presence = 1;
                        break;
                    }
                    case -32: {
                        attDef.presence = (byte)2;
                        break;
                    }
                    case -30: {
                        attDef.presence = (byte)3;
                        break;
                    }
                    default: {
                        parser.error("Expected 'REQUIRED', 'IMPLIED', or 'FIXED'.");
                    }
                }
                parser.nextToken();
            }
            if (attDef.presence == 3 || attDef.presence == 0) {
                switch (parser.token) {
                    case 39: {
                        attDef.def = attDef.parseAttValue(this, parser, true);
                        parser.nextToken();
                        break;
                    }
                    default: {
                        parser.error("Expected FIXED or DEFAULT value for " + attDef.name);
                    }
                }
            }
            this.addAttDef(attDef);
        }
    }

    final void initContent(Context context, Parser parser) throws ParseException {
        Object object;
        context.ed = this;
        AttDef attDef = this.findAttDef(Parser.nameXMLSpace);
        if (attDef != null && (object = attDef.getDefault()) != null) {
            String string = (String)object;
            context.preserveWS = string.equalsIgnoreCase("preserve");
        }
        this.content.initContent(context, parser);
    }

    final boolean checkContent(Context context, Element element, Parser parser) throws ParseException {
        return this.content.checkContent(context, element, parser);
    }

    final boolean acceptEmpty() {
        return this.content.acceptEmpty();
    }

    final Vector expectedElements(int n) {
        return this.content.expectedElements(n);
    }

    final void checkOwnAttributes(Element element, Parser parser) throws ParseException {
        if (this.attdefs == null) {
            return;
        }
        Enumeration enumeration = this.attdefs.elements();
        while (enumeration.hasMoreElements()) {
            AttDef attDef = (AttDef)enumeration.nextElement();
            if (attDef.getPresence() != 1 || element.getAttribute(attDef.getName()) != null) continue;
            parser.error("Attribute '" + attDef.getName() + "' is required.");
        }
    }

    final void checkAttributes(Element element, Parser parser) throws ParseException {
        this.checkOwnAttributes(element, parser);
        if (this.base != null) {
            this.base.checkOwnAttributes(element, parser);
        }
        if (this.interfaces != null) {
            Enumeration enumeration = this.interfaces.elements();
            while (enumeration.hasMoreElements()) {
                ((ElementDecl)enumeration.nextElement()).checkOwnAttributes(element, parser);
            }
        }
    }

    public final ContentModel getContent() {
        return this.content;
    }

    public final Name getName() {
        return this.name;
    }

    final void parseAttribute(Element element, Name name, Parser parser) throws ParseException {
        AttDef attDef = this.findAttDef(name);
        if (attDef == null) {
            parser.error("Illegal attribute name " + name);
        }
        Object object = attDef.parseAttribute(element, parser);
        element.setAttribute(name, object);
    }

    final void addAttDef(AttDef attDef) {
        if (this.attdefs == null) {
            this.attdefs = new Vector();
        }
        this.attdefs.addElement(attDef);
    }

    public final AttDef findAttDef(Name name) {
        AttDef attDef;
        Enumeration enumeration;
        if (this.attdefs != null) {
            enumeration = this.attdefs.elements();
            while (enumeration.hasMoreElements()) {
                attDef = (AttDef)enumeration.nextElement();
                if (attDef.name != name) continue;
                return attDef;
            }
        }
        if (this.base != null && (enumeration = this.base.findAttDef(name)) != null) {
            return enumeration;
        }
        if (this.interfaces != null) {
            enumeration = this.interfaces.elements();
            while (enumeration.hasMoreElements()) {
                attDef = ((ElementDecl)enumeration.nextElement()).findAttDef(name);
                if (attDef == null) continue;
                return attDef;
            }
        }
        return null;
    }

    public Element toSchema() {
        if (this.schema == null) {
            ElementImpl elementImpl = new ElementImpl(nameELEMENTTYPE, 0);
            elementImpl.setAttribute(nameID, (Object)this.name);
            Element element = this.content.toSchema();
            elementImpl.addChild(element, null);
            if (this.attdefs != null) {
                Enumeration enumeration = this.attdefs.elements();
                while (enumeration.hasMoreElements()) {
                    AttDef attDef = (AttDef)enumeration.nextElement();
                    elementImpl.addChild(attDef.toSchema(), null);
                }
            }
            this.schema = elementImpl;
        }
        return this.schema;
    }

    public void save(XMLOutputStream xMLOutputStream) throws IOException {
        xMLOutputStream.writeIndent();
        xMLOutputStream.writeChars("<!ELEMENT ");
        xMLOutputStream.writeQualifiedName(this.name, null);
        xMLOutputStream.writeChars(" ");
        Atom atom = this.name.getNameSpace();
        this.content.save(atom, xMLOutputStream);
        xMLOutputStream.write(62);
        if (this.attdefs != null) {
            int n = xMLOutputStream.getOutputStyle();
            if (n != XMLOutputStream.COMPACT) {
                xMLOutputStream.setOutputStyle(XMLOutputStream.PRETTY);
            }
            xMLOutputStream.writeNewLine();
            Enumeration enumeration = this.attdefs.elements();
            xMLOutputStream.writeIndent();
            xMLOutputStream.writeChars("<!ATTLIST ");
            xMLOutputStream.writeQualifiedName(this.name, null);
            xMLOutputStream.writeChars(" ");
            while (enumeration.hasMoreElements()) {
                xMLOutputStream.writeNewLine();
                AttDef attDef = (AttDef)enumeration.nextElement();
                xMLOutputStream.addIndent(1);
                xMLOutputStream.writeIndent();
                xMLOutputStream.addIndent(-1);
                attDef.save(atom, xMLOutputStream);
            }
            xMLOutputStream.write(62);
            xMLOutputStream.setOutputStyle(n);
        }
        xMLOutputStream.writeNewLine();
    }
}

