/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.DAVExplorer;

import edu.uci.ics.DAVExplorer.ACLChangePrivilegesDialog;
import edu.uci.ics.DAVExplorer.ACLNode;
import edu.uci.ics.DAVExplorer.ACLRequestGenerator;
import edu.uci.ics.DAVExplorer.ACLResponseInterpreter;
import edu.uci.ics.DAVExplorer.GlobalData;
import edu.uci.ics.DAVExplorer.Main;
import edu.uci.ics.DAVExplorer.WebDAVCompletionEvent;
import edu.uci.ics.DAVExplorer.WebDAVCompletionListener;
import edu.uci.ics.DAVExplorer.WebDAVRequestGenerator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ACLAddDialog
extends JDialog
implements ActionListener,
ChangeListener,
ListSelectionListener,
WebDAVCompletionListener {
    protected String hostname;
    protected String resource;
    protected ACLNode node;
    protected JPanel buttonPanel;
    protected JButton okButton;
    protected JButton cancelButton;
    protected JList privilegesList;
    protected JLabel href;
    protected boolean addACL;
    protected boolean changed = false;
    protected boolean waiting;
    protected boolean canceled;
    protected String[] principal;
    protected int principalType;
    protected Vector privileges;
    protected boolean grant;
    protected ACLResponseInterpreter interpreter;

    public ACLAddDialog(String string, String string2) {
        super((Frame)GlobalData.getGlobalData().getMainFrame(), true);
        this.init(string, string2, null);
        this.pack();
        this.setSize(this.getPreferredSize());
        GlobalData.getGlobalData().center(this);
        this.show();
    }

    public ACLAddDialog(String string, String string2, ACLNode aCLNode) {
        super((Frame)GlobalData.getGlobalData().getMainFrame(), true);
        this.init(string, string2, aCLNode);
        this.pack();
        this.setSize(this.getPreferredSize());
        GlobalData.getGlobalData().center(this);
        this.show();
    }

    protected void init(String string, String string2, ACLNode aCLNode) {
        GlobalData.getGlobalData().setCursor(Cursor.getPredefinedCursor(3));
        this.hostname = string2;
        this.resource = string;
        if (aCLNode != null) {
            this.setTitle("Edit ACL");
            this.addACL = false;
            this.principal = new String[2];
            this.principal[0] = new String(aCLNode.getPrincipal()[0]);
            this.principal[1] = new String(aCLNode.getPrincipal()[1]);
            this.principalType = aCLNode.getPrincipalType();
            this.privileges = new Vector(aCLNode.getPrivileges());
            this.grant = aCLNode.getGrant();
            this.node = aCLNode;
        } else {
            this.setTitle("Add ACL");
            this.addACL = true;
        }
        ((Main)GlobalData.getGlobalData().getMainFrame()).addWebDAVCompletionListener(this);
        JLabel jLabel = new JLabel(this.resource, 0);
        jLabel.setForeground(Color.black);
        this.getContentPane().add("North", jLabel);
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(this);
        this.okButton.setMnemonic(79);
        this.okButton.setEnabled(false);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this);
        this.cancelButton.setMnemonic(67);
        this.buttonPanel = new JPanel();
        this.buttonPanel.add(this.okButton);
        this.buttonPanel.add(this.cancelButton);
        this.getRootPane().setDefaultButton(this.cancelButton);
        this.cancelButton.grabFocus();
        this.getContentPane().add("South", this.buttonPanel);
        this.setBackground(Color.lightGray);
        JTabbedPane jTabbedPane = new JTabbedPane();
        JPanel jPanel = this.makePrincipalPanel();
        jTabbedPane.addTab("Principal", jPanel);
        jTabbedPane.setMnemonicAt(0, 80);
        JPanel jPanel2 = this.makePrivilegesPanel();
        jTabbedPane.addTab("Privileges", jPanel2);
        jTabbedPane.setMnemonicAt(1, 82);
        JPanel jPanel3 = this.makeGrantPanel();
        jTabbedPane.addTab("Grant/Deny", jPanel3);
        jTabbedPane.setMnemonicAt(2, 71);
        this.getContentPane().add("Center", jTabbedPane);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ACLAddDialog.this.close(true);
            }
        });
        GlobalData.getGlobalData().resetCursor();
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public String[] getPrincipal() {
        return this.principal;
    }

    public int getPrincipalType() {
        return this.principalType;
    }

    public Vector getPrivileges() {
        return this.privileges;
    }

    public boolean getGrant() {
        return this.grant;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.setChanged();
    }

    protected void setChanged() {
        this.changed = true;
        this.okButton.setEnabled(this.privileges != null);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("OK")) {
            this.close(false);
        } else if (actionEvent.getActionCommand().equals("Change")) {
            ACLChangePrivilegesDialog aCLChangePrivilegesDialog = new ACLChangePrivilegesDialog(this.resource, this.hostname, this.privileges, true);
            if (!aCLChangePrivilegesDialog.isCanceled()) {
                this.privileges = aCLChangePrivilegesDialog.getSelected();
                this.privilegesList.setListData(this.privileges);
                this.setChanged();
            }
        } else if (actionEvent.getActionCommand().equals("Cancel")) {
            this.close(true);
        } else if (actionEvent.getActionCommand().equals("Principal")) {
            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            this.principal = (String[])jComboBox.getSelectedItem();
            this.principalType = 3;
            this.href.setText(this.principal[0]);
            this.setChanged();
        } else if (actionEvent.getActionCommand().equals("Grant")) {
            this.grant = true;
            this.setChanged();
        } else if (actionEvent.getActionCommand().equals("Deny")) {
            this.grant = false;
            this.setChanged();
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completion(WebDAVCompletionEvent webDAVCompletionEvent) {
        if (this.waiting) {
            this.interpreter = (ACLResponseInterpreter)webDAVCompletionEvent.getSource();
            ACLAddDialog aCLAddDialog = this;
            synchronized (aCLAddDialog) {
                this.waiting = false;
                this.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JPanel makePrincipalPanel() {
        Container container;
        Serializable serializable;
        Object object;
        Object object2;
        Vector<String[]> vector = new Vector<String[]>();
        JPanel jPanel = new JPanel(false);
        if (this.addACL) {
            object2 = GlobalData.getGlobalData().getSSL() ? "https://" : "http://";
            object = (ACLRequestGenerator)ACLResponseInterpreter.getGenerator();
            ((WebDAVRequestGenerator)object).setResource((String)object2 + this.resource, null);
            this.waiting = true;
            ((ACLRequestGenerator)object).GetPrincipalCollections();
            try {
                serializable = this;
                synchronized (serializable) {
                    this.wait(30000L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.interpreter != null && (serializable = this.interpreter.getPrincipalCollectionSet()) != null) {
                for (int i = 0; i < ((Vector)serializable).size(); ++i) {
                    this.interpreter = null;
                    ((WebDAVRequestGenerator)object).setResource((String)object2 + this.hostname + (String)((Vector)serializable).get(i), null);
                    this.waiting = true;
                    ((ACLRequestGenerator)object).GetPrincipalNames();
                    try {
                        container = this;
                        synchronized (container) {
                            this.wait(30000L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (this.interpreter == null || this.interpreter.getPrincipalNames() == null) continue;
                    vector.addAll(this.interpreter.getPrincipalNames());
                }
            }
        } else {
            vector.add(this.principal);
        }
        object2 = new JComboBox(vector);
        ((JComboBox)object2).setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                this.setText(((String[])object)[1]);
                this.setBackground(bl ? Color.gray : Color.lightGray);
                this.setForeground(Color.black);
                return this;
            }
        });
        ((JComboBox)object2).setEditable(false);
        ((JComboBox)object2).setActionCommand("Principal");
        ((JComboBox)object2).addActionListener(this);
        this.principal = (String[])((JComboBox)object2).getSelectedItem();
        this.principalType = 3;
        object = new JLabel("Principal: ");
        ((JLabel)object).setHorizontalAlignment(4);
        serializable = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout((LayoutManager)((Object)serializable));
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 1;
        ((GridBagLayout)serializable).setConstraints((Component)object, gridBagConstraints);
        jPanel.add((Component)object);
        gridBagConstraints.gridwidth = 0;
        ((GridBagLayout)serializable).setConstraints((Component)object2, gridBagConstraints);
        jPanel.add((Component)object2);
        container = new JLabel("href: ");
        ((JLabel)container).setHorizontalAlignment(4);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 10;
        ((GridBagLayout)serializable).setConstraints(container, gridBagConstraints);
        jPanel.add(container);
        this.href = new JLabel(this.principal[0]);
        this.href.setHorizontalAlignment(2);
        gridBagConstraints.gridwidth = 0;
        ((GridBagLayout)serializable).setConstraints(this.href, gridBagConstraints);
        jPanel.add(this.href);
        return jPanel;
    }

    protected JPanel makePrivilegesPanel() {
        Vector vector = new Vector();
        JPanel jPanel = new JPanel(false);
        if (!this.addACL) {
            vector.addAll(this.privileges);
        }
        this.privilegesList = new JList(vector);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(this.privilegesList);
        JLabel jLabel = new JLabel("Privileges");
        jLabel.setHorizontalAlignment(0);
        JButton jButton = new JButton("Change");
        jButton.setMnemonic(72);
        jButton.setHorizontalAlignment(0);
        jButton.addActionListener(this);
        jScrollPane.setPreferredSize(new Dimension(10, 10));
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        gridBagLayout.setConstraints(jButton, gridBagConstraints);
        jPanel.add(jButton);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        jPanel.add(jScrollPane);
        return jPanel;
    }

    protected JPanel makeGrantPanel() {
        JPanel jPanel = new JPanel(false);
        ButtonGroup buttonGroup = new ButtonGroup();
        JLabel jLabel = new JLabel("Grant or Deny Privileges");
        jLabel.setHorizontalAlignment(0);
        JRadioButton jRadioButton = new JRadioButton("Grant");
        JRadioButton jRadioButton2 = new JRadioButton("Deny");
        jRadioButton.setMnemonic(84);
        jRadioButton2.setMnemonic(68);
        jRadioButton.setActionCommand("Grant");
        jRadioButton2.setActionCommand("Deny");
        jRadioButton.addActionListener(this);
        jRadioButton2.addActionListener(this);
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        if (this.addACL) {
            this.grant = false;
        }
        if (this.grant) {
            jRadioButton.setSelected(this.grant);
        } else {
            jRadioButton2.setSelected(!this.grant);
        }
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(jRadioButton, gridBagConstraints);
        jPanel.add(jRadioButton);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(jRadioButton2, gridBagConstraints);
        jPanel.add(jRadioButton2);
        return jPanel;
    }

    protected void close(boolean bl) {
        this.setVisible(false);
        this.canceled = bl;
    }
}

