/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.DAVExplorer;

import com.ms.xml.om.Element;
import edu.uci.ics.DAVExplorer.ACLAddDialog;
import edu.uci.ics.DAVExplorer.ACLModel;
import edu.uci.ics.DAVExplorer.ACLNode;
import edu.uci.ics.DAVExplorer.ACLRequestGenerator;
import edu.uci.ics.DAVExplorer.ACLResponseInterpreter;
import edu.uci.ics.DAVExplorer.GlobalData;
import edu.uci.ics.DAVExplorer.Main;
import edu.uci.ics.DAVExplorer.WebDAVCompletionEvent;
import edu.uci.ics.DAVExplorer.WebDAVCompletionListener;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ACLDialog
extends JDialog
implements ActionListener,
ChangeListener,
ListSelectionListener,
WebDAVCompletionListener {
    protected JTable table;
    protected ACLModel model;
    protected JPanel buttonPanel;
    protected JButton addButton;
    protected JButton deleteButton;
    protected JButton saveButton;
    protected JButton closeButton;
    protected String hostname;
    protected String resource;
    protected String locktoken;
    protected boolean changed = false;
    protected boolean waiting;

    public ACLDialog(Element element, String string, String string2, String string3) {
        super(GlobalData.getGlobalData().getMainFrame());
        this.model = new ACLModel(element);
        this.init(this.model, element, string, string2, string3);
        this.pack();
        this.setSize(this.getPreferredSize());
        GlobalData.getGlobalData().center(this);
        this.show();
    }

    protected void init(ACLModel aCLModel, Element element, String string, String string2, String string3) {
        this.setTitle("View/Modify ACLs");
        this.hostname = string2;
        this.resource = string2 + string;
        this.locktoken = string3;
        JLabel jLabel = new JLabel(this.resource, 0);
        jLabel.setForeground(Color.black);
        this.getContentPane().add("North", jLabel);
        this.addButton = new JButton("Add Principal");
        this.addButton.addActionListener(this);
        this.deleteButton = new JButton("Delete Principal");
        this.deleteButton.addActionListener(this);
        this.deleteButton.setEnabled(false);
        this.saveButton = new JButton("Save");
        this.saveButton.addActionListener(this);
        this.closeButton = new JButton("Close");
        this.closeButton.addActionListener(this);
        this.buttonPanel = new JPanel();
        this.buttonPanel.add(this.addButton);
        this.buttonPanel.add(this.deleteButton);
        this.buttonPanel.add(this.saveButton);
        this.buttonPanel.add(this.closeButton);
        this.getRootPane().setDefaultButton(this.closeButton);
        this.closeButton.grabFocus();
        this.saveButton.setEnabled(false);
        this.getContentPane().add("South", this.buttonPanel);
        this.setBackground(Color.lightGray);
        this.table = new JTable(aCLModel);
        this.table.getSelectionModel().addListSelectionListener(this);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(this.table);
        this.getContentPane().add("Center", jScrollPane);
        ((Main)GlobalData.getGlobalData().getMainFrame()).addWebDAVCompletionListener(this);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ACLDialog.this.cancel();
            }
        });
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    ACLDialog.this.handleDoubleClick(mouseEvent);
                }
            }
        };
        this.table.addMouseListener(mouseAdapter);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.setChanged(true);
    }

    public void setChanged(boolean bl) {
        this.changed = bl;
        this.saveButton.setEnabled(this.changed);
        if (!this.changed) {
            this.model.clear();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Add Principal")) {
            this.add();
        } else if (actionEvent.getActionCommand().equals("Delete Principal")) {
            this.remove();
        } else if (actionEvent.getActionCommand().equals("Save")) {
            this.save();
        } else if (actionEvent.getActionCommand().equals("Close")) {
            this.cancel();
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n = this.table.getSelectedRow();
        if (n >= 0) {
            this.deleteButton.setEnabled(!this.model.getRow(n).isInherited() && this.table.getSelectedRow() >= 0);
        }
    }

    public void completion(WebDAVCompletionEvent webDAVCompletionEvent) {
        if (this.waiting && webDAVCompletionEvent.isSuccessful()) {
            this.setChanged(false);
        }
        this.waiting = false;
    }

    public void handleDoubleClick(MouseEvent mouseEvent) {
        ACLAddDialog aCLAddDialog;
        ACLNode aCLNode;
        GlobalData.methodEnter("handleDoubleClick", "ACLDialog", GlobalData.getGlobalData().getDebugFileView());
        Point point = mouseEvent.getPoint();
        int n = this.table.columnAtPoint(point);
        int n2 = this.table.rowAtPoint(point);
        int n3 = this.table.convertColumnIndexToView(0);
        if (n3 == -1) {
            n3 = 1;
        }
        if (n == n3 && n2 != -1 && !(aCLNode = this.model.getRow(n2)).isInherited() && !(aCLAddDialog = new ACLAddDialog(this.resource, this.hostname, aCLNode)).isCanceled()) {
            Vector vector = (Vector)aCLNode.getPrivileges().clone();
            Vector vector2 = aCLAddDialog.getPrivileges();
            vector.removeAll(vector2);
            if (!vector.isEmpty()) {
                aCLNode.setPrincipalType(aCLAddDialog.getPrincipalType());
                aCLNode.setPrivileges(aCLAddDialog.getPrivileges());
                this.setChanged(true);
            }
            if (aCLAddDialog.getGrant() != aCLNode.getGrant()) {
                aCLNode.setGrant(aCLAddDialog.getGrant());
                this.setChanged(true);
            }
        }
    }

    public void add() {
        ACLAddDialog aCLAddDialog = new ACLAddDialog(this.resource, this.hostname);
        if (!aCLAddDialog.isCanceled()) {
            this.model.addRow(aCLAddDialog.getPrincipal(), aCLAddDialog.getPrincipalType(), aCLAddDialog.getPrivileges(), aCLAddDialog.getGrant());
            this.setChanged(true);
        }
    }

    public void remove() {
        String string = "Delete Principal";
        String string2 = "Do you really want to delete the selected principal?";
        if (this.ConfirmationDialog(string, string2)) {
            this.model.removeRow(this.table.getSelectedRow());
            this.table.updateUI();
            this.setChanged(true);
        }
    }

    public void save() {
        Vector<ACLNode> vector = new Vector<ACLNode>();
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            ACLNode aCLNode = this.model.getRow(i);
            if (aCLNode.isInherited()) continue;
            vector.add(aCLNode);
        }
        ACLRequestGenerator aCLRequestGenerator = (ACLRequestGenerator)ACLResponseInterpreter.getGenerator();
        aCLRequestGenerator.GenerateACL(vector);
        this.waiting = true;
        aCLRequestGenerator.execute();
    }

    public void cancel() {
        this.setVisible(false);
        this.dispose();
    }

    protected boolean ConfirmationDialog(String string, String string2) {
        int n = JOptionPane.showConfirmDialog(GlobalData.getGlobalData().getMainFrame(), string2, string, 0);
        return n == 0;
    }
}

