/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.DAVExplorer;

import edu.uci.ics.DAVExplorer.WebDAVProp;
import java.util.Enumeration;
import java.util.Vector;

public class PropNode {
    private Vector children = new Vector();
    private Vector removedChildren = new Vector();
    private String tag;
    private String ns;
    private String value;
    private boolean modified;
    private PropNode parent;

    public PropNode(String string, String string2, String string3, boolean bl) {
        this.tag = string;
        this.ns = string2;
        this.value = string3;
        this.modified = bl;
    }

    public PropNode(String string, String string2, String string3) {
        this.tag = string;
        this.ns = string2;
        this.value = string3;
        this.modified = false;
    }

    public String getTag() {
        return this.tag;
    }

    public String getNamespace() {
        return this.ns;
    }

    public void setNamespace(String string) {
        this.ns = string;
        this.modified = true;
    }

    public String getValue() {
        if (this.value == null) {
            return "";
        }
        return this.value;
    }

    public void setValue(String string) {
        this.value = string;
        this.modified = true;
    }

    public String toString() {
        return this.getTag();
    }

    public PropNode getParent() {
        return this.parent;
    }

    public void setParent(PropNode propNode) {
        this.parent = propNode;
    }

    public void addChild(Object object) {
        this.children.add(object);
    }

    public void removeChild(Object object) {
        this.children.remove(object);
        this.removedChildren.add(object);
    }

    public boolean isModified() {
        return this.modified;
    }

    public Object[] getChildren() {
        return this.children.toArray();
    }

    public Object[] getRemovedChildren() {
        return this.removedChildren.toArray();
    }

    public void clear() {
        this.modified = false;
        this.removedChildren.clear();
    }

    public boolean isDAVProp() {
        if (this.ns != null && this.ns.equals("DAV:")) {
            Enumeration enumeration = WebDAVProp.getDavProps();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (this.tag.equals(string)) {
                    return true;
                }
                if (this.parent == null || !this.parent.isDAVProp()) continue;
                return true;
            }
        }
        return false;
    }
}

