/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.DAVExplorer;

import edu.uci.ics.DAVExplorer.GlobalData;
import edu.uci.ics.DAVExplorer.URIContainer;
import edu.uci.ics.DAVExplorer.WebDAVURIBoxListener;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class URIBox
extends JPanel
implements ActionListener {
    private Vector URIBoxListener;
    private JComboBox urlField;
    private JLabel prefix;
    private JButton okButton;

    public URIBox() {
        JPanel jPanel = new JPanel();
        this.okButton = new JButton(GlobalData.getGlobalData().getImageIcon("connect.gif", "Connect"));
        this.okButton.setActionCommand("Connect");
        this.okButton.addActionListener(this);
        this.okButton.setToolTipText("Connect");
        jPanel.add(this.okButton);
        this.urlField = new JComboBox((Vector)URIContainer.getInstance().getURIs().clone());
        this.urlField.setEditable(true);
        Dimension dimension = this.urlField.getPreferredSize();
        dimension.width = 500;
        this.urlField.setPreferredSize(dimension);
        this.urlField.addActionListener(new EnterPressedListener());
        this.prefix = new JLabel();
        if (GlobalData.getGlobalData().getSSL()) {
            this.prefix.setText("https://");
        } else {
            this.prefix.setText("http://");
        }
        this.prefix.setHorizontalAlignment(4);
        this.prefix.setForeground(Color.black);
        jPanel.add(this.prefix);
        jPanel.add(this.urlField);
        this.add("Center", jPanel);
        this.URIBoxListener = new Vector();
        if (GlobalData.getGlobalData().hideURIBox()) {
            super.setVisible(false);
        }
    }

    public void invalidate() {
        if (GlobalData.getGlobalData().getSSL()) {
            this.prefix.setText("https://");
        } else {
            this.prefix.setText("http://");
        }
        super.invalidate();
    }

    private ImageIcon loadImageIcon(String string, String string2) {
        try {
            return new ImageIcon(this.getClass().getResource("icons/" + string), string2);
        }
        catch (Exception exception) {
            GlobalData.getGlobalData().errorMsg("Toolbar:\nIcon load error.");
            return null;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.notifyListener();
    }

    public void setText(String string) {
        this.urlField.setSelectedItem(string);
    }

    public String getText() {
        return this.urlField.getSelectedItem().toString().trim();
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.URIBoxListener.addElement(actionListener);
    }

    public void setVisible(boolean bl) {
        if (GlobalData.getGlobalData().hideURIBox()) {
            return;
        }
        super.setVisible(bl);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.URIBoxListener.removeElement(actionListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyListener() {
        Vector vector;
        ActionEvent actionEvent = new ActionEvent(this, 1001, this.getText());
        URIBox uRIBox = this;
        synchronized (uRIBox) {
            vector = (Vector)this.URIBoxListener.clone();
        }
        URIContainer.getInstance().addURI(this.getText());
        for (int i = 0; i < vector.size(); ++i) {
            WebDAVURIBoxListener webDAVURIBoxListener = (WebDAVURIBoxListener)vector.elementAt(i);
            webDAVURIBoxListener.actionPerformed(actionEvent);
        }
    }

    class EnterPressedListener
    implements ActionListener {
        EnterPressedListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getActionCommand().compareToIgnoreCase("comboBoxChanged") != 0) {
                URIBox.this.notifyListener();
            }
        }
    }
}

