/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.DAVExplorer;

import edu.uci.ics.DAVExplorer.DataNode;
import edu.uci.ics.DAVExplorer.DeltaVDataNode;
import edu.uci.ics.DAVExplorer.GlobalData;
import edu.uci.ics.DAVExplorer.TableSorter;
import edu.uci.ics.DAVExplorer.ViewSelectionEvent;
import edu.uci.ics.DAVExplorer.ViewSelectionListener;
import edu.uci.ics.DAVExplorer.WebDAVTreeNode;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ImageIcon;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.border.BevelBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class WebDAVFileView
implements ViewSelectionListener,
ActionListener {
    final String[] colNames = new String[]{" ", "Lock", "Versions", "Name", "Display", "Type", "Size", "Last Modified"};
    private Vector data = new Vector();
    JTable table;
    JScrollPane scrPane;
    TableModel dataModel;
    ListSelectionModel selectionModel = new DefaultListSelectionModel();
    TableSorter sorter;
    Color headerColor;
    Vector selListeners = new Vector();
    Vector renameListeners = new Vector();
    Vector displayLockListeners = new Vector();
    Vector displayVersionListeners = new Vector();
    ImageIcon FILE_ICON;
    ImageIcon LOCK_ICON;
    ImageIcon UNLOCK_ICON;
    ImageIcon FOLDER_ICON;
    ImageIcon VERSION_ICON;
    ImageIcon NOVERSION_ICON;
    WebDAVTreeNode parentNode;
    String parentPath = new String();
    String selectedResource;
    int selectedRow = -1;
    int pressRow;
    int releaseRow;

    public WebDAVFileView() {
        GlobalData.methodEnter("Constructor", "WebDAVFileView", GlobalData.getGlobalData().getDebugFileView());
        this.FOLDER_ICON = GlobalData.getGlobalData().getImageIcon("TreeClosed.gif", "");
        this.FILE_ICON = GlobalData.getGlobalData().getImageIcon("resource.gif", "");
        this.LOCK_ICON = GlobalData.getGlobalData().getImageIcon("lck.gif", "");
        this.UNLOCK_ICON = GlobalData.getGlobalData().getImageIcon("unlck.gif", "");
        this.VERSION_ICON = GlobalData.getGlobalData().getImageIcon("version.gif", "");
        this.NOVERSION_ICON = GlobalData.getGlobalData().getImageIcon("noversion.gif", "");
        this.dataModel = new AbstractTableModel(){

            public int getColumnCount() {
                GlobalData.methodEnter("getColumnCount", "WebDAVFileView::AbstractTableModel", GlobalData.getGlobalData().getDebugFileView());
                return WebDAVFileView.this.colNames.length;
            }

            public int getRowCount() {
                GlobalData.methodEnter("getRowCount", "WebDAVFileView::AbstractTableModel", GlobalData.getGlobalData().getDebugFileView());
                return WebDAVFileView.this.data.size();
            }

            public Object getValueAt(int n, int n2) {
                GlobalData.methodEnter("getValueAt", "WebDAVFileView::AbstractTableModel", GlobalData.getGlobalData().getDebugFileView());
                if (WebDAVFileView.this.data.size() == 0) {
                    return null;
                }
                return ((Vector)WebDAVFileView.this.data.elementAt(n)).elementAt(n2);
            }

            public String getColumnName(int n) {
                GlobalData.methodEnter("getColumnName", "WebDAVFileView::AbstractTableModel", GlobalData.getGlobalData().getDebugFileView());
                return WebDAVFileView.this.colNames[n];
            }

            public Class getColumnClass(int n) {
                GlobalData.methodEnter("getColumnClass", "WebDAVFileView::AbstractTableModel", GlobalData.getGlobalData().getDebugFileView());
                if (WebDAVFileView.this.data.size() == 0) {
                    return null;
                }
                Object object = null;
                int n2 = 0;
                while (object == null && n2 < WebDAVFileView.this.data.size() && (object = this.getValueAt(n2++, n)) == null) {
                }
                if (object == null) {
                    return null;
                }
                return object.getClass();
            }

            public boolean isCellEditable(int n, int n2) {
                GlobalData.methodEnter("isCellEditable", "WebDAVFileView::AbstractTableModel", GlobalData.getGlobalData().getDebugFileView());
                return n2 == 3;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void setValueAt(Object object, int n, int n2) {
                GlobalData.methodEnter("setValueAt", "WebDAVFileView::AbstractTableModel", GlobalData.getGlobalData().getDebugFileView());
                if (n2 == 3) {
                    String string = null;
                    try {
                        int n3 = WebDAVFileView.this.table.convertColumnIndexToView(n2);
                        if (n3 == -1) {
                            n3 = n2;
                        }
                        string = (String)WebDAVFileView.this.table.getValueAt(WebDAVFileView.this.selectedRow, n3);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (string != null) {
                        Vector vector;
                        if (!WebDAVFileView.this.parentPath.startsWith("http://") && !WebDAVFileView.this.parentPath.startsWith("https://")) {
                            return;
                        }
                        ((Vector)WebDAVFileView.this.data.elementAt(n)).setElementAt(object, n2);
                        if (object.equals(WebDAVFileView.this.selectedResource)) {
                            return;
                        }
                        Serializable serializable = this;
                        synchronized (serializable) {
                            vector = (Vector)WebDAVFileView.this.renameListeners.clone();
                        }
                        serializable = new ActionEvent(this, 0, object.toString());
                        for (int i = 0; i < vector.size(); ++i) {
                            ActionListener actionListener = (ActionListener)vector.elementAt(i);
                            actionListener.actionPerformed((ActionEvent)serializable);
                        }
                        return;
                    }
                }
                try {
                    ((Vector)WebDAVFileView.this.data.elementAt(n)).setElementAt(object, n2);
                }
                catch (Exception exception) {
                    System.out.println(exception);
                }
            }
        };
        this.sorter = new TableSorter(this.dataModel);
        this.table = new JTable(this.sorter);
        this.sorter.addMouseListenerToHeaderInTable(this.table);
        this.scrPane = new JScrollPane(this.table);
        this.scrPane.setPreferredSize(new Dimension(750, 400));
        this.scrPane.setBorder(new BevelBorder(1));
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    WebDAVFileView.this.handleDoubleClick(mouseEvent);
                }
            }

            public void mousePressed(MouseEvent mouseEvent) {
                WebDAVFileView.this.handlePress(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                WebDAVFileView.this.handleRelease(mouseEvent);
            }
        };
        this.table.addMouseListener(mouseAdapter);
        this.setupTable(this.table);
        this.table.updateUI();
    }

    public String getParentPath() {
        GlobalData.methodEnter("getParentPath", "WebDAVFileView", GlobalData.getGlobalData().getDebugFileView());
        return this.parentPath;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.resetName();
    }

    public synchronized void selectionChanged(ViewSelectionEvent viewSelectionEvent) {
        GlobalData.methodEnter("selectionChanged", "WebDAVFileView", GlobalData.getGlobalData().getDebugFileView());
        this.table.clearSelection();
        this.clearTable();
        this.selectedRow = -1;
        this.parentNode = (WebDAVTreeNode)viewSelectionEvent.getNode();
        TreePath treePath = viewSelectionEvent.getPath();
        Object[] objectArray = treePath.getPath();
        this.parentPath = "";
        if (objectArray.length > 0) {
            for (int i = 1; i < objectArray.length; ++i) {
                this.parentPath = this.parentPath + objectArray[i].toString() + "/";
            }
        }
        if (this.table.getRowCount() != 0) {
            return;
        }
        TreePath treePath2 = viewSelectionEvent.getPath();
        WebDAVTreeNode webDAVTreeNode = (WebDAVTreeNode)treePath2.getLastPathComponent();
        WebDAVTreeNode webDAVTreeNode2 = (WebDAVTreeNode)webDAVTreeNode.getParent();
        GlobalData.getGlobalData().setCursor(Cursor.getPredefinedCursor(3));
        this.addDirToTable(webDAVTreeNode);
        DataNode dataNode = webDAVTreeNode.getDataNode();
        if (dataNode == null) {
            this.table.updateUI();
            GlobalData.getGlobalData().resetCursor();
            return;
        }
        Vector vector = dataNode.getSubNodes();
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                DataNode dataNode2 = (DataNode)vector.elementAt(i);
            }
            this.addFileToTable(vector);
        }
        GlobalData.getGlobalData().resetCursor();
    }

    protected void addDirToTable(WebDAVTreeNode webDAVTreeNode) {
        GlobalData.methodEnter("addDirToTable", "WebDAVFileView", GlobalData.getGlobalData().getDebugFileView());
        int n = webDAVTreeNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            WebDAVTreeNode webDAVTreeNode2 = (WebDAVTreeNode)webDAVTreeNode.getChildAt(i);
            DataNode dataNode = webDAVTreeNode2.getDataNode();
            if (dataNode == null) continue;
            Object[] objectArray = new Object[8];
            objectArray[2] = dataNode instanceof DeltaVDataNode ? new Boolean(((DeltaVDataNode)dataNode).hasVersions()) : "false";
            objectArray[0] = "true";
            objectArray[1] = new Boolean(dataNode.isLocked());
            objectArray[3] = dataNode.getName();
            objectArray[4] = dataNode.getDisplay();
            objectArray[5] = dataNode.getType();
            objectArray[6] = new Long(dataNode.getSize());
            objectArray[7] = dataNode.getDate();
            this.addRow(objectArray);
        }
        this.fireTableModuleEvent();
    }

    protected void addFileToTable(Vector vector) {
        GlobalData.methodEnter("addFileToTable", "WebDAVFileView", GlobalData.getGlobalData().getDebugFileView());
        for (int i = 0; i < vector.size(); ++i) {
            DataNode dataNode = (DataNode)vector.elementAt(i);
            Object[] objectArray = new Object[8];
            objectArray[2] = dataNode instanceof DeltaVDataNode ? new Boolean(((DeltaVDataNode)dataNode).hasVersions()) : "false";
            objectArray[0] = "false";
            objectArray[1] = new Boolean(dataNode.isLocked());
            objectArray[3] = dataNode.getName();
            objectArray[4] = dataNode.getDisplay();
            objectArray[5] = dataNode.getType();
            objectArray[6] = new Long(dataNode.getSize());
            objectArray[7] = dataNode.getDate();
            this.addRow(objectArray);
        }
        this.fireTableModuleEvent();
    }

    public WebDAVTreeNode getParentNode() {
        GlobalData.methodEnter("getParentNode", "WebDAVFileView", GlobalData.getGlobalData().getDebugFileView());
        return this.parentNode;
    }

    protected String getParentPathString() {
        GlobalData.methodEnter("getParentPathString", "WebDAVFileView", GlobalData.getGlobalData().getDebugFileView());
        String string = "";
        if (this.parentNode == null) {
            return string;
        }
        TreePath treePath = new TreePath(this.parentNode.getPath());
        if (treePath.getPathCount() > 1) {
            for (int i = 1; i < treePath.getPathCount(); ++i) {
                if ((string = string + treePath.getPathComponent(i)).startsWith("http://") || string.startsWith("https://")) {
                    string = string + "/";
                    continue;
                }
                if (string.endsWith(String.valueOf(File.separatorChar))) continue;
                string = string + File.separatorChar;
            }
        }
        return string;
    }

    public String getOldSelectedResource() {
        GlobalData.methodEnter("getOldSelectedResource", "WebDAVFileView", GlobalData.getGlobalData().getDebugFileView());
        return this.getParentPathString() + this.selectedResource;
    }

    public WebDAVTreeNode getSelectedCollection() {
        GlobalData.methodEnter("getSelectedCollection", "WebDAVFileView", GlobalData.getGlobalData().getDebugFileView());
        try {
            boolean bl;
            if (this.selectedRow < 0) {
                return null;
            }
            int n = this.table.convertColumnIndexToView(0);
            if (n == -1) {
                n = 0;
            }
            if (bl = new Boolean(this.table.getValueAt(this.selectedRow, n).toString()).booleanValue()) {
                boolean bl2 = false;
                WebDAVTreeNode webDAVTreeNode = null;
                Enumeration<TreeNode> enumeration = this.parentNode.children();
                while (!bl2 && enumeration.hasMoreElements()) {
                    webDAVTreeNode = (WebDAVTreeNode)enumeration.nextElement();
                    String string = (String)webDAVTreeNode.getUserObject();
                    n = this.table.convertColumnIndexToView(3);
                    if (n == -1) {
                        n = 3;
                    }
                    if (!string.equals(this.table.getValueAt(this.selectedRow, n))) continue;
                    bl2 = true;
                }
                if (bl2) {
                    return webDAVTreeNode;
                }
                return null;
            }
            return null;
        }
        catch (Exception exception) {
            System.out.println("Exception getSelectedCollection");
            exception.printStackTrace();
            return null;
        }
    }

    public boolean isSelectedLocked() {
        GlobalData.methodEnter("isSelectedLocked", "WebDAVFileView", GlobalData.getGlobalData().getDebugFileView());
        int n = this.table.convertColumnIndexToView(1);
        if (n == -1) {
            n = 1;
        }
        boolean bl = new Boolean(this.table.getValueAt(this.selectedRow, n).toString());
        return bl;
    }

    public String getSelectedLockToken() {
        GlobalData.methodEnter("getSelectedLockToken", "WebDAVFileView", GlobalData.getGlobalData().getDebugFileView());
        if (this.selectedRow < 0) {
            return null;
        }
        WebDAVTreeNode webDAVTreeNode = this.getSelectedCollection();
        if (webDAVTreeNode != null) {
            DataNode dataNode = webDAVTreeNode.getDataNode();
            return dataNode.getLockToken();
        }
        DataNode dataNode = this.parentNode.getDataNode();
        boolean bl = false;
        Vector vector = dataNode.getSubNodes();
        String string = null;
        for (int i = 0; i < vector.size() && !bl; ++i) {
            DataNode dataNode2 = (DataNode)vector.elementAt(i);
            String string2 = dataNode2.getName();
            if (!this.selectedResource.equals(string2)) continue;
            bl = true;
            string = dataNode2.getLockToken();
        }
        if (string == null) {
            System.out.println("Error: getSelectedCollection, dataNode not found for selected item");
            return null;
        }
        return string;
    }

    public boolean hasSelected() {
        GlobalData.methodEnter("hasSelected", "WebDAVFileView", GlobalData.getGlobalData().getDebugFileView());
        return this.selectedRow >= 0;
    }

    public String getSelected() {
        GlobalData.methodEnter("getSelected", "WebDAVFileView", GlobalData.getGlobalData().getDebugFileView());
        String string = "";
        if (this.selectedRow >= 0) {
            boolean bl;
            TreePath treePath = new TreePath(this.parentNode.getPath());
            int n = this.table.convertColumnIndexToView(3);
            if (n == -1) {
                n = 3;
            }
            string = this.getParentPathString() + (String)this.table.getValueAt(this.selectedRow, n);
            n = this.table.convertColumnIndexToView(0);
            if (n == -1) {
                n = 0;
            }
            if (bl = new Boolean(this.table.getValueAt(this.selectedRow, n).toString()).booleanValue()) {
                return string + "/";
            }
            return string;
        }
        return this.getParentPathString();
    }

    public void resetName() {
        GlobalData.methodEnter("resetName", "WebDAVFileView", GlobalData.getGlobalData().getDebugFileView());
        int n = this.table.convertColumnIndexToView(3);
        if (n == -1) {
            n = 3;
        }
        this.table.setValueAt(this.selectedResource, this.selectedRow, n);
        this.update();
    }

    public String getName() {
        GlobalData.methodEnter("getName", "WebDAVFileView", GlobalData.getGlobalData().getDebugFileView());
        return this.selectedResource;
    }

    public synchronized void setLock() {
        GlobalData.methodEnter("setLock", "WebDAVFileView", GlobalData.getGlobalData().getDebugFileView());
        int n = this.selectedRow;
        try {
            int n2 = this.table.convertColumnIndexToView(1);
            if (n2 == -1) {
                n2 = 1;
            }
            this.table.setValueAt(new Boolean("true"), n, n2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.update();
    }

    public synchronized void resetLock() {
        GlobalData.methodEnter("resetLock", "WebDAVFileView", GlobalData.getGlobalData().getDebugFileView());
        int n = this.selectedRow;
        try {
            int n2 = this.table.convertColumnIndexToView(1);
            if (n2 == -1) {
                n2 = 1;
            }
            this.table.setValueAt(new Boolean("false"), n, n2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.update();
    }

    public synchronized void update() {
        GlobalData.methodEnter("update", "WebDAVFileView", GlobalData.getGlobalData().getDebugFileView());
        this.table.clearSelection();
        this.updateTable(this.data);
    }

    public void setupTable(JTable jTable) {
        GlobalData.methodEnter("setupTable", "WebDAVFileView", GlobalData.getGlobalData().getDebugFileView());
        jTable.clearSelection();
        jTable.setSelectionModel(this.selectionModel);
        this.selectionModel.addListSelectionListener(new SelectionChangeListener());
        jTable.setSelectionMode(0);
        jTable.setIntercellSpacing(new Dimension(0, 0));
        jTable.setCellSelectionEnabled(false);
        jTable.setColumnSelectionAllowed(false);
        jTable.setShowGrid(false);
        TableColumn tableColumn = jTable.getColumn(this.colNames[0]);
        tableColumn.setMaxWidth(25);
        tableColumn.setMinWidth(25);
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer(){

            public void setValue(Object object) {
                try {
                    boolean bl = new Boolean(object.toString());
                    if (bl) {
                        this.setIcon(WebDAVFileView.this.FOLDER_ICON);
                    } else {
                        this.setIcon(WebDAVFileView.this.FILE_ICON);
                    }
                    this.setHorizontalAlignment(0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        tableColumn.setCellRenderer(defaultTableCellRenderer);
        tableColumn = jTable.getColumn(this.colNames[1]);
        tableColumn.setMaxWidth(30);
        tableColumn.setMinWidth(25);
        DefaultTableCellRenderer defaultTableCellRenderer2 = new DefaultTableCellRenderer(){

            public void setValue(Object object) {
                try {
                    boolean bl = new Boolean(object.toString());
                    if (bl) {
                        this.setIcon(WebDAVFileView.this.LOCK_ICON);
                    } else {
                        this.setIcon(WebDAVFileView.this.UNLOCK_ICON);
                    }
                    this.setHorizontalAlignment(0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        tableColumn.setCellRenderer(defaultTableCellRenderer2);
        tableColumn = jTable.getColumn(this.colNames[2]);
        tableColumn.setMaxWidth(50);
        tableColumn.setMinWidth(25);
        DefaultTableCellRenderer defaultTableCellRenderer3 = new DefaultTableCellRenderer(){

            public void setValue(Object object) {
                try {
                    boolean bl = new Boolean(object.toString());
                    if (bl) {
                        this.setIcon(WebDAVFileView.this.VERSION_ICON);
                    } else {
                        this.setIcon(WebDAVFileView.this.NOVERSION_ICON);
                    }
                    this.setHorizontalAlignment(0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        tableColumn.setCellRenderer(defaultTableCellRenderer3);
        tableColumn = jTable.getColumn(this.colNames[3]);
        tableColumn.setMinWidth(100);
        tableColumn = jTable.getColumn(this.colNames[4]);
        tableColumn.setMinWidth(100);
        tableColumn = jTable.getColumn(this.colNames[5]);
        tableColumn.setMinWidth(100);
        DefaultTableCellRenderer defaultTableCellRenderer4 = new DefaultTableCellRenderer();
        defaultTableCellRenderer4.setHorizontalAlignment(0);
        tableColumn.setCellRenderer(defaultTableCellRenderer4);
        tableColumn = jTable.getColumn(this.colNames[6]);
        tableColumn.setMinWidth(50);
        defaultTableCellRenderer4 = new DefaultTableCellRenderer();
        defaultTableCellRenderer4.setHorizontalAlignment(4);
        tableColumn.setCellRenderer(defaultTableCellRenderer4);
        tableColumn = jTable.getColumn(this.colNames[7]);
        tableColumn.setMinWidth(210);
        defaultTableCellRenderer4 = new DefaultTableCellRenderer();
        defaultTableCellRenderer4.setHorizontalAlignment(4);
        tableColumn.setCellRenderer(defaultTableCellRenderer4);
    }

    public JScrollPane getScrollPane() {
        GlobalData.methodEnter("getScrollPane", "WebDAVFileView", GlobalData.getGlobalData().getDebugFileView());
        return this.scrPane;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireTableModuleEvent() {
        GlobalData.methodEnter("fireTableModuleEvent", "WebDAVFileView", GlobalData.getGlobalData().getDebugFileView());
        TableModelEvent tableModelEvent = new TableModelEvent(this.dataModel);
        WebDAVFileView webDAVFileView = this;
        synchronized (webDAVFileView) {
            if (this.sorter != null) {
                this.sorter.tableChanged(tableModelEvent);
            }
        }
    }

    public void updateTable(Vector vector) {
        GlobalData.methodEnter("updateTable", "WebDAVFileView", GlobalData.getGlobalData().getDebugFileView());
        this.data = vector;
        this.fireTableModuleEvent();
    }

    private void addRow(Object[] objectArray) {
        GlobalData.methodEnter("addRow", "WebDAVFileView", GlobalData.getGlobalData().getDebugFileView());
        Vector<Object> vector = new Vector<Object>();
        int n = this.table.getColumnCount();
        for (int i = 0; i < n; ++i) {
            vector.addElement(objectArray[i]);
        }
        this.data.addElement(vector);
    }

    private void removeRow(int n) {
        GlobalData.methodEnter("removeRow", "WebDAVFileView", GlobalData.getGlobalData().getDebugFileView());
        this.data.removeElementAt(n);
        this.fireTableModuleEvent();
    }

    private int getColumn(String string) {
        GlobalData.methodEnter("getColumne", "WebDAVFileView", GlobalData.getGlobalData().getDebugFileView());
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            if (!this.table.getColumnName(i).equalsIgnoreCase(string)) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearTable() {
        GlobalData.methodEnter("clearTable", "WebDAVFileView", GlobalData.getGlobalData().getDebugFileView());
        this.updateTable(new Vector());
        this.fireTableModuleEvent();
        WebDAVFileView webDAVFileView = this;
        synchronized (webDAVFileView) {
            if (this.sorter != null) {
                this.sorter.sortByColumn(3, true);
            }
        }
        this.selectedRow = -1;
    }

    public synchronized void addViewSelectionListener(ViewSelectionListener viewSelectionListener) {
        GlobalData.methodEnter("addViewSelectionListener", "WebDAVFileView", GlobalData.getGlobalData().getDebugFileView());
        this.selListeners.addElement(viewSelectionListener);
    }

    public synchronized void removeViewSelectionListener(ViewSelectionListener viewSelectionListener) {
        GlobalData.methodEnter("removeViewSelectionListener", "WebDAVFileView", GlobalData.getGlobalData().getDebugFileView());
        this.selListeners.removeElement(viewSelectionListener);
    }

    public synchronized void addRenameListener(ActionListener actionListener) {
        GlobalData.methodEnter("addRenameListener", "WebDAVFileView", GlobalData.getGlobalData().getDebugFileView());
        this.renameListeners.addElement(actionListener);
    }

    public synchronized void removeRenameListener(ActionListener actionListener) {
        GlobalData.methodEnter("removeRenameListener", "WebDAVFileView", GlobalData.getGlobalData().getDebugFileView());
        this.renameListeners.removeElement(actionListener);
    }

    public synchronized void addDisplayLockListener(ActionListener actionListener) {
        GlobalData.methodEnter("addDisplayLockListener", "WebDAVFileView", GlobalData.getGlobalData().getDebugFileView());
        this.displayLockListeners.addElement(actionListener);
    }

    public synchronized void removeDisplayLockListener(ActionListener actionListener) {
        GlobalData.methodEnter("removeDisplayLockListener", "WebDAVFileView", GlobalData.getGlobalData().getDebugFileView());
        this.displayLockListeners.removeElement(actionListener);
    }

    public synchronized void addDisplayVersionListener(ActionListener actionListener) {
        GlobalData.methodEnter("addDisplayVersionListener", "WebDAVFileView", GlobalData.getGlobalData().getDebugFileView());
        this.displayVersionListeners.addElement(actionListener);
    }

    public synchronized void removeDisplayVersionListener(ActionListener actionListener) {
        GlobalData.methodEnter("removeDisplayVersionListener", "WebDAVFileView", GlobalData.getGlobalData().getDebugFileView());
        this.displayVersionListeners.removeElement(actionListener);
    }

    public void handlePress(MouseEvent mouseEvent) {
        GlobalData.methodEnter("handlePress", "WebDAVFileView", GlobalData.getGlobalData().getDebugFileView());
        Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
        this.selectedRow = this.pressRow = this.table.rowAtPoint(point);
    }

    public void handleRelease(MouseEvent mouseEvent) {
        GlobalData.methodEnter("handleRelease", "WebDAVFileView", GlobalData.getGlobalData().getDebugFileView());
        Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
        this.selectedRow = this.releaseRow = this.table.rowAtPoint(point);
        if (this.pressRow == -1 || this.releaseRow == -1 || this.pressRow != this.releaseRow) {
            // empty if block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayLock() {
        Vector vector;
        GlobalData.methodEnter("displayLock", "WebDAVFileView", GlobalData.getGlobalData().getDebugFileView());
        Object object = this;
        synchronized (object) {
            vector = (Vector)this.displayLockListeners.clone();
        }
        object = new ActionEvent(this, 0, this.getParentPathString() + this.selectedResource);
        for (int i = 0; i < vector.size(); ++i) {
            ActionListener actionListener = (ActionListener)vector.elementAt(i);
            actionListener.actionPerformed((ActionEvent)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayVersions() {
        Vector vector;
        GlobalData.methodEnter("displayVersions", "WebDAVFileView", GlobalData.getGlobalData().getDebugFileView());
        Object object = this;
        synchronized (object) {
            vector = (Vector)this.displayVersionListeners.clone();
        }
        object = new ActionEvent(this, 0, this.getParentPathString() + this.selectedResource);
        for (int i = 0; i < vector.size(); ++i) {
            ActionListener actionListener = (ActionListener)vector.elementAt(i);
            actionListener.actionPerformed((ActionEvent)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleDoubleClick(MouseEvent mouseEvent) {
        Serializable serializable;
        int n;
        GlobalData.methodEnter("handleDoubleClick", "WebDAVFileView", GlobalData.getGlobalData().getDebugFileView());
        Point point = mouseEvent.getPoint();
        int n2 = this.table.columnAtPoint(point);
        int n3 = this.table.rowAtPoint(point);
        int n4 = this.table.convertColumnIndexToView(1);
        if (n4 == -1) {
            n4 = 1;
        }
        if ((n = this.table.convertColumnIndexToView(2)) == -1) {
            n = 2;
        }
        if (n2 == n4 && n3 != -1) {
            serializable = null;
            try {
                serializable = (Boolean)this.table.getValueAt(n3, n2);
            }
            catch (Exception exception) {
                System.out.println(exception);
                return;
            }
            if (serializable != null && ((Boolean)serializable).booleanValue()) {
                this.displayLock();
                return;
            }
        } else if (n2 == n && n3 != -1) {
            serializable = null;
            try {
                serializable = (Boolean)this.table.getValueAt(n3, n2);
            }
            catch (Exception exception) {
                System.out.println(exception);
                return;
            }
            if (serializable != null && ((Boolean)serializable).booleanValue()) {
                this.displayVersions();
                return;
            }
        }
        if (this.selListeners == null) {
            return;
        }
        WebDAVFileView webDAVFileView = this;
        synchronized (webDAVFileView) {
            serializable = (Vector)this.selListeners.clone();
        }
        int n5 = this.selectionModel.getMaxSelectionIndex();
        if (n5 != -1) {
            if (this.sorter == null) {
                return;
            }
            int n6 = this.sorter.getTrueRow(n5);
            if (n6 == -1) {
                return;
            }
            if (n6 > this.parentNode.getChildCount() - 1) {
                return;
            }
            WebDAVTreeNode webDAVTreeNode = (WebDAVTreeNode)this.parentNode.getChildAt(n6);
            TreePath treePath = new TreePath(webDAVTreeNode.getPath());
            ViewSelectionEvent viewSelectionEvent = new ViewSelectionEvent(this, webDAVTreeNode, treePath);
            for (int i = 0; i < ((Vector)serializable).size(); ++i) {
                ViewSelectionListener viewSelectionListener = (ViewSelectionListener)((Vector)serializable).elementAt(i);
                viewSelectionListener.selectionChanged(viewSelectionEvent);
            }
        }
    }

    class SelectionChangeListener
    implements ListSelectionListener {
        SelectionChangeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            Vector vector;
            GlobalData.methodEnter("valueChanged", "WebDAVFileView::SelectionChangeListener", GlobalData.getGlobalData().getDebugFileView());
            SelectionChangeListener selectionChangeListener = this;
            synchronized (selectionChangeListener) {
                vector = (Vector)WebDAVFileView.this.selListeners.clone();
            }
            int n = WebDAVFileView.this.selectionModel.getMaxSelectionIndex();
            if (n >= 0 && WebDAVFileView.this.data.size() > 0) {
                int n2 = WebDAVFileView.this.table.convertColumnIndexToView(3);
                if (n2 == -1) {
                    n2 = 3;
                }
                WebDAVFileView.this.selectedResource = (String)WebDAVFileView.this.table.getValueAt(n, n2);
                String string = new String(WebDAVFileView.this.selectedResource);
                WebDAVFileView.this.selectedRow = n;
                try {
                    boolean bl;
                    n2 = WebDAVFileView.this.table.convertColumnIndexToView(0);
                    if (n2 == -1) {
                        n2 = 0;
                    }
                    if (bl = new Boolean(WebDAVFileView.this.table.getValueAt(n, n2).toString()).booleanValue()) {
                        if (WebDAVFileView.this.parentPath.startsWith("http://") || WebDAVFileView.this.parentPath.startsWith("https://") || string.startsWith("http://") || string.startsWith("https://")) {
                            if (!string.endsWith("/")) {
                                string = string + "/";
                            }
                        } else {
                            string = string + new Character(File.separatorChar).toString();
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return;
                }
                ViewSelectionEvent viewSelectionEvent = new ViewSelectionEvent(this, null, null);
                for (int i = 0; i < vector.size(); ++i) {
                    ViewSelectionListener viewSelectionListener = (ViewSelectionListener)vector.elementAt(i);
                }
            }
        }
    }
}

