/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.DAVExplorer;

import HTTPClient.NVPair;
import HTTPClient.Util;
import com.ms.xml.om.Document;
import com.ms.xml.om.Element;
import com.ms.xml.util.Name;
import com.ms.xml.util.XMLOutputStream;
import edu.uci.ics.DAVExplorer.AsGen;
import edu.uci.ics.DAVExplorer.EscapeReader;
import edu.uci.ics.DAVExplorer.GlobalData;
import edu.uci.ics.DAVExplorer.ViewSelectionEvent;
import edu.uci.ics.DAVExplorer.WebDAVRequestEvent;
import edu.uci.ics.DAVExplorer.WebDAVRequestListener;
import edu.uci.ics.DAVExplorer.WebDAVTreeNode;
import edu.uci.ics.DAVExplorer.WebDAVXML;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class WebDAVRequestGenerator
implements Runnable {
    protected static final int DEFAULT_PORT = 80;
    protected static String HostName = "";
    protected static int Port = 0;
    protected static String Method = null;
    protected static String Path = "";
    protected static String ResourceName = "";
    protected static String tableResource = "";
    protected static String StrippedResource = "";
    protected static NVPair[] Headers = null;
    protected static byte[] Body = null;
    protected static int extendedCode = 0;
    protected static String extendedData = null;
    protected static String User = "";
    protected static String Password = "";
    protected static Vector listeners = new Vector();
    protected WebDAVTreeNode Node = null;
    protected WebDAVTreeNode parentNode = null;
    protected boolean debugXML = false;
    protected String userAgent = null;
    protected WebDAVTreeNode Node2;
    protected String ResourceName2;
    protected String Dest2;
    protected String dir2;
    protected boolean Overwrite2;
    protected boolean KeepAlive2;
    protected boolean secondTime = false;
    protected String[] extensions = new String[]{"htm", "text/html", "html", "text/html", "gif", "image/gif", "jpg", "image/jpeg", "jpeg", "image/jpeg", "css", "text/css", "pdf", "application/pdf", "doc", "application/msword", "ppt", "application/vnd.ms-powerpoint", "xls", "application/vnd.ms-excel", "ps", "application/postscript", "zip", "application/zip", "fm", "application/vnd.framemaker", "mif", "application/vnd.mif", "png", "image/png", "tif", "image/tiff", "tiff", "image/tiff", "rtf", "text/rtf", "xml", "text/xml", "mpg", "video/mpeg", "mpeg", "video/mpeg", "mov", "video/quicktime", "hqx", "application/mac-binhex40", "au", "audio/basic", "vrm", "model/vrml", "vrml", "model/vrml", "txt", "text/plain", "c", "text/plain", "cc", "text/plain", "cpp", "text/plain", "h", "text/plain", "sh", "text/plain", "bat", "text/plain", "ada", "text/plain", "java", "text/plain", "rc", "text/plain"};

    public static void reset() {
        HostName = "";
        Port = 0;
        Method = null;
        Path = "";
        ResourceName = "";
        tableResource = "";
        StrippedResource = "";
        Headers = null;
        Body = null;
        extendedCode = 0;
        extendedData = null;
        User = "";
        Password = "";
        listeners = new Vector();
    }

    public void setUser(String string) {
        User = string;
    }

    public void setPass(String string) {
        Password = string;
    }

    public void setUserAgent(String string) {
        this.userAgent = string;
    }

    public void DoPropFind(String string, boolean bl) {
        String string2;
        String string3 = string;
        if (!bl) {
            string3 = HostName;
            if (Port > 0) {
                string3 = string3 + ":" + Port;
            }
            string3 = string3 + string;
        }
        if ((string2 = System.getProperty("propfind")) != null && string2.equalsIgnoreCase("allprop")) {
            if (this.GeneratePropFind(string3, "allprop", "one", null, null, false)) {
                this.execute();
            }
        } else {
            String[] stringArray = this.preparePropFind();
            if (this.GeneratePropFind(string3, "prop", "one", stringArray, null, false)) {
                this.execute();
            }
        }
    }

    protected String[] preparePropFind() {
        String[] stringArray = new String[]{"displayname", "resourcetype", "getcontenttype", "getcontentlength", "getlastmodified", "lockdiscovery"};
        return stringArray;
    }

    public void tableSelectionChanged(ViewSelectionEvent viewSelectionEvent) {
        if (viewSelectionEvent.getNode() != null) {
            return;
        }
        tableResource = viewSelectionEvent.getPath().toString();
        if (Path.length() == 0) {
            ResourceName = tableResource;
        }
        ResourceName = Path + tableResource;
    }

    public void setSecondTime(boolean bl) {
        this.secondTime = bl;
    }

    public void setResource(String string, WebDAVTreeNode webDAVTreeNode) {
        if (string == null) {
            return;
        }
        tableResource = string;
        ResourceName = Path.length() == 0 ? string : Path + string;
        this.Node = webDAVTreeNode;
    }

    public void setNode(WebDAVTreeNode webDAVTreeNode) {
        this.Node = webDAVTreeNode;
    }

    public void treeSelectionChanged(ViewSelectionEvent viewSelectionEvent) {
        Path = viewSelectionEvent.getPath().toString();
        ResourceName = Path + "/";
    }

    public String parseResourceName(boolean bl) {
        if (ResourceName.equals("")) {
            GlobalData.getGlobalData().errorMsg("No resource selected!");
            return null;
        }
        if (!ResourceName.startsWith("http://") && !ResourceName.startsWith("https://")) {
            GlobalData.getGlobalData().errorMsg("This operation cannot be executed\non a local resource.");
            return null;
        }
        String string = ResourceName.startsWith("http://") ? ResourceName.substring("http://".length()) : ResourceName.substring("https://".length());
        return this.parseStripped(string, bl);
    }

    public String parseStripped(String string, boolean bl) {
        String string2;
        String string3;
        int n;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        boolean bl2 = false;
        if (!stringTokenizer.hasMoreTokens()) {
            GlobalData.getGlobalData().errorMsg("Invalid host name.");
            return null;
        }
        if (string.endsWith("/")) {
            bl2 = true;
        }
        if ((n = (string3 = stringTokenizer.nextToken()).indexOf(":")) < 0) {
            HostName = string3;
            Port = 0;
        } else {
            HostName = string3.substring(0, n);
            string2 = string3.substring(n + 1);
            try {
                Port = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                GlobalData.getGlobalData().errorMsg("Invalid port number.");
                Port = 0;
                return null;
            }
        }
        string2 = "";
        while (stringTokenizer.hasMoreTokens()) {
            string2 = string2 + "/" + stringTokenizer.nextToken();
        }
        if (string2.length() == 0) {
            string2 = "/";
        } else if (bl2) {
            string2 = string2 + "/";
        }
        if (bl) {
            StringReader stringReader = new StringReader(string2 + "\n");
            EscapeReader escapeReader = new EscapeReader(stringReader, false);
            BufferedReader bufferedReader = new BufferedReader(escapeReader);
            try {
                return bufferedReader.readLine();
            }
            catch (IOException iOException) {
                GlobalData.getGlobalData().errorMsg("URI generation error: \n" + iOException);
                return null;
            }
        }
        return string2;
    }

    public String getDefaultName(String string) {
        String string2 = this.parseResourceName(false);
        if (string2 == null) {
            return null;
        }
        if (string2.endsWith("/")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        if (string != null) {
            string2 = string2 + string;
        }
        return string2;
    }

    public void execute() {
        AsGen.clear();
        Thread thread = new Thread(this);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Vector vector;
        if (Headers == null) {
            GlobalData.getGlobalData().errorMsg("Invalid Request.");
            return;
        }
        WebDAVRequestGenerator webDAVRequestGenerator = this;
        synchronized (webDAVRequestGenerator) {
            vector = (Vector)listeners.clone();
        }
        if (this.userAgent != null) {
            int n = Headers.length;
            Headers = Util.resizeArray(Headers, n + 2);
            WebDAVRequestGenerator.Headers[n] = new NVPair("Translate", "f");
            WebDAVRequestGenerator.Headers[n + 1] = new NVPair("User-Agent", this.userAgent);
        }
        WebDAVRequestEvent webDAVRequestEvent = new WebDAVRequestEvent(this, Method, HostName, Port, StrippedResource, Headers, Body, extendedCode, extendedData, User, Password, this.Node);
        this.Node = null;
        for (int i = 0; i < vector.size(); ++i) {
            WebDAVRequestListener webDAVRequestListener = (WebDAVRequestListener)vector.elementAt(i);
            webDAVRequestListener.requestFormed(webDAVRequestEvent);
        }
    }

    public synchronized void addRequestListener(WebDAVRequestListener webDAVRequestListener) {
        listeners.addElement(webDAVRequestListener);
    }

    public synchronized void removeRequestListener(WebDAVRequestListener webDAVRequestListener) {
        listeners.removeElement(webDAVRequestListener);
    }

    public synchronized boolean DiscoverLock(int n, String string) {
        if (GlobalData.getGlobalData().getDebugRequest()) {
            System.err.println("WebDAVRequestGenerator::DiscoverLock");
        }
        extendedCode = n;
        extendedData = string;
        String[] stringArray = new String[1];
        String[] stringArray2 = new String[1];
        boolean bl = false;
        String string2 = System.getProperty("propfind");
        if (string2 != null && string2.equalsIgnoreCase("allprop")) {
            bl = this.GeneratePropFind(null, "allprop", "zero", null, stringArray2, false);
        } else {
            stringArray[0] = "lockdiscovery";
            stringArray2[0] = "DAV:";
            bl = this.GeneratePropFind(null, "prop", "zero", stringArray, stringArray2, false);
        }
        if (bl) {
            this.execute();
        }
        return bl;
    }

    public synchronized boolean GeneratePropFindForNode(String string, String string2, String string3, String[] stringArray, String[] stringArray2, boolean bl, WebDAVTreeNode webDAVTreeNode) {
        this.Node = webDAVTreeNode;
        return this.GeneratePropFind(string, string2, string3, stringArray, stringArray2, bl);
    }

    public synchronized boolean GenerateOptions(String string) {
        if (GlobalData.getGlobalData().getDebugRequest()) {
            System.err.println("WebDAVRequestGenerator::GenerateOptions");
        }
        Headers = null;
        Body = null;
        StrippedResource = string != null ? this.parseStripped(string, true) : this.parseResourceName(true);
        if (StrippedResource == null) {
            return false;
        }
        Method = "OPTIONS";
        Headers = new NVPair[1];
        WebDAVRequestGenerator.Headers[0] = Port == 0 || Port == 80 ? new NVPair("Host", HostName) : new NVPair("Host", HostName + ":" + Port);
        return true;
    }

    public synchronized boolean GeneratePropFind(String string, String string2, String string3, String[] stringArray, String[] stringArray2, boolean bl) {
        Object object;
        if (GlobalData.getGlobalData().getDebugRequest()) {
            System.err.println("WebDAVRequestGenerator::GeneratePropFind");
            if (string2 != null) {
                System.err.println("\tCommand: " + string2);
            }
            if (string3 != null) {
                System.err.println("\tDepth: " + string3);
            }
        }
        Headers = null;
        Body = null;
        if (bl) {
            if (extendedCode != 2) {
                extendedCode = ResourceName.equals(string) ? 3 : 4;
            }
            ResourceName = string;
            StrippedResource = this.parseResourceName(true);
        } else {
            StrippedResource = string != null ? this.parseStripped(string, true) : this.parseResourceName(true);
        }
        if (StrippedResource == null) {
            return false;
        }
        String string4 = "allprop";
        String string5 = "infinity";
        if (string2.equalsIgnoreCase("prop") || string2.equalsIgnoreCase("propname")) {
            string4 = string2.toLowerCase();
        }
        if (string3.equalsIgnoreCase("zero") || string3.equalsIgnoreCase("one")) {
            string5 = string3;
        }
        if (string5.equalsIgnoreCase("zero")) {
            string5 = "0";
        } else if (string5.equalsIgnoreCase("one")) {
            string5 = "1";
        }
        Method = "PROPFIND";
        Document document = new Document();
        document.setVersion("1.0");
        document.addChild(WebDAVXML.elemNewline, null);
        AsGen asGen = WebDAVXML.findNamespace(new AsGen(), null);
        if (asGen == null) {
            asGen = WebDAVXML.createNamespace(new AsGen(), null);
        }
        Element element = WebDAVXML.createElement("propfind", 0, null, asGen);
        if (string4.equals("allprop")) {
            object = WebDAVXML.createElement("allprop", 0, element, asGen);
            this.addChild(element, (Element)object, 1, true);
        } else if (string4.equals("propname")) {
            object = WebDAVXML.createElement("propname", 0, element, asGen);
            this.addChild(element, (Element)object, 1, true);
        } else {
            this.addProperties(element, asGen, stringArray, 1);
        }
        document.addChild(element, null);
        document.addChild(WebDAVXML.elemNewline, null);
        object = new ByteArrayOutputStream();
        XMLOutputStream xMLOutputStream = new XMLOutputStream((OutputStream)object);
        try {
            document.save(xMLOutputStream);
            Body = ((ByteArrayOutputStream)object).toByteArray();
            Headers = new NVPair[4];
            WebDAVRequestGenerator.Headers[0] = Port == 0 || Port == 80 ? new NVPair("Host", HostName) : new NVPair("Host", HostName + ":" + Port);
            WebDAVRequestGenerator.Headers[1] = new NVPair("Depth", string5);
            WebDAVRequestGenerator.Headers[2] = new NVPair("Content-Type", "text/xml");
            WebDAVRequestGenerator.Headers[3] = new NVPair("Content-Length", new Long(Body.length).toString());
            this.printXML(document);
        }
        catch (Exception exception) {
            GlobalData.getGlobalData().errorMsg("XML generation error: \n" + exception);
            return false;
        }
        return true;
    }

    protected void addProperties(Element element, AsGen asGen, String[] stringArray, int n) {
        Element element2 = WebDAVXML.createElement("prop", 0, element, asGen);
        element2.addChild(WebDAVXML.elemNewline, null);
        for (int i = 0; i < stringArray.length; ++i) {
            Element element3 = WebDAVXML.createElement(stringArray[i], 0, element2, asGen);
            this.addChild(element2, element3, 2, false);
        }
        this.addChild(element, element2, 1, true);
    }

    protected void addChild(Element element, Element element2, int n, boolean bl) {
        this.addChild(element, element2, n, n, bl, true);
    }

    protected void addChild(Element element, Element element2, int n, int n2, boolean bl, boolean bl2) {
        if (element != null) {
            int n3;
            if (element2.numElements() > 0) {
                for (n3 = 0; n3 < n2; ++n3) {
                    element2.addChild(WebDAVXML.elemDSpace, null);
                }
            }
            if (bl) {
                element.addChild(WebDAVXML.elemNewline, null);
            }
            for (n3 = 0; n3 < n; ++n3) {
                element.addChild(WebDAVXML.elemDSpace, null);
            }
            element.addChild(element2, null);
            if (bl2) {
                element.addChild(WebDAVXML.elemNewline, null);
            }
        }
    }

    protected static boolean docContains(Document document, Element element) {
        Enumeration enumeration = document.getElements();
        while (enumeration.hasMoreElements()) {
            Element element2 = (Element)enumeration.nextElement();
            Name name = element2.getTagName();
            if (name == null || !name.getName().equals("prop")) continue;
            Enumeration enumeration2 = element2.getElements();
            while (enumeration2.hasMoreElements()) {
                Element element3 = (Element)enumeration2.nextElement();
                Name name2 = element3.getTagName();
                if (element3.getType() != 0 || !name2.getName().equals(element.getTagName().getName()) || !name2.getNameSpace().equals(element.getTagName().getNameSpace())) continue;
                return true;
            }
        }
        return false;
    }

    public synchronized boolean GeneratePropPatch(String string, Element element, Element element2, String string2) {
        if (GlobalData.getGlobalData().getDebugRequest()) {
            System.err.println("WebDAVRequestGenerator::GeneratePropPatch");
        }
        if ((StrippedResource = string != null ? this.parseStripped(string, true) : this.parseResourceName(true)) == null) {
            return false;
        }
        Headers = null;
        Body = null;
        boolean bl = false;
        boolean bl2 = false;
        Method = "PROPPATCH";
        Document document = new Document();
        document.setVersion("1.0");
        document.addChild(WebDAVXML.elemNewline, null);
        AsGen asGen = WebDAVXML.findNamespace(new AsGen(), null);
        if (asGen == null) {
            asGen = WebDAVXML.createNamespace(new AsGen(), null);
        }
        Element element3 = WebDAVXML.createElement("propertyupdate", 0, null, asGen, true);
        if (element2 != null) {
            element3.addChild(WebDAVXML.elemNewline, null);
            element3.addChild(element2, null);
            element3.addChild(WebDAVXML.elemNewline, null);
        }
        if (element != null) {
            element3.addChild(WebDAVXML.elemNewline, null);
            element3.addChild(element, null);
            element3.addChild(WebDAVXML.elemNewline, null);
        }
        document.addChild(element3, null);
        document.addChild(WebDAVXML.elemNewline, null);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XMLOutputStream xMLOutputStream = new XMLOutputStream(byteArrayOutputStream);
        try {
            String string3;
            document.save(xMLOutputStream);
            Body = byteArrayOutputStream.toByteArray();
            if (string2 != null) {
                Headers = new NVPair[4];
                WebDAVRequestGenerator.Headers[3] = new NVPair("If", "(<" + string2 + ">)");
            } else {
                Headers = new NVPair[3];
            }
            WebDAVRequestGenerator.Headers[0] = Port == 0 || Port == 80 ? new NVPair("Host", HostName) : ((string3 = System.getProperty("Apache", "no")).equalsIgnoreCase("yes") || string3.equalsIgnoreCase("true") ? new NVPair("Host", HostName) : new NVPair("Host", HostName + ":" + Port));
            WebDAVRequestGenerator.Headers[1] = new NVPair("Content-Type", "text/xml");
            WebDAVRequestGenerator.Headers[2] = new NVPair("Content-Length", new Long(Body.length).toString());
            this.printXML(document);
        }
        catch (Exception exception) {
            GlobalData.getGlobalData().errorMsg("XML Generator Error: \n" + exception);
            return false;
        }
        return true;
    }

    public synchronized boolean GenerateMkCol(String string, String string2) {
        if (GlobalData.getGlobalData().getDebugRequest()) {
            System.err.println("WebDAVRequestGenerator::GenerateMkCol");
        }
        Headers = null;
        Body = null;
        ResourceName = string;
        StrippedResource = this.parseResourceName(true);
        if (StrippedResource == null) {
            return false;
        }
        String string3 = string2;
        int n = string3.lastIndexOf(File.separatorChar);
        if (n >= 0) {
            string3 = string3.substring(n + 1);
        }
        StrippedResource = StrippedResource + string3;
        Method = "MKCOL";
        Headers = new NVPair[1];
        WebDAVRequestGenerator.Headers[0] = Port == 0 || Port == 80 ? new NVPair("Host", HostName) : new NVPair("Host", HostName + ":" + Port);
        return true;
    }

    public synchronized boolean GenerateGet(int n) {
        if (GlobalData.getGlobalData().getDebugRequest()) {
            System.err.println("WebDAVRequestGenerator::GenerateGet");
        }
        Headers = null;
        Body = null;
        StrippedResource = this.parseResourceName(true);
        if (StrippedResource == null) {
            return false;
        }
        extendedCode = n;
        Method = "GET";
        Body = null;
        Headers = new NVPair[1];
        WebDAVRequestGenerator.Headers[0] = Port == 0 || Port == 80 ? new NVPair("Host", HostName) : new NVPair("Host", HostName + ":" + Port);
        return true;
    }

    public synchronized boolean GenerateDelete(String string) {
        if (GlobalData.getGlobalData().getDebugRequest()) {
            System.err.println("WebDAVRequestGenerator::GenerateDelete");
        }
        Headers = null;
        Body = null;
        if (this.secondTime) {
            this.Node = this.Node2;
            ResourceName = this.ResourceName2;
        } else {
            this.Node2 = this.Node;
            this.ResourceName2 = ResourceName;
        }
        StrippedResource = this.parseResourceName(true);
        if (StrippedResource == null) {
            return false;
        }
        Method = "DELETE";
        Body = null;
        if (string != null) {
            Headers = new NVPair[2];
            WebDAVRequestGenerator.Headers[1] = new NVPair("If", "(<" + string + ">)");
        } else {
            Headers = new NVPair[1];
        }
        WebDAVRequestGenerator.Headers[0] = Port == 0 || Port == 80 ? new NVPair("Host", HostName) : new NVPair("Host", HostName + ":" + Port);
        return true;
    }

    public WebDAVTreeNode getPossibleParentOfSelectedCollectionNode() {
        return this.parentNode;
    }

    public void resetParentNode() {
        this.parentNode = null;
    }

    public synchronized boolean GeneratePut(String string, String string2, String string3, WebDAVTreeNode webDAVTreeNode) {
        if (GlobalData.getGlobalData().getDebugRequest()) {
            System.err.println("WebDAVRequestGenerator::GeneratePut");
        }
        Headers = null;
        Body = null;
        this.parentNode = webDAVTreeNode;
        ResourceName = string2;
        StrippedResource = this.parseResourceName(true);
        if (StrippedResource == null) {
            return false;
        }
        String string4 = string;
        int n = string4.lastIndexOf(File.separatorChar);
        if (n >= 0) {
            string4 = string4.substring(n + 1);
        }
        if ((n = StrippedResource.lastIndexOf("/")) >= 0) {
            StrippedResource = StrippedResource.substring(0, n + 1);
        }
        StrippedResource = StrippedResource + string4;
        if (string == null || string.equals("")) {
            GlobalData.getGlobalData().errorMsg("DAV Generator:\nFile not found!\n");
            return false;
        }
        File file = new File(string);
        if (!file.exists()) {
            GlobalData.getGlobalData().errorMsg("Invalid File.");
            return false;
        }
        try {
            long l = file.length();
            Method = "PUT";
            extendedData = string;
            if (string3 != null) {
                Headers = new NVPair[4];
                WebDAVRequestGenerator.Headers[3] = new NVPair("If", "(<" + string3 + ">)");
            } else {
                Headers = new NVPair[3];
            }
            WebDAVRequestGenerator.Headers[0] = Port == 0 || Port == 80 ? new NVPair("Host", HostName) : new NVPair("Host", HostName + ":" + Port);
            WebDAVRequestGenerator.Headers[1] = new NVPair("Content-Type", this.getContentType(string));
            WebDAVRequestGenerator.Headers[2] = new NVPair("Content-Length", new Long(l).toString());
        }
        catch (Exception exception) {
            GlobalData.getGlobalData().errorMsg("Error generating PUT\n" + exception);
            return false;
        }
        return true;
    }

    public synchronized boolean GenerateCopy(String string, boolean bl, boolean bl2) {
        String string2;
        if (GlobalData.getGlobalData().getDebugRequest()) {
            System.err.println("WebDAVRequestGenerator::GenerateCopy");
        }
        Headers = null;
        Body = null;
        extendedCode = 32;
        StrippedResource = this.parseResourceName(true);
        if (StrippedResource == null) {
            return false;
        }
        String string3 = string2 = bl ? "T" : "F";
        if (string == null) {
            string = StrippedResource.endsWith("/") ? StrippedResource.substring(0, StrippedResource.length() - 1) : StrippedResource;
            string = string + "_copy";
        }
        if (!(string = Port == 0 || Port == 80 ? HostName + string : HostName + ":" + Port + string).startsWith("http://") && !string.startsWith("https://")) {
            string = GlobalData.getGlobalData().getSSL() ? "https://" + string : "http://" + string;
        }
        Method = "COPY";
        Body = null;
        if (bl2) {
            Document document = new Document();
            document.setVersion("1.0");
            document.addChild(WebDAVXML.elemNewline, null);
            AsGen asGen = WebDAVXML.findNamespace(new AsGen(), null);
            if (asGen == null) {
                asGen = WebDAVXML.createNamespace(new AsGen(), null);
            }
            Element element = WebDAVXML.createElement("propertybehavior", 0, null, asGen);
            element.addChild(WebDAVXML.elemNewline, null);
            Element element2 = WebDAVXML.createElement("keepalive", 0, element, asGen);
            Element element3 = WebDAVXML.createElement(null, 1, element2, asGen);
            element3.setText("*");
            this.addChild(element2, element3, 0, 0, false, false);
            this.addChild(element, element2, 1, 0, false, true);
            document.addChild(element, null);
            document.addChild(WebDAVXML.elemNewline, null);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            XMLOutputStream xMLOutputStream = new XMLOutputStream(byteArrayOutputStream);
            try {
                document.save(xMLOutputStream);
                Body = byteArrayOutputStream.toByteArray();
                Headers = new NVPair[5];
                WebDAVRequestGenerator.Headers[0] = Port == 0 || Port == 80 ? new NVPair("Host", HostName) : new NVPair("Host", HostName + ":" + Port);
                WebDAVRequestGenerator.Headers[1] = new NVPair("Destination", string);
                WebDAVRequestGenerator.Headers[2] = new NVPair("Content-Type", "text/xml");
                WebDAVRequestGenerator.Headers[3] = new NVPair("Content-Length", new Long(Body.length).toString());
                WebDAVRequestGenerator.Headers[4] = new NVPair("Overwrite", string2);
                this.printXML(document);
            }
            catch (Exception exception) {
                GlobalData.getGlobalData().errorMsg("XML Generator Error: \n" + exception);
                return false;
            }
        } else {
            Headers = new NVPair[3];
            WebDAVRequestGenerator.Headers[0] = Port == 0 || Port == 80 ? new NVPair("Host", HostName) : new NVPair("Host", HostName + ":" + Port);
            WebDAVRequestGenerator.Headers[1] = new NVPair("Destination", string);
            WebDAVRequestGenerator.Headers[2] = new NVPair("Overwrite", string2);
        }
        return true;
    }

    public synchronized boolean GenerateRename(String string, String string2) {
        if (GlobalData.getGlobalData().getDebugRequest()) {
            System.err.println("WebDAVRequestGenerator::GenerateRename");
        }
        return this.DiscoverLock(30, string + ":" + string2);
    }

    public synchronized boolean GenerateMove(String string, String string2, boolean bl, boolean bl2, String string3, int n) {
        String string4;
        if (GlobalData.getGlobalData().getDebugRequest()) {
            System.err.println("WebDAVRequestGenerator::GenerateMove");
        }
        Headers = null;
        Body = null;
        extendedCode = n;
        extendedData = string;
        if (this.secondTime) {
            this.Node = this.Node2;
            ResourceName = this.ResourceName2;
            string = this.Dest2;
            string2 = this.dir2;
            bl = this.Overwrite2;
            bl2 = this.KeepAlive2;
        } else {
            this.Node2 = this.Node;
            this.ResourceName2 = ResourceName;
            this.Dest2 = string;
            this.dir2 = string2 != null ? string2 : null;
            this.Overwrite2 = bl;
            this.KeepAlive2 = bl2;
        }
        String string5 = ResourceName;
        ResourceName = string2;
        ResourceName = string5;
        StrippedResource = this.parseResourceName(true);
        if (StrippedResource == null) {
            return false;
        }
        String string6 = string4 = bl ? "T" : "F";
        if (string == null) {
            GlobalData.getGlobalData().errorMsg("Invalid Destination");
            return false;
        }
        if (string2 == null) {
            string2 = GlobalData.getGlobalData().getSSL() ? "https://" : "http://";
            string2 = Port == 0 || Port == 80 ? string2 + HostName : string2 + HostName + ":" + Port;
        }
        string = string2 + string;
        Method = "MOVE";
        Body = null;
        if (bl2) {
            Document document = new Document();
            document.setVersion("1.0");
            document.addChild(WebDAVXML.elemNewline, null);
            AsGen asGen = WebDAVXML.findNamespace(new AsGen(), null);
            if (asGen == null) {
                asGen = WebDAVXML.createNamespace(new AsGen(), null);
            }
            Element element = WebDAVXML.createElement("propertybehavior", 0, null, asGen);
            element.addChild(WebDAVXML.elemNewline, null);
            Element element2 = WebDAVXML.createElement("keepalive", 0, element, asGen);
            Element element3 = WebDAVXML.createElement(null, 1, element2, asGen);
            element3.setText("*");
            this.addChild(element2, element3, 0, 0, false, false);
            this.addChild(element, element2, 1, 0, false, true);
            document.addChild(element, null);
            document.addChild(WebDAVXML.elemNewline, null);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            XMLOutputStream xMLOutputStream = new XMLOutputStream(byteArrayOutputStream);
            try {
                document.save(xMLOutputStream);
                Body = byteArrayOutputStream.toByteArray();
                if (string3 != null) {
                    Headers = new NVPair[6];
                    WebDAVRequestGenerator.Headers[5] = new NVPair("If", "(<" + string3 + ">)");
                } else {
                    Headers = new NVPair[5];
                }
                WebDAVRequestGenerator.Headers[0] = Port == 0 || Port == 80 ? new NVPair("Host", HostName) : new NVPair("Host", HostName + ":" + Port);
                WebDAVRequestGenerator.Headers[1] = new NVPair("Destination", string);
                WebDAVRequestGenerator.Headers[2] = new NVPair("Content-Type", "text/xml");
                WebDAVRequestGenerator.Headers[3] = new NVPair("Content-Length", new Long(Body.length).toString());
                WebDAVRequestGenerator.Headers[4] = new NVPair("Overwrite", string4);
                this.printXML(document);
            }
            catch (Exception exception) {
                GlobalData.getGlobalData().errorMsg("XML Generator Error: \n" + exception);
                return false;
            }
        } else {
            Headers = new NVPair[3];
            WebDAVRequestGenerator.Headers[0] = Port == 0 || Port == 80 ? new NVPair("Host", HostName) : new NVPair("Host", HostName + ":" + Port);
            WebDAVRequestGenerator.Headers[1] = new NVPair("Destination", string);
            WebDAVRequestGenerator.Headers[2] = new NVPair("Overwrite", string4);
        }
        return true;
    }

    public synchronized boolean GenerateLock(String string, String string2, boolean bl) {
        if (GlobalData.getGlobalData().getDebugRequest()) {
            System.err.println("WebDAVRequestGenerator::GenerateLock");
        }
        Headers = null;
        Body = null;
        StrippedResource = this.parseResourceName(true);
        if (StrippedResource == null) {
            return false;
        }
        Method = "LOCK";
        Body = null;
        extendedData = string2;
        if (string2 == null) {
            Document document = new Document();
            document.setVersion("1.0");
            document.addChild(WebDAVXML.elemNewline, null);
            AsGen asGen = WebDAVXML.findNamespace(new AsGen(), null);
            if (asGen == null) {
                asGen = WebDAVXML.createNamespace(new AsGen(), null);
            }
            Element element = WebDAVXML.createElement("lockinfo", 0, null, asGen);
            Element element2 = WebDAVXML.createElement("locktype", 0, element, asGen);
            Element element3 = WebDAVXML.createElement("lockscope", 0, element, asGen);
            Element element4 = WebDAVXML.createElement("owner", 0, element, asGen);
            Element element5 = WebDAVXML.createElement("write", 0, element2, asGen);
            Element element6 = bl ? WebDAVXML.createElement("exclusive", 0, element3, asGen) : WebDAVXML.createElement("shared", 0, element3, asGen);
            Element element7 = WebDAVXML.createElement("href", 0, element4, asGen);
            Element element8 = WebDAVXML.createElement(null, 1, element4, asGen);
            element8.setText(string);
            this.addChild(element7, element8, 0, 0, false, false);
            this.addChild(element4, element7, 2, 0, true, true);
            this.addChild(element2, element5, 2, true);
            this.addChild(element3, element6, 2, true);
            this.addChild(element, element2, 1, true);
            this.addChild(element, element3, 1, false);
            this.addChild(element, element4, 1, false);
            document.addChild(element, null);
            document.addChild(WebDAVXML.elemNewline, null);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            XMLOutputStream xMLOutputStream = new XMLOutputStream(byteArrayOutputStream);
            try {
                document.save(xMLOutputStream);
                Body = byteArrayOutputStream.toByteArray();
                Headers = new NVPair[5];
                WebDAVRequestGenerator.Headers[0] = Port == 0 || Port == 80 ? new NVPair("Host", HostName) : new NVPair("Host", HostName + ":" + Port);
                WebDAVRequestGenerator.Headers[1] = new NVPair("Timeout", "Second-86400");
                WebDAVRequestGenerator.Headers[2] = new NVPair("Content-Type", "text/xml");
                WebDAVRequestGenerator.Headers[3] = new NVPair("Content-Length", new Long(Body.length).toString());
                WebDAVRequestGenerator.Headers[4] = new NVPair("Depth", "infinity");
                this.printXML(document);
            }
            catch (Exception exception) {
                GlobalData.getGlobalData().errorMsg("XML Generator Error: \n" + exception);
                return false;
            }
        }
        try {
            String string3 = "(<" + string2 + ">)";
            Headers = new NVPair[3];
            WebDAVRequestGenerator.Headers[0] = Port == 0 || Port == 80 ? new NVPair("Host", HostName) : new NVPair("Host", HostName + ":" + Port);
            WebDAVRequestGenerator.Headers[1] = new NVPair("Timeout", "Second-86400");
            WebDAVRequestGenerator.Headers[2] = new NVPair("If", string3);
        }
        catch (Exception exception) {
            GlobalData.getGlobalData().errorMsg(exception.toString());
            return false;
        }
        return true;
    }

    public synchronized boolean GenerateUnlock(String string) {
        if (GlobalData.getGlobalData().getDebugRequest()) {
            System.err.println("WebDAVRequestGenerator::GenerateUnlock");
        }
        Headers = null;
        Body = null;
        StrippedResource = this.parseResourceName(true);
        if (StrippedResource == null) {
            return false;
        }
        try {
            Method = "UNLOCK";
            Body = null;
            Headers = new NVPair[2];
            WebDAVRequestGenerator.Headers[0] = Port == 0 || Port == 80 ? new NVPair("Host", HostName) : new NVPair("Host", HostName + ":" + Port);
            WebDAVRequestGenerator.Headers[1] = new NVPair("Lock-Token", "<" + string + ">");
        }
        catch (Exception exception) {
            GlobalData.getGlobalData().errorMsg("Error Generating UNLOCK\n" + exception);
            return false;
        }
        return true;
    }

    public synchronized void setExtendedInfo(int n, String string) {
        extendedCode = n;
        extendedData = string;
    }

    protected String getContentType(String string) {
        String string2 = "application/octet-stream";
        int n = string.lastIndexOf(".");
        if (n >= 0) {
            for (int i = 0; i < this.extensions.length; i += 2) {
                String string3 = string.substring(n + 1).toLowerCase();
                if (!string3.equals(this.extensions[i])) continue;
                string2 = this.extensions[i + 1];
                break;
            }
        }
        return string2;
    }

    protected void printXML(Document document) {
        String string = System.getProperty("debug", "false");
        if (string.equals("true") || this.debugXML) {
            System.out.println("generated xml: ");
            XMLOutputStream xMLOutputStream = new XMLOutputStream(System.out);
            try {
                document.save(xMLOutputStream);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

