/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.DAVExplorer;

import HTTPClient.HTTPResponse;
import HTTPClient.ModuleException;
import com.ms.xml.om.Document;
import com.ms.xml.om.Element;
import com.ms.xml.om.ElementImpl;
import com.ms.xml.om.SiblingEnumeration;
import com.ms.xml.om.TreeEnumeration;
import com.ms.xml.util.Name;
import com.ms.xml.util.XMLOutputStream;
import edu.uci.ics.DAVExplorer.CopyResponseEvent;
import edu.uci.ics.DAVExplorer.CopyResponseListener;
import edu.uci.ics.DAVExplorer.DataNode;
import edu.uci.ics.DAVExplorer.DeltaVDataNode;
import edu.uci.ics.DAVExplorer.GlobalData;
import edu.uci.ics.DAVExplorer.InsertionListener;
import edu.uci.ics.DAVExplorer.PropDialog;
import edu.uci.ics.DAVExplorer.PutEvent;
import edu.uci.ics.DAVExplorer.PutListener;
import edu.uci.ics.DAVExplorer.ResponseException;
import edu.uci.ics.DAVExplorer.WebDAVRequestGenerator;
import edu.uci.ics.DAVExplorer.WebDAVResponseEvent;
import edu.uci.ics.DAVExplorer.WebDAVTreeNode;
import edu.uci.ics.DAVExplorer.WebDAVXML;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;

public class WebDAVResponseInterpreter {
    public static int RESOURCETYPE_NONE = 0;
    public static int RESOURCETYPE_COLLECTION = 1;
    protected static WebDAVRequestGenerator generator;
    protected static byte[] stream;
    protected static String Method;
    protected static int extendedCode;
    protected static String extendedData;
    protected static HTTPResponse res;
    protected static String HostName;
    protected static int Port;
    protected static String Resource;
    protected static String Charset;
    protected static Vector listeners;
    protected static Vector moveListeners;
    protected static Vector lockListeners;
    protected static String WebDAVEditDir;
    protected static boolean refresh;
    protected static String userPathDir;
    protected static CopyResponseListener copyListener;
    protected static PutListener putListener;
    protected static ActionListener actionListener;
    protected WebDAVTreeNode Node;
    protected boolean debugXML = false;
    protected static final String EditDir = "Edit";
    protected static final String WebDAVClassName = "DAVExplorer";
    protected static final String HTTPString = "HTTP/1.1";

    public WebDAVResponseInterpreter() {
    }

    public WebDAVResponseInterpreter(WebDAVRequestGenerator webDAVRequestGenerator) {
        generator = webDAVRequestGenerator;
        String string = System.getProperty("java.class.path");
        if (string == null) {
            WebDAVEditDir = null;
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":;");
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens()) {
            File file;
            String string2 = stringTokenizer.nextToken();
            if (!string2.endsWith(new Character(File.separatorChar).toString())) {
                string2 = string2 + File.separatorChar;
            }
            if (!(file = new File((string2 = string2 + WebDAVClassName + File.separatorChar) + "icons")).exists()) continue;
            File file2 = new File(string2 + EditDir);
            if (!file2.exists()) {
                file2.mkdir();
            }
            WebDAVEditDir = string2 + EditDir;
        }
        userPathDir = System.getProperty("user.home");
        userPathDir = userPathDir == null ? "" : userPathDir + File.separatorChar;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean handleResponse(WebDAVResponseEvent webDAVResponseEvent) throws ResponseException {
        if (GlobalData.getGlobalData().getDebugResponse()) {
            System.err.println("WebDAVResponseInterpreter::handleResponse");
        }
        res = webDAVResponseEvent.getResponse();
        Method = webDAVResponseEvent.getMethodName();
        extendedCode = webDAVResponseEvent.getExtendedCode();
        extendedData = webDAVResponseEvent.getExtendedData();
        HostName = webDAVResponseEvent.getHost();
        Port = webDAVResponseEvent.getPort();
        Charset = this.getCharset();
        Resource = GlobalData.getGlobalData().unescape(webDAVResponseEvent.getResource(), "ISO-8859-1", null);
        this.Node = webDAVResponseEvent.getNode();
        try {
            if (res.getStatusCode() >= 300) {
                if (res.getStatusCode() == 302 || res.getStatusCode() == 301) {
                    String string = res.getHeader("Location");
                    GlobalData.getGlobalData().errorMsg("The resource requested moved to " + string + "\nPlease try connecting to the new location.");
                    return true;
                } else if ((Method.equals("MOVE") || Method.equals("DELETE")) && (res.getStatusCode() == 412 || res.getStatusCode() == 423)) {
                    if (Method.equals("MOVE")) {
                        if (extendedCode == 31) {
                            ActionEvent actionEvent = new ActionEvent(this, 1001, "reset");
                            actionListener.actionPerformed(actionEvent);
                            GlobalData.getGlobalData().errorMsg("Rename Failed\nStatus " + res.getStatusCode() + " " + res.getReasonLine());
                            return true;
                        } else {
                            this.clearStream();
                            generator.DiscoverLock(31, extendedData);
                        }
                        return true;
                    } else if (extendedCode == 21) {
                        GlobalData.getGlobalData().errorMsg("Delete Failed\nStatus " + res.getStatusCode() + " " + res.getReasonLine());
                        return true;
                    } else {
                        this.clearStream();
                        generator.DiscoverLock(21, null);
                    }
                    return true;
                } else {
                    GlobalData.getGlobalData().errorMsg("DAV Interpreter:\n\n" + res.getStatusCode() + " " + res.getReasonLine());
                }
                return true;
            }
            if (Method.equals("MOVE")) {
                this.parseMove();
                return true;
            }
            if (Method.equals("PROPPATCH")) {
                this.parsePropPatch();
                return true;
            }
        }
        catch (Exception exception) {
            String string = System.getProperty("debug", "false");
            if (!string.equals("true")) throw new ResponseException("HTTP error");
            System.out.println(exception);
            throw new ResponseException("HTTP error");
        }
        if (Method.equals("OPTIONS")) {
            this.parseOptions();
            return true;
        } else if (Method.equals("PROPFIND")) {
            this.parsePropFind();
            return true;
        } else if (Method.equals("MKCOL")) {
            this.parseMkCol();
            return true;
        } else if (Method.equals("GET")) {
            this.parseGet();
            return true;
        } else if (Method.equals("PUT")) {
            this.parsePut();
            return true;
        } else if (Method.equals("DELETE")) {
            this.parseDelete();
            return true;
        } else if (Method.equals("COPY")) {
            try {
                if (res.getStatusCode() != 201) return true;
                this.executeCopy();
                return true;
            }
            catch (Exception exception) {
                System.out.println(exception);
                throw new ResponseException("Copy error");
            }
        } else if (Method.equals("LOCK")) {
            this.parseLock(false);
            return true;
        } else if (Method.equals("UNLOCK")) {
            this.parseUnlock();
            return true;
        } else {
            System.out.println("unsupported method.. cannot parse");
        }
        return true;
    }

    protected void saveProps(Element element, Element element2, int n) {
        ElementImpl elementImpl = null;
        if (element2.getType() == 1) {
            elementImpl = new ElementImpl(null, 1);
            elementImpl.setText(element2.getText());
        } else if (element2.getType() == 0) {
            elementImpl = new ElementImpl(element2.getTagName(), 0);
        } else {
            return;
        }
        element.addChild(WebDAVXML.elemNewline, null);
        for (int i = 0; i < n; ++i) {
            element.addChild(WebDAVXML.elemDSpace, null);
        }
        element.addChild(elementImpl, null);
        if (element2.numElements() > 0) {
            Enumeration enumeration = element2.getElements();
            while (enumeration.hasMoreElements()) {
                Element element3 = (Element)enumeration.nextElement();
                if (element3.getType() != 0 && element3.getType() != 1) continue;
                this.saveProps(elementImpl, element3, n + 1);
            }
            elementImpl.addChild(WebDAVXML.elemNewline, null);
            for (int i = 0; i < n; ++i) {
                elementImpl.addChild(WebDAVXML.elemDSpace, null);
            }
        }
    }

    protected void parseOptions() {
        if (GlobalData.getGlobalData().getDebugResponse()) {
            System.err.println("WebDAVResponseInterpreter::parseOptions");
        }
        try {
            String string = res.getHeader("DAV");
            if (string == null) {
                GlobalData.getGlobalData().errorMsg("DAV Interpreter:\n\nThe server does not support WebDAV\nat Resource " + Resource + ".");
                return;
            }
        }
        catch (Exception exception) {
            GlobalData.getGlobalData().errorMsg("DAV Interpreter:\n\nError encountered \nwhile parsing OPTIONS Response:\n" + exception);
            stream = null;
            return;
        }
        if (extendedCode == 1) {
            generator.DoPropFind(Resource, false);
        }
    }

    protected void parsePropFind() {
        if (GlobalData.getGlobalData().getDebugResponse()) {
            System.err.println("WebDAVResponseInterpreter::parsePropFind");
        }
        byte[] byArray = null;
        Document document = null;
        try {
            byArray = res.getData();
            stream = byArray;
            if (byArray == null) {
                GlobalData.getGlobalData().errorMsg("DAV Interpreter:\n\nMissing XML body in\nPROPFIND response.");
                return;
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            document = new Document();
            document.load(byteArrayInputStream);
        }
        catch (Exception exception) {
            GlobalData.getGlobalData().errorMsg("DAV Interpreter:\n\nError encountered \nwhile parsing PROPFIND Response.\n" + exception);
            stream = null;
            return;
        }
        this.printXML(byArray);
        switch (extendedCode) {
            case 1: {
                this.handleUriBox();
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 20: 
            case 21: 
            case 30: 
            case 31: 
            case 50: 
            case 60: {
                this.handleLocktoken(document);
                break;
            }
            case 5: {
                this.handleProperties(document);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            default: {
                this.setRefresh(this.Node);
                this.fireInsertionEvent(null);
            }
        }
    }

    public String getLockInfo() {
        return GlobalData.getGlobalData().ReadConfigEntry("lockinfo", "DAV Explorer");
    }

    public boolean Refreshing() {
        return refresh;
    }

    public void ResetRefresh() {
        refresh = false;
    }

    public void setRefresh(WebDAVTreeNode webDAVTreeNode) {
        if (GlobalData.getGlobalData().getDebugResponse()) {
            System.err.println("WebDAVResponseInterpreter::setRefresh");
        }
        refresh = true;
        this.Node = webDAVTreeNode;
        this.clearStream();
        CopyResponseEvent copyResponseEvent = new CopyResponseEvent(this, this.Node);
        copyListener.CopyEventResponse(copyResponseEvent);
    }

    protected void parsePropPatch() throws Exception {
        if (GlobalData.getGlobalData().getDebugResponse()) {
            System.err.println("WebDAVResponseInterpreter::parsePropPatch");
        }
    }

    protected void parseMkCol() {
        if (GlobalData.getGlobalData().getDebugResponse()) {
            System.err.println("WebDAVResponseInterpreter::parseMkCol");
        }
        this.clearStream();
        switch (extendedCode) {
            case 40: {
                CopyResponseEvent copyResponseEvent = new CopyResponseEvent(this, this.Node);
                copyListener.CopyEventResponse(copyResponseEvent);
                break;
            }
            case 41: {
                WebDAVTreeNode webDAVTreeNode = generator.getPossibleParentOfSelectedCollectionNode();
                PutEvent putEvent = new PutEvent(this, this.Node, webDAVTreeNode);
                putListener.PutEventResponse(putEvent);
            }
        }
    }

    protected void parseGet() {
        if (GlobalData.getGlobalData().getDebugResponse()) {
            System.err.println("WebDAVResponseInterpreter::parseGet");
        }
        byte[] byArray = null;
        String string = "";
        try {
            Object object;
            int n;
            Object object2;
            FileOutputStream fileOutputStream = null;
            String string2 = Resource.substring(1);
            if (extendedCode == 6) {
                object2 = new FileDialog((Frame)GlobalData.getGlobalData().getMainFrame(), "Save As", 1);
                n = string2.lastIndexOf("/");
                if (n >= 0) {
                    string2 = string2.substring(n + 1);
                }
                ((FileDialog)object2).setFile(string2);
                ((Dialog)object2).setVisible(true);
                object = ((FileDialog)object2).getDirectory();
                if (object == null || ((String)object).equals("")) {
                    return;
                }
                String string3 = ((FileDialog)object2).getFile();
                if (string3 == null || string3.equals("")) {
                    return;
                }
                string = (String)object + string3;
            } else {
                string = WebDAVEditDir + File.separatorChar + string2;
                object2 = new StringBuffer(string);
                for (n = 0; n < ((StringBuffer)object2).length(); ++n) {
                    if (((StringBuffer)object2).charAt(n) != '/' && ((StringBuffer)object2).charAt(n) != '\\') continue;
                    ((StringBuffer)object2).setCharAt(n, File.separatorChar);
                }
                string = ((StringBuffer)object2).toString();
            }
            object2 = string.substring(0, string.lastIndexOf(File.separatorChar));
            File file = new File((String)object2);
            file.mkdirs();
            object = new File(string);
            boolean bl = true;
            String string4 = System.getProperty("os.name").toLowerCase();
            Object var10_13 = null;
            if (((File)object).exists() && string4.indexOf("windows") == -1 && !this.replaceFile(string)) {
                bl = false;
                switch (extendedCode) {
                    case 51: 
                    case 52: {
                        if (this.launchAnyway()) break;
                        return;
                    }
                }
            }
            if (bl) {
                byArray = res.getData();
                fileOutputStream = new FileOutputStream(string);
                if (fileOutputStream == null) {
                    return;
                }
                fileOutputStream.write(byArray);
                fileOutputStream.close();
            }
            switch (extendedCode) {
                case 51: 
                case 52: {
                    String string5 = this.selectApplication();
                    if (string5 == null || string5 == "") break;
                    Runtime runtime = Runtime.getRuntime();
                    String[] stringArray = new String[]{string5, string};
                    runtime.exec(stringArray);
                }
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    protected void parsePut() {
        if (GlobalData.getGlobalData().getDebugResponse()) {
            System.err.println("WebDAVResponseInterpreter::parsePut");
        }
        this.clearStream();
        WebDAVTreeNode webDAVTreeNode = generator.getPossibleParentOfSelectedCollectionNode();
        if (webDAVTreeNode != null) {
            PutEvent putEvent = new PutEvent(this, this.Node, webDAVTreeNode);
            putListener.PutEventResponse(putEvent);
        } else {
            CopyResponseEvent copyResponseEvent = new CopyResponseEvent(this, this.Node);
            copyListener.CopyEventResponse(copyResponseEvent);
        }
        generator.resetParentNode();
    }

    protected void parseDelete() {
        if (GlobalData.getGlobalData().getDebugResponse()) {
            System.err.println("WebDAVResponseInterpreter::parseDelete");
        }
        this.clearStream();
        CopyResponseEvent copyResponseEvent = new CopyResponseEvent(this, this.Node);
        copyListener.CopyEventResponse(copyResponseEvent);
    }

    public void addCopyResponseListener(CopyResponseListener copyResponseListener) {
        copyListener = copyResponseListener;
    }

    public void addPutListener(PutListener putListener) {
        WebDAVResponseInterpreter.putListener = putListener;
    }

    public void addActionListener(ActionListener actionListener) {
        WebDAVResponseInterpreter.actionListener = actionListener;
    }

    public void executeCopy() {
        if (GlobalData.getGlobalData().getDebugResponse()) {
            System.err.println("WebDAVResponseInterpreter::executeCopy");
        }
        CopyResponseEvent copyResponseEvent = new CopyResponseEvent(this, this.Node);
        copyListener.CopyEventResponse(copyResponseEvent);
    }

    protected void parseCopy() {
        if (GlobalData.getGlobalData().getDebugResponse()) {
            System.err.println("WebDAVResponseInterpreter::parseCopy");
        }
        this.setRefresh(this.Node);
        this.fireInsertionEvent(null);
    }

    protected void parseMove() {
        EventObject eventObject;
        if (GlobalData.getGlobalData().getDebugResponse()) {
            System.err.println("WebDAVResponseInterpreter::parseMove");
        }
        try {
            if (res.getStatusCode() >= 300) {
                if (extendedCode == 30) {
                    eventObject = new ActionEvent(this, 1001, "reset");
                    actionListener.actionPerformed((ActionEvent)eventObject);
                }
                GlobalData.getGlobalData().errorMsg("DAV Interpreter:\n\n" + res.getStatusCode() + " " + res.getReasonLine());
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
            return;
        }
        this.clearStream();
        eventObject = new CopyResponseEvent(this, this.Node);
        copyListener.CopyEventResponse((CopyResponseEvent)eventObject);
    }

    protected String parseLock(boolean bl) {
        Object object;
        if (GlobalData.getGlobalData().getDebugResponse()) {
            System.err.println("WebDAVResponseInterpreter::parseLock");
        }
        byte[] byArray = null;
        Document document = null;
        try {
            byArray = res.getData();
            stream = byArray;
            if (byArray == null) {
                if (!bl) {
                    GlobalData.getGlobalData().errorMsg("DAV Interpreter:\n\nMissing XML body in\nLOCK response.");
                }
                return null;
            }
            object = new ByteArrayInputStream(byArray);
            document = new Document();
            document.load((InputStream)object);
        }
        catch (Exception exception) {
            if (!bl) {
                GlobalData.getGlobalData().errorMsg("DAV Interpreter:\n\nError encountered \nwhile parsing LOCK Response.\n" + exception);
                stream = null;
            }
            return null;
        }
        if (!bl) {
            this.printXML(byArray);
        }
        object = null;
        String[] stringArray = new String[]{new String("lockdiscovery"), new String("activelock")};
        Element element = this.skipElements(document, stringArray);
        if (element != null) {
            TreeEnumeration treeEnumeration = new TreeEnumeration(element);
            while (treeEnumeration.hasMoreElements()) {
                Element element2 = (Element)treeEnumeration.nextElement();
                Name name = element2.getTagName();
                if (name == null || !name.getName().equals("locktoken")) continue;
                object = this.getLockToken(element2);
                if (object == null) break;
                ((String)object).trim();
                int n = ((String)object).indexOf("opaque");
                if (n < 0) break;
                object = ((String)object).substring(n);
                break;
            }
        }
        if (!bl) {
            this.fireLockEvent(0, (String)object);
        }
        return object;
    }

    protected void parseUnlock() {
        if (GlobalData.getGlobalData().getDebugResponse()) {
            System.err.println("WebDAVResponseInterpreter::parseUnlock");
        }
        this.fireLockEvent(1, null);
    }

    protected DataNode parseProps(Element element, String string, String string2) {
        Object object;
        if (GlobalData.getGlobalData().getDebugTreeNode()) {
            System.err.println("WebDAVTreeNode::parseProps");
        }
        boolean bl = false;
        boolean bl2 = false;
        String string3 = null;
        String string4 = "";
        String string5 = "";
        String string6 = "0";
        String string7 = "";
        String[] stringArray = new String[]{new String("prop")};
        Element element2 = this.skipElements(element, stringArray);
        if (element2 != null) {
            TreeEnumeration treeEnumeration = new TreeEnumeration(element2);
            while (treeEnumeration.hasMoreElements()) {
                Element element3 = (Element)treeEnumeration.nextElement();
                object = element3.getTagName();
                if (object == null) continue;
                if (((Name)object).getName().equals("displayname")) {
                    string4 = this.getDisplayName(element3);
                    continue;
                }
                if (((Name)object).getName().equals("lockdiscovery")) {
                    string3 = this.lockDiscovery(element3);
                    if (string3 == null) continue;
                    bl2 = true;
                    continue;
                }
                if (((Name)object).getName().equals("resourcetype")) {
                    bl = this.getResourceType(element3) == RESOURCETYPE_COLLECTION;
                    continue;
                }
                if (((Name)object).getName().equals("getcontenttype")) {
                    string5 = this.getContentType(element3);
                    continue;
                }
                if (((Name)object).getName().equals("getcontentlength")) {
                    string6 = this.getContentLength(element3);
                    continue;
                }
                if (!((Name)object).getName().equals("getlastmodified")) continue;
                string7 = this.getLastModified(element3);
            }
        }
        long l = 0L;
        try {
            l = Long.parseLong(string6);
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = new DeltaVDataNode(bl, bl2, string3, string2, string4, string5, l, string7, null);
        return object;
    }

    protected String getDisplayName(Element element) {
        if (GlobalData.getGlobalData().getDebugTreeNode()) {
            System.err.println("WebDAVTreeNode::getDisplayName");
        }
        TreeEnumeration treeEnumeration = new TreeEnumeration(element);
        while (treeEnumeration.hasMoreElements()) {
            Element element2;
            Element element3 = (Element)treeEnumeration.nextElement();
            Name name = element3.getTagName();
            if (name == null || !name.getName().equals("displayname") || (element2 = (Element)treeEnumeration.nextElement()) == null || element2.getType() != 1 && element2.getType() != 6) continue;
            return GlobalData.getGlobalData().unescape(element2.getText(), Charset, null);
        }
        return "";
    }

    protected String lockDiscovery(Element element) {
        if (GlobalData.getGlobalData().getDebugTreeNode()) {
            System.err.println("WebDAVTreeNode::lockDiscovery");
        }
        String[] stringArray = new String[]{new String("activelock")};
        int n = 0;
        TreeEnumeration treeEnumeration = new TreeEnumeration(element);
        while (treeEnumeration.hasMoreElements()) {
            Element element2 = (Element)treeEnumeration.nextElement();
            Name name = element2.getTagName();
            if (n >= 0) {
                if (name != null && name.getName().equals(stringArray[n])) {
                    treeEnumeration = new TreeEnumeration(element2);
                    ++n;
                }
                if (n < stringArray.length) continue;
                n = -1;
                continue;
            }
            if (name == null || !name.getName().equals("locktoken")) continue;
            return this.getLockToken(element2);
        }
        return null;
    }

    protected int getResourceType(Element element) {
        if (GlobalData.getGlobalData().getDebugTreeNode()) {
            System.err.println("WebDAVResponseInterpreter::getResourceType");
        }
        TreeEnumeration treeEnumeration = new TreeEnumeration(element);
        while (treeEnumeration.hasMoreElements()) {
            Element element2 = (Element)treeEnumeration.nextElement();
            Name name = element2.getTagName();
            if (name == null || !name.getName().equals("collection")) continue;
            return RESOURCETYPE_COLLECTION;
        }
        return RESOURCETYPE_NONE;
    }

    protected String getContentType(Element element) {
        if (GlobalData.getGlobalData().getDebugTreeNode()) {
            System.err.println("WebDAVTreeNode::getContentType");
        }
        TreeEnumeration treeEnumeration = new TreeEnumeration(element);
        while (treeEnumeration.hasMoreElements()) {
            Element element2 = (Element)treeEnumeration.nextElement();
            if (element2 == null || element2.getType() != 1 && element2.getType() != 6) continue;
            return GlobalData.getGlobalData().unescape(element2.getText(), Charset, null);
        }
        return "";
    }

    protected String getContentLength(Element element) {
        if (GlobalData.getGlobalData().getDebugTreeNode()) {
            System.err.println("WebDAVTreeNode::getContentLength");
        }
        TreeEnumeration treeEnumeration = new TreeEnumeration(element);
        while (treeEnumeration.hasMoreElements()) {
            Element element2 = (Element)treeEnumeration.nextElement();
            if (element2 == null || element2.getType() != 1 && element2.getType() != 6) continue;
            return GlobalData.getGlobalData().unescape(element2.getText(), Charset, null);
        }
        return "0";
    }

    protected String getLastModified(Element element) {
        if (GlobalData.getGlobalData().getDebugTreeNode()) {
            System.err.println("WebDAVTreeNode::getLastModified");
        }
        TreeEnumeration treeEnumeration = new TreeEnumeration(element);
        while (treeEnumeration.hasMoreElements()) {
            Element element2 = (Element)treeEnumeration.nextElement();
            if (element2 == null || element2.getType() != 1 && element2.getType() != 6) continue;
            return GlobalData.getGlobalData().unescape(element2.getText(), Charset, null);
        }
        return "";
    }

    public void clearStream() {
        stream = null;
    }

    public byte[] getXML() {
        return stream;
    }

    public synchronized void addInsertionListener(InsertionListener insertionListener) {
        listeners.addElement(insertionListener);
    }

    public synchronized void removeInsertionListener(InsertionListener insertionListener) {
        listeners.removeElement(insertionListener);
    }

    public synchronized void addMoveUpdateListener(ActionListener actionListener) {
        moveListeners.addElement(actionListener);
    }

    public synchronized void removeMoveUpdateListener(ActionListener actionListener) {
        moveListeners.removeElement(actionListener);
    }

    public synchronized void addLockListener(ActionListener actionListener) {
        lockListeners.addElement(actionListener);
    }

    public synchronized void removeLockListener(ActionListener actionListener) {
        lockListeners.removeElement(actionListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireInsertionEvent(String string) {
        Vector vector;
        if (GlobalData.getGlobalData().getDebugResponse()) {
            System.err.println("WebDAVResponseInterpreter::fireInsertionEvent");
        }
        Object object = this;
        synchronized (object) {
            vector = (Vector)listeners.clone();
        }
        object = new ActionEvent(this, 0, string);
        for (int i = 0; i < vector.size(); ++i) {
            InsertionListener insertionListener = (InsertionListener)vector.elementAt(i);
            insertionListener.actionPerformed((ActionEvent)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireMoveUpdate(String string) {
        Vector vector;
        if (GlobalData.getGlobalData().getDebugResponse()) {
            System.err.println("WebDAVResponseInterpreter::fireMoveUpdate");
        }
        Object object = this;
        synchronized (object) {
            vector = (Vector)moveListeners.clone();
        }
        object = new ActionEvent(this, 0, string);
        for (int i = 0; i < vector.size(); ++i) {
            ActionListener actionListener = (ActionListener)vector.elementAt(i);
            actionListener.actionPerformed((ActionEvent)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireLockEvent(int n, String string) {
        Vector vector;
        if (GlobalData.getGlobalData().getDebugResponse()) {
            System.err.println("WebDAVResponseInterpreter::fireLockEvent");
        }
        Object object = this;
        synchronized (object) {
            vector = (Vector)lockListeners.clone();
        }
        object = new ActionEvent(this, n, string);
        for (int i = 0; i < vector.size(); ++i) {
            ActionListener actionListener = (ActionListener)vector.elementAt(i);
            actionListener.actionPerformed((ActionEvent)object);
        }
    }

    public String getResource() {
        return Resource;
    }

    public String getHost() {
        return HostName;
    }

    public boolean replaceFile(String string) {
        String string2 = new String(string + " exists.\nReplace?\n");
        int n = JOptionPane.showConfirmDialog(null, string2, "File Exists", 0);
        return n == 0;
    }

    public boolean launchAnyway() {
        String string = new String("View in application?");
        int n = JOptionPane.showConfirmDialog(null, string, "Launch Application?", 0);
        return n == 0;
    }

    public String selectApplication() {
        String string = new String("Select the application to show this file");
        String string2 = JOptionPane.showInputDialog(null, string, "Select Application", 3);
        return string2;
    }

    public void displayLock(String string, String string2, String string3, String string4, String string5, String string6) {
        Object[] objectArray = new Object[]{"OK"};
        if (string4 == null) {
            string4 = "";
        }
        String string7 = "Lock Type:  " + string + "\nLock Scope: " + string2 + "\nLock Depth: " + string3 + "\nLock Owner: " + string6 + "\nLock Token: " + string4 + "\nTimeout:    " + string5 + "\n";
        JOptionPane.showOptionDialog(GlobalData.getGlobalData().getMainFrame(), string7, "Lock Information", -1, 1, null, objectArray, objectArray[0]);
    }

    public static WebDAVRequestGenerator getGenerator() {
        if (generator == null) {
            generator = new WebDAVRequestGenerator();
        }
        return generator;
    }

    protected String getLockToken(Element element) {
        if (GlobalData.getGlobalData().getDebugResponse()) {
            System.err.println("WebDAVResponseInterpreter::getLockToken");
        }
        TreeEnumeration treeEnumeration = new TreeEnumeration(element);
        while (treeEnumeration.hasMoreElements()) {
            String string = this.getHref(treeEnumeration);
            if (string == null) continue;
            return string;
        }
        return null;
    }

    protected String getLockType(Element element) {
        if (GlobalData.getGlobalData().getDebugResponse()) {
            System.err.println("WebDAVResponseInterpreter::getLockType");
        }
        TreeEnumeration treeEnumeration = new TreeEnumeration(element);
        while (treeEnumeration.hasMoreElements()) {
            Element element2 = (Element)treeEnumeration.nextElement();
            Name name = element2.getTagName();
            if (name == null || name.getName().equals("locktype")) continue;
            return name.getName();
        }
        return "";
    }

    protected String getLockScope(Element element) {
        if (GlobalData.getGlobalData().getDebugResponse()) {
            System.err.println("WebDAVResponseInterpreter::getLockScope");
        }
        TreeEnumeration treeEnumeration = new TreeEnumeration(element);
        while (treeEnumeration.hasMoreElements()) {
            Element element2 = (Element)treeEnumeration.nextElement();
            Name name = element2.getTagName();
            if (name == null || name.getName().equals("lockscope")) continue;
            return name.getName();
        }
        return "";
    }

    protected String getOwnerInfo(Element element) {
        if (GlobalData.getGlobalData().getDebugResponse()) {
            System.err.println("WebDAVResponseInterpreter::getOwnerInfo");
        }
        TreeEnumeration treeEnumeration = new TreeEnumeration(element);
        Element element2 = null;
        Element element3 = null;
        Element element4 = null;
        Name name = null;
        while (treeEnumeration.hasMoreElements()) {
            element3 = (Element)treeEnumeration.nextElement();
            name = element3 != null ? element3.getTagName() : null;
            if (name != null && name.getName().equals("owner")) {
                element2 = element3;
                continue;
            }
            if (element2 == null) continue;
            if (name != null && name.getName().equals("href")) {
                element4 = element3;
                continue;
            }
            if (element4 == null && (element3.getType() == 1 || element3.getType() == 6)) {
                return element3.getText();
            }
            if (element4 == null || element3.getType() != 1 && element3.getType() != 6) continue;
            return GlobalData.getGlobalData().unescape(element3.getText(), Charset, null);
        }
        return "";
    }

    protected String getLockTimeout(Element element) {
        if (GlobalData.getGlobalData().getDebugResponse()) {
            System.err.println("WebDAVResponseInterpreter::getLockTimeout");
        }
        TreeEnumeration treeEnumeration = new TreeEnumeration(element);
        while (treeEnumeration.hasMoreElements()) {
            Element element2 = (Element)treeEnumeration.nextElement();
            if (element2 == null || element2.getType() != 1 && element2.getType() != 6) continue;
            return element2.getText();
        }
        return "";
    }

    protected String getLockDepth(Element element) {
        if (GlobalData.getGlobalData().getDebugResponse()) {
            System.err.println("WebDAVResponseInterpreter::getLockDepth");
        }
        TreeEnumeration treeEnumeration = new TreeEnumeration(element);
        while (treeEnumeration.hasMoreElements()) {
            Element element2 = (Element)treeEnumeration.nextElement();
            if (element2 == null || element2.getType() != 1 && element2.getType() != 6) continue;
            return element2.getText();
        }
        return "";
    }

    protected int getStatus(Element element) {
        if (GlobalData.getGlobalData().getDebugResponse()) {
            System.err.println("WebDAVResponseInterpreter::getStatus");
        }
        TreeEnumeration treeEnumeration = new TreeEnumeration(element);
        while (treeEnumeration.hasMoreElements()) {
            StringTokenizer stringTokenizer;
            Element element2 = (Element)treeEnumeration.nextElement();
            Name name = element2.getTagName();
            if (name == null || !name.getName().equals("status") || (element2 = (Element)treeEnumeration.nextElement()) == null || element2.getType() != 1 && element2.getType() != 6 || (stringTokenizer = new StringTokenizer(element2.getText())).countTokens() < 2 || !stringTokenizer.nextToken().equals(HTTPString)) continue;
            int n = Integer.parseInt(stringTokenizer.nextToken());
            return n;
        }
        return 0;
    }

    protected boolean checkHrefValue(Element element) {
        TreeEnumeration treeEnumeration;
        String string;
        if (GlobalData.getGlobalData().getDebugResponse()) {
            System.err.println("WebDAVResponseInterpreter::checkHrefValue");
        }
        if ((string = this.getHref(treeEnumeration = new TreeEnumeration(element))) != null) {
            int n = string.indexOf("https://");
            if (n >= 0) {
                string = string.substring(n + "https://".length());
            }
            if ((n = string.indexOf("http://")) >= 0) {
                string = string.substring(n + "http://".length());
            }
            if ((n = string.indexOf("/")) >= 0) {
                string = string.substring(n);
            }
            if (string.length() == 0) {
                string = "/";
            }
            if (string.equals(Resource)) {
                return true;
            }
        }
        return false;
    }

    public Element skipElements(Document document, String[] stringArray) {
        Element element = document.getRoot();
        return this.skipElements(element, stringArray);
    }

    public Element skipElements(Element element, String[] stringArray) {
        if (GlobalData.getGlobalData().getDebugResponse()) {
            System.err.println("WebDAVResponseInterpreter::skipElements");
        }
        int n = 0;
        TreeEnumeration treeEnumeration = new TreeEnumeration(element);
        while (treeEnumeration.hasMoreElements()) {
            Element element2 = (Element)treeEnumeration.nextElement();
            Name name = element2.getTagName();
            if (n < 0) continue;
            if (name != null && name.getName().equals(stringArray[n])) {
                if (name.getName().equals("href")) {
                    if (!this.checkHrefValue(element2)) {
                        break;
                    }
                } else {
                    treeEnumeration = new TreeEnumeration(element2);
                }
                ++n;
            }
            if (n < stringArray.length) continue;
            return element2;
        }
        return null;
    }

    protected DataNode parseResponse(Element element, String string, Vector vector) {
        return this.parseResponse(element, string, vector, null, null, null);
    }

    protected DataNode parseResponse(Element element, String string, Vector vector, DataNode dataNode, String string2, DefaultMutableTreeNode defaultMutableTreeNode) {
        Object object;
        Object object2;
        if (GlobalData.getGlobalData().getDebugTreeNode()) {
            System.err.println("WebDAVTreeNode::parseResponse");
        }
        Object object3 = null;
        String string3 = "";
        String string4 = "";
        Element element2 = null;
        if (element.numElements() == 0) {
            return null;
        }
        SiblingEnumeration siblingEnumeration = new SiblingEnumeration(element.getChild(0));
        while (siblingEnumeration.hasMoreElements()) {
            element2 = (Element)siblingEnumeration.nextElement();
            object2 = element2.getTagName();
            if (object2 == null) continue;
            if (((Name)object2).getName().equals("href")) {
                object = new TreeEnumeration(element2);
                while (((TreeEnumeration)object).hasMoreElements()) {
                    Element element3 = (Element)((TreeEnumeration)object).nextElement();
                    if (element3 == null || element3.getType() != 1 && element3.getType() != 6) continue;
                    string3 = new String(this.truncateResource(GlobalData.getGlobalData().unescape(element3.getText(), Charset, null)));
                    string4 = new String(this.getFullResource(GlobalData.getGlobalData().unescape(element3.getText(), Charset, null)));
                }
                continue;
            }
            if (!((Name)object2).getName().equals("propstat") || string3 == "") continue;
            object = this.parseProps(element2, string, string3);
            if (object3 == null) {
                object3 = object;
                continue;
            }
            if (((DataNode)object).getDisplay().length() != 0) {
                ((DataNode)object3).setDisplay(((DataNode)object).getDisplay());
            }
            if (((DataNode)object).isLocked() && !((DataNode)object3).isLocked()) {
                ((DataNode)object3).lock(((DataNode)object).getLockToken());
            }
            if (((DataNode)object).isCollection()) {
                ((DataNode)object3).makeCollection();
            }
            if (((DataNode)object).getType().length() != 0) {
                ((DataNode)object3).setType(((DataNode)object).getType());
            }
            if (((DataNode)object).getSize() != 0L) {
                ((DataNode)object3).setSize(((DataNode)object).getSize());
            }
            if (((DataNode)object).getDate() == null) continue;
            ((DataNode)object3).setDate(((DataNode)object).getDate());
        }
        if (object3 != null) {
            object2 = "";
            if (string.endsWith("/")) {
                object2 = string.substring(0, string.length() - 1);
            }
            if (string4.equals(string) || string4.equals(object2)) {
                int n;
                object = string3;
                if (defaultMutableTreeNode != null && (n = defaultMutableTreeNode.getPath().length) == 2) {
                    object = GlobalData.getGlobalData().getSSL() ? "https://" + this.getHost() + "/" + string : "http://" + this.getHost() + "/" + string;
                }
                dataNode = new DataNode(((DataNode)object3).isCollection(), ((DataNode)object3).isLocked(), ((DataNode)object3).getLockToken(), (String)object, ((DataNode)object3).getDisplay(), ((DataNode)object3).getType(), ((DataNode)object3).getSize(), ((DataNode)object3).getDate(), null);
            } else if (((DataNode)object3).isCollection()) {
                if (defaultMutableTreeNode != null) {
                    object = new WebDAVTreeNode((Object)string3, string2);
                    ((WebDAVTreeNode)object).setDataNode((DataNode)object3);
                    defaultMutableTreeNode.insert((MutableTreeNode)object, 0);
                }
            } else {
                vector.addElement(object3);
            }
        }
        if (dataNode == null && defaultMutableTreeNode != null) {
            int n = defaultMutableTreeNode.getPath().length;
            object = string3;
            if (n == 2) {
                object = GlobalData.getGlobalData().getSSL() ? "https://" + this.getHost() + "/" + string : "http://" + this.getHost() + "/" + string;
            }
            dataNode = new DataNode(true, false, null, (String)object, string, "httpd/unix-directory", 0L, "", null);
        }
        return dataNode;
    }

    protected String truncateResource(String string) {
        int n;
        if (GlobalData.getGlobalData().getDebugTreeNode()) {
            System.err.println("WebDAVTreeNode::truncateResource");
        }
        if ((n = string.indexOf("https://")) >= 0) {
            string = string.substring("https://".length());
        }
        if ((n = string.indexOf("http://")) >= 0) {
            string = string.substring("http://".length());
        }
        if ((n = string.indexOf("/")) >= 0) {
            string = string.substring(n);
        }
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        if ((n = string.lastIndexOf("/")) >= 0) {
            string = string.substring(n);
        }
        if (string.startsWith("/") && string.length() > 1) {
            string = string.substring(1);
        }
        if (string.length() == 0) {
            string = "/";
        }
        return string;
    }

    protected String getFullResource(String string) {
        int n;
        if (GlobalData.getGlobalData().getDebugTreeNode()) {
            System.err.println("WebDAVTreeNode::getFullResource");
        }
        if ((n = string.indexOf("https://")) >= 0) {
            string = string.substring("https://".length());
        }
        if ((n = string.indexOf("http://")) >= 0) {
            string = string.substring("http://".length());
        }
        if ((n = string.indexOf("/")) >= 0) {
            string = string.substring(n);
        }
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        if (string.length() == 0) {
            string = "/";
        }
        if (string.startsWith("/") && string.length() > 1) {
            string = string.substring(1);
        }
        return string;
    }

    protected void printXML(byte[] byArray) {
        String string = System.getProperty("debug", "false");
        if (string.equals("true") || this.debugXML) {
            System.out.println("Received xml:");
            XMLOutputStream xMLOutputStream = new XMLOutputStream(System.out);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            Document document = new Document();
            try {
                document.load(byteArrayInputStream);
                document.save(xMLOutputStream);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void reset() {
        generator = null;
        stream = null;
        Method = null;
        extendedCode = 0;
        extendedData = null;
        res = null;
        HostName = null;
        Port = 0;
        Resource = null;
        listeners = new Vector();
        moveListeners = new Vector();
        lockListeners = new Vector();
        WebDAVEditDir = null;
        refresh = false;
        userPathDir = null;
        copyListener = null;
        putListener = null;
        actionListener = null;
    }

    protected String getCharset() {
        if (res == null) {
            return null;
        }
        try {
            String string = res.getHeader("Content-type");
            if (string == null) {
                return "UTF-8";
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            while (stringTokenizer.hasMoreTokens()) {
                StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), "=");
                if (!stringTokenizer2.hasMoreTokens() || !stringTokenizer2.nextToken().trim().equalsIgnoreCase("charset") || !stringTokenizer2.hasMoreTokens()) continue;
                return stringTokenizer2.nextToken().trim();
            }
        }
        catch (ModuleException moduleException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return "UTF-8";
    }

    protected void handleUriBox() {
        if (Port > 0) {
            this.fireInsertionEvent(HostName + ":" + Port + Resource);
        } else {
            this.fireInsertionEvent(HostName + Resource);
        }
    }

    protected void handleLocktoken(Document document) {
        Object object;
        Object object2;
        Object object3;
        String string = null;
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String[] stringArray = new String[]{new String("response"), new String("propstat")};
        Element element = this.skipElements(document, stringArray);
        if (element != null) {
            object3 = new TreeEnumeration(element);
            while (((TreeEnumeration)object3).hasMoreElements()) {
                object2 = (Element)((TreeEnumeration)object3).nextElement();
                object = object2.getTagName();
                if (object == null) continue;
                if (((Name)object).getName().equals("status")) {
                    int n = this.getStatus((Element)object2);
                    if (n < 300 || n < 400) continue;
                    if (n < 500) {
                        switch (extendedCode) {
                            case 10: 
                            case 11: 
                            case 12: {
                                GlobalData.getGlobalData().errorMsg("This resource does not support locking.");
                                return;
                            }
                        }
                        continue;
                    }
                    GlobalData.getGlobalData().errorMsg("Server error: " + n);
                    return;
                }
                if (!((Name)object).getName().equals("prop") || (element = this.skipElements((Element)object2, stringArray = new String[]{new String("prop"), new String("lockdiscovery"), new String("activelock")})) == null) continue;
                object3 = new TreeEnumeration(element);
                while (((TreeEnumeration)object3).hasMoreElements()) {
                    object2 = (Element)((TreeEnumeration)object3).nextElement();
                    object = object2.getTagName();
                    if (object == null) continue;
                    if (((Name)object).getName().equals("locktoken")) {
                        string = this.getLockToken((Element)object2);
                        continue;
                    }
                    if (((Name)object).getName().equals("locktype")) {
                        string3 = this.getLockType((Element)object2);
                        continue;
                    }
                    if (((Name)object).getName().equals("lockscope")) {
                        string4 = this.getLockScope((Element)object2);
                        continue;
                    }
                    if (((Name)object).getName().equals("owner")) {
                        string2 = this.getOwnerInfo((Element)object2);
                        continue;
                    }
                    if (((Name)object).getName().equals("timeout")) {
                        string5 = this.getLockTimeout((Element)object2);
                        continue;
                    }
                    if (!((Name)object).getName().equals("depth")) continue;
                    string6 = this.getLockDepth((Element)object2);
                }
            }
        }
        if (string != null) {
            string.trim();
            int n = string.indexOf("opaque");
            if (n >= 0) {
                string = string.substring(n);
            }
        }
        switch (extendedCode) {
            case 10: {
                object3 = this.getLockInfo();
                generator.GenerateLock((String)object3, string, true);
                generator.execute();
                break;
            }
            case 11: {
                object3 = this.getLockInfo();
                generator.GenerateLock((String)object3, string, false);
                generator.execute();
                break;
            }
            case 12: {
                if (string == null) break;
                generator.GenerateUnlock(string);
                generator.execute();
                break;
            }
            case 20: {
                generator.setNode(this.Node);
                generator.GenerateDelete(string);
                generator.execute();
                break;
            }
            case 30: {
                object3 = extendedData;
                int n = ((String)object3).indexOf(":");
                object = null;
                String string7 = null;
                if (n >= 0) {
                    object = ((String)object3).substring(0, n);
                    string7 = ((String)object3).substring(n + 1);
                } else {
                    object = object3;
                }
                this.clearStream();
                generator.setNode(this.Node);
                generator.GenerateMove((String)object, string7, false, true, string, 30);
                generator.execute();
                break;
            }
            case 31: {
                generator.setSecondTime(true);
                generator.GenerateMove(null, null, false, true, string, 31);
                generator.setSecondTime(false);
                this.clearStream();
                generator.execute();
                break;
            }
            case 21: {
                generator.setSecondTime(true);
                generator.GenerateDelete(string);
                generator.setSecondTime(false);
                this.clearStream();
                generator.execute();
                break;
            }
            case 50: {
                this.displayLock(string3, string4, string6, string, string5, string2);
                break;
            }
            case 60: {
                object3 = Resource.substring(1);
                object2 = WebDAVEditDir + File.separatorChar + (String)object3;
                object = new File((String)object2);
                if (!((File)object).exists()) {
                    GlobalData.getGlobalData().errorMsg("File not found!\n");
                    return;
                }
                generator.GeneratePut((String)object2, (String)object3, string, null);
                generator.execute();
            }
        }
    }

    protected void handleProperties(Document document) {
        String string = this.parseLock(true);
        Document document2 = new Document();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XMLOutputStream xMLOutputStream = new XMLOutputStream(byteArrayOutputStream);
        Object var6_6 = null;
        String[] stringArray = new String[]{new String("response")};
        Element element = this.skipElements(document, stringArray);
        if (element != null) {
            TreeEnumeration treeEnumeration = new TreeEnumeration(element);
            while (treeEnumeration.hasMoreElements()) {
                Element element2 = (Element)treeEnumeration.nextElement();
                Name name = element2.getTagName();
                if (name == null || !name.getName().equals("propstat") || (element = this.skipElements(element2, stringArray = new String[]{new String("propstat"), new String("prop")})) == null) continue;
                String string2 = HostName;
                if (Port != 0) {
                    string2 = HostName + ":" + Port;
                }
                PropDialog propDialog = new PropDialog(element, Resource, string2, string, true);
            }
        }
    }

    protected String getHref(TreeEnumeration treeEnumeration) {
        Element element = (Element)treeEnumeration.nextElement();
        return this.getHref(treeEnumeration, element);
    }

    protected String getHref(TreeEnumeration treeEnumeration, Element element) {
        Element element2;
        Name name = element.getTagName();
        if (name != null && name.getName().equals("href") && (element2 = (Element)treeEnumeration.nextElement()) != null && (element2.getType() == 1 || element2.getType() == 6)) {
            return GlobalData.getGlobalData().unescape(element2.getText(), Charset, null);
        }
        return null;
    }

    static {
        stream = null;
        listeners = new Vector();
        moveListeners = new Vector();
        lockListeners = new Vector();
        WebDAVEditDir = null;
        refresh = false;
    }
}

