/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.HTTPConnection;
import HTTPClient.HttpOutputStream;
import HTTPClient.NVPair;
import HTTPClient.RoRequest;

public final class Request
implements RoRequest,
Cloneable {
    private static final NVPair[] empty = new NVPair[0];
    private HTTPConnection connection;
    private String method;
    private String req_uri;
    private NVPair[] headers;
    private byte[] data;
    private HttpOutputStream stream;
    private boolean allow_ui;
    long delay_entity = 0L;
    int num_retries = 0;
    boolean dont_pipeline = false;
    boolean aborted = false;
    boolean internal_subrequest = false;

    public Request(HTTPConnection hTTPConnection, String string, String string2, NVPair[] nVPairArray, byte[] byArray, HttpOutputStream httpOutputStream, boolean bl) {
        this.connection = hTTPConnection;
        this.method = string;
        this.setRequestURI(string2);
        this.setHeaders(nVPairArray);
        this.data = byArray;
        this.stream = httpOutputStream;
        this.allow_ui = bl;
    }

    public HTTPConnection getConnection() {
        return this.connection;
    }

    public void setConnection(HTTPConnection hTTPConnection) {
        this.connection = hTTPConnection;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String string) {
        this.method = string;
    }

    public String getRequestURI() {
        return this.req_uri;
    }

    public void setRequestURI(String string) {
        if (string != null && string.trim().length() > 0) {
            if (!((string = string.trim()).charAt(0) == '/' || string.equals("*") || this.method.equals("CONNECT") || Request.isAbsolute(string))) {
                string = "/" + string;
            }
            this.req_uri = string;
        } else {
            this.req_uri = "/";
        }
    }

    private static final boolean isAbsolute(String string) {
        int n = 0;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            n = c;
            if (c == ':' || n == 47 || n == 63 || n == 35) break;
        }
        return n == 58;
    }

    public NVPair[] getHeaders() {
        return this.headers;
    }

    public void setHeaders(NVPair[] nVPairArray) {
        this.headers = nVPairArray != null ? nVPairArray : empty;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] byArray) {
        this.data = byArray;
    }

    public HttpOutputStream getStream() {
        return this.stream;
    }

    public void setStream(HttpOutputStream httpOutputStream) {
        this.stream = httpOutputStream;
    }

    public boolean allowUI() {
        return this.allow_ui;
    }

    public void setAllowUI(boolean bl) {
        this.allow_ui = bl;
    }

    public Object clone() {
        Request request;
        try {
            request = (Request)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
        request.headers = new NVPair[this.headers.length];
        System.arraycopy(this.headers, 0, request.headers, 0, this.headers.length);
        return request;
    }

    public void copyFrom(Request request) {
        this.connection = request.connection;
        this.method = request.method;
        this.req_uri = request.req_uri;
        this.headers = request.headers;
        this.data = request.data;
        this.stream = request.stream;
        this.allow_ui = request.allow_ui;
        this.delay_entity = request.delay_entity;
        this.num_retries = request.num_retries;
        this.dont_pipeline = request.dont_pipeline;
        this.aborted = request.aborted;
        this.internal_subrequest = request.internal_subrequest;
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.method + " " + this.req_uri;
    }
}

