/*
 * Decompiled with CFR 0.152.
 */
package com.ms.xml.parser;

import com.ms.xml.om.Element;
import com.ms.xml.om.ElementImpl;
import com.ms.xml.parser.ParseException;
import com.ms.xml.parser.Parser;
import com.ms.xml.util.Atom;
import com.ms.xml.util.Name;
import com.ms.xml.util.XMLOutputStream;
import java.io.IOException;
import java.util.Vector;

public class AttDef {
    public static final int CDATA = 0;
    public static final int ID = 1;
    public static final int IDREF = 2;
    public static final int IDREFS = 3;
    public static final int ENTITY = 4;
    public static final int ENTITIES = 5;
    public static final int NMTOKEN = 6;
    public static final int NMTOKENS = 7;
    public static final int NOTATION = 8;
    public static final int ENUMERATION = 9;
    public static final int DEFAULT = 0;
    public static final int REQUIRED = 1;
    public static final int IMPLIED = 2;
    public static final int FIXED = 3;
    Name name;
    byte type;
    byte presence;
    Object def;
    Vector values;
    static Name nameATTRIBUTE = Name.create("ATTRIBUTE", "XML");
    static Name nameID = Name.create("ID", "XML");
    static Name nameDEFAULT = Name.create("DEFAULT", "XML");
    static Name namePRESENCE = Name.create("PRESENCE", "XML");
    static Name nameVALUES = Name.create("VALUES", "XML");
    static Name nameTYPE = Name.create("TYPE", "XML");

    String typeToString() {
        switch (this.type) {
            case 1: {
                return "ID";
            }
            case 2: {
                return "IDREF";
            }
            case 3: {
                return "IDREFS";
            }
            case 4: {
                return "ENTITY";
            }
            case 5: {
                return "ENTITIES";
            }
            case 6: {
                return "NMTOKEN";
            }
            case 7: {
                return "NMTOKENS";
            }
            case 8: {
                return "NOTATION";
            }
            case 9: {
                return "ENUMERATION";
            }
        }
        return "CDATA";
    }

    String presenceToString() {
        switch (this.presence) {
            case 2: {
                return "IMPLIED";
            }
            case 1: {
                return "REQUIRED";
            }
            case 3: {
                return "FIXED";
            }
        }
        return "DEFAULT";
    }

    AttDef(Name name, int n) {
        this(name, n, null, 0, null);
    }

    AttDef(Name name, int n, Vector vector) {
        this(name, n, null, 0, vector);
    }

    AttDef(Name name, int n, Object object, int n2) {
        this(name, n, object, n2, null);
    }

    AttDef(Name name, int n, Object object, int n2, Vector vector) {
        this.name = name;
        this.type = (byte)n;
        this.def = object;
        this.presence = (byte)n2;
        this.values = vector;
    }

    final Object parseAttribute(Element element, Parser parser) throws ParseException {
        parser.parseToken(39, "string");
        return this.parseAttValue(element, parser, false);
    }

    private void reportMismatch(Parser parser) throws ParseException {
        parser.error("Attribute " + this.name + " should have the fixed value \"" + this.def + "\"");
    }

    private void reportEmpty(Parser parser, String string) throws ParseException {
        parser.error("Expected " + parser.tokenString(-4, string) + " insteadof " + parser.tokenString(parser.token, null));
    }

    final Object parseAttValue(Element element, Parser parser, boolean bl) throws ParseException {
        Vector vector;
        Name name = null;
        switch (this.type) {
            case 0: {
                parser.scanString(parser.quote, 38, 38, 60);
                vector = parser.text;
                if (bl || this.presence != 3 || this.def.toString().equals(parser.text)) break;
                this.reportMismatch(parser);
                break;
            }
            case 1: {
                ++parser.simplename;
                parser.parseToken(-4, "ID");
                --parser.simplename;
                parser.parseToken(39, "string");
                if (!bl) {
                    Element element2;
                    if (this.presence == 3 && (Name)this.def != parser.name) {
                        this.reportMismatch(parser);
                    }
                    if ((element2 = parser.dtd.findID(parser.name)) != null) {
                        parser.error("ID " + name + " is already used on element " + element2.getTagName());
                    }
                    parser.dtd.addID(parser.name, element);
                }
                vector = parser.name;
                break;
            }
            case 2: 
            case 3: {
                Vector vector2 = new Vector();
                StringBuffer stringBuffer = new StringBuffer();
                ++parser.simplename;
                int n = parser.parseNames(vector2, 0, stringBuffer);
                --parser.simplename;
                if (n == 0) {
                    this.reportEmpty(parser, "IDREF");
                }
                if (n > 1 && this.type == 2) {
                    parser.error("IDREF type attribute \"" + this.name + "\" cannot refer to more than one ID.");
                }
                if (!bl) {
                    --n;
                    while (n >= 0) {
                        name = (Name)vector2.elementAt(n);
                        if (this.presence == 3) {
                            if (this.type == 3) {
                                this.checkFixed(name, parser);
                            } else if ((Name)this.def != name) {
                                this.reportMismatch(parser);
                            }
                        }
                        if (parser.dtd.findID(name) == null) {
                            parser.dtd.addIDCheck(name, parser.reader.line, parser.reader.column - 1, parser.reader.owner);
                        }
                        --n;
                    }
                }
                vector = this.type == 2 ? vector2.elementAt(0) : vector2;
                break;
            }
            case 4: 
            case 5: {
                StringBuffer stringBuffer = new StringBuffer();
                Vector vector3 = new Vector();
                ++parser.nouppercase;
                int n = parser.parseNames(vector3, 0, stringBuffer);
                --parser.nouppercase;
                if (n == 0) {
                    this.reportEmpty(parser, "ENTITY name");
                }
                if (n > 1 && this.type == 4) {
                    parser.error("ENTITY type attribute \"" + this.name + "\" cannot refer to more than one entity.");
                }
                --n;
                while (n >= 0) {
                    name = (Name)vector3.elementAt(n);
                    if (parser.dtd.findEntity(name) == null) {
                        parser.error("Couldn't find entity '" + name + "'");
                    }
                    if (!bl && this.presence == 3) {
                        if (this.type == 5) {
                            this.checkFixed(name, parser);
                        } else if (name != (Name)this.def) {
                            this.reportMismatch(parser);
                        }
                    }
                    --n;
                }
                vector = this.type == 4 ? vector3.elementAt(0) : vector3;
                break;
            }
            case 6: 
            case 7: {
                StringBuffer stringBuffer = new StringBuffer();
                Vector vector4 = new Vector();
                ++parser.nametoken;
                int n = parser.parseNames(vector4, 0, stringBuffer);
                --parser.nametoken;
                if (n == 0) {
                    this.reportEmpty(parser, "NMTOKEN");
                }
                if (n > 1 && this.type == 6) {
                    parser.error("NMTOKEN type attribute \"" + this.name + "\" cannot refer to more than one name token.");
                }
                if (!bl && this.presence == 3) {
                    if (this.type == 6) {
                        if ((Name)this.def != (Name)vector4.elementAt(0)) {
                            this.reportMismatch(parser);
                        }
                    } else {
                        for (n = vector4.size() - 1; n >= 0; --n) {
                            this.checkFixed((Name)vector4.elementAt(n), parser);
                        }
                    }
                }
                vector = this.type == 6 ? vector4.elementAt(0) : vector4;
                break;
            }
            case 8: 
            case 9: {
                int n;
                if (this.type == 9) {
                    ++parser.nametoken;
                }
                parser.parseToken(-4, "name");
                if (this.type == 9) {
                    --parser.nametoken;
                }
                parser.parseToken(39, "string");
                for (n = this.values.size() - 1; n >= 0 && (Name)this.values.elementAt(n) != parser.name; --n) {
                }
                if (n < 0) {
                    parser.error("Attribute value '" + parser.name + "' is  not in the allowed set.");
                }
                if (!bl && this.presence == 3 && parser.name != this.def) {
                    this.reportMismatch(parser);
                }
                vector = parser.name;
                break;
            }
            default: {
                vector = null;
            }
        }
        return vector;
    }

    private void checkFixed(Name name, Parser parser) throws ParseException {
        int n;
        Vector vector = (Vector)this.def;
        for (n = vector.size() - 1; n >= 0 && (Name)vector.elementAt(n) != name; --n) {
        }
        if (n < 0) {
            parser.error("Attribue value " + name + " is not in the fixed value set.");
        }
    }

    Element toSchema() {
        ElementImpl elementImpl = new ElementImpl(nameATTRIBUTE, 0);
        elementImpl.setAttribute(nameID, (Object)this.name.getName());
        elementImpl.setAttribute(nameTYPE, (Object)this.typeToString());
        if (this.presence != 0) {
            elementImpl.setAttribute(namePRESENCE, (Object)this.presenceToString());
        }
        if (this.type == 9) {
            String string = "";
            for (int i = 0; i < this.values.size(); ++i) {
                Name name = (Name)this.values.elementAt(i);
                string = string + name.toString();
                if (i >= this.values.size() - 1) continue;
                string = string + " ";
            }
            elementImpl.setAttribute(nameVALUES, (Object)string);
        }
        if (this.def != null) {
            elementImpl.setAttribute(nameDEFAULT, this.def);
        }
        return elementImpl;
    }

    void save(Atom atom, XMLOutputStream xMLOutputStream) throws IOException {
        Object object;
        int n;
        if (this.name == Parser.nameXMLSpace) {
            xMLOutputStream.writeChars(this.name.getName());
        } else {
            xMLOutputStream.writeQualifiedName(this.name, atom);
        }
        switch (this.type) {
            case 0: {
                xMLOutputStream.writeChars(" CDATA");
                break;
            }
            case 1: {
                xMLOutputStream.writeChars(" ID");
                break;
            }
            case 2: {
                xMLOutputStream.writeChars(" IDREF");
                break;
            }
            case 3: {
                xMLOutputStream.writeChars(" IDREFS");
                break;
            }
            case 4: {
                xMLOutputStream.writeChars(" ENTITY");
                break;
            }
            case 5: {
                xMLOutputStream.writeChars(" ENTITIES");
                break;
            }
            case 6: {
                xMLOutputStream.writeChars(" NMTOKEN");
                break;
            }
            case 7: {
                xMLOutputStream.writeChars(" NMTOKENS");
                break;
            }
            case 8: {
                xMLOutputStream.writeChars(" NOTATION");
            }
            case 9: {
                xMLOutputStream.writeChars(" (");
                for (n = 0; n < this.values.size(); ++n) {
                    object = (Name)this.values.elementAt(n);
                    if (this.type == 8) {
                        xMLOutputStream.writeQualifiedName((Name)object, atom);
                    } else {
                        xMLOutputStream.writeChars(((Name)object).toString());
                    }
                    if (n >= this.values.size() - 1) continue;
                    xMLOutputStream.write(124);
                }
                xMLOutputStream.write(41);
            }
        }
        block12 : switch (this.presence) {
            case 1: {
                xMLOutputStream.writeChars(" #REQUIRED");
                break;
            }
            case 2: {
                xMLOutputStream.writeChars(" #IMPLIED");
                break;
            }
            case 0: 
            case 3: {
                if (this.presence == 3) {
                    xMLOutputStream.writeChars(" #FIXED");
                }
                if (this.def == null) break;
                xMLOutputStream.writeChars(" ");
                switch (this.type) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 6: 
                    case 9: {
                        xMLOutputStream.writeQuotedString(this.def.toString());
                        break block12;
                    }
                    case 4: 
                    case 8: {
                        xMLOutputStream.write(34);
                        xMLOutputStream.writeQualifiedName((Name)this.def, atom);
                        xMLOutputStream.write(34);
                        break block12;
                    }
                    case 3: 
                    case 5: 
                    case 7: {
                        xMLOutputStream.write(34);
                        n = 0;
                        object = ((Vector)this.def).elements();
                        while (object.hasMoreElements()) {
                            if (n++ > 0) {
                                xMLOutputStream.write(124);
                            }
                            if (this.type == 5) {
                                xMLOutputStream.writeQualifiedName((Name)object.nextElement(), atom);
                                continue;
                            }
                            xMLOutputStream.writeChars(object.nextElement().toString());
                        }
                        xMLOutputStream.write(34);
                    }
                }
            }
        }
    }

    public Object getDefault() {
        return this.def;
    }

    public Name getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public int getPresence() {
        return this.presence;
    }
}

