/*
 * Decompiled with CFR 0.152.
 */
package com.ms.xml.parser;

import com.ms.xml.om.Element;
import com.ms.xml.om.ElementFactory;
import com.ms.xml.parser.AttDef;
import com.ms.xml.parser.Context;
import com.ms.xml.parser.DTD;
import com.ms.xml.parser.ElementDecl;
import com.ms.xml.parser.Entity;
import com.ms.xml.parser.EntityReader;
import com.ms.xml.parser.Notation;
import com.ms.xml.parser.ParseException;
import com.ms.xml.util.Atom;
import com.ms.xml.util.EnumWrapper;
import com.ms.xml.util.Name;
import com.ms.xml.util.XMLInputStream;
import com.ms.xml.util.XMLOutputStream;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;

public class Parser {
    static final int TAGSTART = 60;
    static final int TAGEND = 62;
    static final int SLASH = 47;
    static final int EQ = 61;
    static final int LPAREN = 40;
    static final int RPAREN = 41;
    static final int BANG = 33;
    static final int QMARK = 63;
    static final int DASH = 45;
    static final int PERCENT = 37;
    static final int AMP = 38;
    static final int LEFTSQB = 91;
    static final int RIGHTSQB = 93;
    static final int QUOTE = 39;
    static final int OR = 124;
    static final int ASTERISK = 42;
    static final int PLUS = 43;
    static final int HASH = 35;
    static final int COMMA = 44;
    static final int INVALIDTOKEN = 0;
    static final int EOF = -1;
    static final int WHITESPACE = -2;
    static final int WORDCHAR = -3;
    static final int NAME = -4;
    static final int TEXT = -5;
    static final int PITAGSTART = -6;
    static final int PITAGEND = -7;
    static final int DECLTAGSTART = -8;
    static final int CLOSETAGSTART = -9;
    static final int EMPTYTAGEND = -10;
    static final int COMMENT = -11;
    static final int DOCTYPE = -12;
    static final int SYSTEM = -13;
    static final int CDATATAGSTART = -14;
    static final int ELEMENT = -15;
    static final int EMPTY = -16;
    static final int ANY = -17;
    static final int PCDATA = -18;
    static final int ATTLIST = -19;
    static final int CDATA = -20;
    static final int ID = -21;
    static final int IDREF = -22;
    static final int IDREFS = -23;
    static final int ENTITY = -24;
    static final int ENTITIES = -25;
    static final int NMTOKEN = -26;
    static final int NMTOKENS = -27;
    static final int NOTATION = -28;
    static final int ENUMERATION = -29;
    static final int FIXED = -30;
    static final int REQUIRED = -31;
    static final int IMPLIED = -32;
    static final int NDATA = -33;
    static final int INCLUDETAGSTART = -34;
    static final int IGNORETAGSTART = -35;
    static final int NAMESPACE = -36;
    static final int EXTENDS = -37;
    static final int IMPLEMENTS = -38;
    static final int XML = -39;
    static final int VERSION = -40;
    static final int ENCODING = -41;
    static final int STANDALONE = -42;
    static final int CDEND = -43;
    static final int PUBLIC = -100;
    ElementFactory factory;
    DTD dtd;
    Element root;
    Vector contexts = new Vector(16);
    int contextAt = 0;
    Context current;
    EntityReader reader;
    XMLInputStream xmlIn;
    boolean inTag;
    boolean seenWS;
    int lookahead;
    char quote;
    char[] chars = new char[20000];
    int charAt;
    char[] buf = new char[20000];
    int bufAt;
    int nameappend;
    static Hashtable tokens;
    int token;
    int keyword;
    int nouppercase;
    int substitution;
    int breakText;
    int nametoken;
    int simplename;
    int inEntityRef;
    boolean expandNamedEntities;
    static boolean jdk11;
    Name name;
    String text;
    URL url;
    Name docType;
    boolean internalSubset;
    boolean caseInsensitive;
    boolean firstLine = true;
    static ElementDecl XMLDecl;
    Name conditionRef;
    boolean standAlone;
    boolean loadexternal;
    static int[] chartype;
    static char[] charupper;
    static final int FWHITESPACE = 1;
    static final int FDIGIT = 2;
    static final int FLETTER = 4;
    static final int FMISCNAME = 8;
    static final int FSTARTNAME = 16;
    static final char nameSpaceSeparator = ':';
    static boolean strict;
    static Name nameComment;
    static Name nameCDATA;
    static Name namePCDATA;
    static Name nameVERSION;
    static Name nameENCODING;
    static Name nameDOCTYPE;
    static Name nameXML;
    static Name nameStandalone;
    static Name nameYes;
    static Name nameNo;
    static Name nameURL;
    static Name namePUBLICID;
    static Name nameNAME;
    static Name nameXMLSpace;
    static Name nameXMLSpace2;
    static Name nameXMLAS;
    static Name nameXMLHREF;
    static Name nameXMLNameSpace;
    static Atom atomXML;
    static Name nameXMLLang;

    public Parser() {
        String string = System.getProperty("java.version");
        boolean bl = jdk11 = string.equals("1.1");
        if (!jdk11) {
            float f = Float.valueOf(string.substring(0, 3)).floatValue();
            jdk11 = (double)f >= 1.1;
        }
        this.caseInsensitive = false;
    }

    public final void parse(URL uRL, ElementFactory elementFactory, DTD dTD, Element element, boolean bl, boolean bl2) throws ParseException {
        this.dtd = dTD;
        this.root = element;
        this.loadexternal = bl2;
        this.setURL(uRL);
        this.setFactory(elementFactory);
        this.caseInsensitive = bl;
        this.safeParse();
    }

    final void safeParse() throws ParseException {
        try {
            this.parseDocument();
        }
        catch (ParseException parseException) {
            if (this.xmlIn != null) {
                try {
                    this.xmlIn.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw parseException;
        }
        try {
            this.xmlIn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void parse(InputStream inputStream, ElementFactory elementFactory, DTD dTD, Element element, boolean bl, boolean bl2) throws ParseException {
        this.dtd = dTD;
        this.url = null;
        this.root = element;
        this.loadexternal = bl2;
        this.setInputStream(inputStream);
        this.setFactory(elementFactory);
        this.caseInsensitive = bl;
        this.safeParse();
    }

    public final void report(ParseException parseException, OutputStream outputStream) {
        PrintStream printStream = new PrintStream(outputStream);
        String string = null;
        printStream.println(parseException.getMessage());
        if (parseException.owner instanceof Parser) {
            URL uRL = ((Parser)parseException.owner).url;
            if (uRL != null) {
                string = uRL.toString();
            }
        } else {
            string = parseException.owner instanceof Entity ? "Parsing <" + ((Entity)parseException.owner).name + ">" : "Parsing";
        }
        printStream.println("Location: " + string + "(" + parseException.line + "," + parseException.column + ")");
        printStream.print("Context: ");
        for (int i = 0; i < this.contextAt; ++i) {
            Name name = ((Context)this.contexts.elementAt((int)i)).e.getTagName();
            if (name == null) continue;
            printStream.print("<" + name + ">");
        }
        printStream.print("<");
        if (this.current != null) {
            printStream.print(this.current.e.getTagName());
        }
        printStream.println(">");
    }

    public final XMLOutputStream createOutputStream(OutputStream outputStream) {
        if (this.xmlIn != null) {
            return this.xmlIn.createOutputStream(outputStream);
        }
        return null;
    }

    final void error(String string) throws ParseException {
        int n = 1;
        if (this.token == -4) {
            n = this.name.toString().length();
        }
        throw new ParseException(string, this.reader.line, this.reader.column - 1 - n, this.reader.owner);
    }

    final void advance() throws ParseException {
        this.lookahead = this.reader.read();
        while (this.lookahead == -1 && this.reader.owner != this) {
            if (this.charAt != 0) {
                this.addPCDATA();
            }
            this.reader = this.reader.prev;
            this.pop();
            if (!this.inTag) {
                this.charAt = 0;
            }
            this.lookahead = this.reader.read();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final int nextToken() throws ParseException {
        int n = this.bufAt = 0;
        if (this.inTag || !this.current.preserveWS) {
            while (Parser.isWhiteSpaceChar((char)this.lookahead)) {
                if (!this.inTag) {
                    this.buf[this.bufAt++] = (char)this.lookahead;
                    this.seenWS = true;
                }
                this.advance();
            }
        }
        if (this.inTag) {
            switch (this.lookahead) {
                case -1: {
                    this.token = -1;
                    return this.token;
                }
                case 62: {
                    this.token = 62;
                    this.inTag = false;
                    this.advance();
                    return this.token;
                }
                case 47: {
                    this.advance();
                    if (this.lookahead != 62) return this.token;
                    this.token = -10;
                    this.inTag = false;
                    this.advance();
                    return this.token;
                }
                case 63: {
                    this.advance();
                    if (this.current.type == 9) {
                        this.token = 63;
                        return this.token;
                    }
                    if (this.lookahead == 62) {
                        this.token = -7;
                        this.inTag = false;
                        this.advance();
                        return this.token;
                    }
                    this.token = 63;
                    return this.token;
                }
                case 35: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 61: 
                case 91: 
                case 93: 
                case 124: {
                    this.token = this.lookahead;
                    this.advance();
                    return this.token;
                }
                case 37: {
                    this.advance();
                    if (this.substitution > 0 && Parser.isNameChar((char)this.lookahead)) {
                        this.scanEntityRef(true);
                        return this.nextToken();
                    }
                    this.token = 37;
                    return this.token;
                }
                case 34: 
                case 39: {
                    this.quote = (char)this.lookahead;
                    this.token = 39;
                    this.advance();
                    return this.token;
                }
                default: {
                    if (Parser.isNameChar((char)this.lookahead) || ':' == (char)this.lookahead) {
                        this.scanName("name");
                        if (this.keyword <= 0) return this.token;
                        this.token = this.lookup(this.name.getName());
                        return this.token;
                    }
                    this.error("Unexpected token '" + (char)this.lookahead + "' inside tag <" + this.current.e.getTagName() + ">");
                    return this.token;
                }
            }
        } else {
            if (this.seenWS && !this.current.lastWasWS && (this.lookahead == -1 || this.lookahead == 60)) {
                this.addNewElement(12, null, false, new String(this.buf, n, this.bufAt - n));
            }
            switch (this.lookahead) {
                case -1: {
                    this.token = -1;
                    return this.token;
                }
                case 60: {
                    this.inTag = true;
                    this.seenWS = false;
                    this.advance();
                    switch (this.lookahead) {
                        case 63: {
                            this.token = -6;
                            this.advance();
                            return this.token;
                        }
                        case 33: {
                            this.token = -8;
                            this.advance();
                            if (this.lookahead == 45) {
                                this.advance();
                                if (this.lookahead == 45) {
                                    this.token = -11;
                                    this.advance();
                                    return this.token;
                                }
                                this.error("Bad comment start syntax.  Expected '<!--'");
                                return this.token;
                            }
                            if (this.lookahead != 91) return this.token;
                            this.advance();
                            boolean bl = false;
                            if (this.lookahead == 37) {
                                this.advance();
                                Entity entity = this.scanEntityRef(true);
                                this.conditionRef = entity.getName();
                                bl = true;
                            } else {
                                this.conditionRef = null;
                            }
                            this.parseKeyword(0, "CDATA or Conditional section start tag");
                            if (this.token == -34 || this.token == -35 || this.token == -20 && !bl) {
                                if (this.token == -20) {
                                    this.token = -14;
                                } else {
                                    this.inTag = false;
                                }
                                if (this.lookahead == 91) {
                                    this.advance();
                                    return this.token;
                                }
                                if (this.token == -14) {
                                    this.error("Bad CDATA start syntax. Expected '['");
                                    return this.token;
                                }
                                this.error("Bad conditional section start syntax. Expected '['");
                                return this.token;
                            }
                            this.error("Bad start tag: '<!['" + this.tokenString(this.token) + this.token);
                            return this.token;
                        }
                        case 47: {
                            this.token = -9;
                            this.advance();
                            return this.token;
                        }
                        default: {
                            this.token = 60;
                            return this.token;
                        }
                    }
                }
                case 93: {
                    this.advance();
                    if (this.lookahead == 93) {
                        this.advance();
                        if (this.lookahead == 62) {
                            this.advance();
                            this.token = -43;
                            return this.token;
                        }
                        this.reader.push((char)this.lookahead);
                        this.reader.push(']');
                        this.lookahead = 93;
                    } else {
                        this.reader.push((char)this.lookahead);
                        this.lookahead = 93;
                    }
                    if (this.breakText == this.lookahead) {
                        this.advance();
                        this.token = 93;
                        return this.token;
                    }
                }
                default: {
                    this.token = -5;
                }
            }
        }
        return this.token;
    }

    final String tokenString(int n) {
        return this.tokenString(n, null);
    }

    final String tokenString(int n, String string) {
        switch (n) {
            case 60: {
                return "start tag(<)";
            }
            case 62: {
                return "tag end(>)";
            }
            case 47: {
                return "/";
            }
            case 61: {
                return "=";
            }
            case 40: {
                return "(";
            }
            case 41: {
                return ")";
            }
            case 33: {
                return "!";
            }
            case 63: {
                return "question mark(?)";
            }
            case 45: {
                return "-";
            }
            case 37: {
                return "percent(%)";
            }
            case 38: {
                return "&";
            }
            case 91: {
                return "[";
            }
            case 93: {
                return "]";
            }
            case 39: {
                return "quote(' or \")";
            }
            case 124: {
                return "|";
            }
            case 42: {
                return "*";
            }
            case 43: {
                return "+";
            }
            case 35: {
                return "#";
            }
            case 44: {
                return ",";
            }
            case 0: {
                return "invalidtoken";
            }
            case -1: {
                return "EOF";
            }
            case -2: {
                return "whitespace";
            }
            case -3: {
                return "word character";
            }
            case -4: {
                if (string != null) {
                    return string;
                }
                return "NAME '" + this.name + "'";
            }
            case -5: {
                return "TEXT '" + this.text + "'";
            }
            case -6: {
                return "<?";
            }
            case -7: {
                return "?>";
            }
            case -43: {
                return "]]>";
            }
            case -8: {
                return "<!";
            }
            case -9: {
                return "</";
            }
            case -10: {
                return "/>";
            }
            case -11: {
                return "<!--";
            }
            case -12: {
                return "DOCTYPE";
            }
            case -13: {
                return "SYSTEM";
            }
            case -14: {
                return "<![CDATA";
            }
            case -15: {
                return "ELEMENT";
            }
            case -16: {
                return "EMPTY";
            }
            case -17: {
                return "ANY";
            }
            case -18: {
                return "PCDATA";
            }
            case -19: {
                return "ATTLIST";
            }
            case -20: {
                return "CDATA";
            }
            case -21: {
                return "ID";
            }
            case -22: {
                return "IDREF";
            }
            case -23: {
                return "IDREFS";
            }
            case -24: {
                return "ENTITY";
            }
            case -25: {
                return "ENTITIES";
            }
            case -26: {
                return "NMTOKEN";
            }
            case -27: {
                return "NMTOKENS";
            }
            case -28: {
                return "NOTATION";
            }
            case -29: {
                return "ENUMERATION";
            }
            case -30: {
                return "FIXED";
            }
            case -31: {
                return "REQUIRED";
            }
            case -32: {
                return "IMPLIED";
            }
            case -33: {
                return "NDATA";
            }
            case -34: {
                return "INCLUDETAGSTART";
            }
            case -35: {
                return "IGNORETAGSTART";
            }
            case -36: {
                return "NAMESPACE";
            }
            case -100: {
                return "PUBLIC";
            }
        }
        return string;
    }

    final int lookup(String string) {
        Object v = tokens.get(string);
        this.token = v != null ? (Integer)v : -4;
        return this.token;
    }

    static final boolean isWhiteSpaceChar(char c) {
        if (c < '\u0100') {
            return (chartype[c] & 1) != 0;
        }
        return Character.isWhitespace(c);
    }

    static final boolean isNameChar(char c) {
        if (c < '\u0100') {
            return (chartype[c] & 0xE) != 0;
        }
        return Character.isLetter(c) || Character.isDigit(c) || c == '-' || c == '_' || c == '.';
    }

    final void scanName(String string) throws ParseException {
        String string2 = null;
        Atom atom = null;
        boolean bl = false;
        if (this.nameappend == 0) {
            this.bufAt = 0;
        }
        int n = this.bufAt;
        if (':' != (char)this.lookahead) {
            this.bufAt = this.scanSimpleName(this.bufAt, string);
            bl = true;
        }
        if (this.nametoken == 0 && this.simplename == 0 && ':' == (char)this.lookahead) {
            int n2 = 1;
            ++this.bufAt;
            this.advance();
            if (':' == (char)this.lookahead) {
                ++n2;
                ++this.bufAt;
                this.advance();
            }
            if (bl) {
                string2 = this.caseInsensitive ? new String(this.buf, n, this.bufAt - n - n2).toUpperCase() : new String(this.buf, n, this.bufAt - n - n2);
                Atom atom2 = Atom.create(string2);
                if (DTD.isReservedNameSpace(atom2)) {
                    atom = atom2;
                } else {
                    atom = this.current.findNameSpace(atom2);
                    if (atom == null && (atom = this.dtd.findLongNameSpace(atom2)) == null) {
                        atom = atom2;
                        this.addNameSpace(atom, atom, false);
                    }
                }
            }
            n = this.bufAt;
            this.bufAt = this.scanSimpleName(this.bufAt, string);
        } else if (this.nametoken == 0 && this.simplename == 0 || this.inEntityRef > 0) {
            atom = this.current.defaultNameSpace;
        }
        if (this.nametoken == 0 && this.simplename == 0 || this.inEntityRef > 0) {
            this.current.nameSpace = atom;
        }
        this.name = this.keyword > 0 && this.inEntityRef == 0 || atom == null ? Name.create(this.buf, n, this.bufAt - n) : Name.create(new String(this.buf, n, this.bufAt - n), atom);
        this.token = -4;
    }

    final char toUpperCase(char c) {
        if (this.nouppercase != 0) {
            return c;
        }
        if (c < '\u0100') {
            return charupper[c];
        }
        return Character.toUpperCase(c);
    }

    final int scanSimpleName(int n, String string) throws ParseException {
        boolean bl;
        if (this.lookahead < 256) {
            String string2 = System.getProperty("SharePoint", "no");
            bl = string2.equalsIgnoreCase("yes") || string2.equalsIgnoreCase("true") ? (chartype[this.lookahead] & 0x16) != 0 : (chartype[this.lookahead] & 0x14) != 0;
        } else {
            boolean bl2 = bl = Character.isLetter((char)this.lookahead) || this.lookahead == 95;
        }
        if (!(bl || this.nametoken > 0 && Character.isDigit((char)this.lookahead))) {
            this.error("Expecting " + string + " instead of '" + (char)this.lookahead + "'");
        }
        if (this.nametoken == 0 && this.simplename == 0) {
            if (this.caseInsensitive) {
                this.buf[n++] = this.toUpperCase((char)this.lookahead);
                this.advance();
                while (Parser.isNameChar((char)this.lookahead)) {
                    this.buf[n++] = this.toUpperCase((char)this.lookahead);
                    this.advance();
                }
            } else {
                this.buf[n++] = (char)this.lookahead;
                this.advance();
                while (Parser.isNameChar((char)this.lookahead)) {
                    this.buf[n++] = (char)this.lookahead;
                    this.advance();
                }
            }
        } else if (this.caseInsensitive) {
            this.buf[n++] = this.toUpperCase((char)this.lookahead);
            this.advance();
            while (Parser.isNameChar((char)this.lookahead) || this.lookahead == 58) {
                this.buf[n++] = this.toUpperCase((char)this.lookahead);
                this.advance();
            }
        } else {
            this.buf[n++] = (char)this.lookahead;
            this.advance();
            while (Parser.isNameChar((char)this.lookahead) || this.lookahead == 58) {
                this.buf[n++] = (char)this.lookahead;
                this.advance();
            }
        }
        return n;
    }

    final void scanText(int n, int n2, boolean bl) throws ParseException {
        this.charAt = 0;
        while (this.lookahead != -1 && this.lookahead != 60 && this.lookahead != this.breakText && this.charAt + 1 < this.chars.length) {
            if (this.lookahead == n2) {
                if (this.seenWS) {
                    this.chars[this.charAt++] = 32;
                    this.seenWS = false;
                }
                this.advance();
                if (this.lookahead == 35) {
                    this.scanCharRef();
                    continue;
                }
                if (Parser.isNameChar((char)this.lookahead)) {
                    this.scanEntityRef(false);
                    continue;
                }
                this.chars[this.charAt++] = (char)n2;
                continue;
            }
            if (this.lookahead == n) {
                if (this.seenWS) {
                    this.chars[this.charAt++] = 32;
                    this.seenWS = false;
                }
                this.advance();
                if (Parser.isNameChar((char)this.lookahead)) {
                    this.scanEntityRef(n == 37);
                    continue;
                }
                this.chars[this.charAt++] = (char)n2;
                continue;
            }
            if (bl && Parser.isWhiteSpaceChar((char)this.lookahead)) {
                this.seenWS = true;
            } else {
                if (this.seenWS) {
                    this.chars[this.charAt++] = 32;
                    this.seenWS = false;
                }
                this.chars[this.charAt++] = (char)this.lookahead;
            }
            this.advance();
        }
        this.token = -5;
    }

    final Entity scanEntityRef(boolean bl) throws ParseException {
        Object object;
        Entity entity;
        ++this.nouppercase;
        ++this.inEntityRef;
        this.scanName("entity ref");
        --this.inEntityRef;
        --this.nouppercase;
        if (this.lookahead != 59) {
            this.error("Entity reference syntax error " + this.name);
        }
        if ((entity = this.dtd.findEntity(this.name)) == null) {
            object = "Missing entity '" + this.name + "'.";
            if (!this.loadexternal) {
                object = (String)object + "\nPerhaps you need to change the loadexternal flag to 'true'.";
            }
            this.error((String)object);
        }
        if (bl != entity.par) {
            if (bl) {
                this.error("Entity '" + this.name + "' is not a parameter entity.");
            } else {
                this.error("Entity '" + this.name + "' is a parameter entity.");
            }
        }
        if (bl) {
            if (!this.inTag) {
                this.addNewElement(11, this.name, false, null);
            }
            if (entity.getURL() == null) {
                this.push(entity, this.name, 7);
                this.reader = entity.getReader(this.reader);
            } else {
                if (entity.ndata != null) {
                    this.error("Binary parameter entity " + this.name.toString() + "cannot be used in DTD");
                }
                if (this.loadexternal) {
                    this.loadDTD(entity.getURL(), this.current.defaultNameSpace);
                }
            }
        } else {
            if (!this.inTag) {
                this.chars[this.charAt++] = entity.cdata;
                this.advance();
                return entity;
            }
            if (entity.getLength() != -1 && !entity.parsed) {
                object = this.current;
                if (((Context)object).parent != null) {
                    object = ((Context)object).parent;
                }
                if (entity.getURL() == null) {
                    entity.parsed = true;
                    this.push(entity, this.name, 7);
                    this.current.parent = object;
                    this.reader = entity.getReader(this.reader);
                } else if (entity.ndata == null && this.loadexternal) {
                    entity.parsed = true;
                    this.push(entity, this.name, 7);
                    this.current.parent = object;
                    try {
                        URL uRL = new URL(this.url, entity.getURL());
                        this.reader = new EntityReader(uRL.openStream(), this.reader.line, this.reader.column, this.reader, entity);
                    }
                    catch (Exception exception) {
                        this.error("Cannot load external text entity: " + this.name.toString());
                    }
                }
            }
        }
        this.advance();
        return entity;
    }

    final void scanCharRef() throws ParseException {
        int n;
        block11: {
            n = 0;
            if (this.lookahead == 35) {
                this.advance();
                if (this.lookahead == 120 || this.lookahead == 88) {
                    this.advance();
                    while (true) {
                        if (this.lookahead >= 48 && this.lookahead <= 57) {
                            n = n * 16 + this.lookahead - 48;
                        } else if (this.lookahead >= 97 && this.lookahead <= 102) {
                            n = n * 16 + this.lookahead - 97 + 10;
                        } else {
                            if (this.lookahead < 65 || this.lookahead > 70) break block11;
                            n = n * 16 + this.lookahead - 65 + 10;
                        }
                        this.advance();
                    }
                }
                while (this.lookahead >= 48 && this.lookahead <= 57) {
                    n = n * 10 + this.lookahead - 48;
                    this.advance();
                }
            }
        }
        if (this.lookahead != 59) {
            this.error("Bad character reference syntax. Expecting &#xx;");
        } else {
            this.chars[this.charAt++] = (char)n;
        }
        this.advance();
    }

    final void scanString(int n, int n2, int n3, int n4) throws ParseException {
        this.charAt = 0;
        while (this.lookahead != -1 && this.lookahead != n) {
            if (this.lookahead == n4) {
                this.error("Illegal character in string " + (char)this.lookahead);
                continue;
            }
            if (this.lookahead == n3) {
                this.advance();
                if (this.lookahead == 35) {
                    this.scanCharRef();
                    continue;
                }
                if (Parser.isNameChar((char)this.lookahead)) {
                    if (this.expandNamedEntities) {
                        this.scanEntityRef(false);
                        continue;
                    }
                    this.chars[this.charAt++] = (char)n3;
                    continue;
                }
                this.chars[this.charAt++] = (char)this.lookahead;
                continue;
            }
            if (this.lookahead == n2) {
                this.advance();
                if (Parser.isNameChar((char)this.lookahead)) {
                    boolean bl;
                    boolean bl2 = bl = n2 == 37;
                    if (this.expandNamedEntities) {
                        this.scanEntityRef(bl);
                        continue;
                    }
                    this.chars[this.charAt++] = (char)n2;
                    continue;
                }
                this.chars[this.charAt++] = (char)this.lookahead;
                continue;
            }
            this.chars[this.charAt++] = (char)this.lookahead;
            this.advance();
        }
        if (this.lookahead == n) {
            this.advance();
        } else {
            this.error("Unterminated string");
        }
        this.text = new String(this.chars, 0, this.charAt);
    }

    final String scanUrl() throws ParseException {
        this.parseToken(39, "Url");
        this.scanString(this.quote, 65535, 65535, 65535);
        return this.text;
    }

    final void parseToken(int n, String string) throws ParseException {
        if (this.nextToken() != n) {
            this.error("Expected " + this.tokenString(n, string) + " instead of " + this.tokenString(this.token));
        }
    }

    final void checkToken(int n, String string) throws ParseException {
        if (this.token != n) {
            this.error("Expected " + this.tokenString(n, string) + " instead of " + this.tokenString(this.token));
        }
    }

    final void parseKeyword(int n, String string) throws ParseException {
        ++this.keyword;
        if (n == 0) {
            this.nextToken();
        } else {
            this.parseToken(n, string);
        }
        --this.keyword;
    }

    final int parseNames(Vector vector, int n, StringBuffer stringBuffer) throws ParseException {
        int n2 = 0;
        this.bufAt = 0;
        if (stringBuffer != null) {
            ++this.nameappend;
        }
        while (this.nextToken() == -4) {
            if (n2 > 0) {
                this.buf[this.bufAt++] = 32;
            }
            vector.addElement(this.name);
            ++n2;
            if (n == 0 || this.nextToken() == 124) continue;
        }
        if (stringBuffer != null) {
            stringBuffer.append(this.buf, 0, this.bufAt);
            --this.nameappend;
        }
        return n2;
    }

    final void parseDocument() throws ParseException {
        this.expandNamedEntities = true;
        this.internalSubset = false;
        this.seenWS = false;
        this.contextAt = 0;
        this.standAlone = false;
        this.newContext(this.root, null, 0, false, null, null);
        this.parseProlog();
        this.parseRootElement();
        if (this.lookahead != -1) {
            this.nextToken();
            this.tryMisc();
            if (this.lookahead != -1) {
                this.error("Expected comments, PI, or EOF instead of " + this.tokenString(this.token));
            }
        }
        this.dtd.checkIDs();
    }

    void newContext(Element element, Name name, int n, boolean bl, Atom atom, Hashtable hashtable) {
        if (this.contextAt == this.contexts.size()) {
            this.current = new Context(element, name, n, bl, atom, hashtable);
            this.contexts.addElement(this.current);
        } else {
            this.current = (Context)this.contexts.elementAt(this.contextAt);
            this.current.reset(element, name, n, bl, atom, hashtable);
        }
    }

    final void push(Element element, Name name, int n) {
        ++this.contextAt;
        this.newContext(element, name, n, this.current.preserveWS, this.current.nameSpace, this.current.spaceTable);
    }

    final void pop() {
        this.current = (Context)this.contexts.elementAt(--this.contextAt);
    }

    final void parseProlog() throws ParseException {
        if (this.lookahead != -1) {
            this.nextToken();
            if (this.token == -6) {
                this.parseToken(-4, "PI tag");
                if (this.name == nameXML) {
                    this.parseXMLDecl();
                } else if (this.name == nameXMLNameSpace) {
                    this.parseNameSpaceDecl(true, true);
                } else {
                    this.finishPI();
                }
                this.nextToken();
                this.firstLine = false;
            }
        }
        this.tryMisc();
        this.tryDocTypeDecl();
        this.tryMisc();
    }

    final void parseXMLDecl() throws ParseException {
        Element element = this.addNewElement(5, this.name, false, null);
        this.push(element, this.name, 5);
        ElementDecl elementDecl = this.current.ed;
        this.current.ed = XMLDecl;
        this.parseKeyword(-40, nameVERSION.toString());
        this.parseToken(61, "=");
        this.parseToken(39, "string");
        this.scanString(this.quote, 65535, 65535, 65535);
        if (!this.text.equals("1.0")) {
            this.error("Expected version 1.0 instead of " + this.text);
        }
        this.factory.parsedAttribute(element, nameVERSION, this.text);
        this.parseKeyword(0, "encoding or standalone");
        String string = null;
        if (this.token == -41) {
            this.parseToken(61, "=");
            this.parseToken(39, "string");
            this.scanString(this.quote, 65535, 65535, 65535);
            this.factory.parsedAttribute(element, nameENCODING, this.text);
            string = this.text;
            this.parseKeyword(0, nameStandalone.toString());
        }
        if (this.token == -42) {
            Name name;
            this.parseToken(61, "=");
            this.parseToken(39, "string");
            this.scanString(this.quote, 65535, 65535, 65535);
            if (this.caseInsensitive) {
                this.text = this.text.toUpperCase();
            }
            if ((name = Name.create(this.text)) == nameYes) {
                this.standAlone = true;
            } else if (name == nameNo) {
                this.standAlone = false;
            } else {
                this.error("Expected 'yes' or 'no' instead of " + name);
            }
            this.factory.parsedAttribute(element, nameStandalone, name.toString());
            this.nextToken();
        }
        if (string != null) {
            try {
                this.xmlIn.setEncoding(string);
            }
            catch (IOException iOException) {
                this.error("Unsupported XML encoding: \"" + string + "\"" + "\nLow level error: " + iOException.getMessage());
            }
        }
        if (this.token != -7) {
            this.error("Expected " + this.tokenString(-7) + " instead of " + this.tokenString(this.token));
        }
        this.current.ed = elementDecl;
        this.pop();
    }

    final void tryMisc() throws ParseException {
        while (true) {
            switch (this.token) {
                case -6: {
                    this.parsePI(true);
                    break;
                }
                case -11: {
                    this.parseComment();
                    break;
                }
                default: {
                    return;
                }
            }
            if (this.lookahead == -1) break;
            this.nextToken();
            this.firstLine = false;
        }
        this.token = -1;
    }

    final void tryDocTypeDecl() throws ParseException {
        if (this.token == -8) {
            this.firstLine = false;
            this.parseKeyword(-12, "Doctype");
            Element element = this.addNewElement(4, nameDOCTYPE, false, null);
            this.parseToken(-4, "Doctype name");
            this.docType = this.name;
            this.dtd.docType = this.name;
            this.factory.parsedAttribute(element, nameNAME, this.docType);
            this.parseKeyword(0, "ExternalID");
            String string = null;
            switch (this.token) {
                case -13: {
                    string = this.scanUrl();
                    this.factory.parsedAttribute(element, nameURL, string);
                    this.nextToken();
                    break;
                }
                case -100: {
                    this.parseKeyword(0, "String");
                    if (this.token == 39) {
                        this.expandNamedEntities = false;
                        this.scanString(this.quote, 65535, 65535, 65535);
                        this.expandNamedEntities = true;
                        this.factory.parsedAttribute(element, namePUBLICID, this.text);
                    } else {
                        this.error("Expected " + this.tokenString(39) + " instead of " + this.tokenString(this.token));
                    }
                    string = this.scanUrl();
                    this.factory.parsedAttribute(element, nameURL, string);
                    this.nextToken();
                }
            }
            if (this.token == 91) {
                this.inTag = false;
                this.breakText = 93;
                this.internalSubset = true;
                this.push(element, nameDOCTYPE, 4);
                this.parseInternalSubset();
                if (this.token != 93) {
                    this.error("Expected " + this.tokenString(93));
                }
                this.inTag = true;
                this.internalSubset = false;
                this.breakText = 0;
                this.pop();
                this.nextToken();
            }
            if (string != null && this.loadexternal) {
                this.loadDTD(string.toString(), null);
            }
            if (this.token != 62) {
                this.error("Expected " + this.tokenString(62) + " instead of " + this.tokenString(this.token));
            }
            if (this.lookahead != -1) {
                this.nextToken();
            }
        }
    }

    public final void loadDTD(String string, Atom atom) throws ParseException {
        try {
            URL uRL = new URL(this.url, string);
            Parser parser = new Parser();
            parser.dtd = this.dtd;
            parser.setURL(uRL);
            parser.setFactory(this.factory);
            parser.caseInsensitive = this.caseInsensitive;
            Element element = this.factory.createElement(null, 0, nameDOCTYPE, null);
            parser.newContext(element, null, 0, false, atom, this.current.spaceTable);
            parser.parseInternalSubset();
        }
        catch (IOException iOException) {
            this.error("Couldn't find external DTD '" + string + "'");
        }
    }

    final Element addNewElement(int n, Name name, boolean bl, String string) throws ParseException {
        this.current.lastWasWS = n == 12;
        Element element = this.factory.createElement(this.current.e, n, name, string);
        if (bl && element != null) {
            Context context = this.current;
            if (this.current.parent != null) {
                context = this.current.parent;
            }
            if (context.ed != null) {
                context.ed.checkContent(context, element, this);
            }
        }
        return element;
    }

    final void parseInternalSubset() throws ParseException {
        ++this.substitution;
        block16: while (true) {
            switch (this.nextToken()) {
                case -5: {
                    if (this.lookahead == 37) {
                        this.advance();
                        this.scanEntityRef(true);
                        continue block16;
                    }
                    this.error("Unexpected text in DTD.");
                    return;
                }
                case 93: {
                    if (!this.internalSubset) {
                        System.out.println("Illegal token in DTD: " + this.token);
                    }
                }
                case -1: {
                    --this.substitution;
                    return;
                }
                case -6: {
                    this.parsePI(true);
                    continue block16;
                }
                case -11: {
                    this.parseComment();
                    continue block16;
                }
                case -8: {
                    this.parseKeyword(0, "ENTITY|...");
                    switch (this.token) {
                        case -24: {
                            this.parseEntityDecl();
                            continue block16;
                        }
                        case -15: {
                            this.parseElementDecl();
                            continue block16;
                        }
                        case -19: {
                            this.parseAttListDecl();
                            continue block16;
                        }
                        case -28: {
                            this.parseNotation();
                            continue block16;
                        }
                    }
                    this.error("Unknown DTD keyword " + this.name);
                    continue block16;
                }
                case -34: {
                    this.parseIncludeSection();
                    continue block16;
                }
                case -35: {
                    this.parseIgnoreSection();
                    continue block16;
                }
            }
            break;
        }
    }

    final void parseIncludeSection() throws ParseException {
        Element element = this.addNewElement(13, this.conditionRef, false, null);
        this.push(element, this.conditionRef, 13);
        this.parseInternalSubset();
        this.pop();
    }

    final void parseIgnoreSection() throws ParseException {
        Element element = this.addNewElement(14, this.conditionRef, false, null);
        this.charAt = 0;
        this.push(element, this.conditionRef, 14);
        this.parseIgnoreSectContent();
        if (this.charAt > 0) {
            this.addNewElement(1, null, true, new String(this.chars, 0, this.charAt));
            this.charAt = 0;
        }
        this.pop();
    }

    final void addChar() throws ParseException {
        if (this.lookahead == -1) {
            this.error("Unexpected EOF.");
        }
        this.chars[this.charAt++] = (char)this.lookahead;
        if (this.charAt == this.chars.length) {
            this.addNewElement(1, null, true, new String(this.chars, 0, this.charAt));
            this.charAt = 0;
        }
        this.advance();
    }

    final void checkCDEND(boolean bl) throws ParseException {
        boolean bl2 = false;
        if (this.lookahead == 93) {
            this.addChar();
            if (this.lookahead == 93) {
                this.addChar();
                if (this.lookahead == 62) {
                    if (!bl) {
                        this.error("Bad Ignore conditional section syntex. ']]>' is not allowed here.");
                    }
                    bl2 = true;
                    this.addChar();
                }
            }
        }
        if (!bl2 && bl) {
            this.error("Bad Ignore conditional section syntex. Expected ']]>'.");
        }
    }

    final void parseIgnoreSectContent() throws ParseException {
        boolean bl = false;
        block12: while (this.lookahead != 93) {
            switch (this.lookahead) {
                case 34: 
                case 39: {
                    int n = this.lookahead;
                    this.addChar();
                    while (this.lookahead != n) {
                        this.checkCDEND(false);
                        this.addChar();
                    }
                    this.addChar();
                    continue block12;
                }
                case 60: {
                    this.addChar();
                    switch (this.lookahead) {
                        case 33: {
                            this.addChar();
                            switch (this.lookahead) {
                                case 45: {
                                    this.addChar();
                                    if (this.lookahead != 45) {
                                        this.error("Bad comment syntax. Expected '-'.");
                                    }
                                    this.addChar();
                                    while (!bl) {
                                        if (this.lookahead == 45) {
                                            this.addChar();
                                            if (this.lookahead != 45) continue;
                                            this.addChar();
                                            if (this.lookahead == 62) {
                                                this.addChar();
                                                bl = true;
                                                continue;
                                            }
                                            this.error("Bad comment syntax. Expected '>'.");
                                            continue;
                                        }
                                        this.addChar();
                                    }
                                    bl = false;
                                    continue block12;
                                }
                                case 91: {
                                    this.addChar();
                                    this.parseIgnoreSectContent();
                                    continue block12;
                                }
                            }
                            this.addChar();
                            continue block12;
                        }
                        case 63: {
                            this.addChar();
                            while (!bl) {
                                if (this.lookahead == 63) {
                                    this.addChar();
                                    if (this.lookahead != 62) continue;
                                    this.addChar();
                                    bl = true;
                                    continue;
                                }
                                this.addChar();
                            }
                            bl = false;
                            continue block12;
                        }
                    }
                    this.error("Bad character in IGNORE conditional section.");
                    continue block12;
                }
            }
            this.addChar();
        }
        this.checkCDEND(true);
    }

    final void parseEntityDecl() throws ParseException {
        boolean bl = false;
        ++this.nouppercase;
        if (this.nextToken() == 37) {
            bl = true;
            this.parseToken(-4, "Entity name");
        } else if (this.token != -4) {
            this.error("Expected entity name instead of " + this.tokenString(this.token));
        }
        --this.nouppercase;
        Entity entity = this.dtd.findEntity(this.name);
        if (entity != null) {
            System.err.println("Warning: Entity '" + this.name + "' already defined, using the first definition.");
            entity = new Entity(this.name, bl);
        } else {
            entity = new Entity(this.name, bl);
            this.dtd.addEntity(entity);
            if (this.internalSubset) {
                if (this.current.e != null) {
                    this.current.e.addChild(entity, null);
                }
                this.current.lastWasWS = false;
            }
        }
        this.push(entity, this.name, 7);
        this.parseKeyword(0, "String or SYSTEM");
        if (this.token == -100) {
            this.parseKeyword(0, "String");
            if (this.token == 39) {
                this.expandNamedEntities = false;
                this.scanString(this.quote, 65535, 65535, 65535);
                this.expandNamedEntities = true;
                entity.pubid = this.text;
                this.token = -13;
            } else {
                this.error("Expected " + this.tokenString(39) + " instead of " + this.tokenString(this.token));
            }
        }
        switch (this.token) {
            case 39: {
                int n = this.reader.line;
                int n2 = this.reader.column;
                this.expandNamedEntities = false;
                this.scanString(this.quote, 37, 38, 65535);
                this.expandNamedEntities = true;
                entity.setText(this.text);
                entity.setPosition(n, n2);
                this.nextToken();
                break;
            }
            case -13: {
                entity.setURL(this.scanUrl());
                this.parseKeyword(0, "ndata");
                if (this.token != -33) break;
                this.parseToken(-4, "ndata name");
                Notation notation = this.dtd.findNotation(this.name);
                if (notation == null) {
                    this.error("Notation: " + this.name + " has not been declared yet");
                }
                entity.setNDATA(this.name);
                this.nextToken();
                break;
            }
            default: {
                this.error("Expected " + this.tokenString(39) + " or " + this.tokenString(-13) + " instead of " + this.tokenString(this.token));
            }
        }
        this.checkToken(62, ">");
        this.pop();
    }

    private void addNameSpace(Atom atom, Atom atom2, boolean bl) throws ParseException {
        if (atom == null || atom2 == null) {
            this.error("Name space syntax error.");
        }
        if (DTD.isReservedNameSpace(atom)) {
            this.error(atom.toString() + " is a reserved name space.");
        }
        if (bl) {
            Atom atom3 = this.dtd.findShortNameSpace(atom2);
            if (atom3 != null) {
                if (atom3 != atom) {
                    this.error("Cannot give two short references '" + atom3.toString() + "' and '" + atom.toString() + "' to the same name space: '" + atom2.toString() + "'");
                }
            } else {
                atom3 = this.dtd.findLongNameSpace(atom);
                if (atom3 != null) {
                    this.error("Short reference '" + atom.toString() + "' is used by name space '" + atom3.toString() + "'");
                }
                this.dtd.addNameSpace(atom, atom2);
            }
        } else {
            this.current.addNameSpace(atom, atom2);
        }
    }

    final void parseNotation() throws ParseException {
        this.parseToken(-4, "Notation name");
        Notation notation = this.dtd.findNotation(this.name);
        if (notation != null) {
            this.error("Notation already declared " + this.name);
        }
        notation = new Notation(this.name);
        this.dtd.addNotation(notation);
        if (this.internalSubset) {
            if (this.current.e != null) {
                this.current.e.addChild(notation, null);
            }
            this.current.lastWasWS = false;
        }
        this.push(notation, this.name, 8);
        this.parseKeyword(0, "SYSTEM or PUBLIC");
        if (this.token != -13 && this.token != -100) {
            this.error("Expected " + this.tokenString(-13) + " or " + this.tokenString(-100) + " instead of " + this.tokenString(this.token));
        }
        notation.type = this.token;
        if (notation.type == -100) {
            this.parseKeyword(0, "String");
            if (this.token == 39) {
                this.expandNamedEntities = false;
                this.scanString(this.quote, 65535, 65535, 65535);
                this.expandNamedEntities = true;
                notation.pubid = this.text;
            } else {
                this.error("Expected " + this.tokenString(39) + " instead of " + this.tokenString(this.token));
            }
        }
        notation.setURL(this.scanUrl());
        this.parseToken(62, ">");
        this.pop();
    }

    final ElementDecl createElementDecl(Vector vector) throws ParseException {
        if (this.token != -4) {
            this.error("Expected " + this.tokenString(-4) + " instead of " + this.tokenString(this.token));
        }
        if (this.dtd.findElementDecl(this.name) != null) {
            this.error("Element '" + this.name + "' already declared.");
        }
        ElementDecl elementDecl = new ElementDecl(this.name);
        this.current.lastWasWS = false;
        this.dtd.addElementDecl(elementDecl);
        vector.addElement(elementDecl);
        return elementDecl;
    }

    final void parseElementDecl() throws ParseException {
        Vector vector = new Vector();
        this.nextToken();
        ElementDecl elementDecl = this.createElementDecl(vector);
        if (this.internalSubset && this.current.e != null) {
            this.current.e.addChild(elementDecl, null);
        }
        this.push(elementDecl, this.name, 9);
        elementDecl.parseModel(this);
        this.checkToken(62, ">");
        this.pop();
    }

    final ElementDecl findElementDecl(Vector vector) throws ParseException {
        ElementDecl elementDecl;
        if (this.token != -4) {
            this.error("Expected " + this.tokenString(-4) + " instead of " + this.tokenString(this.token));
        }
        if ((elementDecl = this.dtd.findElementDecl(this.name)) == null) {
            this.error("Missing Element declaration '" + this.name + "'");
        }
        vector.addElement(elementDecl);
        return elementDecl;
    }

    final void parseAttListDecl() throws ParseException {
        Vector vector = new Vector();
        this.nextToken();
        ElementDecl elementDecl = this.findElementDecl(vector);
        this.push(elementDecl, this.name, 9);
        elementDecl.parseAttList(this);
        this.checkToken(62, ">");
        this.pop();
    }

    private void reportMismatch(int n, String string) throws ParseException {
        if (this.current.ed == null) {
            this.error("Content mismatch. Stopped at state " + n);
        }
        Vector vector = this.current.ed.expectedElements(n);
        this.error(string + "  Expected elements " + vector);
    }

    final void parseElement() throws ParseException {
        boolean bl = false;
        while (true) {
            if (bl && this.token != -9) {
                this.error("Expected " + this.tokenString(-9) + " instead of " + this.tokenString(this.token));
            }
            bl = false;
            switch (this.token) {
                case 60: {
                    this.scanName("element tag");
                    ElementDecl elementDecl = this.dtd.findElementDecl(this.name);
                    Element element = this.addNewElement(0, this.name, true, null);
                    this.push(element, this.name, 0);
                    if (elementDecl != null) {
                        if (elementDecl.getContent().type == 1) {
                            bl = true;
                        }
                        elementDecl.initContent(this.current, this);
                    } else {
                        this.current.matched = true;
                    }
                    this.parseAttributes(element);
                    if (this.token == -10) {
                        if (elementDecl != null && !elementDecl.acceptEmpty()) {
                            this.reportMismatch(0, this.name.getName() + " cannot be empty.");
                        }
                        this.factory.parsed(this.current.e);
                        this.pop();
                        bl = false;
                        break;
                    }
                    if (this.token != 62) {
                        this.error("Expected " + this.tokenString(62) + " instead of " + this.tokenString(this.token));
                        break;
                    }
                    if (this.lookahead == 60 || !bl) break;
                    this.error("Expected " + this.tokenString(62) + " instead of '" + (char)this.lookahead + "'");
                    break;
                }
                case -5: {
                    this.parseText(38, 38);
                    break;
                }
                case -6: {
                    this.parsePI(false);
                    break;
                }
                case -11: {
                    this.parseComment();
                    break;
                }
                case -14: {
                    this.parseCDATA();
                    break;
                }
                case -9: {
                    if (!this.current.matched) {
                        this.reportMismatch(this.current.state, this.current.e.getTagName().getName() + " is not complete.");
                    }
                    if (this.lookahead != 62) {
                        if (this.lookahead == 47) {
                            this.advance();
                        } else {
                            Context context = this.current;
                            this.current = (Context)this.contexts.elementAt(this.contextAt - 1);
                            this.scanName("element close tag");
                            this.current = context;
                            if (!this.name.equals(this.current.tagName)) {
                                this.error("Close tag " + this.name + " does not match start tag " + this.current.e.getTagName());
                            }
                        }
                    }
                    this.parseToken(62, ">");
                    this.factory.parsed(this.current.e);
                    this.pop();
                    break;
                }
                case -1: {
                    if (this.contextAt == 1) {
                        this.error("Expected the end of root element instead of end of file.");
                        break;
                    }
                }
                default: {
                    this.error("Bad token in element content: " + this.tokenString(this.token));
                }
            }
            if (this.contextAt == 0) break;
            this.nextToken();
        }
    }

    final void parseRootElement() throws ParseException {
        if (this.token != 60) {
            this.error("Start of root element expected instead of " + this.tokenString(this.token));
        }
        this.scanName("element tag");
        if (this.docType != null && this.name != this.docType) {
            this.error("Root element name must match the DOCTYPE name");
        }
        if (this.name == nameXMLNameSpace) {
            this.parseNameSpaceDecl(false, false);
            return;
        }
        ElementDecl elementDecl = this.dtd.findElementDecl(this.name);
        Element element = this.addNewElement(0, this.name, false, null);
        this.push(element, this.name, 0);
        boolean bl = false;
        if (elementDecl != null) {
            if (elementDecl.getContent().type == 1) {
                bl = true;
            }
            elementDecl.initContent(this.current, this);
        } else {
            this.current.matched = true;
        }
        this.parseAttributes(element);
        if (this.token == -10) {
            if (elementDecl != null && !elementDecl.acceptEmpty()) {
                this.reportMismatch(0, "Root element " + element.getTagName().getName() + " cannot be empty.");
            }
            bl = true;
        } else if (this.token != 62) {
            if (element.getAttributes() == EnumWrapper.emptyEnumeration) {
                this.error("No attribute is declared for element '" + element.getTagName() + "', expected " + this.tokenString(62));
            }
            this.error("Expected " + this.tokenString(62) + " instead of " + this.tokenString(this.token));
        }
        if (bl) {
            this.pop();
            this.nextToken();
        } else {
            this.nextToken();
            this.parseElement();
        }
    }

    final void parseAttributes(Element element) throws ParseException {
        Object object;
        Object object2;
        boolean bl = false;
        while (this.nextToken() == -4) {
            object2 = this.name;
            if (((Name)object2).getName().equals(nameXMLSpace.getName())) {
                object2 = nameXMLSpace;
                bl = true;
            }
            if (element != null && element.getAttribute((Name)object2) != null) {
                this.error("An attribute cannot appear more than once in the same start tag");
            }
            this.parseToken(61, "=");
            if (object2 == nameXMLLang) {
                this.parseToken(39, "string");
                this.parseToken(-4, "lang code");
                object = this.name;
                this.parseToken(39, "string");
                this.factory.parsedAttribute(element, (Name)object2, ((Name)object).getName());
                continue;
            }
            if (this.current.ed != null && element != null) {
                this.current.ed.parseAttribute(element, (Name)object2, this);
                continue;
            }
            this.parseToken(39, "string");
            this.scanString(this.quote, 38, 38, 60);
            this.factory.parsedAttribute(element, (Name)object2, this.text);
        }
        if (bl) {
            object2 = element.getAttribute(nameXMLSpace);
            if (object2 == null) {
                object2 = element.getAttribute(nameXMLSpace2);
            }
            if (object2 != null) {
                object = null;
                if (object2 instanceof String) {
                    object = (String)object2;
                } else if (object2 instanceof Atom) {
                    object = object2.toString();
                } else if (object2 instanceof Name) {
                    object = ((Name)object2).getName().toString();
                }
                if (object != null && ((String)object).equalsIgnoreCase("preserve")) {
                    this.current.preserveWS = true;
                } else if (object != null && ((String)object).equalsIgnoreCase("default")) {
                    this.current.preserveWS = false;
                } else {
                    this.error("Invalid value '" + (String)object + "' for xml-space attribute.");
                }
            }
        }
        if (this.current.ed != null) {
            this.current.ed.checkAttributes(element, this);
        }
    }

    final void parseContent(Element element) throws ParseException {
        block8: while (this.nextToken() != -9) {
            switch (this.token) {
                case -5: {
                    this.parseText(38, 38);
                    continue block8;
                }
                case 60: {
                    this.parseElement();
                    continue block8;
                }
                case -6: {
                    this.parsePI(false);
                    continue block8;
                }
                case -8: {
                    this.parseElement();
                    continue block8;
                }
                case -11: {
                    this.parseComment();
                    continue block8;
                }
                case -14: {
                    this.parseCDATA();
                    continue block8;
                }
            }
            this.error("Bad token in element content: " + this.tokenString(this.token));
        }
        if (!this.current.matched) {
            this.error("Content mismatch, stopped at state " + this.current.state);
        }
        if (this.lookahead != 62) {
            this.scanName("element close tag");
            if (this.name != this.current.e.getTagName()) {
                this.error("Close tag mismatch: " + this.name + " instead of " + this.current.e.getTagName());
            }
        }
        this.parseToken(62, ">");
    }

    /*
     * Enabled aggressive block sorting
     */
    final Element parsePI(boolean bl) throws ParseException {
        this.parseKeyword(0, "PI name");
        if (this.token == -39) {
            if (!this.firstLine) {
                this.error("An XML declaration can only appear in the very beginning of the document.");
                return this.finishPI();
            }
            this.parseXMLDecl();
            return null;
        }
        if (this.token == -36) {
            return this.parseNameSpaceDecl(bl, true);
        }
        if (this.token == -4) return this.finishPI();
        this.error("Expecting PI name instead of " + this.tokenString(this.token));
        return this.finishPI();
    }

    final Element parseNameSpaceDecl(boolean bl, boolean bl2) throws ParseException {
        Atom atom;
        Atom atom2;
        Element element = this.addNewElement(10, this.name, false, null);
        this.push(element, this.name, 10);
        this.parseAttributes(element);
        this.pop();
        if (bl2 && this.token != -7) {
            this.error("Expected PI tag end '?>' instead of " + this.tokenString(this.token));
        } else if (!bl2 && this.token != -10) {
            this.error("Expected " + this.tokenString(-10) + " instead of " + this.tokenString(this.token));
        }
        Object object = element.getAttribute(nameXMLAS);
        Object object2 = element.getAttribute(nameXMLHREF);
        if (object == null || object2 == null) {
            this.error("Missing attribute 'prefix' or 'ns'");
        }
        if (this.caseInsensitive) {
            atom2 = Atom.create(object.toString().toUpperCase());
            atom = Atom.create(object2.toString().toUpperCase());
        } else {
            atom2 = Atom.create(object.toString());
            atom = Atom.create(object2.toString());
        }
        if (DTD.isReservedNameSpace(atom2)) {
            this.error(atom2.toString() + " is a reserved name space.");
        }
        this.addNameSpace(atom2, atom, bl);
        if (this.loadexternal && this.dtd.findLoadedNameSpace(atom) == null) {
            this.dtd.addLoadedNameSpace(atom);
            this.loadDTD(atom.toString(), atom);
        }
        return element;
    }

    final Element finishPI() throws ParseException {
        Element element = this.addNewElement(5, this.name, false, null);
        this.charAt = 0;
        boolean bl = false;
        while (this.lookahead != -1) {
            this.chars[this.charAt++] = (char)this.lookahead;
            if (this.lookahead == 63) {
                this.advance();
                if (this.lookahead == 62) {
                    --this.charAt;
                    bl = true;
                }
            } else {
                this.advance();
            }
            if (this.charAt != this.chars.length && !bl) continue;
            this.push(element, this.name, 5);
            this.addNewElement(6, null, false, new String(this.chars, 0, this.charAt));
            this.pop();
            this.charAt = 0;
            if (!bl) continue;
        }
        this.parseToken(62, "PI end");
        return element;
    }

    final Element parseText(int n, int n2) throws ParseException {
        this.scanText(n, n2, !this.current.preserveWS);
        return this.addPCDATA();
    }

    final Element addPCDATA() throws ParseException {
        if (this.charAt > 0 || this.seenWS) {
            if (this.seenWS) {
                this.chars[this.charAt++] = 32;
                this.seenWS = false;
            }
            this.text = new String(this.chars, 0, this.charAt);
            Element element = this.addNewElement(1, null, true, this.text);
            return element;
        }
        this.seenWS = false;
        return null;
    }

    final Element parseComment() throws ParseException {
        Element element = this.addNewElement(2, nameComment, false, null);
        this.charAt = 0;
        boolean bl = false;
        while (this.lookahead != -1) {
            this.chars[this.charAt++] = (char)this.lookahead;
            if (this.lookahead == 45) {
                this.advance();
                if (this.lookahead == 45) {
                    this.advance();
                    if (this.lookahead == 62) {
                        --this.charAt;
                        bl = true;
                    } else if (strict) {
                        this.error("Bad comment syntax. Expected '>'.");
                    } else {
                        this.reader.push((char)this.lookahead);
                        this.lookahead = 45;
                    }
                }
            } else {
                this.advance();
            }
            if (this.charAt != this.chars.length && !bl) continue;
            this.push(element, nameComment, 2);
            this.addNewElement(6, null, false, new String(this.chars, 0, this.charAt));
            this.pop();
            this.charAt = 0;
            if (!bl) continue;
        }
        this.parseToken(62, "comment end");
        return element;
    }

    final void parseCDATA() throws ParseException {
        this.charAt = 0;
        boolean bl = false;
        while (this.lookahead != -1) {
            this.chars[this.charAt++] = (char)this.lookahead;
            if (this.lookahead == 93) {
                this.advance();
                if (this.lookahead == 93) {
                    this.advance();
                    if (this.lookahead == 62) {
                        --this.charAt;
                        bl = true;
                    } else {
                        this.reader.push((char)this.lookahead);
                        this.lookahead = 93;
                    }
                }
            } else {
                this.advance();
            }
            if (this.charAt != this.chars.length && !bl) continue;
            this.addNewElement(6, nameCDATA, false, new String(this.chars, 0, this.charAt));
            this.charAt = 0;
            if (!bl) continue;
        }
        this.parseToken(62, "CDATA end");
    }

    private final void setURL(URL uRL) throws ParseException {
        boolean bl;
        this.url = uRL;
        String string = System.getProperty("java.vendor");
        boolean bl2 = string.indexOf("Microsoft") == 0;
        String string2 = System.getProperty("os.name");
        boolean bl3 = string2.indexOf("Windows") == 0;
        boolean bl4 = bl = bl2 && jdk11 && bl3;
        if (bl) {
            try {
                this.xmlIn = new XMLInputStream(uRL);
                this.reader = new EntityReader(this.xmlIn, 1, 1, null, this);
                this.advance();
                return;
            }
            catch (IOException iOException) {
                bl = false;
                String string3 = iOException.toString();
            }
        }
        if (!bl) {
            try {
                this.setInputStream(new BufferedInputStream(this.url.openStream(), 20000));
            }
            catch (IOException iOException) {
                throw new ParseException("Error opening input stream for \"" + this.url.toString() + "\": " + iOException.toString());
            }
        }
    }

    private final void setInputStream(InputStream inputStream) throws ParseException {
        this.xmlIn = new XMLInputStream(inputStream);
        this.reader = new EntityReader(this.xmlIn, 1, 1, null, this);
        this.advance();
    }

    private final void setFactory(ElementFactory elementFactory) {
        this.factory = elementFactory;
    }

    static {
        chartype = new int[256];
        charupper = new char[256];
        strict = false;
        nameComment = Name.create("--");
        nameCDATA = Name.create("[CDATA[");
        namePCDATA = Name.create("PCDATA");
        nameVERSION = Name.create("version");
        nameENCODING = Name.create("encoding");
        nameStandalone = Name.create("standalone");
        nameDOCTYPE = Name.create("DOCTYPE");
        nameXML = Name.create("xml");
        nameYes = Name.create("yes");
        nameNo = Name.create("no");
        nameURL = Name.create("URL");
        namePUBLICID = Name.create("PUBLICID");
        nameNAME = Name.create("NAME");
        nameXMLSpace = Name.create("xml-space", "xml");
        nameXMLSpace2 = Name.create("space", "xml");
        nameXMLAS = Name.create("prefix", "xml");
        nameXMLHREF = Name.create("ns", "xml");
        nameXMLNameSpace = Name.create("namespace", "xml");
        atomXML = Atom.create("xml");
        nameXMLLang = Name.create("lang", "xml");
        XMLDecl = new ElementDecl(nameXML);
        XMLDecl.addAttDef(new AttDef(nameVERSION, 0, "1.0", 3));
        XMLDecl.addAttDef(new AttDef(nameENCODING, 0, "UTF-8", 2));
        Vector<Name> vector = new Vector<Name>(2);
        vector.addElement(nameYes);
        vector.addElement(nameNo);
        XMLDecl.addAttDef(new AttDef(nameStandalone, 9, (Name)vector.elementAt(0), 2, vector));
        tokens = new Hashtable();
        tokens.put("DOCTYPE", new Integer(-12));
        tokens.put("SYSTEM", new Integer(-13));
        tokens.put("PUBLIC", new Integer(-100));
        tokens.put("ENTITY", new Integer(-24));
        tokens.put("ELEMENT", new Integer(-15));
        tokens.put("EMPTY", new Integer(-16));
        tokens.put("ANY", new Integer(-17));
        tokens.put("PCDATA", new Integer(-18));
        tokens.put("ATTLIST", new Integer(-19));
        tokens.put("CDATA", new Integer(-20));
        tokens.put("ID", new Integer(-21));
        tokens.put("IDREF", new Integer(-22));
        tokens.put("IDREFS", new Integer(-23));
        tokens.put("ENTITY", new Integer(-24));
        tokens.put("ENTITIES", new Integer(-25));
        tokens.put("NMTOKEN", new Integer(-26));
        tokens.put("NMTOKENS", new Integer(-27));
        tokens.put("FIXED", new Integer(-30));
        tokens.put("REQUIRED", new Integer(-31));
        tokens.put("IMPLIED", new Integer(-32));
        tokens.put("NDATA", new Integer(-33));
        tokens.put("NOTATION", new Integer(-28));
        tokens.put("INCLUDE", new Integer(-34));
        tokens.put("IGNORE", new Integer(-35));
        tokens.put("namespace", new Integer(-36));
        tokens.put("EXTENDS", new Integer(-37));
        tokens.put("IMPLEMENTS", new Integer(-38));
        tokens.put("xml", new Integer(-39));
        tokens.put("version", new Integer(-40));
        tokens.put("encoding", new Integer(-41));
        tokens.put("standalone", new Integer(-42));
        for (int i = 0; i < 256; ++i) {
            char c = (char)i;
            Parser.chartype[i] = 0;
            if (Character.isWhitespace(c) || c == '\r') {
                Parser.chartype[i] = 1;
            }
            if (Character.isLetter(c)) {
                int n = i;
                chartype[n] = chartype[n] | 4;
            }
            if (Character.isDigit(c)) {
                int n = i;
                chartype[n] = chartype[n] | 2;
            }
            Parser.charupper[i] = Character.toUpperCase(c);
        }
        chartype[46] = chartype[46] | 8;
        chartype[45] = chartype[45] | 8;
        chartype[95] = chartype[95] | 0x18;
        chartype[183] = chartype[183] | 8;
    }
}

