/*
 * Decompiled with CFR 0.152.
 */
package com.ms.xml.util;

import com.ms.xml.util.ByteSwapInputStream;
import com.ms.xml.util.XMLOutputStream;
import com.ms.xml.util.XMLStreamReader;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;

public class XMLInputStream
extends InputStream {
    static final int INPUTSR = 1;
    static final int UCS2 = 2;
    static final int ASCII = 3;
    static final int INPUTSR_POP = 4;
    static final int UCS2_POP = 5;
    static final int ASCII_POP = 6;
    static final int SIZE = 1024;
    static final int INTUTF8 = 0;
    static final int INTASCII = 1;
    static final int INTUCS2 = 2;
    static final int INTUCS4 = 3;
    static final int INTEBCDIC = 4;
    static final int INT1252 = 5;
    private int[] next = new int[4];
    private int index = -1;
    private InputStream in;
    private InputStreamReader insr;
    private int pos = 0;
    private String encoding;
    private boolean littleendian;
    private boolean byteOrderMark;
    private int readState;
    private boolean jdk11;
    private boolean jdk12;
    private XMLStreamReader xmlis = null;
    private int intEncoding = -1;
    private int[] buffer = new int[1024];
    private int size = -1;
    private boolean eof = false;
    private boolean onWindows = false;
    public boolean caseInsensitive;

    public XMLInputStream(URL uRL) throws IOException {
        try {
            Class<?> clazz = Class.forName("com.ms.xml.xmlstream.XMLStream");
            this.xmlis = (XMLStreamReader)clazz.newInstance();
            this.intEncoding = this.xmlis.open(uRL.toString());
        }
        catch (Throwable throwable) {
            throw new IOException("Error opening input stream for \"" + uRL.toString() + "\": " + throwable.toString());
        }
        this.onWindows = true;
        switch (this.intEncoding) {
            case 0: {
                this.encoding = "UTF-8";
                break;
            }
            case 1: {
                this.encoding = "ASCII";
                break;
            }
            case 2: {
                this.encoding = "UCS-2";
                break;
            }
            case 3: {
                this.encoding = "UCS-4";
                break;
            }
            case 4: {
                this.encoding = "EBCDIC";
                break;
            }
            case 5: {
                this.encoding = "windows-1252";
                break;
            }
            default: {
                throw new IOException("Error opening input stream for \"" + uRL.toString() + "\"");
            }
        }
    }

    public XMLInputStream(InputStream inputStream) {
        String string = System.getProperty("java.version");
        boolean bl = this.jdk11 = string.equals("1.1");
        if (!this.jdk11) {
            float f = Float.valueOf(string.substring(0, 3)).floatValue();
            this.jdk11 = (double)f >= 1.1;
            this.jdk12 = (double)f >= 1.2;
        }
        this.littleendian = false;
        this.caseInsensitive = false;
        this.byteOrderMark = false;
        this.encoding = "UTF-8";
        this.in = inputStream;
        this.insr = null;
        this.readState = 3;
        boolean bl2 = false;
        try {
            char c = (char)inputStream.read();
            char c2 = (char)inputStream.read();
            char c3 = (char)inputStream.read();
            char c4 = (char)inputStream.read();
            if (c == '\u00fe' && c2 == '\u00ff' && c3 == '\u0000' && c4 == '<') {
                this.littleendian = false;
                this.byteOrderMark = true;
                this.readState = 5;
                this.encoding = "UCS-2";
            } else if (c == '\u00ff' && c2 == '\u00fe' && c3 == '<' && c4 == '\u0000') {
                this.littleendian = true;
                this.byteOrderMark = true;
                this.readState = 5;
                this.encoding = "UCS-2";
                this.in = new ByteSwapInputStream(inputStream);
            } else if (c == '\u0000' && c2 == '<' && c3 == '\u0000' && c4 == '?') {
                this.littleendian = false;
                this.readState = 5;
                this.encoding = "UCS-2";
            } else if (c == '<' && c2 == '\u0000' && c3 == '?' && c4 == '\u0000') {
                this.littleendian = true;
                this.readState = 5;
                this.encoding = "UCS-2";
                this.in = new ByteSwapInputStream(inputStream);
            } else if (c == '<' && c2 == '?' && Character.toUpperCase(c3) == 'X' && Character.toUpperCase(c4) == 'M') {
                bl2 = true;
            } else if (c == '\u0000' && c2 == '\u0000' && c3 == '\u0000' && c4 == '<') {
                this.readState = 6;
                this.encoding = "UCS-4";
            } else if (c == '<' && c2 == '\u0000' && c3 == '\u0000' && c4 == '\u0000') {
                this.readState = 6;
                this.encoding = "UCS-4";
            } else if (c == '\u0000' && c2 == '\u0000' && c3 == '<' && c4 == '\u0000') {
                this.readState = 6;
                this.encoding = "UCS-4";
            } else if (c == '\u0000' && c2 == '<' && c3 == '\u0000' && c4 == '\u0000') {
                this.readState = 6;
                this.encoding = "UCS-4";
            } else if (c == 'L' && c2 == 'o' && c3 == '\u00e7' && c4 == '\u00d4') {
                this.readState = 6;
                this.encoding = "EBCDIC";
            } else {
                bl2 = true;
            }
            if (!this.encoding.equals("UCS-2")) {
                this.push(c4);
                this.push(c3);
                this.push(c2);
                this.push(c);
            } else if (this.littleendian) {
                this.push(c3);
                this.push(c4);
                if (!this.byteOrderMark) {
                    this.push(c);
                    this.push(c2);
                }
            } else {
                this.push(c4);
                this.push(c3);
                if (!this.byteOrderMark) {
                    this.push(c2);
                    this.push(c);
                }
            }
        }
        catch (IOException iOException) {
            bl2 = true;
        }
        this.pos = -1;
        if (bl2) {
            try {
                if (!this.jdk11) {
                    throw new IOException("Readers not supported in JDK 1.0");
                }
                if (!inputStream.markSupported()) {
                    inputStream = new BufferedInputStream(inputStream);
                }
                inputStream.mark(4096);
                this.insr = new InputStreamReader(inputStream, "UTF-8");
                this.readState = 4;
                this.encoding = "UTF-8";
            }
            catch (IOException iOException) {
                this.readState = 6;
                this.encoding = "ASCII";
            }
        }
    }

    private void push(char c) {
        if (this.index == 3) {
            System.exit(0);
        }
        this.next[++this.index] = c;
    }

    public int read() throws IOException {
        if (this.onWindows) {
            int n;
            int n2 = 0;
            if (this.index >= this.size) {
                if (this.eof) {
                    return -1;
                }
                try {
                    n2 = this.xmlis.read(this.buffer, 1024);
                }
                catch (Exception exception) {
                    return -1;
                }
                if (n2 <= 0) {
                    return -1;
                }
                if (n2 < 1024) {
                    this.eof = true;
                }
                this.size = n2;
                this.index = 0;
            }
            if ((n = this.buffer[this.index++]) == 0) {
                String string = "Stream error: unexpected null";
                throw new IOException(string);
            }
            return n;
        }
        switch (this.readState) {
            case 1: {
                ++this.pos;
                if (this.jdk12) {
                    return this.insr.read();
                }
                int n = this.in.read();
                if (n == -1) {
                    return -1;
                }
                if ((n & 0x80) != 0) {
                    int n3 = this.in.read();
                    if (n3 == -1) {
                        return -1;
                    }
                    n3 &= 0x3F;
                    if ((n & 0x40) != 0) {
                        int n4 = this.in.read();
                        if (n4 == -1) {
                            return -1;
                        }
                        n &= 0xF;
                        n = n << 12 | n3 << 6 | (n4 &= 0x3F);
                    } else {
                        n &= 0x1F;
                        n = n << 6 | n3;
                    }
                }
                return n;
            }
            case 3: {
                return this.in.read();
            }
            case 2: {
                int n = this.in.read();
                if (n == -1) {
                    return -1;
                }
                int n5 = this.in.read();
                return n << 8 | n5;
            }
            case 4: {
                if (this.index >= 0) {
                    return this.next[this.index--];
                }
                this.readState = 1;
                return this.read();
            }
            case 5: {
                int n;
                int n6;
                if (this.index >= 0) {
                    n6 = this.next[this.index--];
                } else {
                    this.readState = 2;
                    n6 = this.in.read();
                }
                if (n6 == -1) {
                    return -1;
                }
                if (this.index >= 0) {
                    n = this.next[this.index--];
                } else {
                    this.readState = 2;
                    n = this.in.read();
                }
                return n6 << 8 | n;
            }
        }
        if (this.index >= 0) {
            return this.next[this.index--];
        }
        this.readState = 3;
        return this.in.read();
    }

    public void setEncoding(String string) throws IOException {
        String string2;
        this.insr = null;
        int n = 0;
        if (string.equalsIgnoreCase("ISO-10646-UCS-2") || string.equalsIgnoreCase("UCS-2")) {
            if (!this.encoding.equalsIgnoreCase("UCS-2")) {
                throw new IOException("Illegal Change of Encoding");
            }
            this.readState = 2;
            this.encoding = "UCS-2";
            return;
        }
        if (string.equalsIgnoreCase("Shift_JIS")) {
            if (this.onWindows) {
                throw new IOException("SJIS not yet supported");
            }
            string2 = "SJIS";
        } else if (string.equalsIgnoreCase("ISO-8859-1")) {
            if (this.onWindows) {
                throw new IOException("8859_1 not yet supported");
            }
            string2 = "8859_1";
        } else {
            if (string.equalsIgnoreCase("ISO-10646-UCS-4")) {
                throw new IOException("UCS-4 not yet supported");
            }
            if (string.equalsIgnoreCase("UTF-8")) {
                string2 = "UTF-8";
                n = 0;
            } else {
                if (this.onWindows) {
                    if (string.equals("windows-1252")) {
                        n = 5;
                    } else {
                        throw new IOException(string + " not yet supported");
                    }
                }
                string2 = string;
            }
        }
        if (!this.encoding.equalsIgnoreCase("ASCII") && !this.encoding.equalsIgnoreCase("UTF-8")) {
            throw new IOException("Illegal Change of Encoding");
        }
        if (this.onWindows) {
            if (this.intEncoding != n) {
                this.xmlis.setEncoding(n, this.index);
                this.size = 0;
                this.index = 0;
                this.eof = false;
            }
            return;
        }
        if (this.encoding.equalsIgnoreCase("ASCII")) {
            this.insr = null;
            this.readState = 6;
        } else if (this.jdk11) {
            if (this.pos != -1) {
                // empty if block
            }
            this.insr = new InputStreamReader(this.in, string2);
            this.readState = 1;
            this.encoding = string;
        } else {
            throw new IOException(string2 + " is not supported by your Java Virtual Machine." + "  Try installing the latest VM from http://www.microsoft.com/java/download.htm");
        }
    }

    public XMLOutputStream createOutputStream(OutputStream outputStream) {
        XMLOutputStream xMLOutputStream = new XMLOutputStream(outputStream);
        try {
            xMLOutputStream.setEncoding(this.encoding, this.littleendian, this.byteOrderMark);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return xMLOutputStream;
    }

    public void close() throws IOException {
        if (this.xmlis != null) {
            this.xmlis.close();
        } else if (this.insr != null) {
            this.insr.close();
        } else if (this.in != null) {
            this.in.close();
        }
    }
}

