/*
 * Decompiled with CFR 0.152.
 */
package com.ms.xml.util;

import com.ms.xml.parser.DTD;
import com.ms.xml.util.Atom;
import com.ms.xml.util.ByteSwapOutputStream;
import com.ms.xml.util.Name;
import com.ms.xml.util.NameSpaceContext;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class XMLOutputStream
extends OutputStream {
    static final int OUTPUTSW = 1;
    static final int UCS2 = 2;
    static final int UCS2_BOM = 3;
    static final int ASCII = 4;
    public static int DEFAULT = 0;
    public static int PRETTY = 1;
    public static int COMPACT = 2;
    private OutputStream out;
    private OutputStreamWriter outsw;
    String newline;
    boolean littleendian;
    String encoding;
    private int writeState;
    int outputStyle;
    boolean jdk11;
    private boolean jdk12;
    public boolean mixed;
    private int indent;
    public DTD dtd;
    public NameSpaceContext nameSpaceContext = new NameSpaceContext();
    public boolean savingDTD;

    public XMLOutputStream(OutputStream outputStream) {
        String string = System.getProperty("java.version");
        boolean bl = this.jdk11 = string.equals("1.1");
        if (!this.jdk11) {
            float f = Float.valueOf(string.substring(0, 3)).floatValue();
            this.jdk11 = (double)f >= 1.1;
            this.jdk12 = (double)f >= 1.2;
        }
        this.outputStyle = DEFAULT;
        this.littleendian = false;
        this.savingDTD = false;
        this.mixed = false;
        this.out = outputStream;
        this.newline = System.getProperty("line.separator");
        this.indent = 0;
        try {
            if (!this.jdk11) {
                throw new IOException("Writers not supported in JDK 1.0");
            }
            this.outsw = new OutputStreamWriter(outputStream, "UTF8");
            this.writeState = 1;
            this.encoding = "UTF-8";
        }
        catch (IOException iOException) {
            this.outsw = null;
            this.writeState = 4;
            this.encoding = "ASCII";
        }
    }

    public void flush() throws IOException {
        if (this.outsw != null) {
            this.outsw.flush();
        } else {
            this.out.flush();
        }
    }

    public void close() throws IOException {
        if (this.outsw != null) {
            this.outsw.close();
        } else {
            this.out.close();
        }
    }

    public void setEncoding(String string, boolean bl, boolean bl2) throws IOException {
        this.outsw = null;
        String string2 = string;
        if (string.equalsIgnoreCase("UTF-8")) {
            string2 = "UTF8";
        } else if (string.equalsIgnoreCase("Shift_JIS")) {
            string2 = "SJIS";
        } else if (string.equalsIgnoreCase("ISO-8859-1")) {
            string2 = "8859_1";
        } else {
            if (string.equalsIgnoreCase("ISO-10646-UCS-4") || string.equalsIgnoreCase("UCS-4")) {
                throw new IOException("UCS-4 not yet supported");
            }
            if (string.equalsIgnoreCase("UCS-2")) {
                this.writeState = bl2 ? 3 : 2;
                this.encoding = "UCS-2";
                if (bl) {
                    this.littleendian = true;
                    this.out = new ByteSwapOutputStream(this.out);
                }
                return;
            }
            this.writeState = 4;
            this.encoding = "ASCII";
        }
        if (string.equalsIgnoreCase("ASCII")) {
            this.outsw = null;
        } else {
            try {
                if (!this.jdk11) {
                    throw new IOException("Writers not supported in JDK 1.0");
                }
                this.outsw = new OutputStreamWriter(this.out, string2);
                this.writeState = 1;
                this.encoding = string;
            }
            catch (IOException iOException) {
                throw new IOException(string2 + " is not supported by your Java Virtual Machine." + "  Try installing the latest VM from http://www.microsoft.com/java/download.htm");
            }
        }
    }

    public void write(int n) throws IOException {
        switch (this.writeState) {
            case 1: {
                if (this.jdk12) {
                    this.outsw.write(n);
                    break;
                }
                if (n > 2047) {
                    int n2 = 0xE0 | n >> 12 & 0xF;
                    int n3 = 0x80 | n >> 6 & 0x3F;
                    int n4 = 0x80 | n & 0x3F;
                    this.out.write(n2);
                    this.out.write(n3);
                    this.out.write(n4);
                    break;
                }
                if (n > 127) {
                    int n5 = 0xC0 | n >> 6 & 0x1F;
                    int n6 = 0x80 | n & 0x3F;
                    this.out.write(n5);
                    this.out.write(n6);
                    break;
                }
                this.out.write(n);
                break;
            }
            case 2: {
                int n7 = n >> 8;
                int n8 = n & 0xFF;
                this.out.write(n7);
                this.out.write(n8);
                break;
            }
            case 3: {
                this.writeState = 2;
                this.out.write(254);
                this.out.write(255);
                int n9 = n >> 8;
                int n10 = n & 0xFF;
                this.out.write(n9);
                this.out.write(n10);
                break;
            }
            default: {
                this.out.write(n);
            }
        }
    }

    public void writeQualifiedName(Name name, Atom atom) throws IOException {
        Atom atom2;
        Atom atom3 = atom2 = name.getNameSpace();
        if (atom2 == atom) {
            this.writeChars(name.getName());
            return;
        }
        if (atom2 != null) {
            if (this.dtd != null && !DTD.isReservedNameSpace(atom2)) {
                atom3 = this.nameSpaceContext.findNameSpace(atom2);
                if (atom3 == null) {
                    atom3 = this.dtd.findShortNameSpace(atom2);
                }
                if (atom3 == null) {
                    atom3 = atom2;
                }
            }
            this.writeChars(atom3.toString() + ":" + name.getName());
        } else if (atom == null) {
            this.writeChars(name.getName());
        } else {
            this.writeChars(":" + name.getName());
        }
    }

    public void writeChars(String string) throws IOException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\n') {
                int n2 = this.newline.length();
                for (int j = 0; j < n2; ++j) {
                    this.write(this.newline.charAt(j));
                }
                continue;
            }
            this.write(c);
        }
    }

    public void writeQuotedString(String string) throws IOException {
        char c = '\"';
        if (string.indexOf(34) >= 0 && string.indexOf(39) < 0) {
            c = '\'';
        }
        this.write(c);
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c2 = string.charAt(i);
            if (c2 == c) {
                if (c == '\"') {
                    this.writeChars("&quot;");
                    continue;
                }
                this.writeChars("&apos;");
                continue;
            }
            this.write(c2);
        }
        this.write(c);
    }

    public void writeNewLine() throws IOException {
        if (this.outputStyle == PRETTY && !this.mixed) {
            int n = this.newline.length();
            for (int i = 0; i < n; ++i) {
                this.write(this.newline.charAt(i));
            }
        }
    }

    public void addIndent(int n) {
        this.indent += n;
    }

    public void writeIndent() throws IOException {
        if (this.outputStyle == PRETTY && !this.mixed) {
            for (int i = 0; i < this.indent; ++i) {
                this.write(9);
            }
        }
    }

    public void setOutputStyle(int n) {
        this.outputStyle = n;
    }

    public int getOutputStyle() {
        return this.outputStyle;
    }
}

