/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.DAVExplorer;

import edu.uci.ics.DAVExplorer.ACLRequestGenerator;
import edu.uci.ics.DAVExplorer.ACLResponseInterpreter;
import edu.uci.ics.DAVExplorer.GlobalData;
import edu.uci.ics.DAVExplorer.Main;
import edu.uci.ics.DAVExplorer.WebDAVCompletionEvent;
import edu.uci.ics.DAVExplorer.WebDAVCompletionListener;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ACLChangePrivilegesDialog
extends JDialog
implements ActionListener,
ChangeListener,
ListSelectionListener,
WebDAVCompletionListener {
    protected String hostname;
    protected String resource;
    protected JList privList;
    protected JList curList;
    protected JButton okButton;
    protected JButton cancelButton;
    protected JButton leftButton;
    protected JButton rightButton;
    protected boolean changed = false;
    protected boolean waiting;
    protected boolean canceled;
    protected String principal;
    protected int principalType;
    protected Vector available;
    protected Vector selected;
    protected boolean grant;
    protected ACLResponseInterpreter interpreter;
    protected String panelTitle;

    public ACLChangePrivilegesDialog(String string, String string2, Vector vector, boolean bl) {
        super((Frame)GlobalData.getGlobalData().getMainFrame(), true);
        this.init(string, string2, vector, "Edit Privileges", bl);
        this.pack();
        this.setSize(this.getPreferredSize());
        GlobalData.getGlobalData().center(this);
        this.show();
    }

    public ACLChangePrivilegesDialog(String string, String string2, Vector vector, String string3, boolean bl) {
        super((Frame)GlobalData.getGlobalData().getMainFrame(), true);
        this.init(string, string2, vector, string3, bl);
        this.pack();
        this.setSize(this.getPreferredSize());
        GlobalData.getGlobalData().center(this);
        this.show();
    }

    protected void init(String string, String string2, Vector vector, String string3, boolean bl) {
        GlobalData.getGlobalData().setCursor(Cursor.getPredefinedCursor(3));
        this.hostname = string2;
        this.resource = string;
        this.selected = vector == null ? new Vector() : new Vector(vector);
        this.available = new Vector();
        this.setTitle(string3);
        ((Main)GlobalData.getGlobalData().getMainFrame()).addWebDAVCompletionListener(this);
        JLabel jLabel = new JLabel(this.resource, 0);
        jLabel.setForeground(Color.black);
        this.getContentPane().add("North", jLabel);
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(this);
        this.okButton.setMnemonic(79);
        this.okButton.setEnabled(false);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this);
        this.cancelButton.setMnemonic(67);
        JPanel jPanel = new JPanel();
        jPanel.add(this.okButton);
        jPanel.add(this.cancelButton);
        this.getRootPane().setDefaultButton(this.okButton);
        this.cancelButton.grabFocus();
        this.getContentPane().add("South", jPanel);
        this.setBackground(Color.lightGray);
        JPanel jPanel2 = this.makePanel();
        this.getContentPane().add("Center", jPanel2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ACLChangePrivilegesDialog.this.close(true);
            }
        });
        GlobalData.getGlobalData().resetCursor();
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void stateChanged(ChangeEvent changeEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block3: {
            block5: {
                block4: {
                    block2: {
                        if (!actionEvent.getActionCommand().equals("OK")) break block2;
                        this.close(false);
                        break block3;
                    }
                    if (!actionEvent.getActionCommand().equals("Cancel")) break block4;
                    this.close(true);
                    break block3;
                }
                if (!actionEvent.getActionCommand().equals("=>")) break block5;
                DefaultListModel defaultListModel = (DefaultListModel)this.privList.getModel();
                DefaultListModel defaultListModel2 = (DefaultListModel)this.curList.getModel();
                int[] nArray = this.privList.getSelectedIndices();
                for (int i = nArray.length - 1; i >= 0; --i) {
                    Object e = defaultListModel.getElementAt(nArray[i]);
                    defaultListModel2.addElement(e);
                    this.selected.add(e.toString());
                    defaultListModel.remove(nArray[i]);
                    this.setChanged();
                }
                break block3;
            }
            if (!actionEvent.getActionCommand().equals("<=")) break block3;
            DefaultListModel defaultListModel = (DefaultListModel)this.privList.getModel();
            DefaultListModel defaultListModel3 = (DefaultListModel)this.curList.getModel();
            int[] nArray = this.curList.getSelectedIndices();
            for (int i = nArray.length - 1; i >= 0; --i) {
                Object e = defaultListModel3.getElementAt(nArray[i]);
                defaultListModel.addElement(e);
                defaultListModel3.remove(nArray[i]);
                this.selected.remove(e.toString());
                this.setChanged();
            }
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getSource() == this.privList) {
            this.rightButton.setEnabled(!this.privList.isSelectionEmpty());
        } else {
            this.leftButton.setEnabled(!this.curList.isSelectionEmpty());
        }
    }

    public void setChanged() {
        this.changed = true;
        this.okButton.setEnabled(this.changed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completion(WebDAVCompletionEvent webDAVCompletionEvent) {
        this.interpreter = (ACLResponseInterpreter)webDAVCompletionEvent.getSource();
        ACLChangePrivilegesDialog aCLChangePrivilegesDialog = this;
        synchronized (aCLChangePrivilegesDialog) {
            this.waiting = false;
            this.notify();
        }
    }

    public Vector getSelected() {
        return this.selected;
    }

    protected String getPanelTitle() {
        return "Privileges";
    }

    protected JPanel makePanel() {
        JPanel jPanel = new JPanel(false);
        this.getAvailable();
        DefaultListModel defaultListModel = new DefaultListModel();
        for (int i = 0; i < this.available.size(); ++i) {
            if (this.selected.contains(this.available.get(i))) continue;
            defaultListModel.addElement(this.available.get(i));
        }
        this.privList = new JList(defaultListModel);
        this.privList.setFixedCellWidth(200);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(this.privList);
        this.privList.addListSelectionListener(this);
        defaultListModel = new DefaultListModel();
        for (int i = 0; i < this.selected.size(); ++i) {
            defaultListModel.addElement(this.selected.get(i));
        }
        this.curList = new JList(defaultListModel);
        this.curList.setFixedCellWidth(200);
        JScrollPane jScrollPane2 = new JScrollPane();
        jScrollPane2.setViewportView(this.curList);
        this.curList.addListSelectionListener(this);
        JLabel jLabel = new JLabel(this.getPanelTitle());
        jLabel.setHorizontalAlignment(0);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        JLabel jLabel2 = new JLabel("Available");
        jLabel.setHorizontalAlignment(0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        jPanel.add(jLabel2);
        JLabel jLabel3 = new JLabel("Selected");
        jLabel.setHorizontalAlignment(0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(jLabel3, gridBagConstraints);
        jPanel.add(jLabel3);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        jPanel.add(jScrollPane);
        this.rightButton = new JButton("=>");
        this.rightButton.addActionListener(this);
        this.rightButton.setMnemonic(160);
        this.rightButton.setEnabled(false);
        this.leftButton = new JButton("<=");
        this.leftButton.addActionListener(this);
        this.leftButton.setMnemonic(153);
        this.leftButton.setEnabled(false);
        JPanel jPanel2 = new JPanel();
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        jPanel2.setLayout(gridBagLayout2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagLayout2.setConstraints(this.rightButton, gridBagConstraints);
        jPanel2.add(this.rightButton);
        gridBagLayout2.setConstraints(this.rightButton, gridBagConstraints);
        jPanel2.add(this.leftButton);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = -1;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(jScrollPane2, gridBagConstraints);
        jPanel.add(jScrollPane2);
        this.changePanel(jPanel);
        return jPanel;
    }

    protected void changePanel(JPanel jPanel) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getAvailable() {
        String string = GlobalData.getGlobalData().getSSL() ? "https://" : "http://";
        ACLRequestGenerator aCLRequestGenerator = (ACLRequestGenerator)ACLResponseInterpreter.getGenerator();
        aCLRequestGenerator.setResource(string + this.resource, null);
        this.waiting = true;
        aCLRequestGenerator.GetSupportedPrivilegeSet();
        try {
            ACLChangePrivilegesDialog aCLChangePrivilegesDialog = this;
            synchronized (aCLChangePrivilegesDialog) {
                this.wait(30000L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.interpreter != null && this.interpreter.getSupportedPrivilegeSet() != null) {
            this.available.addAll(this.interpreter.getSupportedPrivilegeSet());
        }
    }

    protected void close(boolean bl) {
        this.setVisible(false);
        this.canceled = bl;
    }
}

