/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.DAVExplorer;

import java.util.Vector;

public class ACLNode {
    public static final int GENERAL = 1;
    public static final int PROPERTY = 2;
    public static final int HREF = 3;
    private String[] principal;
    private int principalType;
    private Vector privileges;
    private boolean grant;
    private boolean inherited;
    private String inheritedHref;
    private boolean modified;

    public ACLNode(String[] stringArray, int n, String[] stringArray2, boolean bl, String string, boolean bl2) {
        this.init(stringArray, n, stringArray2, bl, string, bl2);
    }

    public ACLNode(String[] stringArray, int n, String[] stringArray2, boolean bl, String string) {
        this.init(stringArray, n, stringArray2, bl, string, false);
    }

    public ACLNode(String[] stringArray, int n, String[] stringArray2, boolean bl, boolean bl2) {
        this.init(stringArray, n, stringArray2, bl, null, bl2);
    }

    public ACLNode(String[] stringArray, int n, String[] stringArray2, boolean bl) {
        this.init(stringArray, n, stringArray2, bl, null, false);
    }

    public ACLNode(String[] stringArray, int n, Vector vector, boolean bl) {
        this.init(stringArray, n, vector, bl, null, false);
    }

    public ACLNode() {
        this.privileges = new Vector();
        this.modified = false;
    }

    protected void init(String[] stringArray, int n, String[] stringArray2, boolean bl, String string, boolean bl2) {
        this.principal = new String[2];
        this.principal[0] = new String(stringArray[0]);
        this.principal[1] = new String(stringArray[1]);
        this.principalType = n;
        this.setPrivileges(stringArray2);
        this.grant = bl;
        if (string != null && string.length() > 0) {
            this.inherited = true;
            this.inheritedHref = string;
        } else {
            this.inherited = false;
        }
        this.modified = bl2;
    }

    protected void init(String[] stringArray, int n, Vector vector, boolean bl, String string, boolean bl2) {
        this.principal = stringArray;
        this.principalType = n;
        this.setPrivileges(vector);
        this.grant = bl;
        if (string != null && string.length() > 0) {
            this.inherited = true;
            this.inheritedHref = string;
        } else {
            this.inherited = false;
        }
        this.modified = bl2;
    }

    public String[] getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(String[] stringArray) {
        this.principal = stringArray;
        this.modified = true;
    }

    public int getPrincipalType() {
        return this.principalType;
    }

    public void setPrincipalType(int n) {
        this.principalType = n;
    }

    public Vector getPrivileges() {
        return this.privileges;
    }

    public void setPrivileges(String[] stringArray) {
        this.privileges = new Vector();
        for (int i = 0; i < stringArray.length; ++i) {
            this.privileges.add(stringArray[i]);
        }
        this.modified = true;
    }

    public void setPrivileges(Vector vector) {
        this.privileges = vector;
        this.modified = true;
    }

    public boolean addPrivilege(String string) {
        if (this.privileges.contains(string)) {
            return false;
        }
        this.privileges.add(string);
        this.modified = true;
        return true;
    }

    public void addPrivileges(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            this.addPrivilege((String)vector.get(i));
        }
    }

    public void addPrivileges(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.addPrivilege(stringArray[i]);
        }
    }

    public boolean deletePrivilege(String string) {
        if (this.privileges.contains(string)) {
            this.privileges.removeElement(string);
            this.modified = true;
            return true;
        }
        return false;
    }

    public void deletePrivileges(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            this.deletePrivilege((String)vector.get(i));
        }
    }

    public void deletePrivileges(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.deletePrivilege(stringArray[i]);
        }
    }

    public boolean getGrant() {
        return this.grant;
    }

    public void setGrant(boolean bl) {
        this.grant = bl;
    }

    public boolean isInherited() {
        return this.inherited;
    }

    public String getInherited() {
        if (this.isInherited()) {
            return this.inheritedHref;
        }
        return null;
    }

    public void setInherited(String string) {
        this.inherited = true;
        this.inheritedHref = string;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void clearModified() {
        this.modified = false;
    }
}

