/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.DAVExplorer;

import edu.uci.ics.DAVExplorer.ACLPropertySearchModel;
import edu.uci.ics.DAVExplorer.ACLPropertySearchNode;
import edu.uci.ics.DAVExplorer.ACLReportChangeSearchPropertiesDialog;
import edu.uci.ics.DAVExplorer.ACLReportPropertiesDialog;
import edu.uci.ics.DAVExplorer.GlobalData;
import edu.uci.ics.DAVExplorer.Main;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;

public class ACLReportSearchPropertyDialog
extends ACLReportPropertiesDialog {
    protected JTable propTable;
    protected JButton addButton;
    protected JButton deleteButton;
    protected JCheckBox selfBox;
    protected boolean match;
    protected boolean self;

    public ACLReportSearchPropertyDialog(String string) {
        super(string, "Select Search Criteria", true);
    }

    public ACLReportSearchPropertyDialog(String string, boolean bl) {
        super(string, "Select Search Criteria", bl);
    }

    protected void init(String string, String string2, Vector vector, String string3, boolean bl) {
        GlobalData.getGlobalData().setCursor(Cursor.getPredefinedCursor(3));
        this.resource = string;
        this.match = bl;
        this.self = !bl;
        this.available = new Vector();
        this.selected = new Vector();
        this.setTitle(string3);
        ((Main)GlobalData.getGlobalData().getMainFrame()).addWebDAVCompletionListener(this);
        JLabel jLabel = new JLabel(this.resource, 0);
        jLabel.setForeground(Color.black);
        this.getContentPane().add("North", jLabel);
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(this);
        this.okButton.setMnemonic(79);
        this.okButton.setEnabled(false);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this);
        this.cancelButton.setMnemonic(67);
        JPanel jPanel = new JPanel();
        jPanel.add(this.okButton);
        jPanel.add(this.cancelButton);
        this.getRootPane().setDefaultButton(this.cancelButton);
        this.cancelButton.grabFocus();
        this.getContentPane().add("South", jPanel);
        this.setBackground(Color.lightGray);
        JTabbedPane jTabbedPane = new JTabbedPane();
        JPanel jPanel2 = this.makeCriteriaPanel();
        jTabbedPane.addTab("Search Criteria", jPanel2);
        jTabbedPane.setMnemonicAt(0, 83);
        JPanel jPanel3 = this.makePanel();
        jTabbedPane.addTab("Properties", jPanel3);
        jTabbedPane.setMnemonicAt(1, 80);
        this.getContentPane().add("Center", jTabbedPane);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ACLReportSearchPropertyDialog.this.close(true);
            }
        });
        GlobalData.getGlobalData().resetCursor();
    }

    protected JPanel makeCriteriaPanel() {
        JPanel jPanel;
        JLabel jLabel = new JLabel("Search Criteria");
        JPanel jPanel2 = new JPanel(false);
        jLabel.setForeground(Color.black);
        jLabel.setHorizontalAlignment(0);
        BorderLayout borderLayout = new BorderLayout();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)jLabel, "North");
        this.propTable = new JTable(new ACLPropertySearchModel(this.match));
        this.propTable.getSelectionModel().addListSelectionListener(this);
        this.propTable.setPreferredScrollableViewportSize(new Dimension(400, 100));
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(this.propTable);
        if (this.self) {
            jPanel = new JPanel(false);
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            jPanel.setLayout(gridBagLayout);
            gridBagConstraints.fill = 1;
            gridBagConstraints.weighty = 5.0;
            gridBagConstraints.gridwidth = 0;
            gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
            jPanel.add(jScrollPane);
            this.selfBox = new JCheckBox("Self");
            this.selfBox.addActionListener(this);
            this.selfBox.setMnemonic(83);
            gridBagConstraints.weighty = 1.0;
            gridBagLayout.setConstraints(this.selfBox, gridBagConstraints);
            jPanel.add(this.selfBox);
            jPanel2.add((Component)jPanel, "Center");
        } else {
            jPanel2.add((Component)jScrollPane, "Center");
        }
        this.addButton = new JButton("Add");
        this.addButton.addActionListener(this);
        this.addButton.setMnemonic(65);
        this.deleteButton = new JButton("Delete");
        this.deleteButton.addActionListener(this);
        this.deleteButton.setMnemonic(68);
        this.deleteButton.setEnabled(false);
        jPanel = new JPanel();
        jPanel.add(this.addButton);
        jPanel.add(this.deleteButton);
        jPanel2.add((Component)jPanel, "South");
        return jPanel2;
    }

    protected String getPanelTitle() {
        return "Properties";
    }

    public void setChanged() {
        boolean bl;
        this.changed = true;
        boolean bl2 = bl = ((ACLPropertySearchModel)this.propTable.getModel()).getRealRowCount() > 0 && this.changed;
        if (this.self) {
            bl |= this.selfBox.isSelected();
        }
        this.okButton.setEnabled(bl);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Add")) {
            ACLReportChangeSearchPropertiesDialog aCLReportChangeSearchPropertiesDialog = new ACLReportChangeSearchPropertiesDialog(this.resource, this.match);
            if (!aCLReportChangeSearchPropertiesDialog.isCanceled()) {
                ((ACLPropertySearchModel)this.propTable.getModel()).addRow(aCLReportChangeSearchPropertiesDialog.getSelected(), aCLReportChangeSearchPropertiesDialog.getMatch());
                this.setChanged();
            }
        } else if (actionEvent.getActionCommand().equals("Delete")) {
            int n = this.propTable.getSelectedRow();
            ((ACLPropertySearchModel)this.propTable.getModel()).removeRow(n);
            this.deleteButton.setEnabled(false);
            this.setChanged();
        } else if (actionEvent.getActionCommand().equals("Self")) {
            this.addButton.setEnabled(!this.selfBox.isSelected());
            this.propTable.setEnabled(!this.selfBox.isSelected());
            if (this.selfBox.isSelected()) {
                this.deleteButton.setEnabled(false);
            } else if (((ACLPropertySearchModel)this.propTable.getModel()).getRealRowCount() > 0) {
                this.deleteButton.setEnabled(true);
            }
            this.setChanged();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.propTable.isShowing()) {
            if (((ACLPropertySearchModel)this.propTable.getModel()).getRealRowCount() > 0) {
                this.deleteButton.setEnabled(true);
            }
        } else {
            super.valueChanged(listSelectionEvent);
        }
    }

    public Vector getSearchCriteria() {
        Vector<ACLPropertySearchNode> vector = new Vector<ACLPropertySearchNode>();
        ACLPropertySearchModel aCLPropertySearchModel = (ACLPropertySearchModel)this.propTable.getModel();
        for (int i = 0; i < aCLPropertySearchModel.getRealRowCount(); ++i) {
            vector.add(aCLPropertySearchModel.getRow(i));
        }
        return vector;
    }

    public boolean isSelf() {
        if (this.self) {
            return this.selfBox.isSelected();
        }
        return false;
    }
}

