/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.DAVExplorer;

import com.ms.xml.om.Document;
import com.ms.xml.om.Element;
import com.ms.xml.om.TreeEnumeration;
import com.ms.xml.util.Name;
import edu.uci.ics.DAVExplorer.ACLDialog;
import edu.uci.ics.DAVExplorer.ACLInheritedDialog;
import edu.uci.ics.DAVExplorer.ACLOwnerDialog;
import edu.uci.ics.DAVExplorer.ACLPrivilegesDialog;
import edu.uci.ics.DAVExplorer.ACLRequestGenerator;
import edu.uci.ics.DAVExplorer.ACLRestrictionDialog;
import edu.uci.ics.DAVExplorer.DeltaVResponseInterpreter;
import edu.uci.ics.DAVExplorer.GlobalData;
import edu.uci.ics.DAVExplorer.PrincipalPropertiesModel;
import edu.uci.ics.DAVExplorer.PropDialog;
import edu.uci.ics.DAVExplorer.PropModel;
import edu.uci.ics.DAVExplorer.ResponseException;
import edu.uci.ics.DAVExplorer.WebDAVProp;
import edu.uci.ics.DAVExplorer.WebDAVRequestGenerator;
import edu.uci.ics.DAVExplorer.WebDAVResponseEvent;
import java.io.ByteArrayInputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JDialog;

public class ACLResponseInterpreter
extends DeltaVResponseInterpreter {
    public static int RESOURCETYPE_PRINCIPAL = 2;
    protected Hashtable acl = new Hashtable();
    protected Vector principalCollectionSet;
    protected Vector principalNames;
    protected Vector supportedPrivilegeSet;
    protected Vector propertyNames;

    public ACLResponseInterpreter() {
    }

    public ACLResponseInterpreter(WebDAVRequestGenerator webDAVRequestGenerator) {
        super(webDAVRequestGenerator);
    }

    public boolean handleResponse(WebDAVResponseEvent webDAVResponseEvent) throws ResponseException {
        if (GlobalData.getGlobalData().getDebugResponse()) {
            System.err.println("ACLResponseInterpreter::handleResponse");
        }
        res = webDAVResponseEvent.getResponse();
        Method = webDAVResponseEvent.getMethodName();
        extendedCode = webDAVResponseEvent.getExtendedCode();
        HostName = webDAVResponseEvent.getHost();
        Port = webDAVResponseEvent.getPort();
        Charset = this.getCharset();
        Resource = webDAVResponseEvent.getResource();
        Resource = GlobalData.getGlobalData().unescape(webDAVResponseEvent.getResource(), "ISO-8859-1", null);
        this.Node = webDAVResponseEvent.getNode();
        try {
            if (res.getStatusCode() < 300) {
                if (Method.equals("PROPFIND")) {
                    this.parsePropFind();
                } else if (Method.equals("REPORT")) {
                    this.parseReport();
                } else if (Method.equals("PROPPATCH")) {
                    this.parsePropPatch();
                } else {
                    super.handleResponse(webDAVResponseEvent);
                }
            } else {
                if (res.getStatusCode() == 302 || res.getStatusCode() == 301) {
                    switch (webDAVResponseEvent.getExtendedCode()) {
                        case 78: {
                            String string = res.getHeader("Location");
                            generator.setResource(string, null);
                            ((ACLRequestGenerator)generator).GetPrincipalNames();
                            return false;
                        }
                    }
                }
                super.handleResponse(webDAVResponseEvent);
            }
        }
        catch (Exception exception) {
            String string = System.getProperty("debug", "false");
            if (string.equals("true")) {
                System.out.println(exception);
            }
            throw new ResponseException("HTTP error");
        }
        return true;
    }

    public void parseOptions() {
        if (GlobalData.getGlobalData().getDebugResponse()) {
            System.err.println("ACLResponseInterpreter::parseOptions");
        }
        try {
            String string = res.getHeader("DAV");
            if (string == null) {
                GlobalData.getGlobalData().errorMsg("ACL Interpreter:\n\nThe server does not support DAV\nat Resource " + Resource + ".");
                return;
            }
            boolean bl = false;
            if (string.indexOf("access-control") >= 0) {
                bl = true;
            }
            String string2 = Port == 0 || Port == 80 ? HostName : HostName + ":" + Port;
            string2 = string2 + Resource;
            this.acl.put(string2, bl);
        }
        catch (Exception exception) {
            GlobalData.getGlobalData().errorMsg("ACL Interpreter:\n\nError encountered \nwhile parsing OPTIONS Response:\n" + exception);
            stream = null;
            return;
        }
        if (extendedCode == 1) {
            generator.DoPropFind(Resource, false);
        }
    }

    protected void parsePropFind() {
        if (GlobalData.getGlobalData().getDebugResponse()) {
            System.err.println("ACLResponseInterpreter::parsePropFind");
        }
        byte[] byArray = null;
        Document document = null;
        try {
            byArray = res.getData();
            stream = byArray;
            if (byArray == null) {
                GlobalData.getGlobalData().errorMsg("DAV Interpreter:\n\nMissing XML body in\nPROPFIND response.");
                return;
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            document = new Document();
            document.load(byteArrayInputStream);
        }
        catch (Exception exception) {
            GlobalData.getGlobalData().errorMsg("DAV Interpreter:\n\nError encountered \nwhile parsing PROPFIND Response.\n" + exception);
            stream = null;
            return;
        }
        switch (extendedCode) {
            case 70: {
                this.handleOwner(document, true);
                break;
            }
            case 71: {
                this.handleOwner(document, false);
                break;
            }
            case 72: {
                this.handlePrivileges(document, true);
                break;
            }
            case 73: {
                this.handlePrivileges(document, false);
                break;
            }
            case 74: 
            case 75: 
            case 76: {
                this.handleListACLs(document, extendedCode);
                break;
            }
            case 77: {
                this.handlePrincipalCollectionSet(document);
                break;
            }
            case 78: {
                this.handlePrincipalNames(document);
                break;
            }
            case 79: {
                this.handlePropertyNames(document);
                break;
            }
            default: {
                super.parsePropFind();
            }
        }
        this.printXML(byArray);
    }

    protected void parsePropPatch() throws Exception {
        if (GlobalData.getGlobalData().getDebugResponse()) {
            System.err.println("ACLResponseInterpreter::parsePropPatch");
        }
        byte[] byArray = null;
        Document document = null;
        try {
            byArray = res.getData();
            stream = byArray;
            if (byArray == null) {
                GlobalData.getGlobalData().errorMsg("DAV Interpreter:\n\nMissing XML body in\nPROPFIND response.");
                return;
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            document = new Document();
            document.load(byteArrayInputStream);
        }
        catch (Exception exception) {
            GlobalData.getGlobalData().errorMsg("DAV Interpreter:\n\nError encountered \nwhile parsing PROPFIND Response.\n" + exception);
            stream = null;
            return;
        }
        switch (extendedCode) {
            case 70: 
            case 71: {
                if (res.getStatusCode() != 207) break;
                this.handleMultiStatus(document);
                break;
            }
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                break;
            }
            default: {
                super.parsePropPatch();
            }
        }
    }

    protected void parseReport() {
        if (GlobalData.getGlobalData().getDebugResponse()) {
            System.err.println("ACLResponseInterpreter::parseReport");
        }
        byte[] byArray = null;
        Document document = null;
        try {
            byArray = res.getData();
            stream = byArray;
            if (byArray == null) {
                GlobalData.getGlobalData().errorMsg("DAV Interpreter:\n\nMissing XML body in\nPROPFIND response.");
                return;
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            document = new Document();
            document.load(byteArrayInputStream);
        }
        catch (Exception exception) {
            GlobalData.getGlobalData().errorMsg("DAV Interpreter:\n\nError encountered \nwhile parsing PROPFIND Response.\n" + exception);
            stream = null;
            return;
        }
        switch (extendedCode) {
            case 80: {
                this.handlePrincipalPropSet(document);
                break;
            }
            case 81: {
                this.handlePrincipalMatch(document);
                break;
            }
            case 82: {
                this.handlePrincipalPropertySearch(document);
                break;
            }
            case 83: {
                this.handlePrincipalSearchPropertySet(document);
                break;
            }
            default: {
                super.parseReport();
            }
        }
        this.printXML(byArray);
    }

    protected void handleOwner(Document document, boolean bl) {
        String[] stringArray = new String[]{new String("response")};
        Element element = this.skipElements(document, stringArray);
        if (element != null) {
            TreeEnumeration treeEnumeration = new TreeEnumeration(element);
            while (treeEnumeration.hasMoreElements()) {
                Element element2 = (Element)treeEnumeration.nextElement();
                Name name = element2.getTagName();
                if (name == null || !name.getName().equals("propstat") || (element = this.skipElements(element2, stringArray = new String[]{new String("propstat"), new String("prop")})) == null) continue;
                String string = HostName;
                if (Port != 0) {
                    string = HostName + ":" + Port;
                }
                ACLOwnerDialog aCLOwnerDialog = new ACLOwnerDialog(element, Resource, string, bl, true);
            }
        }
    }

    protected void handlePrivileges(Document document, boolean bl) {
        String[] stringArray = new String[]{new String("response")};
        Element element = this.skipElements(document, stringArray);
        if (element != null) {
            TreeEnumeration treeEnumeration = new TreeEnumeration(element);
            while (treeEnumeration.hasMoreElements()) {
                Element element2 = (Element)treeEnumeration.nextElement();
                Name name = element2.getTagName();
                if (name == null || !name.getName().equals("propstat") || (element = this.skipElements(element2, stringArray = new String[]{new String("propstat"), new String("prop")})) == null) continue;
                if (bl) {
                    this.handleSupportedPrivileges(element);
                    break;
                }
                String string = HostName;
                if (Port != 0) {
                    string = HostName + ":" + Port;
                }
                ACLPrivilegesDialog aCLPrivilegesDialog = new ACLPrivilegesDialog(element, Resource, string, bl);
                break;
            }
        }
    }

    protected void handleListACLs(Document document, int n) {
        String[] stringArray = new String[]{new String("response")};
        Element element = this.skipElements(document, stringArray);
        if (element != null) {
            TreeEnumeration treeEnumeration = new TreeEnumeration(element);
            while (treeEnumeration.hasMoreElements()) {
                Element element2 = (Element)treeEnumeration.nextElement();
                Name name = element2.getTagName();
                if (name == null || !name.getName().equals("propstat") || (element = this.skipElements(element2, stringArray = new String[]{new String("propstat"), new String("prop")})) == null) continue;
                String string = HostName;
                if (Port != 0) {
                    string = HostName + ":" + Port;
                }
                switch (n) {
                    case 74: {
                        JDialog jDialog = new ACLDialog(element, Resource, string, null);
                        break;
                    }
                    case 75: {
                        JDialog jDialog = new ACLRestrictionDialog(element, Resource, string);
                        break;
                    }
                    case 76: {
                        JDialog jDialog = new ACLInheritedDialog(element, Resource, string);
                    }
                }
            }
        }
    }

    protected void handlePrincipalCollectionSet(Document document) {
        String[] stringArray = new String[]{new String("principal-collection-set")};
        Element element = this.skipElements(document, stringArray);
        this.principalCollectionSet = new Vector();
        if (element != null) {
            TreeEnumeration treeEnumeration = new TreeEnumeration(element);
            while (treeEnumeration.hasMoreElements()) {
                Element element2;
                Element element3 = (Element)treeEnumeration.nextElement();
                Name name = element3.getTagName();
                if (name == null || !name.getName().equals("href") || (element2 = (Element)treeEnumeration.nextElement()) == null || element2.getType() != 1 && element2.getType() != 6) continue;
                this.principalCollectionSet.add(GlobalData.getGlobalData().unescape(element2.getText(), "UTF-8", null));
            }
        }
    }

    protected void handlePrincipalNames(Document document) {
        this.principalNames = new Vector();
        String[] stringArray = new String[]{new String("multistatus")};
        int n = Resource.endsWith("/") ? Resource.lastIndexOf(47, Resource.length() - 2) : Resource.lastIndexOf(47, Resource.length());
        String string = Resource.substring(n);
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        String string2 = null;
        Element element = null;
        Element element2 = this.skipElements(document, stringArray);
        if (element2 != null) {
            TreeEnumeration treeEnumeration = new TreeEnumeration(element2);
            while (treeEnumeration.hasMoreElements()) {
                Element element3 = (Element)treeEnumeration.nextElement();
                Name name = element3.getTagName();
                if (name == null) continue;
                if (name.getName().equals("href")) {
                    string2 = this.getHref(treeEnumeration, element3);
                }
                if (name.getName().equals("prop")) {
                    element = element3;
                }
                if (!name.getName().equals("resourcetype") || this.getResourceType(element3) != RESOURCETYPE_PRINCIPAL) continue;
                String[] stringArray2 = new String[]{string2, string + this.getDisplayName(element)};
                this.principalNames.add(stringArray2);
            }
        }
    }

    protected void handleSupportedPrivileges(Element element) {
        this.supportedPrivilegeSet = new Vector();
        if (element != null) {
            TreeEnumeration treeEnumeration = new TreeEnumeration(element);
            block0: while (treeEnumeration.hasMoreElements()) {
                Element element2 = (Element)treeEnumeration.nextElement();
                Name name = element2.getTagName();
                if (name == null || !name.getName().equals("privilege")) continue;
                while (treeEnumeration.hasMoreElements()) {
                    Element element3 = (Element)treeEnumeration.nextElement();
                    if (element3 == null || element3.getTagName() == null) continue;
                    this.supportedPrivilegeSet.add(element3.getTagName().getName());
                    continue block0;
                }
            }
        }
    }

    protected void handlePropertyNames(Document document) {
        this.propertyNames = new Vector();
        String[] stringArray = new String[]{new String("multistatus"), new String("response")};
        Object var3_3 = null;
        Object var4_4 = null;
        Element element = this.skipElements(document, stringArray);
        if (element != null) {
            TreeEnumeration treeEnumeration = new TreeEnumeration(element);
            while (treeEnumeration.hasMoreElements()) {
                Element element2 = (Element)treeEnumeration.nextElement();
                Name name = element2.getTagName();
                if (name == null || !name.getName().equals("prop")) continue;
                this.parsePropertyNames(element2);
            }
        }
    }

    protected void parsePropertyNames(Element element) {
        if (element != null) {
            TreeEnumeration treeEnumeration = new TreeEnumeration(element);
            while (treeEnumeration.hasMoreElements()) {
                Element element2 = (Element)treeEnumeration.nextElement();
                Name name = element2.getTagName();
                if (name == null || name.getName().equals("prop")) continue;
                String[] stringArray = new String[]{name.getName(), WebDAVProp.locateNamespace(element2, name)};
                this.propertyNames.add(stringArray);
            }
        }
    }

    protected void handleMultiStatus(Document document) {
        int n = 0;
        String string = "";
        String[] stringArray = new String[]{new String("response")};
        Element element = this.skipElements(document, stringArray);
        if (element != null) {
            TreeEnumeration treeEnumeration = new TreeEnumeration(element);
            while (treeEnumeration.hasMoreElements()) {
                Element element2 = (Element)treeEnumeration.nextElement();
                Name name = element2.getTagName();
                if (name == null) continue;
                if (name.getName().equals("status")) {
                    n = this.getStatus(element2);
                    continue;
                }
                if (!name.getName().equals("responsedescription")) continue;
                string = this.getDescription(element2);
            }
        }
        if (n >= 400) {
            GlobalData.getGlobalData().errorMsg(string);
        }
    }

    protected String getDescription(Element element) {
        if (GlobalData.getGlobalData().getDebugTreeNode()) {
            System.err.println("ACLResponseInterpreter::getDescription");
        }
        TreeEnumeration treeEnumeration = new TreeEnumeration(element);
        while (treeEnumeration.hasMoreElements()) {
            Element element2 = (Element)treeEnumeration.nextElement();
            if (element2 == null || element2.getType() != 1 && element2.getType() != 6) continue;
            return GlobalData.getGlobalData().unescape(element2.getText(), Charset, null);
        }
        return "";
    }

    protected int getResourceType(Element element) {
        if (GlobalData.getGlobalData().getDebugTreeNode()) {
            System.err.println("ACLResponseInterpreter::getResourceType");
        }
        TreeEnumeration treeEnumeration = new TreeEnumeration(element);
        while (treeEnumeration.hasMoreElements()) {
            Element element2 = (Element)treeEnumeration.nextElement();
            Name name = element2.getTagName();
            if (name == null || !name.getName().equals("principal")) continue;
            return RESOURCETYPE_PRINCIPAL;
        }
        return super.getResourceType(element);
    }

    protected void handlePrincipalPropSet(Document document) {
        String[] stringArray = new String[]{new String("multistatus")};
        Element element = this.skipElements(document, stringArray);
        Vector<Object> vector = new Vector<Object>();
        if (element != null) {
            Object object;
            Object object2;
            TreeEnumeration treeEnumeration = new TreeEnumeration(element);
            while (treeEnumeration.hasMoreElements()) {
                object2 = (Element)treeEnumeration.nextElement();
                object = object2.getTagName();
                if (object == null || !((Name)object).getName().equals("response")) continue;
                vector.add(object2);
            }
            object2 = new PrincipalPropertiesModel(vector);
            object = new PropDialog((PropModel)object2, Resource, HostName, "View Principal Property Set", null, false);
        }
    }

    protected void handlePrincipalMatch(Document document) {
        String[] stringArray = new String[]{new String("multistatus")};
        Element element = this.skipElements(document, stringArray);
        Vector<Object> vector = new Vector<Object>();
        if (element != null) {
            Object object;
            Object object2;
            TreeEnumeration treeEnumeration = new TreeEnumeration(element);
            while (treeEnumeration.hasMoreElements()) {
                object2 = (Element)treeEnumeration.nextElement();
                object = object2.getTagName();
                if (object == null || !((Name)object).getName().equals("response")) continue;
                vector.add(object2);
            }
            object2 = new PrincipalPropertiesModel(vector);
            object = new PropDialog((PropModel)object2, Resource, HostName, "View Principal Match", null, false);
        }
    }

    protected void handlePrincipalPropertySearch(Document document) {
        String[] stringArray = new String[]{new String("multistatus")};
        Element element = this.skipElements(document, stringArray);
        if (element != null) {
            TreeEnumeration treeEnumeration = new TreeEnumeration(element);
            while (treeEnumeration.hasMoreElements()) {
                Element element2 = (Element)treeEnumeration.nextElement();
                Name name = element2.getTagName();
                if (name == null || !name.getName().equals("response")) continue;
                PrincipalPropertiesModel principalPropertiesModel = new PrincipalPropertiesModel(element2);
                PropDialog propDialog = new PropDialog(principalPropertiesModel, Resource, HostName, "View Principal Properties", null, false);
            }
        }
    }

    protected void handlePrincipalSearchPropertySet(Document document) {
        String[] stringArray = new String[]{new String("principal-search-property-set")};
        Element element = this.skipElements(document, stringArray);
        Vector<Object> vector = new Vector<Object>();
        if (element != null) {
            Object object;
            Object object2;
            TreeEnumeration treeEnumeration = new TreeEnumeration(element);
            while (treeEnumeration.hasMoreElements()) {
                object2 = (Element)treeEnumeration.nextElement();
                object = object2.getTagName();
                if (object == null || !((Name)object).getName().equals("principal-search-property")) continue;
                vector.add(object2);
            }
            object2 = new PrincipalPropertiesModel(vector);
            object = new PropDialog((PropModel)object2, Resource, HostName, "View Principal Search Properties", null, false);
        }
    }

    public boolean isACL(String string) {
        Enumeration enumeration = this.acl.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (string.indexOf(string2) < 0) continue;
            return (Boolean)this.acl.get(string2);
        }
        return false;
    }

    public Vector getPrincipalCollectionSet() {
        return this.principalCollectionSet;
    }

    public Vector getPrincipalNames() {
        return this.principalNames;
    }

    public Vector getSupportedPrivilegeSet() {
        return this.supportedPrivilegeSet;
    }

    public Vector getPropertyNames() {
        return this.propertyNames;
    }
}

