/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.DAVExplorer;

import com.ms.xml.om.Document;
import com.ms.xml.om.Element;
import com.ms.xml.om.SiblingEnumeration;
import com.ms.xml.om.TreeEnumeration;
import com.ms.xml.util.Name;
import edu.uci.ics.DAVExplorer.DataNode;
import edu.uci.ics.DAVExplorer.DeltaVDataNode;
import edu.uci.ics.DAVExplorer.DeltaVRequestGenerator;
import edu.uci.ics.DAVExplorer.GlobalData;
import edu.uci.ics.DAVExplorer.InsertionListener;
import edu.uci.ics.DAVExplorer.ResponseException;
import edu.uci.ics.DAVExplorer.VersionInfoDialog;
import edu.uci.ics.DAVExplorer.WebDAVRequestGenerator;
import edu.uci.ics.DAVExplorer.WebDAVResponseEvent;
import edu.uci.ics.DAVExplorer.WebDAVResponseInterpreter;
import edu.uci.ics.DAVExplorer.WebDAVTreeNode;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;

public class DeltaVResponseInterpreter
extends WebDAVResponseInterpreter {
    protected static Vector versionControlListeners = new Vector();
    protected static Vector checkoutListeners = new Vector();
    protected static Vector unCheckoutListeners = new Vector();
    protected static Vector checkinListeners = new Vector();
    protected static Vector mkActivityListeners = new Vector();
    protected static Vector mergeListeners = new Vector();
    protected Hashtable deltaV = new Hashtable();
    protected Hashtable deltaVReports = new Hashtable();
    protected Hashtable deltaVActivity = new Hashtable();
    protected Hashtable activityCollection = new Hashtable();
    protected Hashtable activity = new Hashtable();

    public DeltaVResponseInterpreter() {
    }

    public DeltaVResponseInterpreter(WebDAVRequestGenerator webDAVRequestGenerator) {
        super(webDAVRequestGenerator);
    }

    public boolean handleResponse(WebDAVResponseEvent webDAVResponseEvent) throws ResponseException {
        if (GlobalData.getGlobalData().getDebugResponse()) {
            System.err.println("DeltaVResponseInterpreter::handleResponse");
        }
        res = webDAVResponseEvent.getResponse();
        Method = webDAVResponseEvent.getMethodName();
        extendedCode = webDAVResponseEvent.getExtendedCode();
        HostName = webDAVResponseEvent.getHost();
        Port = webDAVResponseEvent.getPort();
        Charset = this.getCharset();
        Resource = GlobalData.getGlobalData().unescape(webDAVResponseEvent.getResource(), "ISO-8859-1", null);
        this.Node = webDAVResponseEvent.getNode();
        try {
            if (res.getStatusCode() < 300) {
                if (Method.equals("VERSION-CONTROL")) {
                    this.parseVersionControl();
                } else if (Method.equals("CHECKOUT")) {
                    this.parseCheckout();
                } else if (Method.equals("UNCHECKOUT")) {
                    this.parseUnCheckout();
                } else if (Method.equals("CHECKIN")) {
                    this.parseCheckin();
                } else if (Method.equals("REPORT")) {
                    this.parseReport();
                } else if (Method.equals("MKACTIVITY")) {
                    this.parseMkActivity();
                } else if (Method.equals("MERGE")) {
                    this.parseMerge();
                } else {
                    super.handleResponse(webDAVResponseEvent);
                }
            } else {
                super.handleResponse(webDAVResponseEvent);
            }
        }
        catch (Exception exception) {
            String string = System.getProperty("debug", "false");
            if (string.equals("true")) {
                System.out.println(exception);
            }
            throw new ResponseException("HTTP error");
        }
        return true;
    }

    protected void parseVersionControl() {
        try {
            int n = res.getStatusCode();
            if (n >= 200 && n < 300) {
                this.fireVersionControlEvent(Resource, n);
            } else {
                this.fireVersionControlEvent(res.getReasonLine(), n);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void parseCheckout() {
        try {
            int n = res.getStatusCode();
            if (n >= 200 && n < 300) {
                this.fireCheckoutEvent(Resource, n);
            } else {
                this.fireCheckoutEvent(res.getReasonLine(), n);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void parseUnCheckout() {
        try {
            int n = res.getStatusCode();
            if (n >= 200 && n < 300) {
                this.fireUnCheckoutEvent(Resource, n);
            } else {
                this.fireUnCheckoutEvent(res.getReasonLine(), n);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void parseCheckin() {
        try {
            int n = res.getStatusCode();
            if (n >= 200 && n < 300) {
                this.fireCheckinEvent(Resource, n);
            } else {
                this.fireCheckinEvent(res.getReasonLine(), n);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void parseReport() {
        Object object;
        Object object2;
        Object object3;
        Vector vector = new Vector();
        String string = this.getResource();
        byte[] byArray = null;
        Document document = null;
        try {
            byArray = res.getData();
            stream = byArray;
            if (byArray == null) {
                GlobalData.getGlobalData().errorMsg("DeltaV Interpreter:\n\nMissing XML body in\nREPORT response.");
                return;
            }
            object3 = new ByteArrayInputStream(byArray);
            document = new Document();
            document.load((InputStream)object3);
        }
        catch (Exception exception) {
            GlobalData.getGlobalData().errorMsg("DeltaV Interpreter:\n\nError encountered \nwhile parsing REPORT Response.\n" + exception);
            stream = null;
            return;
        }
        this.printXML(byArray);
        object3 = null;
        String[] stringArray = new String[]{new String("multistatus")};
        Element element = this.skipElements(document, stringArray);
        boolean bl = false;
        if (element != null) {
            object2 = new TreeEnumeration(element);
            while (((TreeEnumeration)object2).hasMoreElements()) {
                object = (Element)((TreeEnumeration)object2).nextElement();
                Name name = object.getTagName();
                if (name == null || !name.getName().equals("response")) continue;
                object3 = this.parseResponse((Element)object, string, vector);
            }
        }
        if (extendedCode == 50) {
            object2 = HostName;
            if (Port != 0) {
                object2 = HostName + ":" + Port;
            }
            object = new VersionInfoDialog(vector, string, (String)object2);
            ((VersionInfoDialog)object).addGetVersionListener(new GetVersionListener());
            ((Dialog)object).show();
        }
    }

    protected DataNode parseResponse(Element element, String string, Vector vector) {
        return this.parseResponse(element, string, vector, null, null, null);
    }

    protected DataNode parseResponse(Element element, String string, Vector vector, DataNode dataNode, String string2, DefaultMutableTreeNode defaultMutableTreeNode) {
        Object object;
        Object object2;
        Object object3;
        if (GlobalData.getGlobalData().getDebugTreeNode()) {
            System.err.println("DeltaVResponseInterpreter::parseResponse");
        }
        Object object4 = null;
        String string3 = "";
        String string4 = "";
        Element element2 = null;
        if (element.numElements() == 0) {
            return null;
        }
        SiblingEnumeration siblingEnumeration = new SiblingEnumeration(element.getChild(0));
        while (siblingEnumeration.hasMoreElements()) {
            element2 = (Element)siblingEnumeration.nextElement();
            object3 = element2.getTagName();
            if (object3 == null) continue;
            if (((Name)object3).getName().equals("href")) {
                object2 = new TreeEnumeration(element2);
                while (((TreeEnumeration)object2).hasMoreElements()) {
                    object = (Element)((TreeEnumeration)object2).nextElement();
                    if (object == null || object.getType() != 1 && object.getType() != 6) continue;
                    string3 = this.truncateResource(GlobalData.getGlobalData().unescape(object.getText(), Charset, null));
                    string4 = this.getFullResource(GlobalData.getGlobalData().unescape(object.getText(), Charset, null));
                }
                continue;
            }
            if (!((Name)object3).getName().equals("propstat") || string3 == "") continue;
            object2 = this.parseProps(element2, string, string3);
            if (object4 == null) {
                object4 = object2;
                continue;
            }
            if (((DataNode)object2).getDisplay().length() != 0) {
                ((DataNode)object4).setDisplay(((DataNode)object2).getDisplay());
            }
            if (((DataNode)object2).isLocked() && !((DataNode)object4).isLocked()) {
                ((DataNode)object4).lock(((DataNode)object2).getLockToken());
            }
            if (((DataNode)object2).isCollection()) {
                ((DataNode)object4).makeCollection();
            }
            if (((DataNode)object2).getType().length() != 0) {
                ((DataNode)object4).setType(((DataNode)object2).getType());
            }
            if (((DataNode)object2).getSize() != 0L) {
                ((DataNode)object4).setSize(((DataNode)object2).getSize());
            }
            if (((DataNode)object2).getDate() != null) {
                ((DataNode)object4).setDate(((DataNode)object2).getDate());
            }
            if (((DeltaVDataNode)object4).getComment().length() == 0) {
                ((DeltaVDataNode)object4).setComment(((DeltaVDataNode)object2).getComment());
            }
            if (((DeltaVDataNode)object4).getCreatorDisplayName().length() == 0) {
                ((DeltaVDataNode)object4).setCreatorDisplayName(((DeltaVDataNode)object2).getCreatorDisplayName());
            }
            if (((DeltaVDataNode)object4).getSupportedMethodSet().length() == 0) {
                ((DeltaVDataNode)object4).setSupportedMethodSet(((DeltaVDataNode)object2).getSupportedMethodSet());
            }
            if (((DeltaVDataNode)object4).getSupportedLivePropertySet().length() == 0) {
                ((DeltaVDataNode)object4).setSupportedLivePropertySet(((DeltaVDataNode)object2).getSupportedLivePropertySet());
            }
            if (((DeltaVDataNode)object4).getSupportedReportSet().length() == 0) {
                ((DeltaVDataNode)object4).setSupportedReportSet(((DeltaVDataNode)object2).getSupportedReportSet());
            }
            if (((DeltaVDataNode)object4).getCheckedIn().length() == 0) {
                ((DeltaVDataNode)object4).setCheckedIn(((DeltaVDataNode)object2).getCheckedIn());
            }
            if (((DeltaVDataNode)object4).getAutoVersion().length() == 0) {
                ((DeltaVDataNode)object4).setAutoVersion(((DeltaVDataNode)object2).getAutoVersion());
            }
            if (((DeltaVDataNode)object4).getCheckedOut().length() == 0) {
                ((DeltaVDataNode)object4).setCheckedOut(((DeltaVDataNode)object2).getCheckedOut());
            }
            if (((DeltaVDataNode)object4).getPredecessorSet().length() == 0) {
                ((DeltaVDataNode)object4).setPredecessorSet(((DeltaVDataNode)object2).getPredecessorSet());
            }
            if (((DeltaVDataNode)object4).getSuccessorSet().length() == 0) {
                ((DeltaVDataNode)object4).setSuccessorSet(((DeltaVDataNode)object2).getSuccessorSet());
            }
            if (((DeltaVDataNode)object4).getCheckoutSet().length() == 0) {
                ((DeltaVDataNode)object4).setCheckoutSet(((DeltaVDataNode)object2).getCheckoutSet());
            }
            if (((DeltaVDataNode)object4).getVersionName().length() != 0) continue;
            ((DeltaVDataNode)object4).setVersionName(((DeltaVDataNode)object2).getVersionName());
        }
        object3 = GlobalData.getGlobalData().getSSL() ? "https://" + this.getHost() : "http://" + this.getHost();
        if (Port != 0) {
            object3 = (String)object3 + ":" + Integer.toString(Port);
        }
        object3 = (String)object3 + "/" + string4;
        if (object4 != null) {
            object2 = "";
            if (string.endsWith("/")) {
                object2 = string.substring(0, string.length() - 1);
            }
            if (string4.equals(string) || string4.equals(object2)) {
                int n;
                object = string3;
                if (defaultMutableTreeNode != null && (n = defaultMutableTreeNode.getPath().length) == 2) {
                    object = GlobalData.getGlobalData().getSSL() ? "https://" + this.getHost() + "/" + string : "http://" + this.getHost() + "/" + string;
                }
                dataNode = new DeltaVDataNode(((DataNode)object4).isCollection(), ((DataNode)object4).isLocked(), ((DataNode)object4).getLockToken(), (String)object, ((DataNode)object4).getDisplay(), ((DataNode)object4).getType(), ((DataNode)object4).getSize(), ((DataNode)object4).getDate(), null);
                ((DeltaVDataNode)dataNode).copyFrom((DeltaVDataNode)object4);
                ((DeltaVDataNode)dataNode).setHref((String)object3);
            } else {
                ((DeltaVDataNode)object4).setHref((String)object3);
                if (((DataNode)object4).isCollection()) {
                    if (defaultMutableTreeNode != null) {
                        object = new WebDAVTreeNode((Object)string3, string2);
                        ((WebDAVTreeNode)object).setDataNode((DataNode)object4);
                        defaultMutableTreeNode.insert((MutableTreeNode)object, 0);
                    }
                } else {
                    object = null;
                    if (vector.size() > 0) {
                        object = (DataNode)vector.get(vector.size() - 1);
                    }
                    if (object == null || !((DataNode)object).getName().equals(((DataNode)object4).getName())) {
                        vector.addElement(object4);
                    } else {
                        ((DeltaVDataNode)object).addVersion((DataNode)object4);
                    }
                }
            }
        }
        if (dataNode == null && defaultMutableTreeNode != null) {
            int n = defaultMutableTreeNode.getPath().length;
            object = string3;
            if (n == 2) {
                object = GlobalData.getGlobalData().getSSL() ? "https://" + this.getHost() + "/" + string : "http://" + this.getHost() + "/" + string;
            }
            dataNode = new DeltaVDataNode(true, false, null, (String)object, string, "httpd/unix-directory", 0L, "", null);
            ((DeltaVDataNode)dataNode).setHref((String)object3);
        }
        return dataNode;
    }

    protected DataNode parseProps(Element element, String string, String string2) {
        Object object;
        if (GlobalData.getGlobalData().getDebugTreeNode()) {
            System.err.println("DeltaVResponseInterpreter::parseProps");
        }
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        String string8 = "";
        String string9 = "";
        String string10 = "";
        String string11 = "";
        String string12 = "";
        String string13 = "";
        String string14 = "";
        String[] stringArray = new String[]{new String("prop")};
        Element element2 = this.skipElements(element, stringArray);
        if (element2 != null) {
            object = new TreeEnumeration(element2);
            while (((TreeEnumeration)object).hasMoreElements()) {
                Element element3 = (Element)((TreeEnumeration)object).nextElement();
                Name name = element3.getTagName();
                if (name == null) continue;
                if (name.getName().equals("comment")) {
                    string3 = this.getPropValue(element3);
                    continue;
                }
                if (name.getName().equals("creator-displayname")) {
                    string4 = this.getPropValue(element3);
                    continue;
                }
                if (name.getName().equals("supported-method-set")) {
                    string5 = this.getPropValue(element3);
                    continue;
                }
                if (name.getName().equals("supported-live-property-set")) {
                    string6 = this.getPropValue(element3);
                    continue;
                }
                if (name.getName().equals("supported-report-set")) {
                    string7 = this.getPropValue(element3);
                    continue;
                }
                if (name.getName().equals("checked-in")) {
                    string8 = this.getPropValue(element3);
                    continue;
                }
                if (name.getName().equals("auto-version")) {
                    string9 = this.getPropValue(element3);
                    continue;
                }
                if (name.getName().equals("checked-out")) {
                    string10 = this.getPropValue(element3);
                    continue;
                }
                if (name.getName().equals("predecessor-set")) {
                    string11 = this.getPropValue(element3);
                    continue;
                }
                if (name.getName().equals("successor-set")) {
                    string12 = this.getPropValue(element3);
                    continue;
                }
                if (name.getName().equals("checkout-set")) {
                    string13 = this.getPropValue(element3);
                    continue;
                }
                if (!name.getName().equals("version-name")) continue;
                string14 = this.getPropValue(element3);
            }
        }
        object = new DeltaVDataNode(super.parseProps(element, string, string2));
        ((DeltaVDataNode)object).setComment(string3);
        ((DeltaVDataNode)object).setCreatorDisplayName(string4);
        ((DeltaVDataNode)object).setSupportedMethodSet(string5);
        ((DeltaVDataNode)object).setSupportedLivePropertySet(string6);
        ((DeltaVDataNode)object).setSupportedReportSet(string7);
        ((DeltaVDataNode)object).setCheckedIn(string8);
        ((DeltaVDataNode)object).setAutoVersion(string9);
        ((DeltaVDataNode)object).setCheckedOut(string10);
        ((DeltaVDataNode)object).setPredecessorSet(string11);
        ((DeltaVDataNode)object).setSuccessorSet(string12);
        ((DeltaVDataNode)object).setCheckoutSet(string13);
        ((DeltaVDataNode)object).setVersionName(string14);
        return object;
    }

    protected String getHref(Element element) {
        if (GlobalData.getGlobalData().getDebugResponse()) {
            System.err.println("DeltaVResponseInterpreter::getHref");
        }
        TreeEnumeration treeEnumeration = new TreeEnumeration(element);
        while (treeEnumeration.hasMoreElements()) {
            Element element2 = (Element)treeEnumeration.nextElement();
            Name name = element2.getTagName();
            if (name == null || !name.getName().equalsIgnoreCase("href") || (element2 = (Element)treeEnumeration.nextElement()) == null || element2.getType() != 1 && element2.getType() != 6) continue;
            return element2.getText();
        }
        return "";
    }

    protected String getPropValue(Element element) {
        if (GlobalData.getGlobalData().getDebugResponse()) {
            System.err.println("DeltaVResponseInterpreter::getPropValue");
        }
        TreeEnumeration treeEnumeration = new TreeEnumeration(element);
        while (treeEnumeration.hasMoreElements()) {
            Element element2 = (Element)treeEnumeration.nextElement();
            if (element2 == null || element2.getType() != 1 && element2.getType() != 6) continue;
            return element2.getText();
        }
        return "";
    }

    public void parseOptions() {
        if (GlobalData.getGlobalData().getDebugResponse()) {
            System.err.println("DeltaVResponseInterpreter::parseOptions");
        }
        try {
            String string = res.getHeader("DAV");
            if (string == null) {
                GlobalData.getGlobalData().errorMsg("DeltaV Interpreter:\n\nThe server does not support DAV\nat Resource " + Resource + ".");
                return;
            }
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            if (string.indexOf("version-control") >= 0) {
                bl = true;
                if (string.indexOf("report") >= 0) {
                    bl2 = true;
                }
                if (string.indexOf("activity") >= 0) {
                    bl3 = true;
                }
            }
            String string2 = Port == 0 || Port == 80 ? HostName : HostName + ":" + Port;
            string2 = string2 + Resource;
            this.deltaV.put(string2, bl);
            this.deltaVReports.put(string2, bl2);
            this.deltaVActivity.put(string2, bl3);
            if (bl3) {
                byte[] byArray = null;
                byArray = res.getData();
                if (byArray == null) {
                    if (extendedCode == 1) {
                        String string3 = HostName;
                        if (Port > 0) {
                            string3 = string3 + ":" + Port;
                        }
                        if (((DeltaVRequestGenerator)generator).GenerateOptions(string3 = string3 + Resource, true)) {
                            generator.execute();
                            return;
                        }
                    }
                } else {
                    this.parseOptionsXML();
                }
            }
        }
        catch (Exception exception) {
            GlobalData.getGlobalData().errorMsg("DeltaV Interpreter:\n\nError encountered \nwhile parsing OPTIONS Response:\n" + exception);
            stream = null;
            return;
        }
        if (extendedCode == 1) {
            generator.DoPropFind(Resource, false);
        }
    }

    public void parseOptionsXML() {
        String[] stringArray;
        if (GlobalData.getGlobalData().getDebugResponse()) {
            System.err.println("DeltaVResponseInterpreter::parseOptionsActivity");
        }
        Vector vector = new Vector();
        String string = this.getResource();
        byte[] byArray = null;
        Document document = null;
        try {
            byArray = res.getData();
            stream = byArray;
            if (byArray == null) {
                GlobalData.getGlobalData().errorMsg("DeltaV Interpreter:\n\nMissing XML body in\nOPTIONS response.");
                return;
            }
            stringArray = new ByteArrayInputStream(byArray);
            document = new Document();
            document.load((InputStream)stringArray);
        }
        catch (Exception exception) {
            GlobalData.getGlobalData().errorMsg("DeltaV Interpreter:\n\nError encountered \nwhile parsing OPTIONS Response.\n" + exception);
            stream = null;
            return;
        }
        this.printXML(byArray);
        stringArray = new String[]{new String("options-response")};
        Element element = this.skipElements(document, stringArray);
        boolean bl = false;
        String string2 = null;
        if (element != null) {
            TreeEnumeration treeEnumeration = new TreeEnumeration(element);
            while (treeEnumeration.hasMoreElements()) {
                Element element2 = (Element)treeEnumeration.nextElement();
                Name name = element2.getTagName();
                if (name == null || !name.getName().equals("activity-collection-set")) continue;
                string2 = this.getHref(element2);
                String string3 = Port == 0 || Port == 80 ? HostName : HostName + ":" + Port;
                string3 = string3 + Resource;
                this.activityCollection.put(string3, string2);
            }
        }
        ((DeltaVRequestGenerator)generator).SetActivityCollection(this.activityCollection);
    }

    public void parseMkActivity() {
        try {
            int n = res.getStatusCode();
            if (n >= 200 && n < 300) {
                String string = Port == 0 || Port == 80 ? HostName : HostName + ":" + Port;
                this.activity.put(string, Resource);
                ((DeltaVRequestGenerator)generator).SetActivity(this.activity);
                this.fireMkActivityEvent(Resource, n);
            } else {
                this.fireMkActivityEvent(res.getReasonLine(), n);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void parseMerge() {
        try {
            int n = res.getStatusCode();
            if (n >= 200 && n < 300) {
                String string = Port == 0 || Port == 80 ? HostName : HostName + ":" + Port;
                this.activity.put(string, Resource);
                ((DeltaVRequestGenerator)generator).SetActivity(this.activity);
                this.fireMergeEvent(Resource, n);
            } else {
                this.fireMergeEvent(res.getReasonLine(), n);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireInsertionEvent(String string) {
        Object object;
        boolean bl = false;
        boolean bl2 = false;
        Enumeration enumeration = this.deltaV.keys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if (!Resource.startsWith((String)object)) continue;
            bl = (Boolean)this.deltaV.get(object);
            bl2 = (Boolean)this.deltaVReports.get(object);
            break;
        }
        if (!bl && !bl2) {
            super.fireInsertionEvent(string);
            return;
        }
        Object object2 = this;
        synchronized (object2) {
            object = (Vector)listeners.clone();
        }
        object2 = new ActionEvent(this, 0, string);
        for (int i = 0; i < ((Vector)object).size(); ++i) {
            InsertionListener insertionListener = (InsertionListener)((Vector)object).elementAt(i);
            insertionListener.actionPerformed((ActionEvent)object2, bl);
        }
    }

    public synchronized void addVersionControlListener(ActionListener actionListener) {
        versionControlListeners.addElement(actionListener);
    }

    public synchronized void addCheckoutListener(ActionListener actionListener) {
        checkoutListeners.addElement(actionListener);
    }

    public synchronized void addUnCheckoutListener(ActionListener actionListener) {
        unCheckoutListeners.addElement(actionListener);
    }

    public synchronized void addCheckinListener(ActionListener actionListener) {
        checkinListeners.addElement(actionListener);
    }

    public synchronized void addMkActivityListener(ActionListener actionListener) {
        mkActivityListeners.addElement(actionListener);
    }

    public synchronized void addMergeListener(ActionListener actionListener) {
        mergeListeners.addElement(actionListener);
    }

    public synchronized void removeVersionControlListener(ActionListener actionListener) {
        versionControlListeners.removeElement(actionListener);
    }

    public synchronized void removeCheckoutListener(ActionListener actionListener) {
        checkoutListeners.removeElement(actionListener);
    }

    public synchronized void removeUnCheckoutListener(ActionListener actionListener) {
        unCheckoutListeners.removeElement(actionListener);
    }

    public synchronized void removeCheckinListener(ActionListener actionListener) {
        checkinListeners.removeElement(actionListener);
    }

    public synchronized void removeMkActivityListener(ActionListener actionListener) {
        mkActivityListeners.removeElement(actionListener);
    }

    public synchronized void removeMergeListener(ActionListener actionListener) {
        mergeListeners.removeElement(actionListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireVersionControlEvent(String string, int n) {
        Vector vector;
        Object object = this;
        synchronized (object) {
            vector = (Vector)versionControlListeners.clone();
        }
        object = new ActionEvent(this, n, string);
        for (int i = 0; i < vector.size(); ++i) {
            ActionListener actionListener = (ActionListener)vector.elementAt(i);
            actionListener.actionPerformed((ActionEvent)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireCheckoutEvent(String string, int n) {
        Vector vector;
        Object object = this;
        synchronized (object) {
            vector = (Vector)checkoutListeners.clone();
        }
        object = new ActionEvent(this, n, string);
        for (int i = 0; i < vector.size(); ++i) {
            ActionListener actionListener = (ActionListener)vector.elementAt(i);
            actionListener.actionPerformed((ActionEvent)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireUnCheckoutEvent(String string, int n) {
        Vector vector;
        Object object = this;
        synchronized (object) {
            vector = (Vector)unCheckoutListeners.clone();
        }
        object = new ActionEvent(this, n, string);
        for (int i = 0; i < vector.size(); ++i) {
            ActionListener actionListener = (ActionListener)vector.elementAt(i);
            actionListener.actionPerformed((ActionEvent)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireCheckinEvent(String string, int n) {
        Vector vector;
        Object object = this;
        synchronized (object) {
            vector = (Vector)checkinListeners.clone();
        }
        object = new ActionEvent(this, n, string);
        for (int i = 0; i < vector.size(); ++i) {
            ActionListener actionListener = (ActionListener)vector.elementAt(i);
            actionListener.actionPerformed((ActionEvent)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireMkActivityEvent(String string, int n) {
        Vector vector;
        Object object = this;
        synchronized (object) {
            vector = (Vector)mkActivityListeners.clone();
        }
        object = new ActionEvent(this, n, string);
        for (int i = 0; i < vector.size(); ++i) {
            ActionListener actionListener = (ActionListener)vector.elementAt(i);
            actionListener.actionPerformed((ActionEvent)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireMergeEvent(String string, int n) {
        Vector vector;
        Object object = this;
        synchronized (object) {
            vector = (Vector)mergeListeners.clone();
        }
        object = new ActionEvent(this, n, string);
        for (int i = 0; i < vector.size(); ++i) {
            ActionListener actionListener = (ActionListener)vector.elementAt(i);
            actionListener.actionPerformed((ActionEvent)object);
        }
    }

    protected String truncateResource(String string) {
        int n;
        if (GlobalData.getGlobalData().getDebugTreeNode()) {
            System.err.println("DeltaVResponseInterpreter::truncateResource");
        }
        if ((n = string.indexOf("https://")) >= 0) {
            string = string.substring("https://".length());
        }
        if ((n = string.indexOf("http://")) >= 0) {
            string = string.substring("http://".length());
        }
        if ((n = string.indexOf("/")) >= 0) {
            string = string.substring(n);
        }
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        if ((n = string.lastIndexOf("/")) >= 0) {
            string = string.substring(n);
        }
        if (string.startsWith("/") && string.length() > 1) {
            string = string.substring(1);
        }
        if (string.length() == 0) {
            string = "/";
        }
        return string;
    }

    protected String getFullResource(String string) {
        int n;
        if (GlobalData.getGlobalData().getDebugTreeNode()) {
            System.err.println("DeltaVResponseInterpreter::getFullResource");
        }
        if ((n = string.indexOf("https://")) >= 0) {
            string = string.substring("https://".length());
        } else {
            n = string.indexOf("http://");
            if (n >= 0) {
                string = string.substring("http://".length());
            }
        }
        n = string.indexOf("/");
        if (n >= 0) {
            string = string.substring(n);
        }
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        if (string.length() == 0) {
            string = "/";
        }
        if (string.startsWith("/") && string.length() > 1) {
            string = string.substring(1);
        }
        return string;
    }

    public boolean isDeltaV(String string) {
        Enumeration enumeration = this.deltaV.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (string.indexOf(string2) < 0) continue;
            return (Boolean)this.deltaV.get(string2);
        }
        return false;
    }

    public boolean isDeltaVReports(String string) {
        Enumeration enumeration = this.deltaVReports.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (string.indexOf(string2) < 0) continue;
            return (Boolean)this.deltaVReports.get(string2);
        }
        return false;
    }

    public boolean isDeltaVActivity(String string) {
        Enumeration enumeration = this.deltaVActivity.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (string.indexOf(string2) < 0) continue;
            return (Boolean)this.deltaVActivity.get(string2);
        }
        return false;
    }

    class GetVersionListener
    implements ActionListener {
        GetVersionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getActionCommand() != null) {
                WebDAVResponseInterpreter.generator.setResource(actionEvent.getActionCommand(), null);
            }
            if (WebDAVResponseInterpreter.generator.GenerateGet(6)) {
                WebDAVResponseInterpreter.generator.execute();
            }
        }
    }
}

