/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.DAVExplorer;

import com.ms.xml.om.Element;
import edu.uci.ics.DAVExplorer.GlobalData;
import edu.uci.ics.DAVExplorer.JTreeTable;
import edu.uci.ics.DAVExplorer.Main;
import edu.uci.ics.DAVExplorer.PropAddDialog;
import edu.uci.ics.DAVExplorer.PropModel;
import edu.uci.ics.DAVExplorer.PropNode;
import edu.uci.ics.DAVExplorer.WebDAVCompletionEvent;
import edu.uci.ics.DAVExplorer.WebDAVCompletionListener;
import edu.uci.ics.DAVExplorer.WebDAVRequestGenerator;
import edu.uci.ics.DAVExplorer.WebDAVResponseInterpreter;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.TreePath;

public class PropDialog
extends JDialog
implements ActionListener,
ChangeListener,
ListSelectionListener,
WebDAVCompletionListener {
    protected JTreeTable treeTable;
    protected PropModel model;
    protected JPanel buttonPanel;
    protected JButton addButton;
    protected JButton deleteButton;
    protected JButton saveButton;
    protected JButton closeButton;
    protected boolean changeable;
    protected boolean changed = false;
    protected String resource;
    protected String locktoken;
    protected boolean waiting;

    public PropDialog(Element element, String string, String string2, String string3, boolean bl) {
        super(GlobalData.getGlobalData().getMainFrame());
        this.model = new PropModel(element);
        this.init(this.model, string, string2, null, string3, bl);
        this.pack();
        this.setSize(this.getPreferredSize());
        GlobalData.getGlobalData().center(this);
        this.show();
    }

    public PropDialog(Element element, String string, String string2, String string3, String string4, boolean bl) {
        super(GlobalData.getGlobalData().getMainFrame());
        this.model = new PropModel(element);
        this.init(this.model, string, string2, string3, string4, bl);
        this.pack();
        this.setSize(this.getPreferredSize());
        GlobalData.getGlobalData().center(this);
        this.show();
    }

    public PropDialog(PropModel propModel, String string, String string2, String string3, boolean bl) {
        super(GlobalData.getGlobalData().getMainFrame());
        this.init(propModel, string, string2, null, string3, bl);
        this.pack();
        this.setSize(this.getPreferredSize());
        GlobalData.getGlobalData().center(this);
        this.show();
    }

    public PropDialog(PropModel propModel, String string, String string2, String string3, String string4, boolean bl) {
        super(GlobalData.getGlobalData().getMainFrame());
        this.init(propModel, string, string2, string3, string4, bl);
        this.pack();
        this.setSize(this.getPreferredSize());
        GlobalData.getGlobalData().center(this);
        this.show();
    }

    protected PropDialog() {
        super(GlobalData.getGlobalData().getMainFrame());
    }

    protected void init(PropModel propModel, String string, String string2, String string3, String string4, boolean bl) {
        this.changeable = bl;
        if (string3 != null) {
            this.setTitle(string3);
        } else if (bl) {
            this.setTitle("View/Modify Properties");
        } else {
            this.setTitle("View Properties");
        }
        this.resource = string2 + string;
        this.locktoken = string4;
        JLabel jLabel = new JLabel(this.resource, 0);
        jLabel.setForeground(Color.black);
        this.getContentPane().add("North", jLabel);
        this.addButton = new JButton("Add");
        this.addButton.addActionListener(this);
        this.deleteButton = new JButton("Delete");
        this.deleteButton.addActionListener(this);
        this.deleteButton.setEnabled(false);
        this.saveButton = new JButton("Save");
        this.saveButton.addActionListener(this);
        this.closeButton = new JButton("Close");
        this.closeButton.addActionListener(this);
        this.buttonPanel = new JPanel();
        this.buttonPanel.add(this.addButton);
        this.buttonPanel.add(this.deleteButton);
        this.buttonPanel.add(this.saveButton);
        this.buttonPanel.add(this.closeButton);
        this.getRootPane().setDefaultButton(this.closeButton);
        this.closeButton.grabFocus();
        if (!bl) {
            this.addButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
        }
        this.saveButton.setEnabled(false);
        this.getContentPane().add("South", this.buttonPanel);
        this.setBackground(Color.lightGray);
        propModel.addChangeListener(this);
        this.treeTable = new JTreeTable(propModel);
        this.treeTable.getSelectionModel().addListSelectionListener(this);
        JTree jTree = this.treeTable.getTree();
        jTree.expandRow(0);
        if (jTree.getRowCount() < 5) {
            jTree.expandRow(1);
        }
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(this.treeTable);
        this.getContentPane().add("Center", jScrollPane);
        ((Main)GlobalData.getGlobalData().getMainFrame()).addWebDAVCompletionListener(this);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                PropDialog.this.cancel();
            }
        });
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.setChanged(true);
    }

    public void setChanged(boolean bl) {
        if (this.changeable) {
            this.changed = bl;
            this.saveButton.setEnabled(this.changed);
            if (!this.changed) {
                this.model.clear();
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Add")) {
            this.add();
        } else if (actionEvent.getActionCommand().equals("Delete")) {
            this.remove();
        } else if (actionEvent.getActionCommand().equals("Save")) {
            this.save();
        } else if (actionEvent.getActionCommand().equals("Close")) {
            this.cancel();
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.changeable) {
            TreePath treePath = this.treeTable.getTree().getPathForRow(this.treeTable.getSelectedRow());
            if (treePath == null) {
                this.deleteButton.setEnabled(false);
                return;
            }
            PropNode propNode = (PropNode)treePath.getLastPathComponent();
            this.deleteButton.setEnabled(this.model.isNodeRemovable(propNode));
        }
    }

    public void completion(WebDAVCompletionEvent webDAVCompletionEvent) {
        if (this.waiting && webDAVCompletionEvent.isSuccessful()) {
            this.setChanged(false);
        }
        this.waiting = false;
    }

    public void add() {
        Object object;
        boolean bl = true;
        TreePath treePath = this.treeTable.getTree().getPathForRow(this.treeTable.getSelectedRow());
        if (treePath == null) {
            bl = false;
        } else {
            object = (PropNode)treePath.getLastPathComponent();
            if (((PropNode)object).getValue().length() != 0 || ((PropNode)object).isDAVProp()) {
                bl = false;
            }
        }
        object = new PropAddDialog(this.resource, bl);
        if (!((PropAddDialog)object).isCanceled()) {
            PropNode propNode = null;
            PropNode propNode2 = new PropNode(((PropAddDialog)object).getTag(), ((PropAddDialog)object).getNamespace(), ((PropAddDialog)object).getValue(), true);
            propNode = ((PropAddDialog)object).isAddToRoot() ? (PropNode)this.model.getRoot() : (PropNode)treePath.getLastPathComponent();
            this.model.addNode(propNode, propNode2, ((PropAddDialog)object).isAddToRoot());
            this.setChanged(true);
        }
    }

    public void remove() {
        String string = "Delete Property";
        String string2 = "Do you really want to delete the selected property?";
        if (this.ConfirmationDialog(string, string2)) {
            TreePath treePath = this.treeTable.getTree().getPathForRow(this.treeTable.getSelectedRow());
            this.model.removeNode(treePath);
            this.treeTable.updateUI();
            this.setChanged(true);
        }
    }

    public void save() {
        Element element = this.model.getModified(false);
        Element element2 = this.model.getModified(true);
        WebDAVRequestGenerator webDAVRequestGenerator = WebDAVResponseInterpreter.getGenerator();
        webDAVRequestGenerator.GeneratePropPatch(this.resource, element, element2, this.locktoken);
        this.waiting = true;
        webDAVRequestGenerator.execute();
    }

    public void cancel() {
        this.setVisible(false);
        this.dispose();
    }

    protected boolean ConfirmationDialog(String string, String string2) {
        int n = JOptionPane.showConfirmDialog(GlobalData.getGlobalData().getMainFrame(), string2, string, 0);
        return n == 0;
    }
}

