/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.DAVExplorer;

import HTTPClient.ChunkedInputStream;
import HTTPClient.HttpHeaderElement;
import HTTPClient.Log;
import HTTPClient.ModuleException;
import HTTPClient.NVPair;
import HTTPClient.ParseException;
import HTTPClient.Request;
import HTTPClient.Response;
import HTTPClient.RoRequest;
import HTTPClient.TransferEncodingModule;
import HTTPClient.Util;
import java.io.IOException;
import java.util.Vector;

public class TransferEncoding
extends TransferEncodingModule {
    public int requestHandler(Request request, Response[] responseArray) throws ModuleException {
        Vector vector;
        int n;
        int n2 = super.requestHandler(request, responseArray);
        NVPair[] nVPairArray = request.getHeaders();
        for (n = 0; n < nVPairArray.length && !nVPairArray[n].getName().equalsIgnoreCase("TE"); ++n) {
        }
        if (n == nVPairArray.length) {
            return 0;
        }
        try {
            vector = Util.parseHeader(nVPairArray[n].getValue());
        }
        catch (ParseException parseException) {
            throw new ModuleException(parseException.toString());
        }
        HttpHeaderElement httpHeaderElement = Util.getElement(vector, "*");
        if (httpHeaderElement != null) {
            NVPair[] nVPairArray2 = httpHeaderElement.getParams();
            for (n = 0; n < nVPairArray2.length && !nVPairArray2[n].getName().equalsIgnoreCase("q"); ++n) {
            }
            if (n == nVPairArray2.length) {
                return n2;
            }
            if (nVPairArray2[n].getValue() == null || nVPairArray2[n].getValue().length() == 0) {
                throw new ModuleException("Invalid q value for \"*\" in TE header: ");
            }
            try {
                if ((double)Float.valueOf(nVPairArray2[n].getValue()).floatValue() > 0.0) {
                    return n2;
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new ModuleException("Invalid q value for \"*\" in TE header: " + numberFormatException.getMessage());
            }
        }
        if (vector.contains(new HttpHeaderElement("deflate"))) {
            vector.removeElement(new HttpHeaderElement("deflate"));
        }
        if (vector.contains(new HttpHeaderElement("gzip"))) {
            vector.removeElement(new HttpHeaderElement("gzip"));
        }
        if (vector.contains(new HttpHeaderElement("compress"))) {
            vector.removeElement(new HttpHeaderElement("compress"));
        }
        nVPairArray[n] = new NVPair("TE", Util.assembleHeader(vector));
        return n2;
    }

    public void responsePhase3Handler(Response response, RoRequest roRequest) throws IOException, ModuleException {
        Vector vector;
        String string = response.getHeader("Transfer-Encoding");
        if (string == null || roRequest.getMethod().equals("HEAD")) {
            return;
        }
        try {
            vector = Util.parseHeader(string);
        }
        catch (ParseException parseException) {
            throw new ModuleException(parseException.toString());
        }
        while (vector.size() > 0) {
            String string2 = ((HttpHeaderElement)vector.lastElement()).getName();
            if (string2.equalsIgnoreCase("chunked")) {
                Log.write(32, "TEM:   pushing chunked-input-stream");
                response.inp_stream = new ChunkedInputStream(response.inp_stream);
            } else if (string2.equalsIgnoreCase("identity")) {
                Log.write(32, "TEM:   ignoring 'identity' token");
            } else {
                Log.write(32, "TEM:   Unknown transfer encoding '" + string2 + "'");
                break;
            }
            vector.removeElementAt(vector.size() - 1);
        }
        if (vector.size() > 0) {
            response.setHeader("Transfer-Encoding", Util.assembleHeader(vector));
        } else {
            response.deleteHeader("Transfer-Encoding");
        }
    }
}

