/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.DAVExplorer;

import HTTPClient.HTTPConnection;
import HTTPClient.HTTPResponse;
import HTTPClient.ModuleException;
import HTTPClient.NVPair;
import HTTPClient.ProtocolNotSuppException;
import com.sun.net.ssl.SSLContext;
import com.sun.net.ssl.TrustManager;
import edu.uci.ics.DAVExplorer.GlobalData;
import edu.uci.ics.DAVExplorer.RelaxedX509TrustManager;
import edu.uci.ics.DAVExplorer.SSLTrustDialog;
import edu.uci.ics.DAVExplorer.WebDAVConnection;
import edu.uci.ics.DAVExplorer.WebDAVRequestEvent;
import edu.uci.ics.DAVExplorer.WebDAVResponseEvent;
import edu.uci.ics.DAVExplorer.WebDAVResponseListener;
import edu.uci.ics.DAVExplorer.WebDAVTreeNode;
import java.awt.Cursor;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.net.ssl.SSLSocketFactory;

public class WebDAVManager {
    public HTTPResponse Response;
    private WebDAVConnection Con;
    private String Hostname = null;
    private int Port;
    private String ProxyHostname = null;
    private int ProxyPort;
    private String MethodName;
    private String ResourceName;
    private NVPair[] Headers;
    private byte[] Body;
    private int ExtraInfo;
    private String ExtraData;
    private Vector Listeners = new Vector();
    private boolean logging = false;
    private String logFilename = null;

    public void sendRequest(WebDAVRequestEvent webDAVRequestEvent) {
        Object object;
        String string = null;
        int n = 0;
        String string2 = null;
        if (GlobalData.getGlobalData().isAppletMode()) {
            string2 = GlobalData.getGlobalData().getProxy();
        }
        if (string2 == null) {
            string2 = GlobalData.getGlobalData().ReadConfigEntry("proxy");
        }
        boolean bl = false;
        if (string2 != null && (string2.length() > 0 || string2.startsWith("http://"))) {
            if (string2.startsWith("http://")) {
                string2 = string2.substring("http://".length());
            }
            if (!((StringTokenizer)(object = new StringTokenizer(string2, "/"))).hasMoreTokens()) {
                GlobalData.getGlobalData().errorMsg("Invalid proxy name.");
                return;
            }
            string2 = ((StringTokenizer)object).nextToken();
            if (!((StringTokenizer)(object = new StringTokenizer(string2, ":"))).hasMoreTokens()) {
                GlobalData.getGlobalData().errorMsg("Invalid proxy name.");
                return;
            }
            bl = true;
            string = ((StringTokenizer)object).nextToken();
            if (((StringTokenizer)object).hasMoreTokens()) {
                try {
                    n = Integer.parseInt(((StringTokenizer)object).nextToken());
                }
                catch (Exception exception) {
                    GlobalData.getGlobalData().errorMsg("Invalid proxy port number.");
                    this.Port = 0;
                    return;
                }
            }
        }
        object = webDAVRequestEvent.getNode();
        String string3 = webDAVRequestEvent.getHost();
        int n2 = webDAVRequestEvent.getPort();
        if (string3 != null && string3.length() > 0 && !string3.equals(this.Hostname) || n2 != this.Port || string != null && string.length() > 0 && !string.equals(this.ProxyHostname) || n != this.ProxyPort) {
            try {
                if (bl) {
                    this.ProxyHostname = string;
                    this.ProxyPort = n;
                    HTTPConnection.setProxyServer(this.ProxyHostname, this.ProxyPort);
                } else {
                    HTTPConnection.setProxyServer(null, 0);
                }
                this.Hostname = string3;
                GlobalData.getGlobalData().getMainFrame().setCursor(Cursor.getPredefinedCursor(3));
                if (n2 != 0) {
                    this.Port = n2;
                    this.Con = GlobalData.getGlobalData().getSSL() ? new WebDAVConnection("https", this.Hostname, this.Port) : new WebDAVConnection(this.Hostname, this.Port);
                } else {
                    this.Port = 0;
                    this.Con = GlobalData.getGlobalData().getSSL() ? new WebDAVConnection("https", this.Hostname, 443) : new WebDAVConnection(this.Hostname);
                }
                this.Con.setLogging(this.logging, this.logFilename);
                GlobalData.getGlobalData().getMainFrame().setCursor(Cursor.getDefaultCursor());
            }
            catch (ProtocolNotSuppException protocolNotSuppException) {
                GlobalData.getGlobalData().getMainFrame().setCursor(Cursor.getDefaultCursor());
                GlobalData.getGlobalData().errorMsg("Error: Protocol not supported.\n" + protocolNotSuppException.toString());
            }
        }
        if (this.Con == null) {
            return;
        }
        String string4 = webDAVRequestEvent.getUser();
        String string5 = webDAVRequestEvent.getPass();
        if (string4.length() > 0) {
            try {
                this.Con.addDigestAuthorization(this.Hostname, string4, string5);
                this.Con.addBasicAuthorization(this.Hostname, string4, string5);
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
        }
        this.MethodName = webDAVRequestEvent.getMethod();
        this.ResourceName = webDAVRequestEvent.getResource();
        this.Headers = webDAVRequestEvent.getHeaders();
        this.Body = webDAVRequestEvent.getBody();
        this.ExtraInfo = webDAVRequestEvent.getExtraInfo();
        this.ExtraData = webDAVRequestEvent.getExtraData();
        try {
            this.Response = webDAVRequestEvent.getMethod().equals("PUT") ? this.Con.Put(this.ResourceName, this.ExtraData, this.Headers) : this.Con.Generic(this.MethodName, this.ResourceName, this.Body, this.Headers);
            WebDAVResponseEvent webDAVResponseEvent = this.GenerateWebDAVResponse(this.Response, (WebDAVTreeNode)object);
            this.fireResponse(webDAVResponseEvent);
        }
        catch (IOException iOException) {
            Object var12_17 = null;
            try {
                Class<?> clazz = Class.forName("javax.net.ssl.SSLPeerUnverifiedException");
                if (iOException.getClass().equals(clazz)) {
                    SSLTrustDialog sSLTrustDialog = new SSLTrustDialog();
                    if (sSLTrustDialog.getTrust(this.Hostname)) {
                        TrustManager[] trustManagerArray = new TrustManager[]{new RelaxedX509TrustManager()};
                        SSLContext sSLContext = SSLContext.getInstance((String)"SSL");
                        sSLContext.init(null, trustManagerArray, new SecureRandom());
                        SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
                        this.Con.setSSLSocketFactory(sSLSocketFactory);
                        this.Con.setAllowAnyHostname(true);
                        try {
                            this.Response = this.Con.Generic(this.MethodName, this.ResourceName, this.Body, this.Headers);
                            WebDAVResponseEvent webDAVResponseEvent = this.GenerateWebDAVResponse(this.Response, (WebDAVTreeNode)object);
                            this.fireResponse(webDAVResponseEvent);
                        }
                        catch (IOException iOException2) {
                            GlobalData.getGlobalData().errorMsg("Connection error: \n" + iOException);
                        }
                    }
                }
                GlobalData.getGlobalData().errorMsg("Connection error: \n" + iOException);
            }
            catch (Throwable throwable) {
                GlobalData.getGlobalData().errorMsg("Connection error: \n" + iOException);
            }
        }
        catch (ModuleException moduleException) {
            GlobalData.getGlobalData().errorMsg("HTTPClient error: \n" + moduleException);
        }
    }

    public synchronized void addResponseListener(WebDAVResponseListener webDAVResponseListener) {
        this.Listeners.addElement(webDAVResponseListener);
    }

    public synchronized void removeResponseListener(WebDAVResponseListener webDAVResponseListener) {
        this.Listeners.removeElement(webDAVResponseListener);
    }

    public WebDAVResponseEvent GenerateWebDAVResponse(HTTPResponse hTTPResponse, WebDAVTreeNode webDAVTreeNode) {
        WebDAVResponseEvent webDAVResponseEvent = new WebDAVResponseEvent(this, this.Hostname, this.Port, this.ResourceName, this.MethodName, hTTPResponse, this.ExtraInfo, this.ExtraData, webDAVTreeNode);
        return webDAVResponseEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireResponse(WebDAVResponseEvent webDAVResponseEvent) {
        Vector vector;
        WebDAVManager webDAVManager = this;
        synchronized (webDAVManager) {
            vector = (Vector)this.Listeners.clone();
        }
        for (int i = 0; i < vector.size(); ++i) {
            WebDAVResponseListener webDAVResponseListener = (WebDAVResponseListener)vector.elementAt(i);
            webDAVResponseListener.responseFormed(webDAVResponseEvent);
        }
    }

    public void setLogging(boolean bl, String string) {
        this.logging = bl;
        this.logFilename = string;
        if (this.Con != null) {
            this.Con.setLogging(bl, string);
        }
    }

    protected WebDAVConnection createProxyConnection(String string, int n) {
        if (n != 0) {
            return new WebDAVConnection(string, n);
        }
        return new WebDAVConnection(string);
    }
}

