/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.DAVExplorer;

import edu.uci.ics.DAVExplorer.GlobalData;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToolBar;

public class WebDAVToolBar
extends JPanel
implements ActionListener {
    private JToolBar toolbar;
    private Vector toolbarListener;

    public WebDAVToolBar() {
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setLayout(new BorderLayout());
        this.toolbar = new JToolBar();
        this.add(this.createToolbar());
        this.toolbarListener = new Vector();
    }

    private void addTool(JToolBar jToolBar, String string, String string2, int n) {
        this.addTool(jToolBar, string, string, string2, n);
    }

    private void addTool(JToolBar jToolBar, String string, String string2, String string3, int n) {
        WebDAVTBButton webDAVTBButton = new WebDAVTBButton(GlobalData.getGlobalData().getImageIcon(string2 + ".gif", string), n);
        webDAVTBButton.setActionCommand(string3);
        webDAVTBButton.addActionListener(this);
        webDAVTBButton.setToolTipText(string3);
        webDAVTBButton.setMargin(new Insets(1, 1, 1, 1));
        jToolBar.add(webDAVTBButton);
    }

    private Component createToolbar() {
        this.addTool(this.toolbar, "open", "Get File", 0);
        this.addTool(this.toolbar, "save", "Write File", 1);
        this.addTool(this.toolbar, "copy", "Copy", 5);
        this.addTool(this.toolbar, "delete", "Delete", 7);
        this.toolbar.addSeparator();
        this.addTool(this.toolbar, "exclusiveLock", "lock", "Exclusive Lock", 2);
        this.addTool(this.toolbar, "unlock", "Unlock", 4);
        this.addTool(this.toolbar, "propfind", "View/Modify Properties", 15);
        this.toolbar.addSeparator();
        this.addTool(this.toolbar, "versioning", "Put Under Version Control", 100);
        this.addTool(this.toolbar, "checkout", "Check Out", 102);
        this.addTool(this.toolbar, "uncheckout", "Uncheckout", 103);
        this.addTool(this.toolbar, "checkin", "Check In", 104);
        this.addTool(this.toolbar, "versions", "Version Report", 101);
        return this.toolbar;
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.toolbarListener.addElement(actionListener);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.toolbarListener.removeElement(actionListener);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.notifyListener(actionEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyListener(ActionEvent actionEvent) {
        Vector vector;
        WebDAVTBButton webDAVTBButton = (WebDAVTBButton)actionEvent.getSource();
        ActionEvent actionEvent2 = new ActionEvent(this, webDAVTBButton.getId(), actionEvent.getActionCommand());
        WebDAVToolBar webDAVToolBar = this;
        synchronized (webDAVToolBar) {
            vector = (Vector)this.toolbarListener.clone();
        }
        for (int i = 0; i < vector.size(); ++i) {
            ActionListener actionListener = (ActionListener)vector.elementAt(i);
            actionListener.actionPerformed(actionEvent2);
        }
    }

    class WebDAVTBButton
    extends JButton {
        private int id;

        public WebDAVTBButton(Icon icon, int n) {
            super(icon);
            this.id = n;
        }

        public int getId() {
            return this.id;
        }
    }
}

