/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.DAVExplorer;

import com.ms.xml.om.Document;
import com.ms.xml.om.Element;
import com.ms.xml.om.TreeEnumeration;
import com.ms.xml.util.Name;
import edu.uci.ics.DAVExplorer.DataNode;
import edu.uci.ics.DAVExplorer.DeltaVDataNode;
import edu.uci.ics.DAVExplorer.DeltaVRequestGenerator;
import edu.uci.ics.DAVExplorer.DeltaVResponseInterpreter;
import edu.uci.ics.DAVExplorer.GlobalData;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.text.DateFormat;
import java.util.Date;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;

public class WebDAVTreeNode
extends DefaultMutableTreeNode {
    protected static DeltaVRequestGenerator generator = new DeltaVRequestGenerator();
    protected static DeltaVResponseInterpreter interpreter = new DeltaVResponseInterpreter();
    protected boolean hasLoaded = false;
    protected static final String WebDAVRoot = "DAV Explorer";
    protected DataNode dataNode;
    private String userAgent;
    protected boolean childrenLoaded = false;
    protected boolean localLoad = false;

    public static void reset() {
        generator = new DeltaVRequestGenerator();
        interpreter = new DeltaVResponseInterpreter();
    }

    public WebDAVTreeNode(Object object, String string) {
        super(object);
        this.userAgent = string;
        generator.setUserAgent(string);
        this.hasLoaded = true;
    }

    public WebDAVTreeNode(Object object, boolean bl, String string) {
        super(object);
        this.userAgent = string;
        generator.setUserAgent(string);
        this.hasLoaded = true;
        this.childrenLoaded = true;
        this.dataNode = new DataNode(true, false, null, object.toString(), "DAV Root Node", "", 0L, "", null);
    }

    public void setUserAgent(String string) {
        this.userAgent = string;
        generator.setUserAgent(this.userAgent);
    }

    public DataNode getDataNode() {
        return this.dataNode;
    }

    public void setDataNode(DataNode dataNode) {
        this.dataNode = dataNode;
    }

    public boolean isLeaf() {
        return false;
    }

    public boolean hasLoadedChildren() {
        return this.childrenLoaded;
    }

    public void setHasLoadedChildren(boolean bl) {
        this.childrenLoaded = bl;
    }

    public void removeChildren() {
        if (GlobalData.getGlobalData().getDebugTreeNode()) {
            System.err.println("WebDAVTreeNode::removeChildren");
        }
        int n = super.getChildCount();
        for (int i = 0; i < n; ++i) {
            this.remove(0);
        }
        this.dataNode = null;
    }

    public int getChildCount() {
        return super.getChildCount();
    }

    protected void loadRemote(byte[] byArray) {
        String[] stringArray;
        if (GlobalData.getGlobalData().getDebugTreeNode()) {
            System.err.println("WebDAVTreeNode::loadRemote");
        }
        Vector vector = new Vector();
        Document document = null;
        Object var4_4 = null;
        Object var5_5 = null;
        boolean bl = false;
        String string = interpreter.getResource();
        if (string.startsWith("/") && string.length() > 1) {
            string = string.substring(1);
        }
        try {
            stringArray = new ByteArrayInputStream(byArray);
            document = new Document();
            document.load((InputStream)stringArray);
        }
        catch (Exception exception) {
            System.out.println("Exception: loadRemote: " + exception);
            interpreter.clearStream();
            return;
        }
        this.dataNode = null;
        stringArray = new String[]{new String("multistatus")};
        Element element = interpreter.skipElements(document, stringArray);
        if (element != null) {
            TreeEnumeration treeEnumeration = new TreeEnumeration(element);
            while (treeEnumeration.hasMoreElements()) {
                Element element2 = (Element)treeEnumeration.nextElement();
                Name name = element2.getTagName();
                if (name == null || !name.getName().equals("response")) continue;
                this.dataNode = interpreter.parseResponse(element2, string, vector, this.dataNode, this.userAgent, this);
            }
        } else {
            this.dataNode = null;
            this.hasLoaded = false;
        }
        interpreter.clearStream();
        interpreter.ResetRefresh();
        if (this.dataNode != null) {
            this.dataNode.setSubNodes(vector);
            this.hasLoaded = true;
        }
    }

    protected void loadLocal(String string, Object[] objectArray) {
        Object object;
        Vector<DataNode> vector;
        if (GlobalData.getGlobalData().getDebugTreeNode()) {
            System.err.println("WebDAVTreeNode::loadLocal");
        }
        String string2 = string;
        for (int i = 2; i < objectArray.length; ++i) {
            if (!string2.endsWith(String.valueOf(File.separatorChar))) {
                string2 = string2 + File.separator;
            }
            string2 = string2 + objectArray[i];
        }
        string = objectArray[objectArray.length - 1].toString();
        File file = new File(string2);
        if (file != null && file.exists() && file.isDirectory()) {
            vector = new Vector<DataNode>();
            try {
                object = file.list();
                int n = ((String[])object).length;
                for (int i = 0; i < n; ++i) {
                    String string3 = string2;
                    if (!string2.endsWith(String.valueOf(File.separatorChar))) {
                        string3 = string3 + File.separatorChar;
                    }
                    string3 = string3 + object[i];
                    File file2 = new File(string3);
                    boolean bl = file2.isDirectory();
                    Date date = new Date(file2.lastModified());
                    DataNode dataNode = new DataNode(bl, false, null, object[i], "Local File", "", file2.length(), DateFormat.getDateTimeInstance().format(date), null);
                    if (bl) {
                        WebDAVTreeNode webDAVTreeNode = new WebDAVTreeNode((Object)dataNode.getName(), this.userAgent);
                        webDAVTreeNode.setDataNode(dataNode);
                        this.insert(webDAVTreeNode, 0);
                        continue;
                    }
                    vector.addElement(dataNode);
                }
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
        } else {
            this.hasLoaded = false;
            this.dataNode = null;
            return;
        }
        object = new Date(file.lastModified());
        this.dataNode = new DataNode(true, false, null, string, "Local File", "", file.length(), DateFormat.getDateTimeInstance().format((Date)object), vector);
        this.hasLoaded = true;
    }

    public void finishLoadChildren() {
        byte[] byArray = interpreter.getXML();
        if (byArray != null) {
            this.loadRemote(byArray);
        }
        interpreter.ResetRefresh();
        this.childrenLoaded = true;
    }

    public void loadChildren(boolean bl) {
        Object[] objectArray;
        if (GlobalData.getGlobalData().getDebugTreeNode()) {
            System.err.println("WebDAVTreeNode::loadChildren");
        }
        if ((objectArray = this.getPath()) == null || objectArray.length <= 1) {
            return;
        }
        String string = objectArray[1].toString();
        if (string.startsWith("http://") || string.startsWith("https://")) {
            this.localLoad = false;
            byte[] byArray = interpreter.getXML();
            if (byArray == null) {
                this.hasLoaded = false;
                this.dataNode = null;
                interpreter.ResetRefresh();
                if (bl) {
                    generator.setExtendedInfo(2, null);
                } else {
                    generator.setExtendedInfo(3, null);
                }
                String string2 = string;
                for (int i = 2; i < objectArray.length; ++i) {
                    string2 = string2 + "/" + objectArray[i].toString();
                }
                string2 = string2 + "/";
                generator.setResource(string2, null);
                String string3 = System.getProperty("propfind");
                if (string3 != null && string3.equalsIgnoreCase("allprop")) {
                    if (generator.GeneratePropFindForNode(string2, "allprop", "one", null, null, true, this)) {
                        generator.execute();
                    }
                } else {
                    String[] stringArray = new String[]{"displayname", "resourcetype", "getcontenttype", "getcontentlength", "getlastmodified", "lockdiscovery", "checked-in", "checked-out", "version-name"};
                    if (generator.GeneratePropFindForNode(string2, "prop", "one", stringArray, null, true, this)) {
                        generator.execute();
                    }
                }
                return;
            }
            interpreter.clearStream();
            this.hasLoaded = false;
            this.dataNode = null;
            interpreter.ResetRefresh();
            generator.setExtendedInfo(3, null);
            String string4 = string;
            for (int i = 2; i < objectArray.length; ++i) {
                string4 = string4 + "/" + objectArray[i].toString();
            }
            string4 = string4 + "/";
            String string5 = System.getProperty("propfind");
            if (string5 != null) {
                if (string5.equalsIgnoreCase("allprop")) {
                    if (generator.GeneratePropFindForNode(string4, "allprop", "one", null, null, true, this)) {
                        generator.execute();
                    }
                } else {
                    String[] stringArray = new String[]{"displayname", "resourcetype", "getcontenttype", "getcontentlength", "getlastmodified", "lockdiscovery", "checked-in", "checked-out", "version-name"};
                    if (generator.GeneratePropFindForNode(string4, "prop", "one", stringArray, null, true, this)) {
                        generator.execute();
                    }
                }
            }
        } else {
            this.localLoad = true;
            this.loadLocal(string, objectArray);
        }
    }

    public boolean isLocalLoad() {
        return this.localLoad;
    }

    public boolean isDeltaV() {
        return this.getDeltaV();
    }

    public boolean getDeltaV() {
        if (!(this.dataNode instanceof DeltaVDataNode)) {
            return false;
        }
        return ((DeltaVDataNode)this.dataNode).getDeltaV();
    }

    public void setDeltaV(boolean bl) {
        if (!(this.dataNode instanceof DeltaVDataNode)) {
            return;
        }
        ((DeltaVDataNode)this.dataNode).setDeltaV(bl);
    }

    public boolean getDeltaVReports() {
        if (!(this.dataNode instanceof DeltaVDataNode)) {
            return false;
        }
        return ((DeltaVDataNode)this.dataNode).getDeltaVReports();
    }

    public void setDeltaVReports(boolean bl) {
        if (!(this.dataNode instanceof DeltaVDataNode)) {
            return;
        }
        ((DeltaVDataNode)this.dataNode).setDeltaVReports(bl);
    }
}

