/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.DAVExplorer;

import edu.uci.ics.DAVExplorer.CopyResponseEvent;
import edu.uci.ics.DAVExplorer.CopyResponseListener;
import edu.uci.ics.DAVExplorer.DataNode;
import edu.uci.ics.DAVExplorer.DeltaVDataNode;
import edu.uci.ics.DAVExplorer.GlobalData;
import edu.uci.ics.DAVExplorer.PutEvent;
import edu.uci.ics.DAVExplorer.PutListener;
import edu.uci.ics.DAVExplorer.URIBox;
import edu.uci.ics.DAVExplorer.ViewSelectionEvent;
import edu.uci.ics.DAVExplorer.ViewSelectionListener;
import edu.uci.ics.DAVExplorer.WebDAVTreeNode;
import java.awt.Cursor;
import java.awt.Dimension;
import java.io.File;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class WebDAVTreeView
implements ViewSelectionListener,
CopyResponseListener,
PutListener {
    JTree tree;
    static final String WebDAVRoot = "DAV Explorer";
    DefaultMutableTreeNode root = new WebDAVTreeNode("DAV Explorer", true, "");
    DefaultTreeModel treeModel = new DefaultTreeModel(this.root);
    DefaultMutableTreeNode currNode = this.root;
    Vector rootElements = new Vector();
    TreePath currPath;
    TreeSelectionModel selectionModel = new DefaultTreeSelectionModel();
    Vector selListeners = new Vector();
    public String homeDirName;
    private String startDirName = null;
    private String userAgent;
    JScrollPane sp;
    SelectionChangeListener treeSelectionListener = new SelectionChangeListener();
    treeExpansionListener treeExpListener = new treeExpansionListener();

    public WebDAVTreeView() {
        GlobalData.methodEnter("Constructor", "WebDAVTreeView", GlobalData.getGlobalData().getDebugTreeView());
        GlobalData.getGlobalData().setTree(this);
        this.tree = new JTree(this.treeModel);
        this.tree.putClientProperty("JTree.lineStyle", "Angled");
        this.tree.setSelectionModel(this.selectionModel);
        this.selectionModel.setSelectionMode(1);
        this.tree.addTreeSelectionListener(this.treeSelectionListener);
        this.tree.setRowHeight(-1);
        this.sp = new JScrollPane(this.tree);
        this.sp.setPreferredSize(new Dimension(240, 400));
        String string = System.getProperty("local", "yes");
        if (!string.equalsIgnoreCase("no")) {
            String string2 = System.getProperty("os.name").toLowerCase();
            if (string2.indexOf("windows") == -1) {
                this.startDirName = System.getProperty("user.home");
            } else {
                this.startDirName = System.getProperty("user.home");
                int n = this.startDirName.indexOf(new Character(File.separatorChar).toString());
                if (n > -1) {
                    this.startDirName = this.startDirName.substring(0, n + 1) + File.separatorChar;
                }
            }
            if (this.startDirName == null) {
                this.startDirName = new Character(File.separatorChar).toString();
            }
        }
        this.tree.addTreeExpansionListener(this.treeExpListener);
        this.treeModel.addTreeModelListener(new TreeModelListener(){

            public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            }

            public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            }

            public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            }

            public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            }
        });
    }

    public DefaultMutableTreeNode getRoot() {
        GlobalData.methodEnter("getRoot", "WebDAVTreeView", GlobalData.getGlobalData().getDebugTreeView());
        return this.root;
    }

    public void setUserAgent(String string) {
        GlobalData.methodEnter("setUserAgent", "WebDAVTreeView", GlobalData.getGlobalData().getDebugTreeView());
        this.userAgent = string;
        ((WebDAVTreeNode)this.root).setUserAgent(this.userAgent);
    }

    public void PutEventResponse(PutEvent putEvent) {
        GlobalData.methodEnter("PutEventResponse", "WebDAVTreeView", GlobalData.getGlobalData().getDebugTreeView());
        WebDAVTreeNode webDAVTreeNode = putEvent.getNode();
        TreeNode[] treeNodeArray = webDAVTreeNode.getPath();
        this.tree.removeTreeExpansionListener(this.treeExpListener);
        this.tree.removeTreeSelectionListener(this.treeSelectionListener);
        webDAVTreeNode.removeChildren();
        webDAVTreeNode.loadChildren(false);
        this.tree.addTreeExpansionListener(this.treeExpListener);
        this.tree.addTreeSelectionListener(this.treeSelectionListener);
    }

    public synchronized void CopyEventResponse(CopyResponseEvent copyResponseEvent) {
        GlobalData.methodEnter("CopyEventResponse", "WebDAVTreeView", GlobalData.getGlobalData().getDebugTreeView());
        WebDAVTreeNode webDAVTreeNode = copyResponseEvent.getNode();
        if (webDAVTreeNode == null) {
            return;
        }
        TreeNode[] treeNodeArray = webDAVTreeNode.getPath();
        webDAVTreeNode.removeAllChildren();
        webDAVTreeNode.loadChildren(true);
    }

    public JScrollPane getScrollPane() {
        GlobalData.methodEnter("getScrollPane", "WebDAVTreeView", GlobalData.getGlobalData().getDebugTreeView());
        return this.sp;
    }

    public void selectionChanged(ViewSelectionEvent viewSelectionEvent) {
        GlobalData.methodEnter("selectionChanged", "WebDAVTreeView", GlobalData.getGlobalData().getDebugTreeView());
        this.tableSelectionChanged(viewSelectionEvent);
    }

    protected void tableSelectionChanged(ViewSelectionEvent viewSelectionEvent) {
        Object object;
        GlobalData.methodEnter("tableSelectionChanged", "WebDAVTreeView", GlobalData.getGlobalData().getDebugTreeView());
        WebDAVTreeNode webDAVTreeNode = (WebDAVTreeNode)viewSelectionEvent.getNode();
        TreePath treePath = viewSelectionEvent.getPath();
        this.tree.removeTreeExpansionListener(this.treeExpListener);
        this.tree.removeTreeSelectionListener(this.treeSelectionListener);
        if (!webDAVTreeNode.hasLoadedChildren()) {
            object = treePath.getPathComponent(1);
            String string = object.toString();
            if (string.startsWith("http://") || string.startsWith("https://")) {
                this.tree.addTreeExpansionListener(this.treeExpListener);
                this.tree.addTreeSelectionListener(this.treeSelectionListener);
                webDAVTreeNode.loadChildren(true);
                return;
            }
            webDAVTreeNode.loadChildren(true);
        }
        GlobalData.getGlobalData().setCursor(Cursor.getPredefinedCursor(3));
        if (!this.tree.isExpanded(treePath)) {
            this.tree.expandPath(treePath);
        }
        this.tree.setSelectionPath(treePath);
        this.tree.makeVisible(treePath);
        this.tree.scrollPathToVisible(treePath);
        this.tree.treeDidChange();
        object = new ViewSelectionEvent(this, webDAVTreeNode, treePath);
        for (int i = 0; i < this.selListeners.size(); ++i) {
            ViewSelectionListener viewSelectionListener = (ViewSelectionListener)this.selListeners.elementAt(i);
            viewSelectionListener.selectionChanged((ViewSelectionEvent)object);
        }
        this.currPath = treePath;
        GlobalData.getGlobalData().resetCursor();
        this.tree.addTreeExpansionListener(this.treeExpListener);
        this.tree.addTreeSelectionListener(this.treeSelectionListener);
    }

    public void refresh() {
        GlobalData.methodEnter("refresh", "WebDAVTreeView", GlobalData.getGlobalData().getDebugTreeView());
        int n = this.tree.getRowForPath(this.currPath);
        this.tree.clearSelection();
        this.tree.setSelectionRow(n);
    }

    public synchronized void addViewSelectionListener(ViewSelectionListener viewSelectionListener) {
        GlobalData.methodEnter("addViewSelectionListener", "WebDAVTreeView", GlobalData.getGlobalData().getDebugTreeView());
        this.selListeners.addElement(viewSelectionListener);
    }

    public synchronized void removeViewSelectionListener(ViewSelectionListener viewSelectionListener) {
        GlobalData.methodEnter("removeViewSelectionListener", "WebDAVTreeView", GlobalData.getGlobalData().getDebugTreeView());
        this.selListeners.removeElement(viewSelectionListener);
    }

    public void setSelectedNode(WebDAVTreeNode webDAVTreeNode) {
        GlobalData.methodEnter("setSelectedNode", "WebDAVTreeView", GlobalData.getGlobalData().getDebugTreeView());
        TreePath treePath = new TreePath(webDAVTreeNode.getPath());
        this.tree.removeTreeExpansionListener(this.treeExpListener);
        this.tree.removeTreeSelectionListener(this.treeSelectionListener);
        if (!this.tree.isExpanded(treePath)) {
            this.tree.expandPath(treePath);
        }
        this.treeModel.nodeStructureChanged(webDAVTreeNode);
        this.tree.setSelectionPath(treePath);
        this.tree.makeVisible(treePath);
        this.tree.scrollPathToVisible(treePath);
        this.tree.addTreeExpansionListener(this.treeExpListener);
        this.tree.addTreeSelectionListener(this.treeSelectionListener);
        ViewSelectionEvent viewSelectionEvent = new ViewSelectionEvent(this, webDAVTreeNode, treePath);
        for (int i = 0; i < this.selListeners.size(); ++i) {
            ViewSelectionListener viewSelectionListener = (ViewSelectionListener)this.selListeners.elementAt(i);
            viewSelectionListener.selectionChanged(viewSelectionEvent);
        }
    }

    public void initTree() {
        GlobalData.methodEnter("initTree", "WebDAVTreeView", GlobalData.getGlobalData().getDebugTreeView());
        if (this.startDirName != null && GlobalData.getGlobalData().doAddStartDir()) {
            this.addRowToRoot(this.startDirName, true, false);
        }
        if (GlobalData.getGlobalData().isAppletMode()) {
            String[][] stringArray = GlobalData.getGlobalData().getInitialSites();
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray2 = stringArray[i];
                if (stringArray2.length == 0) continue;
                String string = stringArray[i][0];
                if (string.startsWith("https://")) {
                    string = string.substring("https://".length());
                }
                if (string.startsWith("http://")) {
                    string = string.substring("http://".length());
                }
                URIBox uRIBox = GlobalData.getGlobalData().getURIBox();
                uRIBox.setText(string);
                uRIBox.notifyListener();
            }
        }
    }

    public String constructPath(TreePath treePath) {
        GlobalData.methodEnter("constructPath", "WebDAVTreeView", GlobalData.getGlobalData().getDebugTreeView());
        String string = "";
        if (treePath == null) {
            return string;
        }
        Object[] objectArray = treePath.getPath();
        if (objectArray.length == 1) {
            return string;
        }
        String string2 = objectArray[1].toString();
        if (!string2.startsWith("http://") && !string2.startsWith("https://")) {
            if ((string = string + this.startDirName).endsWith(new Character(File.separatorChar).toString())) {
                string = string.substring(0, string.length() - 1);
            }
            for (int i = 2; i < objectArray.length; ++i) {
                string = string + File.separator + objectArray[i].toString();
            }
            if (!string.endsWith(new Character(File.separatorChar).toString())) {
                string = string + new Character(File.separatorChar).toString();
            }
        } else {
            for (int i = 1; i < objectArray.length; ++i) {
                if ((string = string + objectArray[i].toString()).endsWith("/")) continue;
                string = string + "/";
            }
            if (!string.endsWith("/")) {
                string = string + "/";
            }
        }
        return string;
    }

    public boolean addRowToRoot(String string, boolean bl, boolean bl2) {
        Serializable serializable;
        GlobalData.methodEnter("addRowToRoot", "WebDAVTreeView", GlobalData.getGlobalData().getDebugTreeView());
        String string2 = "";
        if (string == null || string.equals("")) {
            return false;
        }
        if (bl) {
            if (string.endsWith(new Character(File.separatorChar).toString())) {
                string = string.substring(0, string.length() - 1);
            }
            if (string.length() == 0) {
                string = new Character(File.separatorChar).toString();
            }
            string2 = string;
            serializable = null;
            serializable = new File(string2);
            if (serializable == null) {
                return false;
            }
            if (!((File)serializable).isDirectory()) {
                GlobalData.getGlobalData().errorMsg("TreeView Error:\n\nFile is not a directory.");
                return false;
            }
        } else {
            if (string.endsWith("/")) {
                string = string.substring(0, string.length() - 1);
            }
            string2 = GlobalData.getGlobalData().getSSL() && !string.startsWith("https://") ? "https://" + string : (!string.startsWith("http://") ? "http://" + string : string);
        }
        if (this.rootElements.contains(string2)) {
            if (!GlobalData.getGlobalData().isAppletMode()) {
                GlobalData.getGlobalData().errorMsg("TreeView Error:\n\nNode already exists!");
            }
            return false;
        }
        this.rootElements.addElement(string2);
        serializable = new WebDAVTreeNode((Object)string2, this.userAgent);
        this.treeModel.insertNodeInto((MutableTreeNode)((Object)serializable), this.root, 0);
        if (bl) {
            this.tree.clearSelection();
            this.tree.setSelectionRow(1);
            this.tree.expandPath(this.tree.getPathForRow(0));
        } else {
            ((WebDAVTreeNode)serializable).finishLoadChildren();
            ((WebDAVTreeNode)serializable).setHasLoadedChildren(true);
            this.treeModel.nodeStructureChanged((TreeNode)((Object)serializable));
            this.tree.setSelectionRow(1);
            ((WebDAVTreeNode)serializable).setDeltaV(bl2);
        }
        return true;
    }

    public String getCurrentPath() {
        GlobalData.methodEnter("getCurrentPath", "WebDAVTreeView", GlobalData.getGlobalData().getDebugTreeView());
        return this.constructPath(this.currPath);
    }

    public void addTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        GlobalData.methodEnter("addTreeSelectionListener", "WebDAVTreeView", GlobalData.getGlobalData().getDebugTreeView());
        this.tree.addTreeSelectionListener(treeSelectionListener);
    }

    public String getLockToken(String string) {
        GlobalData.methodEnter("getLockToken", "WebDAVTreeView", GlobalData.getGlobalData().getDebugTreeView());
        if (this.currPath == null) {
            return null;
        }
        this.currNode = (WebDAVTreeNode)this.currPath.getLastPathComponent();
        DataNode dataNode = ((WebDAVTreeNode)this.currNode).getDataNode();
        return this.getLockToken(dataNode, string);
    }

    public void setLock(String string, String string2) {
        GlobalData.methodEnter("setLock", "WebDAVTreeView", GlobalData.getGlobalData().getDebugTreeView());
        this.currNode = (WebDAVTreeNode)this.currPath.getLastPathComponent();
        DataNode dataNode = ((WebDAVTreeNode)this.currNode).getDataNode();
        dataNode = this.getCurrentDataNode(dataNode, string);
        if (dataNode != null) {
            dataNode.lock(string2);
        }
    }

    public void resetLock(String string) {
        GlobalData.methodEnter("resetLock", "WebDAVTreeView", GlobalData.getGlobalData().getDebugTreeView());
        this.currNode = (WebDAVTreeNode)this.currPath.getLastPathComponent();
        DataNode dataNode = ((WebDAVTreeNode)this.currNode).getDataNode();
        dataNode = this.getCurrentDataNode(dataNode, string);
        if (dataNode != null) {
            dataNode.unlock();
        }
    }

    public boolean isCollection(String string) {
        GlobalData.methodEnter("isCollection", "WebDAVTreeView", GlobalData.getGlobalData().getDebugTreeView());
        int n = this.isRemote(string) ? string.lastIndexOf("/") : string.lastIndexOf(String.valueOf(File.separatorChar));
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        this.currNode = (WebDAVTreeNode)this.currPath.getLastPathComponent();
        DataNode dataNode = ((WebDAVTreeNode)this.currNode).getDataNode();
        if ((dataNode = this.getCurrentDataNode(dataNode, string)) != null && dataNode.isCollection()) {
            return true;
        }
        Enumeration<TreeNode> enumeration = ((WebDAVTreeNode)this.currNode).children();
        while (enumeration.hasMoreElements()) {
            WebDAVTreeNode webDAVTreeNode = (WebDAVTreeNode)enumeration.nextElement();
            dataNode = webDAVTreeNode.getDataNode();
            if ((dataNode = this.getCurrentDataNode(dataNode, string)) == null || !dataNode.isCollection()) continue;
            return true;
        }
        return false;
    }

    public boolean isRemote(String string) {
        GlobalData.methodEnter("isRemote", "WebDAVTreeView", GlobalData.getGlobalData().getDebugTreeView());
        return string.startsWith("http://") || string.startsWith("https://");
    }

    public boolean isDeltaV() {
        GlobalData.methodEnter("isDeltaV", "WebDAVTreeView", GlobalData.getGlobalData().getDebugTreeView());
        return this.getDeltaV();
    }

    public boolean getDeltaV() {
        GlobalData.methodEnter("getDeltaV", "WebDAVTreeView", GlobalData.getGlobalData().getDebugTreeView());
        if (this.currPath == null || this.currPath.getPathCount() < 1) {
            return false;
        }
        WebDAVTreeNode webDAVTreeNode = (WebDAVTreeNode)this.currPath.getPathComponent(1);
        return webDAVTreeNode.getDeltaV();
    }

    public boolean getDeltaVReports() {
        GlobalData.methodEnter("getDeltaVReports", "WebDAVTreeView", GlobalData.getGlobalData().getDebugTreeView());
        if (this.currPath == null || this.currPath.getPathCount() < 1) {
            return false;
        }
        WebDAVTreeNode webDAVTreeNode = (WebDAVTreeNode)this.currPath.getPathComponent(1);
        return webDAVTreeNode.getDeltaVReports();
    }

    public void setVersions(String string, Vector vector) {
        GlobalData.methodEnter("setVersions", "WebDAVTreeView", GlobalData.getGlobalData().getDebugTreeView());
        this.currNode = (WebDAVTreeNode)this.currPath.getLastPathComponent();
        DataNode dataNode = ((WebDAVTreeNode)this.currNode).getDataNode();
        dataNode = this.getCurrentDataNode(dataNode, string);
        if (dataNode != null && dataNode instanceof DeltaVDataNode) {
            ((DeltaVDataNode)dataNode).setVersions(vector);
        }
    }

    public void refreshLocalNoSelection(WebDAVTreeNode webDAVTreeNode) {
        GlobalData.methodEnter("refreshLocalNoSelection", "WebDAVTreeView", GlobalData.getGlobalData().getDebugTreeView());
        this.tree.removeTreeExpansionListener(this.treeExpListener);
        this.tree.removeTreeSelectionListener(this.treeSelectionListener);
        webDAVTreeNode.removeAllChildren();
        webDAVTreeNode.setHasLoadedChildren(false);
        webDAVTreeNode.loadChildren(true);
        this.treeModel.nodeStructureChanged(webDAVTreeNode);
        webDAVTreeNode.setHasLoadedChildren(true);
        this.tree.addTreeExpansionListener(this.treeExpListener);
        this.tree.addTreeSelectionListener(this.treeSelectionListener);
    }

    public void refreshLocal(WebDAVTreeNode webDAVTreeNode) {
        GlobalData.methodEnter("refreshLocal", "WebDAVTreeView", GlobalData.getGlobalData().getDebugTreeView());
        if (webDAVTreeNode == null) {
            return;
        }
        Object[] objectArray = webDAVTreeNode.getPath();
        String string = "";
        for (int i = 1; i < objectArray.length; ++i) {
            if ((string = string + objectArray[i]).endsWith(String.valueOf(File.separatorChar))) continue;
            string = string + File.separatorChar;
        }
        this.tree.removeTreeExpansionListener(this.treeExpListener);
        this.tree.removeTreeSelectionListener(this.treeSelectionListener);
        webDAVTreeNode.removeAllChildren();
        webDAVTreeNode.setHasLoadedChildren(false);
        TreePath treePath = new TreePath(objectArray);
        webDAVTreeNode.loadChildren(true);
        this.treeModel.nodeStructureChanged(webDAVTreeNode);
        webDAVTreeNode.setHasLoadedChildren(true);
        this.tree.addTreeExpansionListener(this.treeExpListener);
        this.tree.addTreeSelectionListener(this.treeSelectionListener);
        ViewSelectionEvent viewSelectionEvent = new ViewSelectionEvent(this, webDAVTreeNode, treePath);
        for (int i = 0; i < this.selListeners.size(); ++i) {
            ViewSelectionListener viewSelectionListener = (ViewSelectionListener)this.selListeners.elementAt(i);
            viewSelectionListener.selectionChanged(viewSelectionEvent);
        }
    }

    private String getLockToken(DataNode dataNode, String string) {
        GlobalData.methodEnter("getLockToken", "WebDAVTreeView", GlobalData.getGlobalData().getDebugTreeView());
        if (dataNode == null) {
            return null;
        }
        if (dataNode.getName().equals(string)) {
            return dataNode.getLockToken();
        }
        if (dataNode.isCollection()) {
            if (dataNode.getSubNodes() == null) {
                return null;
            }
            Enumeration enumeration = dataNode.getSubNodes().elements();
            while (enumeration.hasMoreElements()) {
                DataNode dataNode2 = (DataNode)enumeration.nextElement();
                String string2 = this.getLockToken(dataNode2, string);
                if (string2 == null) continue;
                return string2;
            }
        }
        return null;
    }

    private DataNode getCurrentDataNode(DataNode dataNode, String string) {
        GlobalData.methodEnter("getCurrentDataNode", "WebDAVTreeView", GlobalData.getGlobalData().getDebugTreeView());
        if (dataNode == null) {
            return null;
        }
        if (dataNode.getName().equals(string)) {
            return dataNode;
        }
        if (dataNode.isCollection()) {
            if (dataNode.getSubNodes() == null) {
                return null;
            }
            Enumeration enumeration = dataNode.getSubNodes().elements();
            while (enumeration.hasMoreElements()) {
                DataNode dataNode2 = (DataNode)enumeration.nextElement();
                DataNode dataNode3 = this.getCurrentDataNode(dataNode2, string);
                if (dataNode3 == null) continue;
                return dataNode3;
            }
        }
        return null;
    }

    class SelectionChangeListener
    implements TreeSelectionListener {
        SelectionChangeListener() {
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            Object object;
            TreePath treePath;
            GlobalData.methodEnter("valueChanged", "WebDAVTreeView::SelectionChangeListener", GlobalData.getGlobalData().getDebugTreeView());
            WebDAVTreeView.this.currPath = treePath = treeSelectionEvent.getPath();
            WebDAVTreeNode webDAVTreeNode = (WebDAVTreeNode)WebDAVTreeView.this.currPath.getLastPathComponent();
            if (!webDAVTreeNode.hasLoadedChildren() && (object = treePath.getPathComponent(1)) != null) {
                String string = object.toString();
                if (string.startsWith("http://") || string.startsWith("https://")) {
                    webDAVTreeNode.loadChildren(true);
                    return;
                }
                GlobalData.getGlobalData().setCursor(Cursor.getPredefinedCursor(3));
                WebDAVTreeView.this.refreshLocal(webDAVTreeNode);
                webDAVTreeNode.setHasLoadedChildren(true);
                GlobalData.getGlobalData().resetCursor();
            }
            WebDAVTreeView.this.treeModel.nodeStructureChanged(webDAVTreeNode);
            object = new ViewSelectionEvent(this, webDAVTreeNode, treePath);
            for (int i = 0; i < WebDAVTreeView.this.selListeners.size(); ++i) {
                ViewSelectionListener viewSelectionListener = (ViewSelectionListener)WebDAVTreeView.this.selListeners.elementAt(i);
                viewSelectionListener.selectionChanged((ViewSelectionEvent)object);
            }
        }
    }

    class treeExpansionListener
    implements TreeExpansionListener {
        treeExpansionListener() {
        }

        public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
            TreePath treePath;
            GlobalData.methodEnter("treeExpanded", "WebDAVTreeView::treeExpansionListener", GlobalData.getGlobalData().getDebugTreeView());
            TreePath treePath2 = WebDAVTreeView.this.selectionModel.getSelectionPath();
            GlobalData.getGlobalData().setCursor(Cursor.getPredefinedCursor(3));
            WebDAVTreeView.this.currPath = treePath = treeExpansionEvent.getPath();
            WebDAVTreeNode webDAVTreeNode = (WebDAVTreeNode)treePath.getLastPathComponent();
            if (!webDAVTreeNode.hasLoadedChildren()) {
                webDAVTreeNode.loadChildren(false);
            }
            GlobalData.getGlobalData().resetCursor();
        }

        public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            GlobalData.methodEnter("treeCollapsed", "WebDAVTreeView::treeExpansionListener", GlobalData.getGlobalData().getDebugTreeView());
        }
    }
}

