/*
 * Copyright (c) 2001-2004 Regents of the University of California.
 * All rights reserved.
 *
 * This software was developed at the University of California, Irvine.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the University of California, Irvine.  The name of the
 * University may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

/**
 * Title:       TreeTableModel
 * Description: Interface for use with the TreeTable
 * Copyright:   Copyright (c) 2001-2004 Regents of the University of California. All rights reserved.
 * @author      Joachim Feise (dav-exp@ics.uci.edu)
 * @date        29 September 2001
 *
 * Based on the JTreeTable examples provided by Sun Microsystems, Inc.:
 * http://java.sun.com/products/jfc/tsc/articles/treetable1/index.html
 * http://java.sun.com/products/jfc/tsc/articles/treetable2/index.html
 * @author      Joachim Feise (dav-exp@ics.uci.edu)
 * @date        1 October 2001
 * Changes:     Change of package name
 * @author      Joachim Feise (dav-exp@ics.uci.edu)
 * @date        08 February 2004
 * Changes:     Added Javadoc templates
 */

package edu.uci.ics.DAVExplorer;

import javax.swing.tree.TreeModel;


/**
 * 
 */
public interface TreeTableModel extends TreeModel
{
    /**
     * 
     * @return
     */
    public int getColumnCount();


    /**
     * 
     * @param column
     * @return
     */
    public String getColumnName( int column );


    /**
     * 
     * @param column
     * @return
     */
    public Class getColumnClass( int column );


    /**
     * 
     * @param node
     * @param column
     * @return
     */
    public Object getValueAt( Object node, int column );


    /**
     * 
     * @param node
     * @param column
     * @return
     */
    public boolean isCellEditable( Object node, int column );


    /**
     * 
     * @param aValue
     * @param node
     * @param column
     */
    public void setValueAt( Object aValue, Object node, int column );
}
